"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FinancialOverviewStructure = void 0;
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        financialView: {
            glossaryId() {
                return 388;
            },
            code: 'financialView',
        },
    },
};
let FinancialOverviewStructure = class FinancialOverviewStructure extends xtrem_core_1.Node {
};
exports.FinancialOverviewStructure = FinancialOverviewStructure;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PBTGRP',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 388,
            },
            control: {
                glossaryId: 388,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], FinancialOverviewStructure.prototype, "financialView", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PBTCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], FinancialOverviewStructure.prototype, "columnSequence", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], FinancialOverviewStructure.prototype, "columnContent", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SCOL1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], FinancialOverviewStructure.prototype, "subColumn1Title", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SCOL2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], FinancialOverviewStructure.prototype, "subColumn2Title", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COL1TYP',
        dataType: () => sageX3ProjectManagementData.enums.quantityAmountDatatype,
    })
], FinancialOverviewStructure.prototype, "subColumn1Type", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COL2TYP',
        dataType: () => sageX3ProjectManagementData.enums.quantityAmountDatatype,
    })
], FinancialOverviewStructure.prototype, "subColumn2Type", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSPLY',
    })
], FinancialOverviewStructure.prototype, "display", void 0);
exports.FinancialOverviewStructure = FinancialOverviewStructure = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMBUDTRS',
        keyPropertyNames: ['financialView', 'columnSequence'],
        indexes: [
            {
                orderBy: {
                    financialView: 1,
                    columnSequence: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], FinancialOverviewStructure);
//# sourceMappingURL=financial-overview-structure.js.map