"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Budget = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        site: {
            code: 'site',
        },
        parent: {
            project: 'project',
            code: 'parent',
        },
        keyConcatenation: {
            id: 'keyConcatenation',
        },
        responsiblePerson: {
            employee: 'responsiblePerson',
        },
        progressRange: {
            glossaryId() {
                return 385;
            },
            code: 'progressRange',
        },
        timeCategory: {
            code: 'timeCategory',
        },
        source: {
            id: 'source',
        },
        projectLink: {
            id: 'keyConcatenation',
        },
        longCommentRef: {
            code() {
                return 'PJMBUD';
            },
            identifier1() {
                return 'PBUDESTEX';
            },
            identifier2: 'keyConcatenation',
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
        longDescriptionRef: {
            code() {
                return 'PJMBUD';
            },
            identifier1() {
                return 'PBUCOMTEX';
            },
            identifier2: 'keyConcatenation',
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
    },
    collectionJoins: {
        lines: {
            project: 'project',
            budget: 'code',
        },
    },
};
const compositeReferences = {
    projectLink: {
        isActive: 'isActive',
        localizedDescription: 'localizedDescription',
        localizedShortDescription: 'localizedShortDescription',
        type: 'type',
    },
    longCommentRef: {
        longComment: 'text',
    },
    longDescriptionRef: {
        longDescription: 'text',
    },
};
let Budget = class Budget extends xtrem_core_1.Node {
};
exports.Budget = Budget;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], Budget.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PBUCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Budget.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], Budget.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUSOR',
    })
], Budget.prototype, "sortKey", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUDATH',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Budget.prototype, "suspensionDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUDATS',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Budget.prototype, "closingDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUDATO',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Budget.prototype, "deliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUPAE',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Budget,
    })
], Budget.prototype, "parent", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUSTATE',
        dataType: () => sageX3ProjectManagementData.enums.projectBudgetStatusDatatype,
    })
], Budget.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PBUELE',
    })
], Budget.prototype, "isElementary", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PBUIMP',
    })
], Budget.prototype, "isChargeable", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUSTARTDT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Budget.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUENDDT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Budget.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnName: 'KEYCONCAT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], Budget.prototype, "keyConcatenation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PBUNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Budget.prototype, "sequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RPBAUS',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
    })
], Budget.prototype, "responsiblePerson", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Budget.prototype, "estimatedProgress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLADI',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 385,
            },
            control: {
                glossaryId: 385,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], Budget.prototype, "progressRange", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Budget.prototype, "progressDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCCPLMET',
        dataType: () => sageX3ProjectManagementData.enums.estimationMethodUsedDatatype,
    })
], Budget.prototype, "progressMethod", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PROBIL',
        dataType: () => sageX3ProjectManagementData.enums.billingModeDatatype,
    })
], Budget.prototype, "billingMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTETYP',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TimeCategory,
    })
], Budget.prototype, "timeCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIPBU',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], Budget.prototype, "source", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.BudgetLine,
        isMutable: true,
        dependsOn: ['project', 'code'],
    })
], Budget.prototype, "lines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], Budget.prototype, "projectLink", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMBUD',
                identifier1: 'PBUDESTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'PJMBUD',
                identifier1: 'PBUDESTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], Budget.prototype, "longCommentRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMBUD',
                identifier1: 'PBUCOMTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'PJMBUD',
                identifier1: 'PBUCOMTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], Budget.prototype, "longDescriptionRef", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMSTA',
    })
], Budget.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Budget.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMDESAX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Budget.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], Budget.prototype, "longComment", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], Budget.prototype, "longDescription", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMTYP',
        dataType: () => sageX3MasterData.enums.projectAllocationTypeDatatype,
    })
], Budget.prototype, "type", void 0);
exports.Budget = Budget = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMBUD',
        keyPropertyNames: ['project', 'code'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
        canUpdate: true,
        canDelete: true,
        canDeleteMany: true,
    })
], Budget);
//# sourceMappingURL=budget.js.map