"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CostTypeExtension = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        costTypeGroup: {
            glossaryId() {
                return 386;
            },
            code: 'costTypeGroup',
        },
        product: {
            code: 'product',
        },
        indirectCostType: {
            code: 'indirectCostType',
        },
        laborUnit: {
            code: 'laborUnit',
        },
        currency: {
            code: 'currency',
        },
        chart: {
            code: 'chart',
        },
        account: {
            chartOfAccounts: 'chart',
            code: 'account',
        },
        accountingCode: {
            type() {
                return 'projectCostType';
            },
            accountingCode: 'accountingCode',
        },
    },
    collectionJoins: {
        rateDates: {
            costType: 'code',
        },
        costGroupLinks: {
            costType: 'code',
        },
    },
};
let CostTypeExtension = class CostTypeExtension extends xtrem_core_1.NodeExtension {
};
exports.CostTypeExtension = CostTypeExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCCGRP',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 386,
            },
            control: {
                glossaryId: 386,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], CostTypeExtension.prototype, "costTypeGroup", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCCPOHA',
    })
], CostTypeExtension.prototype, "isPurchasingCost", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCCWKA',
    })
], CostTypeExtension.prototype, "isLaborCost", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCCSTOA',
    })
], CostTypeExtension.prototype, "isStockIssueCost", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCCHATA',
    })
], CostTypeExtension.prototype, "isAccountingCost", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], CostTypeExtension.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCCPROV',
    })
], CostTypeExtension.prototype, "isIndirectCost", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCCPRCT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], CostTypeExtension.prototype, "indirectCostPercentage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCCCOD2',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.CostType,
    })
], CostTypeExtension.prototype, "indirectCostType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCCU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], CostTypeExtension.prototype, "laborUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCCCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], CostTypeExtension.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COA',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.ChartOfAccounts,
    })
], CostTypeExtension.prototype, "chart", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACC',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Account,
    })
], CostTypeExtension.prototype, "account", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCCOD',
        columnType: 'string',
        filters: {
            lookup: {
                type: 'projectCostType',
            },
            control: {
                type: 'projectCostType',
            },
        },
        node: () => sageX3FinanceData.nodes.AccountingCode,
    })
], CostTypeExtension.prototype, "accountingCode", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.CostDate,
        isMutable: true,
        dependsOn: ['code'],
    })
], CostTypeExtension.prototype, "rateDates", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.CostGroupLink,
        isMutable: true,
        dependsOn: ['code'],
    })
], CostTypeExtension.prototype, "costGroupLinks", void 0);
exports.CostTypeExtension = CostTypeExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3ProjectManagementData.nodes.CostType,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], CostTypeExtension);
//# sourceMappingURL=cost-type-extension.js.map