import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { NodeExtension, Reference, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class CostTypeExtension extends NodeExtension<sageX3ProjectManagementData.nodes.CostType> {
    readonly costTypeGroup: Reference<sageX3System.nodes.MiscellaneousTable>;
    readonly isPurchasingCost: Promise<boolean>;
    readonly isLaborCost: Promise<boolean>;
    readonly isStockIssueCost: Promise<boolean>;
    readonly isAccountingCost: Promise<boolean>;
    readonly product: Reference<sageX3MasterData.nodes.Product | null>;
    readonly isIndirectCost: Promise<boolean>;
    readonly indirectCostPercentage: Promise<decimal | null>;
    readonly indirectCostType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
    readonly laborUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
    readonly chart: Reference<sageX3FinanceData.nodes.ChartOfAccounts | null>;
    readonly account: Reference<sageX3FinanceData.nodes.Account | null>;
    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
    readonly rateDates: Collection<sageX3ProjectManagement.nodes.CostDate>;
    readonly costGroupLinks: Collection<sageX3ProjectManagement.nodes.CostGroupLink>;
}
declare module '@sage/x3-project-management-data/lib/nodes/cost-type' {
    interface CostType extends CostTypeExtension {
    }
}
//# sourceMappingURL=cost-type-extension.d.ts.map