declare module '@sage/x3-project-management-data-api-partial' {
    import type {
        BomCodes,
        BusinessPartner,
        CustomerProduct,
        CustomerProductInput,
        Package as SageX3MasterData$Package,
        Product,
        ProductCategory,
        ProductCategoryInput,
        ProductCategoryStatisticalGroups,
        ProductCategoryStatisticalGroupsBinding,
        ProductCategoryStatisticalGroupsInput,
        ProductInput,
        ProductPackingUnits,
        ProductPackingUnitsBinding,
        ProductPackingUnitsInput,
        ProductSite,
        ProductStatisticalGroups,
        ProductStatisticalGroupsBinding,
        ProductStatisticalGroupsInput,
        SupplierProduct,
        SupplierProductInput,
        TechnicalSheet,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type { Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type {
        Access,
        Company,
        GenericPrintReport,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface Action2068$Enum {
        always: 1;
        confirmation: 2;
    }
    export type Action2068 = keyof Action2068$Enum;
    export interface AdjustedValue$Enum {
        none: 1;
        billedProgress: 2;
        billedQuantity: 3;
        billedAmount: 4;
    }
    export type AdjustedValue = keyof AdjustedValue$Enum;
    export interface Aggregate$Enum {
        company: 1;
        site: 2;
        role: 3;
        employee: 4;
    }
    export type Aggregate = keyof Aggregate$Enum;
    export interface AssignmentDetails$Enum {
        notCalculated: 1;
        calculated: 2;
    }
    export type AssignmentDetails = keyof AssignmentDetails$Enum;
    export interface AssignmentSplitDetails$Enum {
        notCalculated: 1;
        limitedToSelectedPeriod: 2;
        fullAssignmentPeriod: 3;
    }
    export type AssignmentSplitDetails = keyof AssignmentSplitDetails$Enum;
    export interface BdgtAutoProcessingOptions$Enum {
        includeAllSubBudgets: 1;
        useTaskProducts: 2;
        useTaskOperations: 3;
        overwriteExistingBudgetLines: 4;
        writeLogFile: 5;
        deleteAllExistingLines: 6;
    }
    export type BdgtAutoProcessingOptions = keyof BdgtAutoProcessingOptions$Enum;
    export interface BillingMode$Enum {
        none: 1;
        progressBilling: 2;
        timeBilling: 3;
    }
    export type BillingMode = keyof BillingMode$Enum;
    export interface BudgetEvent$Enum {
        deliver: 1;
        close: 2;
        suspend: 3;
        reactivate: 4;
    }
    export type BudgetEvent = keyof BudgetEvent$Enum;
    export interface BudgetLineOrigin$Enum {
        manual: 1;
        operations: 2;
        productRequirements: 3;
        budgetLines: 4;
        project: 5;
        operationsAndProductRequirements: 6;
    }
    export type BudgetLineOrigin = keyof BudgetLineOrigin$Enum;
    export interface BudgetMethod$Enum {
        notApplicable: 1;
        standardCost: 2;
        revisedStandard: 3;
        budgetCost: 4;
        simulatedCost: 5;
    }
    export type BudgetMethod = keyof BudgetMethod$Enum;
    export interface CalculationMethodUsed$Enum {
        notCalculated: 1;
        manual: 2;
        revRecSnapshot: 3;
    }
    export type CalculationMethodUsed = keyof CalculationMethodUsed$Enum;
    export interface ClosingWithAuthorizedCredit$Enum {
        notAuthorized: 1;
        authorized: 2;
    }
    export type ClosingWithAuthorizedCredit = keyof ClosingWithAuthorizedCredit$Enum;
    export interface ConstraintType$Enum {
        flexible: 1;
        strict: 2;
    }
    export type ConstraintType = keyof ConstraintType$Enum;
    export interface ConsumptionMode$Enum {
        directDelivery: 1;
        salesOrder: 2;
    }
    export type ConsumptionMode = keyof ConsumptionMode$Enum;
    export interface CopyBudgetStatus$Enum {
        allBudgets: 1;
        notOpened: 2;
        open: 3;
        delivered: 4;
        closed: 5;
        suspended: 6;
    }
    export type CopyBudgetStatus = keyof CopyBudgetStatus$Enum;
    export interface CopyTaskStatus$Enum {
        allTasks: 1;
        notOpened: 2;
        opened: 3;
        launched: 4;
        started: 5;
        planned: 6;
        closed: 7;
        suspended: 8;
    }
    export type CopyTaskStatus = keyof CopyTaskStatus$Enum;
    export interface CopyTaskType$Enum {
        allTypes: 1;
        material: 2;
        labor: 3;
        mixed: 4;
        miscellaneous: 5;
    }
    export type CopyTaskType = keyof CopyTaskType$Enum;
    export interface CostGroupType$Enum {
        material: 1;
        labor: 2;
        machine: 3;
    }
    export type CostGroupType = keyof CostGroupType$Enum;
    export interface DatesAdjustmentRules$Enum {
        onDemandUpdate: 1;
        automaticUpdate: 2;
    }
    export type DatesAdjustmentRules = keyof DatesAdjustmentRules$Enum;
    export interface DeliveryStatus$Enum {
        notDelivered: 1;
        partiallyDelivered: 2;
        delivered: 3;
        noDeliverable: 4;
    }
    export type DeliveryStatus = keyof DeliveryStatus$Enum;
    export interface Display$Enum {
        displayAll: 1;
        timeSpentMoreThanCapacity: 2;
        timeSpentLessThanCapacity: 3;
    }
    export type Display = keyof Display$Enum;
    export interface DurationCopyOptions$Enum {
        copyFromTheSource: 1;
        copyFromTheTaskCategory: 2;
        clearDuration: 3;
    }
    export type DurationCopyOptions = keyof DurationCopyOptions$Enum;
    export interface EstimationMethodUsed$Enum {
        notCalculated: 1;
        manualEntry: 2;
        calculated: 3;
        revRecSnapshot: 4;
    }
    export type EstimationMethodUsed = keyof EstimationMethodUsed$Enum;
    export interface EstimationMethod$Enum {
        manualEntry: 1;
        calculated: 2;
        manualEntryOrCalculated: 3;
    }
    export type EstimationMethod = keyof EstimationMethod$Enum;
    export interface GenerationType2268$Enum {
        actual: 1;
        activeSimulation: 2;
        inactiveSimulation: 3;
    }
    export type GenerationType2268 = keyof GenerationType2268$Enum;
    export interface LaborRatePriority$Enum {
        employee: 1;
        projectCostType: 2;
    }
    export type LaborRatePriority = keyof LaborRatePriority$Enum;
    export interface LoadAnalysis$Enum {
        allTasks: 1;
        lateTasks: 2;
        overConsumedTasks: 3;
        remainingTasks: 4;
    }
    export type LoadAnalysis = keyof LoadAnalysis$Enum;
    export interface Objects$Enum {
        purchaseOrder: 1;
        workOrders: 2;
        subContracts: 3;
    }
    export type Objects = keyof Objects$Enum;
    export interface OpeProvTask$Enum {
        provisional: 1;
        operational: 2;
    }
    export type OpeProvTask = keyof OpeProvTask$Enum;
    export interface OperationEvent$Enum {
        close: 1;
        suspend: 2;
        reactivate: 3;
    }
    export type OperationEvent = keyof OperationEvent$Enum;
    export interface OperationLaborRatePriority$Enum {
        costingDimension: 1;
        projectCostType: 2;
    }
    export type OperationLaborRatePriority = keyof OperationLaborRatePriority$Enum;
    export interface OperationsLinkType$Enum {
        endToStart: 1;
        startToStart: 2;
        endToEnd: 3;
        startToEnd: 4;
    }
    export type OperationsLinkType = keyof OperationsLinkType$Enum;
    export interface Origin$Enum {
        invoice: 1;
        creditMemo: 2;
    }
    export type Origin = keyof Origin$Enum;
    export interface PeriodToControl$Enum {
        day: 1;
        week: 2;
        month: 3;
    }
    export type PeriodToControl = keyof PeriodToControl$Enum;
    export interface PjmBudgetManagement$Enum {
        byCostStructure: 1;
        byProjectStructure: 2;
        bothStructures: 3;
    }
    export type PjmBudgetManagement = keyof PjmBudgetManagement$Enum;
    export interface PlanningMode$Enum {
        dateOfTasks: 1;
        manualDate: 2;
        calculatedDate: 3;
        noOperation: 4;
    }
    export type PlanningMode = keyof PlanningMode$Enum;
    export interface ProgStatusPercentageInit$Enum {
        projectProgressOnly: 1;
        forecastStatusOnlyScheduledInvoices: 2;
        combinedProjectProgressForecastStatus: 3;
    }
    export type ProgStatusPercentageInit = keyof ProgStatusPercentageInit$Enum;
    export interface ProgressBillingLineStatus$Enum {
        pending: 1;
        toBeInvoiced: 2;
        invoiced: 3;
        creditMemo: 4;
    }
    export type ProgressBillingLineStatus = keyof ProgressBillingLineStatus$Enum;
    export interface ProgressBillingSelection$Enum {
        bySalesOrderLine: 1;
        bySalesOrder: 2;
        byProjectPhase: 3;
    }
    export type ProgressBillingSelection = keyof ProgressBillingSelection$Enum;
    export interface ProgressStatusSelection$Enum {
        notGrouped: 1;
        byMonthPeriodStart: 2;
        byMonthInvoiceDate: 3;
    }
    export type ProgressStatusSelection = keyof ProgressStatusSelection$Enum;
    export interface ProjectBudgetStatus$Enum {
        new: 1;
        open: 2;
        delivered: 3;
        closed: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        suspended: 9;
    }
    export type ProjectBudgetStatus = keyof ProjectBudgetStatus$Enum;
    export interface ProjectDefaultStatus$Enum {
        new: 1;
        launched: 2;
    }
    export type ProjectDefaultStatus = keyof ProjectDefaultStatus$Enum;
    export interface ProjectEvent$Enum {
        launch: 1;
        deliver: 2;
        close: 3;
        suspend: 4;
        reactivate: 5;
    }
    export type ProjectEvent = keyof ProjectEvent$Enum;
    export interface ProjectGanttChart$Enum {
        project: 1;
        task: 2;
        product: 3;
        operation: 4;
        parentTask: 5;
    }
    export type ProjectGanttChart = keyof ProjectGanttChart$Enum;
    export interface ProjectStatus2278$Enum {
        allProjects: 1;
        notOpened: 2;
        opened: 3;
        launched: 4;
        delivered: 5;
        closed: 6;
        suspended: 7;
    }
    export type ProjectStatus2278 = keyof ProjectStatus2278$Enum;
    export interface ProjectStatus$Enum {
        new: 1;
        launched: 2;
        delivered: 3;
        closed: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        suspended: 9;
    }
    export type ProjectStatus = keyof ProjectStatus$Enum;
    export interface ProjectTaskStatus$Enum {
        new: 1;
        launched: 2;
        started: 3;
        closed: 4;
        planned: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        suspended: 9;
    }
    export type ProjectTaskStatus = keyof ProjectTaskStatus$Enum;
    export interface ProjectTaskType$Enum {
        material: 1;
        labor: 2;
        mixed: 3;
        miscellaneous: 4;
    }
    export type ProjectTaskType = keyof ProjectTaskType$Enum;
    export interface QuantityAmount$Enum {
        quantity: 1;
        amount: 2;
    }
    export type QuantityAmount = keyof QuantityAmount$Enum;
    export interface RemainingLoadCalculation$Enum {
        onFullAssignmentPeriod: 1;
        fromCurrentDate: 2;
    }
    export type RemainingLoadCalculation = keyof RemainingLoadCalculation$Enum;
    export interface RevisionManagementOptions$Enum {
        notManaged: 1;
        managedOnDemand: 2;
        managedAutomatically: 3;
    }
    export type RevisionManagementOptions = keyof RevisionManagementOptions$Enum;
    export interface SaleablePrdLineOrigin$Enum {
        manual: 1;
        operations: 2;
        productRequirements: 3;
        budgetLines: 4;
    }
    export type SaleablePrdLineOrigin = keyof SaleablePrdLineOrigin$Enum;
    export interface SaleableProdListAutomation$Enum {
        includeAllSubLevels: 1;
        useBudgetLines: 2;
        saleableProductsFromTasks: 3;
        useTaskProducts: 4;
        useTaskOperations: 5;
        overwriteExistingAutomatedSaleableProductLines: 6;
        writeLogFile: 7;
        deleteAllExistingAutomatedSaleableProductLines: 8;
    }
    export type SaleableProdListAutomation = keyof SaleableProdListAutomation$Enum;
    export interface SoldProductsDocumentType$Enum {
        quote: 1;
        salesOrder: 2;
        directInvoice: 3;
    }
    export type SoldProductsDocumentType = keyof SoldProductsDocumentType$Enum;
    export interface SoldProductsLineDocType$Enum {
        notSelected: 1;
        quote: 2;
        salesOrder: 3;
        directInvoice: 4;
    }
    export type SoldProductsLineDocType = keyof SoldProductsLineDocType$Enum;
    export interface SoldProductsLinePrdGrpLvl$Enum {
        notGrouped: 1;
        project: 2;
        budgetCode: 3;
        taskCode: 4;
    }
    export type SoldProductsLinePrdGrpLvl = keyof SoldProductsLinePrdGrpLvl$Enum;
    export interface SourceOfPostedLaborAcct$Enum {
        employeeCostType: 1;
        projectCostType: 2;
    }
    export type SourceOfPostedLaborAcct = keyof SourceOfPostedLaborAcct$Enum;
    export interface SourceOfPostedLaborRate$Enum {
        employeeLaborRate: 1;
        projectLaborRate: 2;
    }
    export type SourceOfPostedLaborRate = keyof SourceOfPostedLaborRate$Enum;
    export interface TaskEvent$Enum {
        plan: 1;
        launch: 2;
        close: 3;
        suspend: 4;
        reactivate: 5;
    }
    export type TaskEvent = keyof TaskEvent$Enum;
    export interface TasksLinkType$Enum {
        endToStart: 1;
        startToStart: 2;
        endToEnd: 3;
        startToEnd: 4;
    }
    export type TasksLinkType = keyof TasksLinkType$Enum;
    export interface TimeEntryControlPhase$Enum {
        mandatory: 1;
        notMandatory: 2;
    }
    export type TimeEntryControlPhase = keyof TimeEntryControlPhase$Enum;
    export interface TimeEntryOrigin$Enum {
        manual: 1;
        imported: 2;
    }
    export type TimeEntryOrigin = keyof TimeEntryOrigin$Enum;
    export interface TimeEntryReportStatus$Enum {
        pendingValidation: 1;
        validated: 2;
        controlled: 3;
        approved: 4;
        rejected: 5;
    }
    export type TimeEntryReportStatus = keyof TimeEntryReportStatus$Enum;
    export interface TimeEntryStatus$Enum {
        pendingValidation: 1;
        validated: 2;
        controlled: 3;
        approved: 4;
        postedSimulation: 5;
        postedActual: 6;
        rejected: 7;
    }
    export type TimeEntryStatus = keyof TimeEntryStatus$Enum;
    export interface WeekDays$Enum {
        monday: 1;
        tuesday: 2;
        wednesday: 3;
        thursday: 4;
        friday: 5;
        saturday: 6;
        sunday: 7;
        substituteValue8: 8;
    }
    export type WeekDays = keyof WeekDays$Enum;
    export interface CostType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        site: Site;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
    }
    export interface CostTypeInput extends ClientNodeInput {
        code?: string;
        site?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isActive?: boolean | string;
    }
    export interface CostTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        site: Site;
        localizedDescription: string;
        localizedShortDescription: string;
        isActive: boolean;
    }
    export interface CostType$Lookups {
        site: QueryOperation<Site>;
    }
    export interface CostType$Operations {
        query: QueryOperation<CostType>;
        read: ReadOperation<CostType>;
        aggregate: {
            read: AggregateReadOperation<CostType>;
            query: AggregateQueryOperation<CostType>;
        };
        lookups(dataOrId: string | { data: CostTypeInput }): CostType$Lookups;
        getDefaults: GetDefaultsOperation<CostType>;
    }
    export interface ProjectLink extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        localizedDescription: string;
        localizedShortDescription: string;
        site: Site;
        type: ProjectAllocationType;
        isActive: boolean;
        company: Company;
    }
    export interface ProjectLinkInput extends ClientNodeInput {
        id?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        site?: string;
        type?: ProjectAllocationType;
        isActive?: boolean | string;
        company?: string;
    }
    export interface ProjectLinkBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        localizedDescription: string;
        localizedShortDescription: string;
        site: Site;
        type: ProjectAllocationType;
        isActive: boolean;
        company: Company;
    }
    export interface ProjectLink$Lookups {
        site: QueryOperation<Site>;
        company: QueryOperation<Company>;
    }
    export interface ProjectLink$Operations {
        query: QueryOperation<ProjectLink>;
        read: ReadOperation<ProjectLink>;
        aggregate: {
            read: AggregateReadOperation<ProjectLink>;
            query: AggregateQueryOperation<ProjectLink>;
        };
        lookups(dataOrId: string | { data: ProjectLinkInput }): ProjectLink$Lookups;
        getDefaults: GetDefaultsOperation<ProjectLink>;
    }
    export interface ProjectText extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        identifier1: string;
        identifier2: string;
        identifier3: string;
        identifier4: string;
        text: TextStream;
    }
    export interface ProjectTextInput extends ClientNodeInput {
        code?: string;
        identifier1?: string;
        identifier2?: string;
        identifier3?: string;
        identifier4?: string;
        text?: TextStream;
    }
    export interface ProjectTextBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        identifier1: string;
        identifier2: string;
        identifier3: string;
        identifier4: string;
        text: TextStream;
    }
    export interface ProjectText$Operations {
        query: QueryOperation<ProjectText>;
        read: ReadOperation<ProjectText>;
        aggregate: {
            read: AggregateReadOperation<ProjectText>;
            query: AggregateQueryOperation<ProjectText>;
        };
        getDefaults: GetDefaultsOperation<ProjectText>;
    }
    export interface ProductCategoryExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroups>;
        costType: CostType;
    }
    export interface ProductCategoryInputExtension {
        stockSite?: string;
        code?: string;
        description?: string;
        localizedDescription?: string;
        shortDescription?: string;
        localizedShortDescription?: string;
        isSold?: boolean | string;
        productSequenceNumber?: string;
        creationMethod?: ProductCreationMode;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticUnit?: string;
        euUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        euUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseConversionFactorEntryAllowed?: boolean | string;
        isSalesConversionFactorEntryAllowed?: boolean | string;
        weightUnit?: string;
        stockUnitWeight?: decimal | string;
        volumeUnit?: string;
        stockUnitVolume?: decimal | string;
        labelFormatForStockUnit?: string;
        stockManagementMode?: StockManagement;
        managementMode?: StandardProductCode;
        isNegativeStockAuthorized?: boolean | string;
        lotSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        serialSequenceNumber?: string;
        valuationMethod?: string;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        userAccessCode?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        buyer?: string;
        planner?: string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        salesPriceOrigin?: PriceOrigin;
        percentagePricePurchaseApplied?: decimal | string;
        configuratorProductLine?: string;
        isLocationManaged?: boolean | string;
        salesOrderAllocationRule?: string;
        workOrderAllocationRule?: string;
        shipmentAllocationRule?: string;
        materialConsumptionAllocationRule?: string;
        transferAllocationRule?: string;
        subcontractReplenishmentAllocationRule?: string;
        subcontractConsumptionAllocationRule?: string;
        afterSalesAllocationRule?: string;
        isStatusAAuthorizedInGlobalAllocation?: boolean | string;
        isStatusQAuthorizedInGlobalAllocation?: boolean | string;
        isStatusRAuthorizedInGlobalAllocation?: boolean | string;
        abcClass?: ProductAbcClass;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        shrinkagePercent?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningRequestHorizon?: integer | string;
        planningRequestHorizonTimeUnit?: LeadTimeUnit;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        stockCoverageInWeeks?: integer | string;
        safetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        isReleasedIfShortage?: boolean | string;
        automaticClosingPercentage?: decimal | string;
        salesDeliveryTolerance?: decimal | string;
        salesMinimumQuantity?: decimal | string;
        salesMaximumQuantity?: decimal | string;
        isLoanAuthorized?: boolean | string;
        isBackToBackOrderManaged?: boolean | string;
        directBackToBackOrderQuantity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTool?: boolean | string;
        isDeliverable?: boolean | string;
        isIntermediary?: boolean | string;
        isMaintenance?: boolean | string;
        packagingCapacity?: decimal | string;
        assignmentRules?: string;
        isStockDetailedInPacking?: boolean | string;
        technicalSheet?: string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        afterSalesWarehouse?: string;
        canBeCapitalized?: boolean | string;
        isPackingManaged?: boolean | string;
        sageSalesTax?: string;
        saftProductType?: SafTProductType;
        freightClass?: string;
        freightCommodityCode?: string;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        inventoryProductType?: ProductType;
        containerManagement?: boolean | string;
        statisticalGroups?: Partial<ProductCategoryStatisticalGroupsInput>[];
        costType?: string;
    }
    export interface ProductCategoryBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroupsBinding>;
        costType: CostType;
    }
    export interface ProductCategoryExtension$Lookups {
        costType: QueryOperation<CostType>;
    }
    export interface ProductCategoryExtension$Operations {
        lookups(dataOrId: string | { data: ProductCategoryInput }): ProductCategoryExtension$Lookups;
    }
    export interface ProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnits>;
        statisticalGroups: ClientCollection<ProductStatisticalGroups>;
        costType: CostType;
    }
    export interface ProductInputExtension {
        code?: string;
        company?: string;
        productCategory?: string;
        searchKey?: string;
        description1?: string;
        description2?: string;
        description3?: string;
        localizedDescription1?: string;
        localizedDescription2?: string;
        localizedDescription3?: string;
        managementMode?: StandardProductCode;
        standard?: string;
        upc?: string;
        productStatus?: ProductStatus;
        isPrototype?: boolean | string;
        defaultPotencyInPercentage?: decimal | string;
        defaultPotencyInInternationalUnit?: decimal | string;
        serviceLifeStartDate?: string;
        serviceLifeEndDate?: string;
        storageSheet?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticalUnit?: string;
        eeUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseFactorEntryAllowed?: boolean | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        isSalesFactorEntryAllowed?: boolean | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        eeUnitToStockUnitConversionFactor?: decimal | string;
        weightUnit?: string;
        productWeight?: decimal | string;
        volumeUnit?: string;
        productVolume?: decimal | string;
        lotSequenceNumber?: string;
        serialSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        expirationLeadTime?: integer | string;
        checkLeadTime?: integer | string;
        isNegativeStockAuthorized?: boolean | string;
        costGroup?: string;
        userAccessCode?: string;
        alternateProduct?: string;
        isIntrastatDeclarationSubmitted?: boolean | string;
        intrastatCommodity?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        buyer?: string;
        planner?: string;
        reorderLeadTime?: integer | string;
        purchaseBasePrice?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        exemptionFlag?: string;
        taxFlagStatusLocal?: string;
        configuratorProductLine?: string;
        configuratorNumericField1?: decimal | string;
        configuratorNumericField2?: decimal | string;
        configuratorNumericField3?: decimal | string;
        configuratorNumericField4?: decimal | string;
        configuratorNumericField5?: decimal | string;
        configuratorNumericField6?: decimal | string;
        configuratorAlphaField1?: string;
        configuratorAlphaField2?: string;
        configuratorAlphaField3?: string;
        configuratorAlphaField4?: string;
        configuratorAlphaField5?: string;
        configuratorAlphaField6?: string;
        configurationJournal?: string;
        configuratorBusinessPartner?: string;
        configuratorBusinessPartnerReference?: string;
        configuratorReferenceProduct?: string;
        configuratorPurgeDate?: string;
        isInstalledBaseCreated?: boolean | string;
        voucherCategory?: string;
        tokensToBeCredited?: integer | string;
        creditUnit?: string;
        labelFormatForStockUnit?: string;
        bomCodeForAfterSales?: integer | string;
        productTypeForAfterSales?: TypeOfProduct;
        isAfterSalesProductIssuedByDefault?: boolean | string;
        daysUnit?: string;
        hourUnit?: string;
        minuteUnit?: string;
        productDensity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTools?: boolean | string;
        isDeliverable?: boolean | string;
        isSold?: boolean | string;
        isIntermediary?: boolean | string;
        isCapitalized?: boolean | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        intrastatFederalStateOrRegion?: string;
        plmProductReference?: string;
        plmLinkedDocuments?: string;
        plmProductHistory?: string;
        sageSalesTax?: string;
        allergens?: string;
        allergenChangeDate?: string;
        allergenBomCode?: integer | string;
        saftProductType?: SafTProductType;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        productType?: ProductType;
        globalTradeItemNumber?: string;
        supplierProduct?: Partial<SupplierProductInput>[];
        customerProduct?: Partial<CustomerProductInput>[];
        manufacturingText?: TextStream;
        picture?: BinaryStream;
        purchasingText?: TextStream;
        packingUnits?: Partial<ProductPackingUnitsInput>[];
        statisticalGroups?: Partial<ProductStatisticalGroupsInput>[];
        costType?: string;
    }
    export interface ProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnitsBinding>;
        statisticalGroups: ClientCollection<ProductStatisticalGroupsBinding>;
        costType: CostType;
    }
    export interface ProductExtension$Lookups {
        costType: QueryOperation<CostType>;
    }
    export interface ProductExtension$Operations {
        lookups(dataOrId: string | { data: ProductInput }): ProductExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-project-management-data/CostType': CostType$Operations;
        '@sage/x3-project-management-data/ProjectLink': ProjectLink$Operations;
        '@sage/x3-project-management-data/ProjectText': ProjectText$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3MasterData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-project-management-data-api' {
    export type * from '@sage/x3-project-management-data-api-partial';
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-project-management-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type {
        ProductBindingExtension,
        ProductCategoryBindingExtension,
        ProductCategoryExtension,
        ProductCategoryExtension$Lookups,
        ProductCategoryExtension$Operations,
        ProductCategoryInputExtension,
        ProductExtension,
        ProductExtension$Lookups,
        ProductExtension$Operations,
        ProductInputExtension,
    } from '@sage/x3-project-management-data-api';
    export interface ProductCategory extends ProductCategoryExtension {}
    export interface ProductCategoryBinding extends ProductCategoryBindingExtension {}
    export interface ProductCategoryInput extends ProductCategoryInputExtension {}
    export interface ProductCategory$Lookups extends ProductCategoryExtension$Lookups {}
    export interface ProductCategory$Operations extends ProductCategoryExtension$Operations {}
    export interface Product extends ProductExtension {}
    export interface ProductBinding extends ProductBindingExtension {}
    export interface ProductInput extends ProductInputExtension {}
    export interface Product$Lookups extends ProductExtension$Lookups {}
    export interface Product$Operations extends ProductExtension$Operations {}
}
