"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntrastatStatisticalRule = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        legislation: {
            glossaryId() {
                return 909;
            },
            code: 'legislation',
        },
        groupOfCompany: {
            group: 'groupOfCompany',
        },
    },
};
let IntrastatStatisticalRule = class IntrastatStatisticalRule extends xtrem_core_1.Node {
};
exports.IntrastatStatisticalRule = IntrastatStatisticalRule;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'EECSCH',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], IntrastatStatisticalRule.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LEG',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 909,
            },
            control: {
                glossaryId: 909,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], IntrastatStatisticalRule.prototype, "legislation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], IntrastatStatisticalRule.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], IntrastatStatisticalRule.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLUX',
        dataType: () => sageX3MasterData.enums.ruleFlowDatatype,
    })
], IntrastatStatisticalRule.prototype, "physicalFlow", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VALSTO',
    })
], IntrastatStatisticalRule.prototype, "valueStock", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'A1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], IntrastatStatisticalRule.prototype, "alpha1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'A2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], IntrastatStatisticalRule.prototype, "alpha2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'N1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], IntrastatStatisticalRule.prototype, "numeric1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'N2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], IntrastatStatisticalRule.prototype, "numeric2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOC',
        columnType: 'string',
        node: () => sageX3Structure.nodes.SiteGroupings,
    })
], IntrastatStatisticalRule.prototype, "groupOfCompany", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
    })
], IntrastatStatisticalRule.prototype, "active", void 0);
exports.IntrastatStatisticalRule = IntrastatStatisticalRule = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'TABEECSCH',
        keyPropertyNames: ['code', 'legislation'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                    legislation: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['legislation'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], IntrastatStatisticalRule);
//# sourceMappingURL=intrastat-statistical-rule.js.map