import * as ui from '@sage/xtrem-ui';

/**
 * This allow to change page delayed
 * @param pageInstance current page instance
 * @param address page url
 * @param parameters optional parameters
 *
 */
/** @internal */
export function onGoto(pageInstance: ui.Page, address: string, parameters?: any): void {
    setTimeout(() => {
        try {
            pageInstance.$.removeToasts();
            pageInstance.$.setPageClean();
            pageInstance.$.router.goTo(address, parameters);
        } catch (error) {
            ui.console.error(`Router goto failure :\n${JSON.stringify(error) ?? ''}`);
        }
    }, 100);
}
