import * as ui from '@sage/xtrem-ui';
import { dialogMessage } from './dialogs';

/**
 * Return selected stock site for current application
 * @param pageInstance Current page instance
 * @param errorTitle error title when no default site exist
 * @param errorMessage error message when no default site exist
 * @returns default site or null
 */
export async function getSelectedStockSite(
    pageInstance: ui.Page,
    errorTitle: string,
    errorMessage: string,
): Promise<string | null> {
    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');
    if (!selectedSite) {
        // Please note that there asynchronous processing is not prefixed by an await on purpose
        // so that it can be processed in parallel and not block the main process.
        // Be careful not to leave the current page before the user has closed this dialog box.
        pageInstance.$.sound.error();
        dialogMessage(pageInstance, 'error', errorTitle, errorMessage);
        return null;
    } else {
        return selectedSite.toString();
    }
}
