import { Dict } from '@sage/xtrem-shared';
import * as ui from '@sage/xtrem-ui';
/**
 * Return values not transient for current page
 * @param pageInstance Current page instance
 * @returns array of values not transient
 */

export const getPageValuesNotTransient = (
    pageInstance: ui.Page,
): Dict<any> => {
    const screenValues = pageInstance.$.values;
    const keys = Object.keys(screenValues);
    keys.forEach(elementId => {
        const properties = pageInstance._pageMetadata.uiComponentProperties[elementId];
        if (properties && properties.isTransient) {
            delete screenValues[elementId];
        }
    });
    return screenValues;
};