import { Node, Reference, integer, decimal, TextStream } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class SupplierProduct extends Node {
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly supplier: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly priority: Promise<integer | null>;
    readonly supplierProduct: Promise<string>;
    readonly supplierProductDescription: Promise<string>;
    readonly supplierUpc: Promise<string>;
    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly purchaseUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly packingUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
    readonly euStatisticsIncrease: Promise<decimal | null>;
    readonly minimumPurchaseQuantity: Promise<decimal | null>;
    readonly landingCostCoefficient: Promise<decimal | null>;
    readonly fixedCostPerUnit: Promise<decimal | null>;
    readonly qualityRank: Promise<integer | null>;
    readonly qualityControlManagementMode: Promise<sageX3MasterData.enums.SubjectToControl | null>;
    readonly isBackToBackOrder: Promise<boolean>;
    readonly purchasingTextKey: Promise<string>;
    readonly configurationJournal: Promise<string>;
    readonly subcontractLeadTime: Promise<integer | null>;
    readonly qualityControlFrequency: Promise<integer | null>;
    readonly qualityControlNumberEntries: Promise<integer | null>;
    readonly qualityProcessIdFrequency: Promise<integer | null>;
    readonly qualityProcessIdEntries: Promise<integer | null>;
    readonly isVersionPreloaded: Promise<boolean>;
    readonly text1004082: Promise<boolean>;
    readonly text1004085: Promise<boolean>;
    readonly purchasingTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly purchasingText: Promise<TextStream>;
}
//# sourceMappingURL=supplier-product.d.ts.map