"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Prospect = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        code: {
            code: 'code',
        },
        customerCategory: {
            code: 'customerCategory',
        },
        groupCustomer: {
            code: 'groupCustomer',
        },
        defaultAddress: {
            entityType() {
                return 'businessPartner';
            },
            prospect: 'code',
            code: 'defaultAddress',
        },
        defaultContact: {
            entityType() {
                return 'businessPartner';
            },
            prospect: 'code',
            code: 'defaultContact',
        },
        currency: {
            code: 'currency',
        },
        businessPartner: {
            code: 'code',
        },
    },
    collectionJoins: {
        addresses: {
            entityType() {
                return 'businessPartner';
            },
            prospect: 'code',
        },
        contacts: {
            entityType() {
                return 'businessPartner';
            },
            prospect: 'code',
        },
    },
};
const compositeReferences = {
    businessPartner: {
        acronym: 'acronym',
        companyName1: 'companyName1',
        companyName2: 'companyName2',
        companyNames: 'companyNames',
        country: 'country',
        europeanUnionVatNumber: 'europeanUnionVatNumber',
        fiscalCode: 'fiscalCode',
        isMailingProhibited: 'isMailingProhibited',
        isPhysicalPerson: 'isPhysicalPerson',
        language: 'language',
    },
};
let Prospect = class Prospect extends xtrem_core_1.Node {
};
exports.Prospect = Prospect;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Prospect.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BCGCOD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CustomerCategory,
    })
], Prospect.prototype, "customerCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCGRU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], Prospect.prototype, "groupCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.ProspectAddress,
    })
], Prospect.prototype, "defaultAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.ProspectContact,
    })
], Prospect.prototype, "defaultContact", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCSTA',
    })
], Prospect.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isStored: true,
        columnName: 'PPTFLG',
    })
], Prospect.prototype, "isProspect", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], Prospect.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COMCAT',
        dataType: () => sageX3MasterData.enums.commissionCategoryDatatype,
    })
], Prospect.prototype, "commissionCategory", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.ProspectAddress,
        isMutable: true,
        dependsOn: ['code'],
    })
], Prospect.prototype, "addresses", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Prospect.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.ProspectContact,
        isMutable: true,
        dependsOn: ['code'],
    })
], Prospect.prototype, "contacts", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRLOG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Prospect.prototype, "acronym", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Prospect.prototype, "companyName1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Prospect.prototype, "companyName2", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.BusinessPartnerCompanyNames,
        isMutable: true,
    })
], Prospect.prototype, "companyNames", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], Prospect.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], Prospect.prototype, "europeanUnionVatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FISCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KitActivityCode],
    })
], Prospect.prototype, "fiscalCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRFBDMAG',
    })
], Prospect.prototype, "isMailingProhibited", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEGETT',
    })
], Prospect.prototype, "isPhysicalPerson", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], Prospect.prototype, "language", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.ProspectSalesReps,
    })
], Prospect.prototype, "salesReps", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.ProspectStatisticalGroups,
    })
], Prospect.prototype, "statisticalGroups", void 0);
exports.Prospect = Prospect = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPCUSTOMER',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            denormalizedPropertyColumnSuffix: {
                companyName1: 0,
                companyName2: 1,
            },
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PptActivityCode],
        getFilters() {
            return [{ isProspect: true }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Prospect);
//# sourceMappingURL=prospect.js.map