import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, Collection } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class Prospect extends Node {
    readonly code: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly customerCategory: Reference<sageX3MasterData.nodes.CustomerCategory | null>;
    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly defaultAddress: Reference<sageX3MasterData.nodes.ProspectAddress | null>;
    readonly defaultContact: Reference<sageX3MasterData.nodes.ProspectContact | null>;
    readonly isActive: Promise<boolean>;
    readonly isProspect: Promise<boolean>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
    readonly commissionCategory: Promise<sageX3MasterData.enums.CommissionCategory | null>;
    readonly addresses: Collection<sageX3MasterData.nodes.ProspectAddress>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly contacts: Collection<sageX3MasterData.nodes.ProspectContact>;
    readonly acronym: Promise<string>;
    readonly companyName1: Promise<string>;
    readonly companyName2: Promise<string>;
    readonly companyNames: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyNames>;
    readonly country: Reference<sageX3Structure.nodes.Country | null>;
    readonly europeanUnionVatNumber: Promise<string>;
    readonly fiscalCode: Promise<string>;
    readonly isMailingProhibited: Promise<boolean>;
    readonly isPhysicalPerson: Promise<boolean>;
    readonly language: Reference<sageX3System.nodes.Language>;
    readonly salesReps: Collection<sageX3MasterData.nodes.ProspectSalesReps>;
    readonly statisticalGroups: Collection<sageX3MasterData.nodes.ProspectStatisticalGroups>;
}
//# sourceMappingURL=prospect.d.ts.map