import * as sageX3System from '@sage/x3-system';
import { Node, Reference, decimal, date, integer, Collection, TextStream, BinaryStream } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class Product extends Node {
    readonly code: Promise<string>;
    readonly company: Reference<sageX3System.nodes.Company | null>;
    readonly productCategory: Reference<sageX3MasterData.nodes.ProductCategory>;
    readonly searchKey: Promise<string>;
    readonly description1: Promise<string>;
    readonly description2: Promise<string>;
    readonly description3: Promise<string>;
    readonly localizedDescription1: Promise<string>;
    readonly localizedDescription2: Promise<string>;
    readonly localizedDescription3: Promise<string>;
    readonly managementMode: Promise<sageX3MasterData.enums.StandardProductCode | null>;
    readonly standard: Promise<string>;
    readonly upc: Promise<string>;
    readonly productStatus: Promise<sageX3MasterData.enums.ProductStatus | null>;
    readonly isPrototype: Promise<boolean>;
    readonly defaultPotencyInPercentage: Promise<decimal | null>;
    readonly defaultPotencyInInternationalUnit: Promise<decimal | null>;
    readonly serviceLifeStartDate: Promise<date | null>;
    readonly serviceLifeEndDate: Promise<date | null>;
    readonly storageSheet: Promise<string>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly statisticalUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly eeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly purchaseUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly isPurchaseFactorEntryAllowed: Promise<boolean>;
    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly isSalesFactorEntryAllowed: Promise<boolean>;
    readonly statisticalUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly eeUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly productWeight: Promise<decimal | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly productVolume: Promise<decimal | null>;
    readonly lotSequenceNumber: Promise<string>;
    readonly serialSequenceNumber: Promise<string>;
    readonly serialNumberManagementMode: Promise<sageX3MasterData.enums.SerialNumberManagement | null>;
    readonly expirationManagementMode: Promise<sageX3MasterData.enums.ExpirationManagement | null>;
    readonly expirationStockStatus: Promise<string>;
    readonly expirationLeadTime: Promise<integer | null>;
    readonly checkLeadTime: Promise<integer | null>;
    readonly isNegativeStockAuthorized: Promise<boolean>;
    readonly costGroup: Promise<string>;
    readonly userAccessCode: Reference<sageX3System.nodes.Access | null>;
    readonly alternateProduct: Reference<sageX3MasterData.nodes.Product | null>;
    readonly isIntrastatDeclarationSubmitted: Promise<boolean>;
    readonly intrastatCommodity: Promise<string>;
    readonly purchasingPlanningHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
    readonly purchasingPlanningHorizon: Promise<integer | null>;
    readonly purchasingFirmHorizon: Promise<integer | null>;
    readonly purchasingFirmHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
    readonly buyer: Reference<sageX3System.nodes.User | null>;
    readonly planner: Reference<sageX3System.nodes.User | null>;
    readonly reorderLeadTime: Promise<integer | null>;
    readonly purchaseBasePrice: Promise<decimal | null>;
    readonly landedCostCoefficient: Promise<decimal | null>;
    readonly fixedLandedCostPerUnit: Promise<decimal | null>;
    readonly purchaseDeliveryTolerance: Promise<decimal | null>;
    readonly isReceived: Promise<boolean>;
    readonly isMandatoryPurchaseOrderRequest: Promise<boolean>;
    readonly purchasingTextKey: Promise<string>;
    readonly manufacturingTextKey: Promise<string>;
    readonly exemptionFlag: Promise<string>;
    readonly taxFlagStatusLocal: Promise<string>;
    readonly configuratorProductLine: Promise<string>;
    readonly configuratorNumericField1: Promise<decimal | null>;
    readonly configuratorNumericField2: Promise<decimal | null>;
    readonly configuratorNumericField3: Promise<decimal | null>;
    readonly configuratorNumericField4: Promise<decimal | null>;
    readonly configuratorNumericField5: Promise<decimal | null>;
    readonly configuratorNumericField6: Promise<decimal | null>;
    readonly configuratorAlphaField1: Promise<string>;
    readonly configuratorAlphaField2: Promise<string>;
    readonly configuratorAlphaField3: Promise<string>;
    readonly configuratorAlphaField4: Promise<string>;
    readonly configuratorAlphaField5: Promise<string>;
    readonly configuratorAlphaField6: Promise<string>;
    readonly configurationJournal: Promise<string>;
    readonly configuratorBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly configuratorBusinessPartnerReference: Promise<string>;
    readonly configuratorReferenceProduct: Reference<sageX3MasterData.nodes.Product | null>;
    readonly configuratorPurgeDate: Promise<date | null>;
    readonly isInstalledBaseCreated: Promise<boolean>;
    readonly voucherCategory: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly tokensToBeCredited: Promise<integer | null>;
    readonly creditUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly labelFormatForStockUnit: Reference<sageX3System.nodes.GenericPrintReport | null>;
    readonly bomCodeForAfterSales: Reference<sageX3MasterData.nodes.BomCodes | null>;
    readonly productTypeForAfterSales: Promise<sageX3MasterData.enums.TypeOfProduct | null>;
    readonly isAfterSalesProductIssuedByDefault: Promise<boolean>;
    readonly daysUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly hourUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly minuteUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly productDensity: Promise<decimal | null>;
    readonly isPurchased: Promise<boolean>;
    readonly isManufactured: Promise<boolean>;
    readonly isSubcontracted: Promise<boolean>;
    readonly isService: Promise<boolean>;
    readonly isPhantom: Promise<boolean>;
    readonly isGeneric: Promise<boolean>;
    readonly isTools: Promise<boolean>;
    readonly isDeliverable: Promise<boolean>;
    readonly isSold: Promise<boolean>;
    readonly isIntermediary: Promise<boolean>;
    readonly isCapitalized: Promise<boolean>;
    readonly newStockStatusAfterRecontrol: Promise<string>;
    readonly useByDateCoefficient: Promise<decimal | null>;
    readonly intrastatFederalStateOrRegion: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly plmProductReference: Promise<string>;
    readonly plmLinkedDocuments: Promise<string>;
    readonly plmProductHistory: Promise<string>;
    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly allergens: Promise<string>;
    readonly allergenChangeDate: Promise<date | null>;
    readonly allergenBomCode: Promise<integer | null>;
    readonly saftProductType: Promise<sageX3MasterData.enums.SafTProductType | null>;
    readonly isVersionManaged: Promise<boolean>;
    readonly minorVersionSequence: Promise<string>;
    readonly majorVersionSequence: Promise<string>;
    readonly isVersionPreloaded: Promise<boolean>;
    readonly productType: Promise<sageX3MasterData.enums.ProductType | null>;
    readonly globalTradeItemNumber: Promise<string>;
    readonly productSites: Collection<sageX3MasterData.nodes.ProductSite>;
    readonly supplierProduct: Collection<sageX3MasterData.nodes.SupplierProduct>;
    readonly customerProduct: Collection<sageX3MasterData.nodes.CustomerProduct>;
    readonly pictureRef: Reference<sageX3MasterData.nodes.CommonImage | null>;
    readonly purchasingTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly manufacturingTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly manufacturingText: Promise<TextStream>;
    readonly picture: Promise<BinaryStream>;
    readonly purchasingText: Promise<TextStream>;
    readonly packingUnits: Collection<sageX3MasterData.nodes.ProductPackingUnits>;
    readonly statisticalGroups: Collection<sageX3MasterData.nodes.ProductStatisticalGroups>;
}
//# sourceMappingURL=product.d.ts.map