import * as sageX3System from '@sage/x3-system';
import { Node, Reference, decimal, integer, Collection } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class ProductCategory extends Node {
    readonly stockSite: Reference<sageX3System.nodes.Site | null>;
    readonly code: Promise<string>;
    readonly description: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly shortDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly isSold: Promise<boolean>;
    readonly productSequenceNumber: Promise<string>;
    readonly creationMethod: Promise<sageX3MasterData.enums.ProductCreationMode | null>;
    readonly qualityControlManagementMode: Promise<sageX3MasterData.enums.SubjectToControl | null>;
    readonly qualityControlAccessCode: Promise<string>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly statisticUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly euUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly purchaseUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly statisticalUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly euUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly isPurchaseConversionFactorEntryAllowed: Promise<boolean>;
    readonly isSalesConversionFactorEntryAllowed: Promise<boolean>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly stockUnitWeight: Promise<decimal | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly stockUnitVolume: Promise<decimal | null>;
    readonly labelFormatForStockUnit: Reference<sageX3System.nodes.GenericPrintReport | null>;
    readonly stockManagementMode: Promise<sageX3MasterData.enums.StockManagement | null>;
    readonly managementMode: Promise<sageX3MasterData.enums.StandardProductCode | null>;
    readonly isNegativeStockAuthorized: Promise<boolean>;
    readonly lotSequenceNumber: Promise<string>;
    readonly serialNumberManagementMode: Promise<sageX3MasterData.enums.SerialNumberManagement | null>;
    readonly serialSequenceNumber: Promise<string>;
    readonly valuationMethod: Promise<string>;
    readonly expirationManagementMode: Promise<sageX3MasterData.enums.ExpirationManagement | null>;
    readonly expirationStockStatus: Promise<string>;
    readonly userAccessCode: Promise<string>;
    readonly purchasingPlanningHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
    readonly purchasingPlanningHorizon: Promise<integer | null>;
    readonly purchasingFirmHorizon: Promise<integer | null>;
    readonly purchasingFirmHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
    readonly reorderLeadTime: Promise<decimal | null>;
    readonly buyer: Reference<sageX3System.nodes.User | null>;
    readonly planner: Reference<sageX3System.nodes.User | null>;
    readonly purchaseDeliveryTolerance: Promise<decimal | null>;
    readonly isReceived: Promise<boolean>;
    readonly isMandatoryPurchaseOrderRequest: Promise<boolean>;
    readonly landedCostCoefficient: Promise<decimal | null>;
    readonly fixedLandedCostPerUnit: Promise<decimal | null>;
    readonly salesPriceOrigin: Promise<sageX3MasterData.enums.PriceOrigin | null>;
    readonly percentagePricePurchaseApplied: Promise<decimal | null>;
    readonly configuratorProductLine: Promise<string>;
    readonly isLocationManaged: Promise<boolean>;
    readonly salesOrderAllocationRule: Promise<string>;
    readonly workOrderAllocationRule: Promise<string>;
    readonly shipmentAllocationRule: Promise<string>;
    readonly materialConsumptionAllocationRule: Promise<string>;
    readonly transferAllocationRule: Promise<string>;
    readonly subcontractReplenishmentAllocationRule: Promise<string>;
    readonly subcontractConsumptionAllocationRule: Promise<string>;
    readonly afterSalesAllocationRule: Promise<string>;
    readonly isStatusAAuthorizedInGlobalAllocation: Promise<boolean>;
    readonly isStatusQAuthorizedInGlobalAllocation: Promise<boolean>;
    readonly isStatusRAuthorizedInGlobalAllocation: Promise<boolean>;
    readonly abcClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
    readonly stockWithdrawalMode: Promise<sageX3MasterData.enums.StockWithdrawal | null>;
    readonly countManagementMode: Promise<sageX3MasterData.enums.Count | null>;
    readonly trendProfile: Promise<string>;
    readonly shrinkagePercent: Promise<decimal | null>;
    readonly planningFirmHorizon: Promise<integer | null>;
    readonly planningFirmHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
    readonly planningRequestHorizon: Promise<integer | null>;
    readonly planningRequestHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
    readonly reorderingPeriodicity: Promise<integer | null>;
    readonly reorderingSuggestionType: Promise<sageX3MasterData.enums.SuggestionType | null>;
    readonly reorderingSite: Reference<sageX3System.nodes.Site | null>;
    readonly reorderingPolicy: Promise<string>;
    readonly stockCoverageInWeeks: Promise<integer | null>;
    readonly safetyStock: Promise<decimal | null>;
    readonly reorderingThreshold: Promise<decimal | null>;
    readonly reorderingMaximumStock: Promise<decimal | null>;
    readonly economicOrderQuantity: Promise<decimal | null>;
    readonly technicalLotQuantity: Promise<decimal | null>;
    readonly standardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
    readonly revisedStandardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
    readonly budgetStandardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
    readonly simulatedCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
    readonly isReleasedIfShortage: Promise<boolean>;
    readonly automaticClosingPercentage: Promise<decimal | null>;
    readonly salesDeliveryTolerance: Promise<decimal | null>;
    readonly salesMinimumQuantity: Promise<decimal | null>;
    readonly salesMaximumQuantity: Promise<decimal | null>;
    readonly isLoanAuthorized: Promise<boolean>;
    readonly isBackToBackOrderManaged: Promise<boolean>;
    readonly directBackToBackOrderQuantity: Promise<decimal | null>;
    readonly isPurchased: Promise<boolean>;
    readonly isManufactured: Promise<boolean>;
    readonly isSubcontracted: Promise<boolean>;
    readonly isService: Promise<boolean>;
    readonly isPhantom: Promise<boolean>;
    readonly isGeneric: Promise<boolean>;
    readonly isTool: Promise<boolean>;
    readonly isDeliverable: Promise<boolean>;
    readonly isIntermediary: Promise<boolean>;
    readonly isMaintenance: Promise<boolean>;
    readonly packagingCapacity: Promise<decimal | null>;
    readonly assignmentRules: Promise<string>;
    readonly isStockDetailedInPacking: Promise<boolean>;
    readonly technicalSheet: Reference<sageX3MasterData.nodes.TechnicalSheet | null>;
    readonly orderWarehouse: Promise<string>;
    readonly workOrderWarehouse: Promise<string>;
    readonly shippingWarehouse: Promise<string>;
    readonly materialConsumptionWarehouse: Promise<string>;
    readonly internalMovementWarehouse: Promise<string>;
    readonly subcontractShipmentWarehouse: Promise<string>;
    readonly subcontractConsumptionWarehouse: Promise<string>;
    readonly afterSalesWarehouse: Promise<string>;
    readonly canBeCapitalized: Promise<boolean>;
    readonly isPackingManaged: Promise<boolean>;
    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly saftProductType: Promise<sageX3MasterData.enums.SafTProductType | null>;
    readonly freightClass: Promise<string>;
    readonly freightCommodityCode: Promise<string>;
    readonly isVersionManaged: Promise<boolean>;
    readonly minorVersionSequence: Promise<string>;
    readonly majorVersionSequence: Promise<string>;
    readonly isVersionPreloaded: Promise<boolean>;
    readonly inventoryProductType: Promise<sageX3MasterData.enums.ProductType | null>;
    readonly containerManagement: Promise<boolean>;
    readonly statisticalGroups: Collection<sageX3MasterData.nodes.ProductCategoryStatisticalGroups>;
}
//# sourceMappingURL=product-category.d.ts.map