"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Customer = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        code: {
            code: 'code',
        },
        customerCategory: {
            code: 'customerCategory',
        },
        billToCustomer: {
            code: 'billToCustomer',
        },
        billToCustomerAddress: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'billToCustomer',
            code: 'billToCustomerAddress',
        },
        payByCustomer: {
            code: 'payByCustomer',
        },
        payByCustomerAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'payByCustomer',
            code: 'payByCustomerAddress',
        },
        groupCustomer: {
            code: 'groupCustomer',
        },
        riskCustomer: {
            code: 'riskCustomer',
        },
        defaultAddress: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'code',
            code: 'defaultAddress',
        },
        defaultShipToAddress: {
            customer: 'code',
            shipToAddress: 'defaultShipToAddress',
        },
        defaultContact: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'code',
            code: 'defaultContact',
        },
        currency: {
            code: 'currency',
        },
        insuranceCompany: {
            code: 'insuranceCompany',
        },
        businessSector: {
            glossaryId() {
                return 425;
            },
            code: 'businessSector',
        },
        prospectOrigin: {
            glossaryId() {
                return 413;
            },
            code: 'prospectOrigin',
        },
        printTemplate: {
            code: 'printTemplate',
        },
        unavailablePaymentPeriod: {
            code: 'unavailablePaymentPeriod',
        },
        contact: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'code',
            code: 'contact',
        },
        businessPartner: {
            code: 'code',
        },
        orderHeaderTextRef: {
            code: 'orderHeaderTextKey',
        },
        invoiceHeaderTextRef: {
            code: 'invoiceHeaderTextKey',
        },
    },
    collectionJoins: {
        addresses: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'code',
        },
        contacts: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'code',
        },
        bankDetails: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'code',
        },
        shipToCustomers: {
            customer: 'code',
        },
    },
};
const compositeReferences = {
    businessPartner: {
        acronym: 'acronym',
        businessPartnerSite: 'businessPartnerSite',
        cfonbPaymentMethod: 'cfonbPaymentMethod',
        companyName1: 'companyName1',
        companyName2: 'companyName2',
        companyNames: 'companyNames',
        consolidationCode: 'consolidationCode',
        consolidationGroup: 'consolidationGroup',
        consolidationPartner: 'consolidationPartner',
        country: 'country',
        customerOrSupplierOriginCategory: 'customerOrSupplierOriginCategory',
        documentType: 'documentType',
        economicOperatorRegistrationAndIdNumber: 'economicOperatorRegistrationAndIdNumber',
        electronicAddress: 'electronicAddress',
        electronicInvoiceType: 'electronicInvoiceType',
        europeanUnionVatNumber: 'europeanUnionVatNumber',
        fiscalCode: 'fiscalCode',
        isCashExcluded: 'isCashExcluded',
        isIntersite: 'isIntersite',
        isMailingProhibited: 'isMailingProhibited',
        isPhysicalPerson: 'isPhysicalPerson',
        isPublicSector: 'isPublicSector',
        isServiceCaller: 'isServiceCaller',
        isServiceSupplier: 'isServiceSupplier',
        italianTaxNumber: 'italianTaxNumber',
        language: 'language',
        nonResidentAccount: 'nonResidentAccount',
        registrationNumber: 'registrationNumber',
        relatedCompany: 'relatedCompany',
        reportAccessCode: 'reportAccessCode',
        routingCode: 'routingCode',
        serviceCode: 'serviceCode',
        shortCompanyName: 'shortCompanyName',
        siteIdentificationNumber: 'siteIdentificationNumber',
        standardIndustrialClassificationCode: 'standardIndustrialClassificationCode',
        vatNumber: 'vatNumber',
    },
    invoiceHeaderTextRef: {
        invoiceHeaderText: 'text',
    },
    orderHeaderTextRef: {
        orderHeaderText: 'text',
    },
};
let Customer = class Customer extends xtrem_core_1.Node {
};
exports.Customer = Customer;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Customer.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BCGCOD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CustomerCategory,
    })
], Customer.prototype, "customerCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], Customer.prototype, "billToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], Customer.prototype, "billToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCPYR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Customer.prototype, "payByCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAPYR',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], Customer.prototype, "payByCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCGRU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], Customer.prototype, "groupCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCRSK',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], Customer.prototype, "riskCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], Customer.prototype, "defaultAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPDADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ShipToCustomerAddress,
    })
], Customer.prototype, "defaultShipToAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerContact,
    })
], Customer.prototype, "defaultContact", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCSTA',
    })
], Customer.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isStored: true,
        columnName: 'PPTFLG',
        serviceOptions: () => [sageX3System.serviceOptions.PptActivityCode],
    })
], Customer.prototype, "isProspect", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCBPSNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "ourSupplierCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], Customer.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], Customer.prototype, "rateType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COMCAT',
        dataType: () => sageX3MasterData.enums.commissionCategoryDatatype,
    })
], Customer.prototype, "commissionCategory", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VATEXN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "exemptionTaxNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRITYP',
        dataType: () => sageX3MasterData.enums.priceAmountTaxTaxDatatype,
    })
], Customer.prototype, "priceOrAmountType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OSTCTL',
        dataType: () => sageX3MasterData.enums.workInProgressControlDatatype,
    })
], Customer.prototype, "creditControl", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OSTAUZ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Customer.prototype, "authorizedCreditAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDMINAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Customer.prototype, "minimumOrderAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDTISR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Customer.prototype, "creditInsuranceAmount", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDTISRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Customer.prototype, "insuranceDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCCDTISR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Customer.prototype, "insuranceCompany", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FUPTYP',
        dataType: () => sageX3MasterData.enums.reminderTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.FupActivityCode],
    })
], Customer.prototype, "reminderType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FUPMINAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.FupActivityCode],
    })
], Customer.prototype, "minimumReminderAmount", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MTCFLG',
    })
], Customer.prototype, "canBeMatched", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'ORDTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "orderHeaderTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'INVTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "invoiceHeaderTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LNDAUZ',
        serviceOptions: () => [sageX3System.serviceOptions.LndActivityCode],
    })
], Customer.prototype, "isLoanAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OCNFLG',
    })
], Customer.prototype, "mustPrintAcknowledgment", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORDCLE',
    })
], Customer.prototype, "isOrderClosingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ODL',
    })
], Customer.prototype, "mustContainOneOrderPerDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BUS',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 425,
            },
            control: {
                glossaryId: 425,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], Customer.prototype, "businessSector", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIPPT',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 413,
            },
            control: {
                glossaryId: 413,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], Customer.prototype, "prospectOrigin", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PITCDT',
    })
], Customer.prototype, "tokenCredit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PITCPT',
    })
], Customer.prototype, "manualAdditionalToken", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTPIT',
    })
], Customer.prototype, "totalTokenCredit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COTPITRQD',
    })
], Customer.prototype, "necessaryTokensForServiceContract", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTFIRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Customer.prototype, "firstContactDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDFIRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Customer.prototype, "firstOrderDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUOLASDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.PptActivityCode],
    })
], Customer.prototype, "lastQuoteDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTLASDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.PptActivityCode],
    })
], Customer.prototype, "lastContactDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTNEXDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.PptActivityCode],
    })
], Customer.prototype, "nextContactDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ABCCLS',
        dataType: () => sageX3MasterData.enums.productAbcClassDatatype,
    })
], Customer.prototype, "customerAbcClass", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TPMCOD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.PrintTemplate,
    })
], Customer.prototype, "printTemplate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCSNCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Customer.prototype, "initialDateSinceCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UVYCOD2',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnavailablePeriods,
    })
], Customer.prototype, "unavailablePaymentPeriod", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BELVATSUB',
        serviceOptions: () => [sageX3System.serviceOptions.KbeActivityCode],
    })
], Customer.prototype, "isSubjectToTax", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ELECTINV',
        serviceOptions: () => [sageX3System.serviceOptions.EfatActivityCode],
    })
], Customer.prototype, "isEfatElectronicInvoicingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTEFAT',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerContact,
        serviceOptions: () => [sageX3System.serviceOptions.EfatActivityCode],
    })
], Customer.prototype, "contact", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDATEFAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.EfatActivityCode],
    })
], Customer.prototype, "startDateforElectronicInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AEIFLG',
        serviceOptions: () => [sageX3System.serviceOptions.ElinvActivityCode],
    })
], Customer.prototype, "isElectronicInvoiceAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.CustomerAddress,
        isMutable: true,
        dependsOn: ['code'],
    })
], Customer.prototype, "addresses", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.CustomerContact,
        isMutable: true,
        dependsOn: ['code'],
    })
], Customer.prototype, "contacts", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.CustomerBankDetail,
        isMutable: true,
        dependsOn: ['code'],
    })
], Customer.prototype, "bankDetails", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Customer.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.ShipToCustomerAddress,
        isMutable: true,
        dependsOn: ['code'],
    })
], Customer.prototype, "shipToCustomers", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], Customer.prototype, "orderHeaderTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], Customer.prototype, "invoiceHeaderTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRLOG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "acronym", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], Customer.prototype, "businessPartnerSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MODPAM',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], Customer.prototype, "cfonbPaymentMethod", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "companyName1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "companyName2", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.BusinessPartnerCompanyNames,
        isMutable: true,
    })
], Customer.prototype, "companyNames", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRUCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.CslActivityCode],
    })
], Customer.prototype, "consolidationCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GRUGPY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.SiteGroupings,
    })
], Customer.prototype, "consolidationGroup", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CSLBPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
        serviceOptions: () => [sageX3System.serviceOptions.PrcslActivityCode],
    })
], Customer.prototype, "consolidationPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], Customer.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BRGOBJ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "customerOrSupplierOriginCategory", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DOCTYP',
        dataType: () => sageX3MasterData.enums.documentTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], Customer.prototype, "documentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EORINUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EoriActivityCode],
    })
], Customer.prototype, "economicOperatorRegistrationAndIdNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ELCADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], Customer.prototype, "electronicAddress", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EINVTYP',
        dataType: () => sageX3MasterData.enums.electronicInvoiceTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], Customer.prototype, "electronicInvoiceType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], Customer.prototype, "europeanUnionVatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FISCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KitActivityCode],
    })
], Customer.prototype, "fiscalCode", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], Customer.prototype, "invoiceHeaderText", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CFOEXD',
        serviceOptions: () => [sageX3System.serviceOptions.CfomActivityCode],
    })
], Customer.prototype, "isCashExcluded", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETFCY',
    })
], Customer.prototype, "isIntersite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRFBDMAG',
    })
], Customer.prototype, "isMailingProhibited", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEGETT',
    })
], Customer.prototype, "isPhysicalPerson", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPPFLG',
    })
], Customer.prototype, "isPublicSector", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DOOFLG',
    })
], Customer.prototype, "isServiceCaller", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRVFLG',
    })
], Customer.prototype, "isServiceSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VATNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KitActivityCode],
    })
], Customer.prototype, "italianTaxNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], Customer.prototype, "language", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCNONREI',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], Customer.prototype, "nonResidentAccount", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], Customer.prototype, "orderHeaderText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KzaActivityCode],
    })
], Customer.prototype, "registrationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPYREL',
        dataType: () => sageX3MasterData.enums.relatedCompanySettingsDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PbdpoActivityCode],
    })
], Customer.prototype, "relatedCompany", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACS',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], Customer.prototype, "reportAccessCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RTGCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], Customer.prototype, "routingCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INTSRVCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], Customer.prototype, "serviceCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "shortCompanyName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Customer.prototype, "siteIdentificationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NAF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KfrActivityCode],
    })
], Customer.prototype, "standardIndustrialClassificationCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VATNO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KzaActivityCode],
    })
], Customer.prototype, "vatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.CustomerCashTaxRules,
    })
], Customer.prototype, "cashTaxRules", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.CustomerPaymentDays,
    })
], Customer.prototype, "paymentDays", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.CustomerSalesReps,
    })
], Customer.prototype, "salesReps", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.CustomerStatisticalGroups,
    })
], Customer.prototype, "statisticalGroups", void 0);
exports.Customer = Customer = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPCUSTOMER',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            denormalizedPropertyColumnSuffix: {
                companyName1: 0,
                companyName2: 1,
            },
        }),
        getFilters() {
            return [{ isProspect: false }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
        canUpdate: true,
    })
], Customer);
//# sourceMappingURL=customer.js.map