"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerAddressAddressPhoneNumbers = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const denormalized = { maxRepeat: 5 };
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            entityType: 'entityType',
            customer: 'customer',
            code: 'code',
        },
    },
};
let CustomerAddressAddressPhoneNumbers = class CustomerAddressAddressPhoneNumbers extends xtrem_core_1.Node {
};
exports.CustomerAddressAddressPhoneNumbers = CustomerAddressAddressPhoneNumbers;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], CustomerAddressAddressPhoneNumbers.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPATYP',
        dataType: () => sageX3Structure.enums.entityTypeDatatype,
    })
], CustomerAddressAddressPhoneNumbers.prototype, "entityType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'BPANUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddressAddressPhoneNumbers.prototype, "customer", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'BPAADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddressAddressPhoneNumbers.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], CustomerAddressAddressPhoneNumbers.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddressAddressPhoneNumbers.prototype, "addressPhoneNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isNullable: true,
        dataType: () => sageX3System.enums.telephoneTypeDatatype,
        computeValue() {
            return sageX3MasterData.functions.getPhoneNumberType(this);
        },
    })
], CustomerAddressAddressPhoneNumbers.prototype, "phoneType", void 0);
exports.CustomerAddressAddressPhoneNumbers = CustomerAddressAddressPhoneNumbers = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPADDRESS',
        keyPropertyNames: ['denormalizedIndex', 'entityType', 'customer', 'code'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], CustomerAddressAddressPhoneNumbers);
//# sourceMappingURL=customer-address-address-phone-numbers.js.map