import * as sageX3System from '@sage/x3-system';
import { Node, Reference, decimal, integer } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class Container extends Node {
    readonly code: Promise<string>;
    readonly containerType: Promise<sageX3MasterData.enums.InternalContainerType | null>;
    readonly isActive: Promise<boolean>;
    readonly description: Promise<string>;
    readonly shortDescription: Promise<string>;
    readonly sizeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly tareWeight: Promise<decimal | null>;
    readonly maxWeight: Promise<decimal | null>;
    readonly length: Promise<decimal | null>;
    readonly width: Promise<decimal | null>;
    readonly height: Promise<decimal | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volume: Promise<decimal | null>;
    readonly usableVolume: Promise<decimal | null>;
    readonly twentyFootEquivalentUnit: Promise<integer | null>;
    readonly isRefrigerated: Promise<boolean>;
    readonly isInternal: Promise<boolean>;
    readonly isFreight: Promise<boolean>;
    readonly isSingleProduct: Promise<boolean>;
    readonly isSingleLot: Promise<boolean>;
    readonly labelFormat: Reference<sageX3System.nodes.GenericPrintReport | null>;
}
//# sourceMappingURL=container.d.ts.map