"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonImage = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {};
let CommonImage = class CommonImage extends xtrem_core_1.Node {
};
exports.CommonImage = CommonImage;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODBLB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CommonImage.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IDENT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CommonImage.prototype, "identifier1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IDENT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CommonImage.prototype, "identifier2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NAMBLB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CommonImage.prototype, "fileName", void 0);
__decorate([
    xtrem_core_1.decorators.binaryStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BLOB',
    })
], CommonImage.prototype, "data", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYPBLB',
        dataType: () => sageX3System.enums.typeOfNonStandardFileDatatype,
    })
], CommonImage.prototype, "specialFileType", void 0);
exports.CommonImage = CommonImage = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CBLOB',
        keyPropertyNames: ['code', 'identifier1', 'identifier2'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                    identifier1: 1,
                    identifier2: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['code', 'identifier1', 'identifier2'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], CommonImage);
//# sourceMappingURL=common-image.js.map