import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, Collection } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class BusinessPartner extends Node {
    readonly code: Promise<string>;
    readonly isActive: Promise<boolean>;
    readonly category: Reference<sageX3MasterData.nodes.CustomerCategory | null>;
    readonly customerOrSupplierOriginCategory: Promise<string>;
    readonly companyName1: Promise<string>;
    readonly companyName2: Promise<string>;
    readonly shortCompanyName: Promise<string>;
    readonly europeanUnionVatNumber: Promise<string>;
    readonly isIntersite: Promise<boolean>;
    readonly businessPartnerSite: Reference<sageX3System.nodes.Site | null>;
    readonly country: Reference<sageX3Structure.nodes.Country | null>;
    readonly siteIdentificationNumber: Promise<string>;
    readonly standardIndustrialClassificationCode: Promise<string>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly language: Reference<sageX3System.nodes.Language>;
    readonly acronym: Promise<string>;
    readonly italianTaxNumber: Promise<string>;
    readonly fiscalCode: Promise<string>;
    readonly consolidationGroup: Reference<sageX3Structure.nodes.SiteGroupings | null>;
    readonly consolidationCode: Promise<string>;
    readonly isCustomer: Promise<boolean>;
    readonly isSupplier: Promise<boolean>;
    readonly isGrantor: Promise<boolean>;
    readonly isCarrier: Promise<boolean>;
    readonly isFactor: Promise<boolean>;
    readonly isSalesRep: Promise<boolean>;
    readonly isMiscellaneousBusinessPartner: Promise<boolean>;
    readonly isProspect: Promise<boolean>;
    readonly isServiceSupplier: Promise<boolean>;
    readonly isServiceCaller: Promise<boolean>;
    readonly defaultAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly defaultContact: Reference<sageX3MasterData.nodes.BusinessPartnerContact | null>;
    readonly defaultBankId: Reference<sageX3MasterData.nodes.BusinessPartnerBankDetail | null>;
    readonly bankIdCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly reportAccessCode: Reference<sageX3System.nodes.Access | null>;
    readonly isMailingProhibited: Promise<boolean>;
    readonly cfonbPaymentMethod: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly nonResidentAccount: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly isPhysicalPerson: Promise<boolean>;
    readonly isCashExcluded: Promise<boolean>;
    readonly documentType: Promise<sageX3MasterData.enums.DocumentType | null>;
    readonly isPublicSector: Promise<boolean>;
    readonly relatedCompany: Promise<sageX3MasterData.enums.RelatedCompanySettings | null>;
    readonly consolidationPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly registrationNumber: Promise<string>;
    readonly vatNumber: Promise<string>;
    readonly economicOperatorRegistrationAndIdNumber: Promise<string>;
    readonly serviceCode: Promise<string>;
    readonly routingCode: Promise<string>;
    readonly electronicInvoiceType: Promise<sageX3MasterData.enums.ElectronicInvoiceType | null>;
    readonly mappingCode: Reference<sageX3MasterData.nodes.Mapping | null>;
    readonly electronicAddress: Promise<string>;
    readonly addresses: Collection<sageX3MasterData.nodes.BusinessPartnerAddress>;
    readonly contacts: Collection<sageX3MasterData.nodes.BusinessPartnerContact>;
    readonly bankDetails: Collection<sageX3MasterData.nodes.BusinessPartnerBankDetail>;
    readonly companyException: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyException>;
    readonly companyNames: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyNames>;
}
//# sourceMappingURL=business-partner.d.ts.map