"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessPartnerBankDetail = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        businessPartner: {
            code: 'businessPartner',
        },
        address: {
            entityType: 'entityType',
            businessPartner: 'businessPartner',
            code: 'address',
        },
        country: {
            code: 'country',
        },
        currency: {
            code: 'currency',
        },
        intermediaryBankCountry: {
            code: 'intermediaryBankCountry',
        },
    },
};
let BusinessPartnerBankDetail = class BusinessPartnerBankDetail extends xtrem_core_1.Node {
};
exports.BusinessPartnerBankDetail = BusinessPartnerBankDetail;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPATYP',
        dataType: () => sageX3Structure.enums.entityTypeDatatype,
    })
], BusinessPartnerBankDetail.prototype, "entityType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPANUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], BusinessPartnerBankDetail.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BIDNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerBankDetail.prototype, "bankId", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], BusinessPartnerBankDetail.prototype, "address", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BIDNUMFLG',
    })
], BusinessPartnerBankDetail.prototype, "byDefault", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BNF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerBankDetail.prototype, "beneficiary", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAB1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerBankDetail.prototype, "payingBank1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAB2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "payingBank2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAB3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "payingBank3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAB4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "payingBank4", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IBAN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerBankDetail.prototype, "ibanPrefix", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BICCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "bic", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], BusinessPartnerBankDetail.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], BusinessPartnerBankDetail.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MIDPAB1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "intermediaryBankName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MIDPAB2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "intermediaryBankAddress1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MIDPAB3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "intermediaryBankAddress2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MIDPAB4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "intermediaryBankAddress3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MIDBICCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "intermediaryBankBic", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MIDCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
        serviceOptions: () => [sageX3System.serviceOptions.ViiActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "intermediaryBankCountry", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ACCNONREI',
    })
], BusinessPartnerBankDetail.prototype, "nonResidentAccount", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BVRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KswActivityCode],
    })
], BusinessPartnerBankDetail.prototype, "isrCustomerNumber", void 0);
exports.BusinessPartnerBankDetail = BusinessPartnerBankDetail = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BID',
        keyPropertyNames: ['entityType', 'businessPartner', 'bankId', 'address'],
        indexes: [
            {
                orderBy: {
                    entityType: 1,
                    businessPartner: 1,
                    bankId: 1,
                    address: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['entityType', 'businessPartner', 'bankId', 'address'],
        }),
        getFilters() {
            return [{ entityType: 'businessPartner' }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], BusinessPartnerBankDetail);
//# sourceMappingURL=business-partner-bank-detail.js.map