"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BomRouting = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        accessCode: {
            access: 'accessCode',
        },
        site: {
            code: 'site',
        },
        bomCode1: {
            bomType() {
                return 'manufacturing';
            },
            code: 'bomCode1',
        },
        bomCode2: {
            bomType() {
                return 'manufacturing';
            },
            code: 'bomCode2',
        },
        bomCode3: {
            bomType() {
                return 'manufacturing';
            },
            code: 'bomCode3',
        },
    },
};
let BomRouting = class BomRouting extends xtrem_core_1.Node {
};
exports.BomRouting = BomRouting;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ROUALT',
    })
], BomRouting.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRODESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], BomRouting.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TROSHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], BomRouting.prototype, "shortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACSCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], BomRouting.prototype, "accessCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], BomRouting.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGUSE',
    })
], BomRouting.prototype, "isProductionUtilization", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSTUSE',
    })
], BomRouting.prototype, "isCostUtilization", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCCUSE',
    })
], BomRouting.prototype, "isRccpUtilization", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMALT1',
        columnType: 'integer',
        filters: {
            lookup: {
                bomType: 'manufacturing',
            },
            control: {
                bomType: 'manufacturing',
            },
        },
        node: () => sageX3MasterData.nodes.BomCodes,
    })
], BomRouting.prototype, "bomCode1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMALT2',
        columnType: 'integer',
        filters: {
            lookup: {
                bomType: 'manufacturing',
            },
            control: {
                bomType: 'manufacturing',
            },
        },
        node: () => sageX3MasterData.nodes.BomCodes,
    })
], BomRouting.prototype, "bomCode2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMALT3',
        columnType: 'integer',
        filters: {
            lookup: {
                bomType: 'manufacturing',
            },
            control: {
                bomType: 'manufacturing',
            },
        },
        node: () => sageX3MasterData.nodes.BomCodes,
    })
], BomRouting.prototype, "bomCode3", void 0);
exports.BomRouting = BomRouting = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'TABROUALT',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], BomRouting);
//# sourceMappingURL=bom-routing.js.map