"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BomDetail = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        parentProduct: {
            code: 'parentProduct',
        },
        bomCode: {
            parentProduct: 'parentProduct',
            bomCode: 'bomCode',
            bomType: 'bomType',
        },
        componentProduct: {
            code: 'componentProduct',
        },
        uom: {
            code: 'uom',
        },
    },
};
let BomDetail = class BomDetail extends xtrem_core_1.Node {
};
exports.BomDetail = BomDetail;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], BomDetail.prototype, "parentProduct", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMALT',
        columnType: 'integer',
        node: () => sageX3MasterData.nodes.BomHeader,
    })
], BomDetail.prototype, "bomCode", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMSEQ',
    })
], BomDetail.prototype, "sequence", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPNITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], BomDetail.prototype, "componentProduct", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMALTTYP',
        dataType: () => sageX3MasterData.enums.bomCodeTypeDatatype,
    })
], BomDetail.prototype, "bomType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMSEQNUM',
    })
], BomDetail.prototype, "sequenceRemainder", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPNTYP',
        dataType: () => sageX3MasterData.enums.componentTypeDatatype,
    })
], BomDetail.prototype, "componentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BomDetail.prototype, "linkDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMSTRLOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BomDetail.prototype, "firstValidLot", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMENDLOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BomDetail.prototype, "lastValidLot", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMSTRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], BomDetail.prototype, "validityStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], BomDetail.prototype, "validityEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LIKQTYCOD',
        dataType: () => sageX3MasterData.enums.bomQuantityLinkDatatype,
    })
], BomDetail.prototype, "linkQuantityCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYRND',
        dataType: () => sageX3MasterData.enums.componentRoundedDatatype,
    })
], BomDetail.prototype, "quantityRounding", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMUOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], BomDetail.prototype, "uom", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BomDetail.prototype, "uomStockFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BomDetail.prototype, "uomLinkQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LIKQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BomDetail.prototype, "linkQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BomDetail.prototype, "scrapFactorPercentage", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPNOPE',
    })
], BomDetail.prototype, "routingOperation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPENUMLEV',
    })
], BomDetail.prototype, "routingOperationSuffix", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMOFS',
    })
], BomDetail.prototype, "operationLeadTime", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PICPRN',
    })
], BomDetail.prototype, "isPrintMaterialNote", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OCNPRN',
    })
], BomDetail.prototype, "isPrintAcknowledgment", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NDEPRN',
    })
], BomDetail.prototype, "isPrintPackingSlip", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVPRN',
    })
], BomDetail.prototype, "isPrintInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LIKRLE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BomDetail.prototype, "linkReviewIndex", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSTFLG',
    })
], BomDetail.prototype, "isValuation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PKC',
        dataType: () => sageX3MasterData.enums.codeToServeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.MwmActivityCode],
    })
], BomDetail.prototype, "pickListCode", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMTOLPOS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.MwmActivityCode],
    })
], BomDetail.prototype, "weighingPositiveTolerancePercentage", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMTOLNEG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.MwmActivityCode],
    })
], BomDetail.prototype, "weighingNegativeTolerancePercentage", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LEVSET',
        dataType: () => sageX3MasterData.enums.toleranceDefinitionLevelDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.MwmActivityCode],
    })
], BomDetail.prototype, "setupLevel", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOFLG',
        dataType: () => sageX3MasterData.enums.materialReplenishTypeDatatype,
    })
], BomDetail.prototype, "typeOfSupply", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FORSEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BomDetail.prototype, "selectionFormula", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FORQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BomDetail.prototype, "quantityFormula", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMAJ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], BomDetail.prototype, "majorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], BomDetail.prototype, "minorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCRLEGRP',
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], BomDetail.prototype, "revisionGroup", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.MwcActivityCode],
    })
], BomDetail.prototype, "masterContainer", void 0);
exports.BomDetail = BomDetail = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BOMD',
        keyPropertyNames: ['parentProduct', 'bomCode', 'sequence', 'componentProduct', 'bomType'],
        indexes: [
            {
                orderBy: {
                    parentProduct: 1,
                    bomCode: 1,
                    sequence: 1,
                    componentProduct: 1,
                    bomType: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['componentProduct'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], BomDetail);
//# sourceMappingURL=bom-detail.js.map