"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SiteExtension = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        unavailabilityCode: {
            code: 'unavailabilityCode',
        },
    },
    collectionJoins: {
        addresses: {
            entityType() {
                return 'site';
            },
            site: 'code',
        },
        contacts: {
            entityType() {
                return 'site';
            },
            site: 'code',
        },
        bankDetails: {
            entityType() {
                return 'site';
            },
            site: 'code',
        },
    },
};
let SiteExtension = class SiteExtension extends xtrem_core_1.NodeExtension {
};
exports.SiteExtension = SiteExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UVYCOD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnavailablePeriods,
    })
], SiteExtension.prototype, "unavailabilityCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RTGCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], SiteExtension.prototype, "routingCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ELCADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], SiteExtension.prototype, "electronicAddress", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.SiteAddress,
        isMutable: true,
        dependsOn: ['code'],
    })
], SiteExtension.prototype, "addresses", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.SiteContact,
        isMutable: true,
        dependsOn: ['code'],
    })
], SiteExtension.prototype, "contacts", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.SiteBankDetail,
        isMutable: true,
        dependsOn: ['code'],
    })
], SiteExtension.prototype, "bankDetails", void 0);
exports.SiteExtension = SiteExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3System.nodes.Site,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], SiteExtension);
//# sourceMappingURL=site-extension.js.map