"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNodeStatus = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const xtrem_core_1 = require("@sage/xtrem-core");
function getNodeStatus(_this) {
    if (typesLib.strictEq(_this.$.status, xtrem_core_1.NodeStatus.added)) {
        return 'C';
    }
    if (typesLib.strictEq(_this.$.status, xtrem_core_1.NodeStatus.modified)) {
        return 'U';
    }
    if (typesLib.strictEq(_this.$.status, xtrem_core_1.NodeStatus.deleted)) {
        return 'D';
    }
    return 'R';
}
exports.getNodeStatus = getNodeStatus;
//# sourceMappingURL=node-status.js.map