"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeWeeklyCapacity = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
function computeWeeklyCapacity(_this) {
    const weeklyCapacity = _this.weeklyStructureDailyCapacity;
    // 0 is initial value
    return weeklyCapacity.reduce(async (accumulator, item) => {
        const calcItem = (await item.dailyCapicity) ?? 0;
        return typesLib.add(accumulator, calcItem);
    }, 0);
}
exports.computeWeeklyCapacity = computeWeeklyCapacity;
//# sourceMappingURL=compute-weekly-capacity.js.map