"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bankSignDatatype = exports.BankSignEnum = void 0;
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
var BankSignEnum;
(function (BankSignEnum) {
    BankSignEnum[BankSignEnum["expense"] = 1] = "expense";
    BankSignEnum[BankSignEnum["revenue"] = 2] = "revenue";
    BankSignEnum[BankSignEnum["expenseReversal"] = 3] = "expenseReversal";
    BankSignEnum[BankSignEnum["revenueReversal"] = 4] = "revenueReversal";
})(BankSignEnum || (exports.BankSignEnum = BankSignEnum = {}));
exports.bankSignDatatype = new xtrem_x3_gateway_1.X3EnumDataType({
    enum: BankSignEnum,
    filename: __filename,
    localMenuNumber: 3680,
});
//# sourceMappingURL=bank-sign.js.map