"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.onGoto = void 0;
const ui = require("@sage/xtrem-ui");
/**
 * This allow to change page delayed
 * @param pageInstance current page instance
 * @param address page url
 * @param parameters optional parameters
 *
 */
/** @internal */
function onGoto(pageInstance, address, parameters) {
    setTimeout(() => {
        try {
            pageInstance.$.removeToasts();
            pageInstance.$.setPageClean();
            pageInstance.$.router.goTo(address, parameters);
        }
        catch (error) {
            ui.console.error(`Router goto failure :\n${JSON.stringify(error) ?? ''}`);
        }
    }, 100);
}
exports.onGoto = onGoto;
//# sourceMappingURL=on-goto.js.map