"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSelectedStockSite = void 0;
const dialogs_1 = require("./dialogs");
/**
 * Return selected stock site for current application
 * @param pageInstance Current page instance
 * @param errorTitle error title when no default site exist
 * @param errorMessage error message when no default site exist
 * @returns default site or null
 */
async function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {
    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');
    if (!selectedSite) {
        // Please note that there asynchronous processing is not prefixed by an await on purpose
        // so that it can be processed in parallel and not block the main process.
        // Be careful not to leave the current page before the user has closed this dialog box.
        pageInstance.$.sound.error();
        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);
        return null;
    }
    else {
        return selectedSite.toString();
    }
}
exports.getSelectedStockSite = getSelectedStockSite;
//# sourceMappingURL=get-selected-stock-site.js.map