"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPageValuesNotTransient = void 0;
/**
 * Return values not transient for current page
 * @param pageInstance Current page instance
 * @returns array of values not transient
 */
const getPageValuesNotTransient = (pageInstance) => {
    const screenValues = pageInstance.$.values;
    const keys = Object.keys(screenValues);
    keys.forEach(elementId => {
        const properties = pageInstance._pageMetadata.uiComponentProperties[elementId];
        if (properties && properties.isTransient) {
            delete screenValues[elementId];
        }
    });
    return screenValues;
};
exports.getPageValuesNotTransient = getPageValuesNotTransient;
//# sourceMappingURL=get-page-values-not-transient.js.map