declare module '@sage/x3-master-data-api-partial' {
    import type { Country, Package as SageX3Structure$Package, SiteGroupings } from '@sage/x3-structure-api';
    import type {
        Access,
        Company,
        GenericPrintReport,
        Image,
        Language,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        SiteInput,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        CreateOperation,
        GetDefaultsOperation,
        GetDuplicateOperation,
        Operation as Node$Operation,
        QueryOperation,
        ReadOperation,
        TextStream,
        UpdateByIdOperation,
        UpdateOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AbelEntreprisePlans$Enum {
        technical: 1;
        reprocessed: 2;
        grant: 3;
        free1: 4;
        free2: 5;
        free3: 6;
        free4: 7;
        free5: 8;
        free6: 9;
        none: 10;
    }
    export type AbelEntreprisePlans = keyof AbelEntreprisePlans$Enum;
    export interface AccSourceType$Enum {
        event: 1;
        depreciation: 2;
        otherTable: 3;
        provisionsForRenewal: 4;
        varianceBetweenPlans: 5;
    }
    export type AccSourceType = keyof AccSourceType$Enum;
    export interface AcceptableQualityLevel$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        substituteValue9: 9;
        substituteValue10: 10;
        substituteValue11: 11;
        substituteValue12: 12;
    }
    export type AcceptableQualityLevel = keyof AcceptableQualityLevel$Enum;
    export interface AccountField$Enum {
        alphanumeric: 1;
        numeric: 2;
    }
    export type AccountField = keyof AccountField$Enum;
    export interface AccountStructure$Enum {
        bankBp: 1;
        bankAccount: 2;
        accountBp: 3;
    }
    export type AccountStructure = keyof AccountStructure$Enum;
    export interface AccountType$Enum {
        normal: 1;
        control: 2;
    }
    export type AccountType = keyof AccountType$Enum;
    export interface AccountingCodeType$Enum {
        product: 1;
        customer: 2;
        supplier: 3;
        salesRep: 4;
        buyer: 5;
        journal: 6;
        company: 7;
        site: 8;
        currency: 9;
        tax: 10;
        salesFooter: 11;
        discount: 12;
        bank: 13;
        payment: 14;
        fixedAssets: 15;
        purchaseFooter: 16;
        miscellaneousBusinessPartners: 17;
        costCenter: 18;
        overheads: 19;
        expensesCosts: 20;
        factor: 21;
        leaseContract: 22;
        grant: 23;
        concessionAgreement: 24;
        cost: 25;
        interface: 26;
        employee: 27;
        department: 28;
        profile: 29;
        user: 30;
        fund: 31;
        allocation: 32;
        contribution: 33;
        expenseNote: 34;
        accountingContract: 35;
        projectCostType: 36;
        project: 37;
    }
    export type AccountingCodeType = keyof AccountingCodeType$Enum;
    export interface AccountingDateRules$Enum {
        automaticJournal: 1;
        startOfProcessedPeriod: 2;
        endOfProcessedPeriod: 3;
        startOfProcessedFy: 4;
        endOfProcessedFy: 5;
        startOfCurrentPeriod: 6;
        endOfCurrentPeriod: 7;
        enteredDate: 8;
        specificDate: 9;
    }
    export type AccountingDateRules = keyof AccountingDateRules$Enum;
    export interface AccountingJournalCategory$Enum {
        actual: 1;
        activeSimulation: 2;
        inactiveSimulation: 3;
        offBalanceSheet: 4;
        template: 5;
    }
    export type AccountingJournalCategory = keyof AccountingJournalCategory$Enum;
    export interface AccountingNature$Enum {
        fixedAssetsInProgress: 1;
        fixedAssetsInService: 2;
        cost: 3;
        others: 4;
    }
    export type AccountingNature = keyof AccountingNature$Enum;
    export interface AccountingReferential$Enum {
        undetermined: 1;
        companyAccounting: 2;
        groupAccounting: 3;
    }
    export type AccountingReferential = keyof AccountingReferential$Enum;
    export interface Action2011$Enum {
        send: 1;
        receive: 2;
    }
    export type Action2011 = keyof Action2011$Enum;
    export interface Action2070$Enum {
        send: 1;
        receive: 2;
        all: 3;
    }
    export type Action2070 = keyof Action2070$Enum;
    export interface ActionOnPhysicalAssetCount$Enum {
        newNote: 1;
        pendingDecision: 2;
        validated: 3;
        rejected: 4;
        assetUpdated: 5;
        matchingAsset: 6;
        rejectedNote: 7;
    }
    export type ActionOnPhysicalAssetCount = keyof ActionOnPhysicalAssetCount$Enum;
    export interface ActionOrigins$Enum {
        manualCreation: 1;
        agenda: 2;
    }
    export type ActionOrigins = keyof ActionOrigins$Enum;
    export interface ActionerEmailText$Enum {
        planForChangeRequest1ToAction: 1;
        youAreAssignedAsAnActionerForThePlan: 2;
        toViewTheChangeRequestClickTheLink: 3;
    }
    export type ActionerEmailText = keyof ActionerEmailText$Enum;
    export interface ActionsOfNavigation$Enum {
        new: 1;
        filter: 2;
    }
    export type ActionsOfNavigation = keyof ActionsOfNavigation$Enum;
    export interface ActionsOnDisposal$Enum {
        disposal: 1;
        disposalCancellation: 2;
        stopCancellation: 3;
    }
    export type ActionsOnDisposal = keyof ActionsOnDisposal$Enum;
    export interface Actions$Enum {
        select: 1;
        scrap: 2;
        useUp: 3;
        modify: 4;
        moveToSpares: 5;
        complete: 6;
        completeAndModify: 7;
        disassemble: 8;
        change: 9;
        remove: 10;
        block: 11;
        delay: 12;
        cancel: 13;
        returnToSupplier: 14;
        receiveAndModify: 15;
        deleteLines: 16;
        concessions: 17;
        close: 18;
        consult: 19;
        inform: 20;
        addOperations: 21;
        modifyOperations: 22;
        createNewForecast: 23;
        updateForecast: 24;
    }
    export type Actions = keyof Actions$Enum;
    export interface ActiveInactive$Enum {
        active: 1;
        inactive: 2;
    }
    export type ActiveInactive = keyof ActiveInactive$Enum;
    export interface AddresseeTypes$Enum {
        user: 1;
        businessPartners: 2;
        contact: 3;
        other: 4;
    }
    export type AddresseeTypes = keyof AddresseeTypes$Enum;
    export interface AfterSalesServiceActionTyp$Enum {
        noGeographicIncidence: 1;
        atTheCustomerSite: 2;
        atOurPremises: 3;
    }
    export type AfterSalesServiceActionTyp = keyof AfterSalesServiceActionTyp$Enum;
    export interface AfterSalesServiceDepartments$Enum {
        units: 1;
        days: 2;
        hours: 3;
        minutes: 4;
        other: 5;
    }
    export type AfterSalesServiceDepartments = keyof AfterSalesServiceDepartments$Enum;
    export interface AggregationLevel$Enum {
        detail: 1;
        date: 2;
        week: 3;
        month: 4;
    }
    export type AggregationLevel = keyof AggregationLevel$Enum;
    export interface AllApproverEmailText$Enum {
        approvalStatusSetForAllApproversForChangeRequest1: 1;
        allApproversHaveSetApprovalStatusToApprovedOrRejectedForThisChangeRequest: 2;
        toViewTheChangeRequestClickTheLink: 3;
    }
    export type AllApproverEmailText = keyof AllApproverEmailText$Enum;
    export interface AllocationStatus$Enum {
        notAllocated: 1;
        partlyAllocated: 2;
        allocated: 3;
    }
    export type AllocationStatus = keyof AllocationStatus$Enum;
    export interface AllocationType3621$Enum {
        none: 1;
        account: 2;
    }
    export type AllocationType3621 = keyof AllocationType3621$Enum;
    export interface AllocationType$Enum {
        global: 1;
        detailed: 2;
    }
    export type AllocationType = keyof AllocationType$Enum;
    export interface AlmacomProtocols$Enum {
        etebac3: 1;
        pesit: 2;
        xmodem: 3;
        etebac5: 4;
    }
    export type AlmacomProtocols = keyof AlmacomProtocols$Enum;
    export interface AmountForAssetSplit$Enum {
        coAReceiptExTaxValue: 1;
        iasIfrsReceiptExTaxValue: 2;
        coABalanceSheetValue: 3;
        iasIfrsBalanceSheetValue: 4;
        coAReevaluatedBalanceSheetValue: 5;
        iasIfrsReevaluatedBalanceSheetValue: 6;
    }
    export type AmountForAssetSplit = keyof AmountForAssetSplit$Enum;
    export interface AnalyticalInitType$Enum {
        fixed: 1;
        user: 2;
    }
    export type AnalyticalInitType = keyof AnalyticalInitType$Enum;
    export interface AnalyticalSort$Enum {
        date: 1;
        document: 2;
        dimension: 3;
    }
    export type AnalyticalSort = keyof AnalyticalSort$Enum;
    export interface AndOr2955$Enum {
        substituteValue1: 1;
        and: 2;
        or: 3;
    }
    export type AndOr2955 = keyof AndOr2955$Enum;
    export interface AndOrNot3024$Enum {
        and: 1;
        or: 2;
        andNot: 3;
        orNot: 4;
    }
    export type AndOrNot3024 = keyof AndOrNot3024$Enum;
    export interface AndOrNot$Enum {
        substituteValue1: 1;
        and: 2;
        or: 3;
        andNot: 4;
        orNot: 5;
    }
    export type AndOrNot = keyof AndOrNot$Enum;
    export interface AnnualOperationType$Enum {
        cashCollections: 1;
        insuranceOperations: 2;
        travelAgency: 3;
    }
    export type AnnualOperationType = keyof AnnualOperationType$Enum;
    export interface ApplicableRate$Enum {
        contract: 1;
        invoice: 2;
    }
    export type ApplicableRate = keyof ApplicableRate$Enum;
    export interface ApplicableRuleUponDisposal$Enum {
        disposalOnTheSpecifiedDay: 1;
        disposalAtTheEndOfThePreviousMonth: 2;
        disposalAtTheEndOfTheCurrentMonth: 3;
        disposalAtTheEndOfThePreviousFy: 4;
        disposalAtTheEndOfTheCurrentFy: 5;
        disposalAtTheEndOfThePreviousHalfYear: 6;
        disposalAtTheEndOfTheCurrentHalfYear: 7;
        noDepreciationChargeOnTheDisposalDay: 8;
        substituteValue9: 9;
        excepDeprecNetValue: 10;
    }
    export type ApplicableRuleUponDisposal = keyof ApplicableRuleUponDisposal$Enum;
    export interface AppointmentsOrigins$Enum {
        manualCreation: 1;
        massMail: 2;
        callCampaign: 3;
        tradeShow: 4;
        mediaCampaign: 5;
        marketingCampaign: 6;
    }
    export type AppointmentsOrigins = keyof AppointmentsOrigins$Enum;
    export interface ApprovalStatus3510$Enum {
        approvalPending: 1;
        approvalSubmitted: 2;
        approvalInProgress: 3;
        approvalRejected: 4;
        approvedForPrototype: 5;
        approvedForPilot: 6;
        approvedForProduction: 7;
    }
    export type ApprovalStatus3510 = keyof ApprovalStatus3510$Enum;
    export interface ApprovalStatus$Enum {
        pending: 1;
        approved: 2;
        rejected: 3;
    }
    export type ApprovalStatus = keyof ApprovalStatus$Enum;
    export interface ApproverRejectionEmailText$Enum {
        approverRejectionOfChangeRequest1: 1;
        anApproverHasRejectedThisChangeRequest: 2;
        theApproverAndRejectedEntitiesAre: 3;
        toViewTheChangeRequestClickTheLink: 4;
    }
    export type ApproverRejectionEmailText = keyof ApproverRejectionEmailText$Enum;
    export interface AssetHoldingType$Enum {
        owned: 1;
        rented: 2;
        leased: 3;
        provisional: 4;
        concession: 5;
        template: 6;
        cancelled: 7;
    }
    export type AssetHoldingType = keyof AssetHoldingType$Enum;
    export interface AssetNatureForTheTpTf$Enum {
        bnptf: 1;
        bptf: 2;
        exField: 3;
    }
    export type AssetNatureForTheTpTf = keyof AssetNatureForTheTpTf$Enum;
    export interface AssetReceiptNature$Enum {
        purchase: 1;
        internalProduction: 2;
        partialProvisionForAsset: 3;
        merger: 4;
        split: 5;
        intraGroupSales: 6;
        leaseBuyback: 7;
    }
    export type AssetReceiptNature = keyof AssetReceiptNature$Enum;
    export interface AssetSplitMethod3139$Enum {
        splitByPhysicalAsset: 1;
        splitByPendingMovement: 2;
        splitByExpense: 3;
    }
    export type AssetSplitMethod3139 = keyof AssetSplitMethod3139$Enum;
    export interface AssetSplitMethod$Enum {
        quantity: 1;
        amount: 2;
        expense: 3;
    }
    export type AssetSplitMethod = keyof AssetSplitMethod$Enum;
    export interface AssetStabilityType$Enum {
        fixed: 1;
        generalInstallation: 2;
        mobile: 3;
    }
    export type AssetStabilityType = keyof AssetStabilityType$Enum;
    export interface AssetStatusAtPurchase$Enum {
        new: 1;
        secondHand: 2;
    }
    export type AssetStatusAtPurchase = keyof AssetStatusAtPurchase$Enum;
    export interface AssetStatus$Enum {
        autonomous: 1;
        principal: 2;
        component: 3;
        componentWaitingAssignment: 4;
        pool: 5;
        lva: 6;
    }
    export type AssetStatus = keyof AssetStatus$Enum;
    export interface AssignmentTypeSre$Enum {
        accordingToMarketSector: 1;
        dispatching: 2;
        queue: 3;
        nominal: 4;
        personOnTheBase: 5;
        externalServiceProvider: 6;
    }
    export type AssignmentTypeSre = keyof AssignmentTypeSre$Enum;
    export interface AtRecordType$Enum {
        manual: 1;
        saftT: 2;
        webService: 3;
    }
    export type AtRecordType = keyof AtRecordType$Enum;
    export interface Attachement$Enum {
        no: 1;
        yes: 2;
        all: 3;
    }
    export type Attachement = keyof Attachement$Enum;
    export interface AttachmentCategories$Enum {
        select: 1;
        requestDetail: 2;
        approval: 3;
        recommendation: 4;
        planning: 5;
        implementation: 6;
        rejection: 7;
        other: 8;
    }
    export type AttachmentCategories = keyof AttachmentCategories$Enum;
    export interface AuthorizationStep$Enum {
        orderEntry: 1;
        postOrder: 2;
    }
    export type AuthorizationStep = keyof AuthorizationStep$Enum;
    export interface AutomaticJournalEnum$Enum {
        substituteValue1: 1;
        groupedJournal: 2;
    }
    export type AutomaticJournalEnum = keyof AutomaticJournalEnum$Enum;
    export interface AutomaticJournalType$Enum {
        general: 1;
        payments: 2;
    }
    export type AutomaticJournalType = keyof AutomaticJournalType$Enum;
    export interface AutomaticNumbers$Enum {
        none: 1;
        mandatory: 2;
        optional: 3;
    }
    export type AutomaticNumbers = keyof AutomaticNumbers$Enum;
    export interface BankCash$Enum {
        bank: 1;
        cash: 2;
    }
    export type BankCash = keyof BankCash$Enum;
    export interface BankFileFieldType$Enum {
        alphanumeric: 1;
        numeric: 2;
        dateDdmmyy: 3;
        dateYymmdd: 4;
        year: 5;
        month: 6;
        day: 7;
        binary: 8;
        centAmount: 9;
    }
    export type BankFileFieldType = keyof BankFileFieldType$Enum;
    export interface BankFileGenerationMode$Enum {
        create: 1;
        regenerate: 2;
    }
    export type BankFileGenerationMode = keyof BankFileGenerationMode$Enum;
    export interface BankSign$Enum {
        expense: 1;
        revenue: 2;
        expenseReversal: 3;
        revenueReversal: 4;
    }
    export type BankSign = keyof BankSign$Enum;
    export interface BankStatementImport$Enum {
        documentNo: 1;
        sourceDocumentNo: 2;
    }
    export type BankStatementImport = keyof BankStatementImport$Enum;
    export interface BaseOfExpression$Enum {
        hours: 1;
        days: 2;
        weeks: 3;
        months: 4;
        years: 5;
        substituteValue6: 6;
    }
    export type BaseOfExpression = keyof BaseOfExpression$Enum;
    export interface BaseRecordSource$Enum {
        manualCreation: 1;
        split: 2;
        shipmentValidation: 3;
        invoiceValidation: 4;
        warrantyRequest: 5;
        manualModificationOfTheInstallation: 6;
        salesReturn: 7;
        loanReturn: 8;
    }
    export type BaseRecordSource = keyof BaseRecordSource$Enum;
    export interface BaseRuleValueCompTarget$Enum {
        contributionValue: 1;
        renewalToPreviousBasis: 2;
    }
    export type BaseRuleValueCompTarget = keyof BaseRuleValueCompTarget$Enum;
    export interface BaseType2983$Enum {
        listedBase: 1;
        filteredBase: 2;
    }
    export type BaseType2983 = keyof BaseType2983$Enum;
    export interface Basis$Enum {
        quantity: 1;
        volume: 2;
        weight: 3;
    }
    export type Basis = keyof Basis$Enum;
    export interface BeginSearchAt$Enum {
        firstCharacter: 1;
        lastCharacter: 2;
        startPosition: 3;
    }
    export type BeginSearchAt = keyof BeginSearchAt$Enum;
    export interface BelgianBankStatementFormat$Enum {
        coda: 1;
        manual: 2;
    }
    export type BelgianBankStatementFormat = keyof BelgianBankStatementFormat$Enum;
    export interface BelowExceedAll$Enum {
        below: 1;
        exceeded: 2;
        all: 3;
    }
    export type BelowExceedAll = keyof BelowExceedAll$Enum;
    export interface BiFlow$Enum {
        standard: 1;
        intercompany: 2;
        intersite: 3;
    }
    export type BiFlow = keyof BiFlow$Enum;
    export interface BiLineType$Enum {
        normal: 1;
        invoicingElement: 2;
        parentProduct: 3;
        component: 4;
        free: 5;
        openItem: 6;
    }
    export type BiLineType = keyof BiLineType$Enum;
    export interface BomCodeType$Enum {
        salesKit: 1;
        manufacturing: 2;
        subcontracting: 3;
    }
    export type BomCodeType = keyof BomCodeType$Enum;
    export interface BomQuantityLink$Enum {
        proportional: 1;
        fixed: 2;
    }
    export type BomQuantityLink = keyof BomQuantityLink$Enum;
    export interface BpConcernedByPriceList$Enum {
        outsideGroup: 1;
        group: 2;
        all: 3;
    }
    export type BpConcernedByPriceList = keyof BpConcernedByPriceList$Enum;
    export interface BpRiskInitialization$Enum {
        invoiceBp: 1;
        payByBp: 2;
        groupBp: 3;
    }
    export type BpRiskInitialization = keyof BpRiskInitialization$Enum;
    export interface BusinessObject$Enum {
        expense: 1;
        asset: 2;
        subsidy: 3;
        leaseContract: 4;
        physicalAssetCount: 5;
        physicalAsset: 6;
        concession: 7;
    }
    export type BusinessObject = keyof BusinessObject$Enum;
    export interface BusinessPartnerRule$Enum {
        customer: 1;
        supplier: 2;
        carrier: 3;
        factor: 4;
        salesRep: 5;
        miscellaneousBPs: 6;
    }
    export type BusinessPartnerRule = keyof BusinessPartnerRule$Enum;
    export interface BusinessPartnerSequenceNos$Enum {
        payments: 1;
        paymentsReceivable: 2;
        depositSlips: 3;
        paymentOrders4: 4;
        statementsOfItemsDue: 5;
        bankStatements: 6;
        paymentEntryBatches: 7;
        supplierProformas: 8;
        draftNumbers: 9;
        paymentOrders: 10;
        receipt: 11;
        reminderManagement: 12;
        sepaMessageReference: 13;
        mandateReference: 14;
        recurringSupplierInvoice: 15;
        recurringCustomerInvoice: 16;
        positivePay: 17;
        cashForecastManagement: 18;
        variableMessageReference: 19;
        cashRegister: 20;
        bankRegister: 21;
        prepaymentsInvoiceManagement: 22;
        remittanceGroups: 23;
    }
    export type BusinessPartnerSequenceNos = keyof BusinessPartnerSequenceNos$Enum;
    export interface CalculationChronology$Enum {
        beforeTaxCalculation: 1;
        afterTaxCalculation: 2;
        action: 3;
    }
    export type CalculationChronology = keyof CalculationChronology$Enum;
    export interface CalculationClosingStatus$Enum {
        notCalculated: 1;
        calculated: 2;
        closed: 3;
    }
    export type CalculationClosingStatus = keyof CalculationClosingStatus$Enum;
    export interface CalculationMethod$Enum {
        singleRate: 1;
        ratePerInstallment: 2;
        minMaxThreshold: 3;
    }
    export type CalculationMethod = keyof CalculationMethod$Enum;
    export interface CalculationMethods$Enum {
        dailyRate: 1;
        actual365: 2;
        actual360: 3;
        actualActualIsda: 4;
        substituteValue5: 5;
    }
    export type CalculationMethods = keyof CalculationMethods$Enum;
    export interface CalendarDisplayType3052$Enum {
        serviceResponse: 1;
    }
    export type CalendarDisplayType3052 = keyof CalendarDisplayType3052$Enum;
    export interface CalendarDisplayType$Enum {
        task: 1;
        call: 2;
        appointment: 3;
    }
    export type CalendarDisplayType = keyof CalendarDisplayType$Enum;
    export interface CalendarInformation3048$Enum {
        appointment: 1;
        call: 2;
        task: 3;
        serviceResponse: 4;
        request: 5;
    }
    export type CalendarInformation3048 = keyof CalendarInformation3048$Enum;
    export interface CalendarInformation$Enum {
        appointment: 1;
        call: 2;
        task: 3;
        project: 4;
        contract: 5;
    }
    export type CalendarInformation = keyof CalendarInformation$Enum;
    export interface CallCover$Enum {
        byServiceContract: 1;
        byOrder: 2;
        byCommercialDecision: 3;
        byDirectInvoicing: 4;
        byLoanContract: 5;
        substituteValue6: 6;
    }
    export type CallCover = keyof CallCover$Enum;
    export interface CallOrigin$Enum {
        manualCreation: 1;
        massMail: 2;
        callCampaign: 3;
        tradeShow: 4;
        mediaCampaign: 5;
        marketingCampaign: 6;
    }
    export type CallOrigin = keyof CallOrigin$Enum;
    export interface CallRunLater2980$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        customized: 6;
    }
    export type CallRunLater2980 = keyof CallRunLater2980$Enum;
    export interface CallRunLater$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        halfHour: 3;
        substituteValue4: 4;
        tomorrow: 5;
        customized: 6;
    }
    export type CallRunLater = keyof CallRunLater$Enum;
    export interface CallType$Enum {
        incomingCall: 1;
        outgoingCall: 2;
    }
    export type CallType = keyof CallType$Enum;
    export interface CampaignDisplay$Enum {
        includeCallsLinkedToACampaign: 1;
        excludeCallsLinkedToACampaign: 2;
        onlyCallsLinkedToACampaign: 3;
    }
    export type CampaignDisplay = keyof CampaignDisplay$Enum;
    export interface CancellationStatus$Enum {
        canceledInvoice: 1;
        invoiceCancellation: 2;
        normal: 3;
    }
    export type CancellationStatus = keyof CancellationStatus$Enum;
    export interface CarbonEmissionRate$Enum {
        lessThanOrEqualTo100: 1;
        higherThan100AndLessThanOrEqualTo120: 2;
        higherThan120AndLessThanOrEqualTo140: 3;
        higherThan140AndLessThanOrEqualTo160: 4;
        higherThan160AndLessThanOrEqualTo200: 5;
        higherThan200AndLessThanOrEqualTo250: 6;
        higherThan250: 7;
    }
    export type CarbonEmissionRate = keyof CarbonEmissionRate$Enum;
    export interface CashForecastTypes$Enum {
        purchaseRequests: 1;
        purchaseContracts: 2;
        purchaseOrders: 3;
        receiptsNotes: 4;
        quotes: 5;
        salesOrders: 6;
        salesContracts: 7;
        crmContracts: 8;
        packingSlips: 9;
        leasing: 10;
        reserved11: 11;
        reserved12: 12;
        reserved13: 13;
        reserved14: 14;
        reserved15: 15;
        reserved16: 16;
        reserved17: 17;
        reserved18: 18;
        reserved: 19;
        userType1: 20;
        userType2: 21;
    }
    export type CashForecastTypes = keyof CashForecastTypes$Enum;
    export interface Category$Enum {
        purchaseInvoice: 1;
        salesInvoice: 2;
        purchaseOrder: 3;
        salesOrder: 4;
        salesDelivery: 5;
        intrastatDeclaration: 6;
        salesDeliveryNotification: 7;
    }
    export type Category = keyof Category$Enum;
    export interface Certificate$Enum {
        toBeDefined: 1;
    }
    export type Certificate = keyof Certificate$Enum;
    export interface ChangeRequestStatus$Enum {
        select: 1;
        newRequirement: 2;
        enhancement: 3;
        defect: 4;
        other: 5;
    }
    export type ChangeRequestStatus = keyof ChangeRequestStatus$Enum;
    export interface ChangeStatus$Enum {
        new: 1;
        inReview: 2;
        rejected: 3;
        inPlanning: 4;
        beingImplemented: 5;
        completed: 6;
        closed: 7;
    }
    export type ChangeStatus = keyof ChangeStatus$Enum;
    export interface ChargeDiscountCalculation$Enum {
        byUnit: 1;
        byLine: 2;
        byDocument: 3;
    }
    export type ChargeDiscountCalculation = keyof ChargeDiscountCalculation$Enum;
    export interface CheckDocumentType$Enum {
        check: 1;
        draft: 2;
    }
    export type CheckDocumentType = keyof CheckDocumentType$Enum;
    export interface CheckFormat$Enum {
        notUsed: 1;
        checkStubStub: 2;
        stubCheckStub: 3;
        checkStub: 4;
    }
    export type CheckFormat = keyof CheckFormat$Enum;
    export interface CheckStatus$Enum {
        unissued: 1;
        issued: 2;
        voided: 3;
        posted: 4;
        cleared: 5;
    }
    export type CheckStatus = keyof CheckStatus$Enum;
    export interface CheckType2761$Enum {
        manual: 1;
        normal: 2;
    }
    export type CheckType2761 = keyof CheckType2761$Enum;
    export interface CivilityType$Enum {
        mr: 1;
        mrs: 2;
        miss: 3;
    }
    export type CivilityType = keyof CivilityType$Enum;
    export interface ClauseSelection$Enum {
        criteria: 1;
        formula: 2;
        criteriaAndFormula: 3;
    }
    export type ClauseSelection = keyof ClauseSelection$Enum;
    export interface ClosedStatus$Enum {
        select: 1;
        rejected: 2;
        completed: 3;
    }
    export type ClosedStatus = keyof ClosedStatus$Enum;
    export interface CodeDescriptionExtraction$Enum {
        codeOnly: 1;
        descriptionOnly: 2;
        codeAndDescription: 3;
    }
    export type CodeDescriptionExtraction = keyof CodeDescriptionExtraction$Enum;
    export interface CodeToServe$Enum {
        componentNotWeighedOnWeighingStations: 1;
        componentWeighedOnWeighingStations: 2;
        componentWeighedInProduction: 3;
        excipientPhaseOnWeighingStations: 4;
        excipientPhaseInManufacturing: 5;
        finalWorkOrderExcipientPhaseOnWeighingStations: 6;
        finalWorkOrderExcipientPhaseInManufacturing: 7;
        materialCorrectionOnWeighingStations: 8;
        materialCorrectionInManufacturing: 9;
        qsfAtEndOfManufacture: 10;
    }
    export type CodeToServe = keyof CodeToServe$Enum;
    export interface CommercialActionType$Enum {
        task: 1;
        call: 2;
        appointment: 3;
    }
    export type CommercialActionType = keyof CommercialActionType$Enum;
    export interface CommissionCategory$Enum {
        category1: 1;
        category2: 2;
        category3: 3;
    }
    export type CommissionCategory = keyof CommissionCategory$Enum;
    export interface CommissionType$Enum {
        yes: 1;
        no: 2;
        initialization: 3;
    }
    export type CommissionType = keyof CommissionType$Enum;
    export interface CommonDataSequenceNumbers$Enum {
        mtoNetwork: 1;
        vcsNumber: 2;
        employeeIdNumber: 3;
        arrivalOfANewEmployee: 4;
        employmentContract: 5;
        costStructure: 6;
        costs: 7;
        project: 8;
        ediFileName: 9;
        billOfLading: 10;
        place: 11;
        hazardousConditionsRecord: 12;
        pjmProjectTask: 13;
        pjmProjectBudget: 14;
        pjmSoldProducts: 15;
        pjmFinancialSnapshots: 16;
        pjmProjectSnapshots: 17;
        externalPayments: 18;
        pjmTimeReport: 19;
        pjmProgressBillingPlan: 20;
        pjmTaskCode: 21;
        pjmBudgetCode: 22;
        pjmTimeBillingPlan: 23;
    }
    export type CommonDataSequenceNumbers = keyof CommonDataSequenceNumbers$Enum;
    export interface CommunicationProvider$Enum {
        ama: 1;
        digitalSign: 2;
        undefined: 3;
    }
    export type CommunicationProvider = keyof CommunicationProvider$Enum;
    export interface CommunicationType2427$Enum {
        saft: 1;
        electronicInvoice: 2;
    }
    export type CommunicationType2427 = keyof CommunicationType2427$Enum;
    export interface CommunicationType$Enum {
        creation: 1;
        modification: 2;
        cancellation: 3;
    }
    export type CommunicationType = keyof CommunicationType$Enum;
    export interface CompleteNameOfContact$Enum {
        titleFirstNameSurname: 1;
        titleSurnameFirstName: 2;
        firstNameSurnameTitle: 3;
        firstNameTitleSurname: 4;
        surnameFirstNameTitle: 5;
        surnameTitleFirstName: 6;
    }
    export type CompleteNameOfContact = keyof CompleteNameOfContact$Enum;
    export interface ComponentRounded$Enum {
        roundToTheNearest: 1;
        greaterThan: 2;
        lessThan: 3;
    }
    export type ComponentRounded = keyof ComponentRounded$Enum;
    export interface ComponentType3513$Enum {
        existingMaterial: 1;
        newMaterial: 2;
        existingAssembly: 3;
        designAssembly: 4;
        genericProduct: 5;
        costing: 6;
        text: 7;
    }
    export type ComponentType3513 = keyof ComponentType3513$Enum;
    export interface ComponentType$Enum {
        normal: 1;
        option: 2;
        variant: 3;
        byProduct: 4;
        text: 5;
        costing: 6;
        service: 7;
        multipleOption: 8;
        normalWithFormula: 9;
    }
    export type ComponentType = keyof ComponentType$Enum;
    export interface ConcessionInfoModification$Enum {
        provisionalDate: 1;
        contractualObligation: 2;
        transferredAgainstIndemnity: 3;
        updateCode: 4;
    }
    export type ConcessionInfoModification = keyof ConcessionInfoModification$Enum;
    export interface ConcessionManagementMode$Enum {
        substituteValue1: 1;
        renewal: 2;
    }
    export type ConcessionManagementMode = keyof ConcessionManagementMode$Enum;
    export interface ConcessionStatus$Enum {
        underPreparation: 1;
        active: 2;
        ended: 3;
    }
    export type ConcessionStatus = keyof ConcessionStatus$Enum;
    export interface ConsignmentGoodsType$Enum {
        delivery: 1;
        initialRecipientSubstitution: 2;
        deliveryToInitialOrSubstituteRecipient: 3;
        otherDeliveryToInitialOrSubstituteRecipient: 4;
        deliveryToAnotherCountry: 5;
        destructionLossTheft: 6;
        returnToTai: 7;
        substituteValue8: 8;
        madeAvailableToTheDeclarant: 9;
    }
    export type ConsignmentGoodsType = keyof ConsignmentGoodsType$Enum;
    export interface ContextRecalculation$Enum {
        no: 1;
        yes: 2;
        yesAfterClosing: 3;
    }
    export type ContextRecalculation = keyof ContextRecalculation$Enum;
    export interface Context$Enum {
        labor: 1;
        products: 2;
        expenses: 3;
        finance: 4;
        timeEntry: 5;
    }
    export type Context = keyof Context$Enum;
    export interface ContractSelectionDate$Enum {
        onStartDate: 1;
        onEndDate: 2;
    }
    export type ContractSelectionDate = keyof ContractSelectionDate$Enum;
    export interface ContractStatisticsGroup$Enum {
        contractGroupNo1: 1;
        contractGroupNo2: 2;
        contractGroupNo3: 3;
        contractGroupNo4: 4;
        contractGroupNo5: 5;
    }
    export type ContractStatisticsGroup = keyof ContractStatisticsGroup$Enum;
    export interface ContractType$Enum {
        warranty: 1;
        maintenance: 2;
        point: 3;
    }
    export type ContractType = keyof ContractType$Enum;
    export interface Control3668$Enum {
        noControl: 1;
        debitCredit: 2;
        bankAccountId: 3;
    }
    export type Control3668 = keyof Control3668$Enum;
    export interface ControlLevel$Enum {
        folder: 1;
        company: 2;
    }
    export type ControlLevel = keyof ControlLevel$Enum;
    export interface ControlSystemStatus$Enum {
        accepted: 1;
        inError: 2;
        canceled: 3;
        lroeMonitor: 4;
        waiting: 5;
        generated: 6;
    }
    export type ControlSystemStatus = keyof ControlSystemStatus$Enum;
    export interface ControlType253$Enum {
        valueList: 1;
        ranges: 2;
        noControl: 3;
    }
    export type ControlType253 = keyof ControlType253$Enum;
    export interface CostCalculationMethod$Enum {
        percentagePerNetPrice: 1;
        fixedAmount: 2;
        amountPerUnit: 3;
        amountByFixedBracket: 4;
        schedule: 5;
        weightedAmount: 6;
        formula: 7;
    }
    export type CostCalculationMethod = keyof CostCalculationMethod$Enum;
    export interface CostDistribution$Enum {
        no: 1;
        netAmountProRata: 2;
        netWeightProRata: 3;
        grossWeightProRata: 4;
        volumeProRata: 5;
        costAmountProRata: 6;
    }
    export type CostDistribution = keyof CostDistribution$Enum;
    export interface CostNature$Enum {
        packaging: 1;
        loading: 2;
        preTransport: 3;
        exportCustomsFormality: 4;
        mainTransportLoading: 5;
        mainTransport: 6;
        mainTransportUnloading: 7;
        importCustomsFormalities: 8;
        postTransport: 9;
        unloading: 10;
        insurance: 11;
        others: 12;
    }
    export type CostNature = keyof CostNature$Enum;
    export interface CostType482$Enum {
        standard: 1;
        forecast: 2;
        costPrice: 3;
    }
    export type CostType482 = keyof CostType482$Enum;
    export interface CostTypeEnum$Enum {
        standard: 1;
        revised: 2;
        budgeted: 3;
        simulated: 4;
    }
    export type CostTypeEnum = keyof CostTypeEnum$Enum;
    export interface CostingMethod$Enum {
        standardCost: 1;
        revisedStandard: 2;
        lastCost: 3;
        cumulativeAuc: 4;
        fifoCost: 5;
        lotAuc: 6;
        orderCost: 7;
        lifoCost: 8;
        lastPurchasePrice: 9;
    }
    export type CostingMethod = keyof CostingMethod$Enum;
    export interface CostsPayableBy$Enum {
        neitherTheBuyerNorTheSeller: 1;
        buyer: 2;
        seller: 3;
        buyerAndSeller: 4;
    }
    export type CostsPayableBy = keyof CostsPayableBy$Enum;
    export interface Count$Enum {
        cycleCount: 1;
        annualCount: 2;
        noCount: 3;
    }
    export type Count = keyof Count$Enum;
    export interface CountryLocation$Enum {
        domestic: 1;
        otherEu: 2;
        outsideEu: 3;
    }
    export type CountryLocation = keyof CountryLocation$Enum;
    export interface CreationModification$Enum {
        creation: 1;
        modification: 2;
        deletion: 3;
    }
    export type CreationModification = keyof CreationModification$Enum;
    export interface CreatorEmailText$Enum {
        changeRequest1AwaitsClosureConfirmation: 1;
        thisChangeRequestRequiresYourConfirmationToClose: 2;
        theChangeRequestIsAtStatus: 3;
        toViewTheChangeRequestClickTheLink: 4;
    }
    export type CreatorEmailText = keyof CreatorEmailText$Enum;
    export interface CrmActivitiesCounters$Enum {
        crmActivities: 1;
        projects: 2;
        marketingOperations: 3;
        callsScripts: 4;
        marketingCampaigns: 5;
        competitorProducts: 6;
        contacts: 7;
        reservationOfResources: 8;
        recoveryData: 9;
        transcodification: 10;
        crmImageFiles: 11;
        outlookContacts: 12;
    }
    export type CrmActivitiesCounters = keyof CrmActivitiesCounters$Enum;
    export interface CrmActivitiesEntryTrxs$Enum {
        crmActivitiesPlanningCalendar: 1;
    }
    export type CrmActivitiesEntryTrxs = keyof CrmActivitiesEntryTrxs$Enum;
    export interface CrmEntryTransactions$Enum {
        base: 1;
        serviceRequest: 2;
        serviceResponse: 3;
        hotlinePlanningCalendar: 5;
    }
    export type CrmEntryTransactions = keyof CrmEntryTransactions$Enum;
    export interface Crm$Enum {
        dummyValue: 0;
    }
    export type Crm = keyof Crm$Enum;
    export interface CrystalReportSupportCli$Enum {
        dummyValue: 0;
    }
    export type CrystalReportSupportCli = keyof CrystalReportSupportCli$Enum;
    export interface CrystalReportsCommon$Enum {
        accordingToDatabase: 1;
        january: 2;
        february: 3;
        march: 4;
        april: 5;
        may: 6;
        june: 7;
        july: 8;
        august: 9;
        september: 10;
        october: 11;
        november: 12;
        december: 13;
        firstLevel: 14;
        lastLevel: 15;
        multilevel: 16;
        processedBy: 17;
        anyLatePaymentWillRequireThatAFixedAllowanceBePaidForTheRecoveryCostsOf: 18;
        specialCashVatTaxRule: 19;
        transportCode: 20;
        freightChargeTermsFreightChargesArePrepaidUnlessMarkedOtherwise: 21;
        noteLiabilityLimitationForLossOrDamageInThisShipmentMayBeApplicableSee49USC14706C1AAndB: 22;
        theCarrierShallNotMakeDeliveryOfThisShipmentWithoutPaymentOfFreightAndAllOtherLawfulCharges: 23;
        prepaid: 24;
        collect: 25;
        thirdParty: 26;
        codAmount: 27;
        feeTerms: 28;
        customerCheckAcceptable: 29;
        shipperSignature: 30;
        shipperSignatureAndDate: 31;
        trailerLoaded: 32;
        freightCounted: 33;
        byShipper: 34;
        byDriver: 35;
        byDriverPalletsSaidToContain: 36;
        byDriverPieces: 37;
        carrierSignatureAndPickupDate: 38;
        propertyDescribedAboveIsReceivedInGoodOrderExceptAsNoted: 39;
        fob: 40;
        customerTotal: 41;
        agedTotal: 42;
        statementDate: 43;
        cutoffDate: 44;
        originalAmount: 45;
        openAmount: 46;
        progressiveBalance: 47;
        substituteValue48: 48;
        substituteValue49: 49;
        substituteValue50: 50;
        over90Days: 51;
        registrationNumber: 52;
        trailerRegistrationNo: 53;
        departureDate: 54;
        departureTime: 55;
        arrivalDate: 56;
        arrivalTime: 57;
        type: 58;
        documentForInternalUsageOnly: 59;
        thisDocumentIsOnlyAReferenceToAPreviousRevisionOfAFinalSalesQuote: 60;
        salesQuoteRevisionReport: 61;
        totalWithoutVatExcludingTaxes: 62;
        totalWithoutVat: 63;
        internalReference: 64;
        cashVatRule: 65;
        qtyIssued: 66;
        ending: 67;
        qtyReceived: 68;
        valuationMethodTotal: 69;
        versionTotal: 70;
        valuationMethodChanged: 71;
        controlSystem: 72;
        veriFactu: 73;
        firstRecord: 74;
        lastRecord: 75;
        doYouWantToExportOnlyNonExportedEvents: 76;
        noVeriFactu: 77;
        sendingWithoutRequestNumberIsOnlyAllowedInTestMode: 78;
        optionForThePaymentOfTheTaxAccordingToTheDebits: 79;
    }
    export type CrystalReportsCommon = keyof CrystalReportsCommon$Enum;
    export interface CrystalReportsLists$Enum {
        blocked: 1;
        exceeded: 2;
        both: 3;
    }
    export type CrystalReportsLists = keyof CrystalReportsLists$Enum;
    export interface CustomerCategories$Enum {
        directCustomer: 1;
        reseller: 2;
        wholesaler: 3;
        endUser: 4;
        other: 5;
    }
    export type CustomerCategories = keyof CustomerCategories$Enum;
    export interface CustomerHoldRelease$Enum {
        creditControl: 1;
        paymentDelayControl: 2;
    }
    export type CustomerHoldRelease = keyof CustomerHoldRelease$Enum;
    export interface CustomerInformationType$Enum {
        firstContact: 1;
        lastContact: 2;
        nextContact: 3;
        lastQuote: 4;
        firstOrder: 5;
        lastOrder: 6;
        lastDelivery: 7;
        lastReturn: 8;
        lastInvoice: 9;
        lastCreditMemo: 10;
        lastServiceRequest: 11;
        lastServiceResponse: 12;
        lastProject: 13;
        lastServiceContract: 14;
        lastPayment: 15;
        lastPaymentDue: 16;
        numberOfPaymentsDue: 17;
        lastReminder: 18;
        lastReminderLevel: 19;
        maximumReminderLevel: 20;
    }
    export type CustomerInformationType = keyof CustomerInformationType$Enum;
    export interface CustomerMovementType$Enum {
        quote: 1;
        order: 2;
        delivery: 3;
        return: 4;
        invoice: 5;
        serviceContract: 6;
        serviceRequest: 7;
        serviceResponse: 8;
        project: 9;
        payment: 10;
        paymentDue: 11;
        reminder: 12;
        withoutTypeTask: 13;
        telephone: 14;
        visit: 15;
    }
    export type CustomerMovementType = keyof CustomerMovementType$Enum;
    export interface CustomerSituationRisks$Enum {
        onOrder: 1;
        onLoanOrder: 2;
        shipmentInProgress: 3;
        shippedNotInvoiced: 4;
        shippedOnLoan: 5;
        nonPostedInvoices: 6;
        unmatchedCreditMemos: 7;
        invoices: 8;
        temporaryPayments: 9;
        notesPR1: 10;
        notesPR2: 11;
        notesPR3: 12;
    }
    export type CustomerSituationRisks = keyof CustomerSituationRisks$Enum;
    export interface CustomerSource$Enum {
        invoiceCustomer: 1;
        orderCustomer: 2;
    }
    export type CustomerSource = keyof CustomerSource$Enum;
    export interface CustomersStatisticsGroups$Enum {
        group1: 1;
        group2: 2;
        group3: 3;
        group4: 4;
        group5: 5;
    }
    export type CustomersStatisticsGroups = keyof CustomersStatisticsGroups$Enum;
    export interface CustomsFileDocTakenIntoAc$Enum {
        no: 1;
        fiscalValue: 2;
        statisticalValue: 3;
    }
    export type CustomsFileDocTakenIntoAc = keyof CustomsFileDocTakenIntoAc$Enum;
    export interface Daily$Enum {
        daily: 1;
        weekdays: 2;
    }
    export type Daily = keyof Daily$Enum;
    export interface DataType$Enum {
        alphanumeric: 1;
        numeric: 2;
        date: 3;
    }
    export type DataType = keyof DataType$Enum;
    export interface DatabaseOperation$Enum {
        unspecified: 1;
        create: 2;
        update: 3;
        ignore: 4;
    }
    export type DatabaseOperation = keyof DatabaseOperation$Enum;
    export interface DateChosenForReevaluation$Enum {
        purchaseDate: 1;
        postingDate: 2;
        inServiceDate: 3;
    }
    export type DateChosenForReevaluation = keyof DateChosenForReevaluation$Enum;
    export interface DateFormat$Enum {
        yyyymmdd: 1;
        yymmdd: 2;
        ddmmyyyy: 3;
        ddmmyy: 4;
        yyyyMmDd: 5;
        yyMmDd: 6;
        ddMmYyyy: 7;
        ddMmYy: 8;
        mmddyyyy: 9;
        mmddyy: 10;
        mmDdYyyy: 11;
        mmDdYy: 12;
    }
    export type DateFormat = keyof DateFormat$Enum;
    export interface DateSelectionMode$Enum {
        dueDate: 1;
        earlyDiscount: 2;
        both: 3;
    }
    export type DateSelectionMode = keyof DateSelectionMode$Enum;
    export interface DateSelection$Enum {
        accountingDate: 1;
        invoiceDate: 2;
    }
    export type DateSelection = keyof DateSelection$Enum;
    export interface DateTypes$Enum {
        purchaseDate: 1;
        firstUseDate: 2;
        postingDate: 3;
    }
    export type DateTypes = keyof DateTypes$Enum;
    export interface DebitCollectionType$Enum {
        onDebit: 1;
        onPayment: 2;
    }
    export type DebitCollectionType = keyof DebitCollectionType$Enum;
    export interface DeductionType$Enum {
        finalInvoiceOnly: 1;
        issuedInvoices: 2;
        firstInvoice: 3;
    }
    export type DeductionType = keyof DeductionType$Enum;
    export interface DefaultCurrency$Enum {
        fromPropsectCustomer: 1;
        fromSalesRep: 2;
    }
    export type DefaultCurrency = keyof DefaultCurrency$Enum;
    export interface DefaultDimensionType$Enum {
        product: 1;
        customer: 2;
        supplier: 3;
        salesRep: 4;
        buyer: 5;
        document: 6;
        company: 7;
        site: 8;
        currency: 9;
        tax: 10;
        salesFooter: 11;
        discount: 12;
        bank: 13;
        account: 14;
        fixedAsset: 15;
        purchaseFooter: 16;
        miscellaneousBusinessPartner: 17;
        costingDimensions: 18;
        overheadCosts: 19;
        sourceDocument: 20;
        previousDimensions: 21;
        requester: 22;
        purchaseCosts: 23;
        project: 24;
        projectCostType: 25;
        employee: 26;
        department: 27;
        profile: 28;
        user: 29;
        event: 30;
        activityNature: 31;
        expenseCode: 32;
        accountingContract: 33;
        none: 34;
    }
    export type DefaultDimensionType = keyof DefaultDimensionType$Enum;
    export interface DeferredDepreciationRule$Enum {
        none: 1;
        percentage: 2;
        noBookVsTaxDeferredDepreciation: 3;
        reversalOnResidualDuration: 4;
    }
    export type DeferredDepreciationRule = keyof DeferredDepreciationRule$Enum;
    export interface DeferredDepreciationType$Enum {
        none: 1;
        lossMakingDeferredDepreciation: 2;
        profitMakingDeferredDepreciation: 3;
        deferredDepreciationReversal: 4;
        substituteValue5: 5;
    }
    export type DeferredDepreciationType = keyof DeferredDepreciationType$Enum;
    export interface DematerializationStatus$Enum {
        disabled: 1;
        accepted: 2;
        closed: 3;
        inProgress: 4;
        rejected: 5;
        inProcess: 6;
    }
    export type DematerializationStatus = keyof DematerializationStatus$Enum;
    export interface DepositRate$Enum {
        invoiceRate: 1;
        paymentRate: 2;
        paymentRateRevalued: 3;
    }
    export type DepositRate = keyof DepositRate$Enum;
    export interface DeprecCalcPriorityRule$Enum {
        byDefault: 1;
        periodPriority: 2;
        fyPriority: 3;
    }
    export type DeprecCalcPriorityRule = keyof DeprecCalcPriorityRule$Enum;
    export interface DeprecCalculationTypeReques$Enum {
        noCalculation: 1;
        fyCalculation: 2;
        periodicProformaCalculation: 3;
        periodicActualCalculation: 4;
    }
    export type DeprecCalculationTypeReques = keyof DeprecCalculationTypeReques$Enum;
    export interface DeprecEndAndDispDateRule$Enum {
        onTheSpecifiedDay: 1;
        fromTheLastDayOfThePreviousMonth: 2;
        fromTheLastDayOfTheCurrentMonth: 3;
        fromTheLastDayOfThePreviousFinancialYear: 4;
        fromTheLastDayOfTheCurrentFinancialYear: 5;
        fromTheLastDayOfThePreviousHalfYear: 6;
        fromTheLastDayOfTheCurrentHalfYear: 7;
        fromThePreviousDay: 8;
        fromTheFirstDayOfTheNextHalfYear: 9;
        fromTheLastDayOfTheCurrentQuarter: 10;
    }
    export type DeprecEndAndDispDateRule = keyof DeprecEndAndDispDateRule$Enum;
    export interface DepreciationBasisType$Enum {
        balanceSheetValue: 1;
        netValue: 2;
        balanceSheetValueDepreciationDuration: 3;
        netValueResidualDuration4: 4;
        netValueTotalDuration: 5;
        balanceSheetValueSalvageValue: 6;
        netValueSalvageValue: 7;
        netValueResidualDuration: 8;
    }
    export type DepreciationBasisType = keyof DepreciationBasisType$Enum;
    export interface DepreciationContexts$Enum {
        finance: 1;
        context2: 2;
        context3: 3;
        context4: 4;
        context5: 5;
        context6: 6;
        context7: 7;
        context8: 8;
        context9: 9;
        context10: 10;
        context11: 11;
    }
    export type DepreciationContexts = keyof DepreciationContexts$Enum;
    export interface DepreciationMethodType$Enum {
        free: 1;
        standard: 2;
    }
    export type DepreciationMethodType = keyof DepreciationMethodType$Enum;
    export interface DepreciationPlanStandards$Enum {
        standard: 1;
        crc200210: 2;
        iasIfrs: 3;
    }
    export type DepreciationPlanStandards = keyof DepreciationPlanStandards$Enum;
    export interface DepreciationPlans$Enum {
        accounts: 1;
        finance: 2;
        minimum: 3;
        source: 4;
        reevaluation76: 5;
        iasIfrs: 6;
        technical: 7;
        reprocessed: 8;
        subsidy: 9;
        free1: 10;
        free2: 11;
        free3: 12;
        free4: 13;
        free5: 14;
        free6: 15;
        all: 16;
    }
    export type DepreciationPlans = keyof DepreciationPlans$Enum;
    export interface DepreciationPriorityRule$Enum {
        depreciationRate: 1;
        depreciationEndDate: 2;
    }
    export type DepreciationPriorityRule = keyof DepreciationPriorityRule$Enum;
    export interface DepreciationStartDateType$Enum {
        onTheSpecifiedDay: 1;
        fromFirstDayOfTheMonth: 2;
        fromFirstDayOfTheNextMonth: 3;
        fromFirstDayOfInvestmentFy: 4;
        fromFirstDayOfNextFy: 5;
        fromFirstDayOfInvestmentHalfYear: 6;
    }
    export type DepreciationStartDateType = keyof DepreciationStartDateType$Enum;
    export interface DepreciationStopStatus$Enum {
        noStop: 1;
        improvement: 2;
        preservation: 3;
        stoppedForImprovement: 4;
        stoppedForPreservation: 5;
        restartedAfterImprovement: 6;
        restartedAfterPreservation: 7;
        suspend: 8;
        stopped: 9;
        restartedAfterExtension: 10;
        restarted: 11;
        extensionDeprec: 12;
        suspendedForExtension: 13;
    }
    export type DepreciationStopStatus = keyof DepreciationStopStatus$Enum;
    export interface DestinationEnum$Enum {
        blcstr: 1;
        blcend: 2;
        tbd: 3;
        bsisns: 4;
    }
    export type DestinationEnum = keyof DestinationEnum$Enum;
    export interface DetailLevel3635$Enum {
        total: 1;
        forecastType: 2;
        document: 3;
    }
    export type DetailLevel3635 = keyof DetailLevel3635$Enum;
    export interface DigitalSignatureControl$Enum {
        invoices: 1;
        journalEntries: 2;
    }
    export type DigitalSignatureControl = keyof DigitalSignatureControl$Enum;
    export interface DimensionTypes$Enum {
        none: 1;
        dimension1: 2;
        dimension2: 3;
        dimension3: 4;
        dimension4: 5;
        dimension5: 6;
        dimension6: 7;
        dimension7: 8;
        dimension8: 9;
        dimension9: 10;
        sectorOfActivity: 11;
        geographicSector: 12;
        toDefine: 13;
    }
    export type DimensionTypes = keyof DimensionTypes$Enum;
    export interface DirectAssociations$Enum {
        assetGroup: 1;
        accountingCode: 2;
    }
    export type DirectAssociations = keyof DirectAssociations$Enum;
    export interface DirectDebitSequence$Enum {
        lastSequence: 1;
        firstSequence: 2;
        oneOffSequence: 3;
        recurringSequence: 4;
    }
    export type DirectDebitSequence = keyof DirectDebitSequence$Enum;
    export interface DirectDebitType$Enum {
        core: 1;
        b2B: 2;
        cor1: 3;
    }
    export type DirectDebitType = keyof DirectDebitType$Enum;
    export interface DiscountCalculationRules$Enum {
        amount: 1;
        combined: 2;
        series: 3;
    }
    export type DiscountCalculationRules = keyof DiscountCalculationRules$Enum;
    export interface DiscountCalculation$Enum {
        cumulated: 1;
        compound: 2;
    }
    export type DiscountCalculation = keyof DiscountCalculation$Enum;
    export interface DiscountCharge$Enum {
        discount: 1;
        charge: 2;
    }
    export type DiscountCharge = keyof DiscountCharge$Enum;
    export interface DiscountDateType$Enum {
        earliestDiscountDate: 1;
        latestDiscountDate: 2;
    }
    export type DiscountDateType = keyof DiscountDateType$Enum;
    export interface DiscountManagementMode$Enum {
        rebateOnVat: 1;
        breakdownByVatInvoiceLevel: 2;
        globalCalculation: 3;
        breakdownByVatAccountLevel: 4;
        rebateOnTaxExemptGlobal: 5;
    }
    export type DiscountManagementMode = keyof DiscountManagementMode$Enum;
    export interface DisposalReason3175$Enum {
        notDisposed: 1;
        stockCountIssue: 2;
        sale: 3;
        scrap: 4;
        theftOrDisappearance: 5;
    }
    export type DisposalReason3175 = keyof DisposalReason3175$Enum;
    export interface DisposalReason$Enum {
        sales: 1;
        scrap: 2;
        intraGroupSale: 3;
        stolenOrDisappeared: 4;
        leaseContractEnd5: 5;
        partialAcquisition: 6;
        merger: 7;
        split: 8;
        leaseContractEnd: 9;
        cancelledContract: 10;
        importedAsset: 11;
        renewal: 12;
        transferredToGrantor: 13;
    }
    export type DisposalReason = keyof DisposalReason$Enum;
    export interface DisputeReason$Enum {
        revocation: 1;
        reject: 2;
        return: 3;
    }
    export type DisputeReason = keyof DisputeReason$Enum;
    export interface DistributionKeyRule$Enum {
        netValueOfThePlan: 1;
        coABalanceSheetValue: 2;
        iasIfrsBalanceSheetValue: 3;
    }
    export type DistributionKeyRule = keyof DistributionKeyRule$Enum;
    export interface DistributionKeySplit$Enum {
        group: 1;
        accountingCode: 2;
        coAAccount: 3;
        ifrsAccount: 4;
    }
    export type DistributionKeySplit = keyof DistributionKeySplit$Enum;
    export interface DistributionRule$Enum {
        periodDistribution: 1;
        substituteValue2: 2;
    }
    export type DistributionRule = keyof DistributionRule$Enum;
    export interface DocumentBatchStatus$Enum {
        accepted: 1;
        partiallyAccepted: 2;
        rejected: 3;
    }
    export type DocumentBatchStatus = keyof DocumentBatchStatus$Enum;
    export interface DocumentClassification$Enum {
        automatic: 1;
        manual: 2;
    }
    export type DocumentClassification = keyof DocumentClassification$Enum;
    export interface DocumentSource$Enum {
        purchasing: 1;
        sales: 2;
        stock: 3;
        production: 4;
        mps: 5;
        mrp: 6;
        projet: 7;
    }
    export type DocumentSource = keyof DocumentSource$Enum;
    export interface DocumentStatus$Enum {
        pending: 1;
        dataSnapshot: 2;
        outOfScope: 3;
        sent: 4;
    }
    export type DocumentStatus = keyof DocumentStatus$Enum;
    export interface DocumentType$Enum {
        siteTaxIdNumber: 1;
        intracommunityTaxIdNumber: 2;
        passport: 3;
        officialDocument: 4;
        fiscalResidenceCertificate: 5;
        others: 6;
        notRegistered: 7;
    }
    export type DocumentType = keyof DocumentType$Enum;
    export interface DocumentTypes$Enum {
        supplierInvoice: 1;
        customerInvoice: 2;
    }
    export type DocumentTypes = keyof DocumentTypes$Enum;
    export interface DueDateInDiscountBlock$Enum {
        activated: 1;
        deactivated: 2;
    }
    export type DueDateInDiscountBlock = keyof DueDateInDiscountBlock$Enum;
    export interface DuplicateAuthorization$Enum {
        authorized: 1;
        notAuthorized: 2;
    }
    export type DuplicateAuthorization = keyof DuplicateAuthorization$Enum;
    export interface EInvoicingStatus$Enum {
        pending: 1;
        fileGenerated: 2;
        pdfGenerated: 3;
        documentGenerated: 4;
        inError: 5;
    }
    export type EInvoicingStatus = keyof EInvoicingStatus$Enum;
    export interface EdiEvents$Enum {
        checkingEdiAuthorizationsForCompanies: 1;
        checkingEdiAuthorizationsForSites: 2;
        checkingEdiAuthorizationsForBpAddresses: 3;
        checkingCombinationOfEdiFlowWithBpCompanies: 4;
        recoveringEdiFlowInformation: 5;
        checkingEdiFlowSetup: 6;
        ediDocumentProcessing: 7;
        ediDocumentStatus: 8;
        newEdiDocumentProcessing: 9;
        creatingEdiTemporaryStorageSpace: 10;
        updatingStatusOfTheEdiTemporaryStorageSpace: 11;
        accessingTheEdiTemporaryStorageSpace: 12;
        instantiatingEdiRepresentation: 13;
        updatingTheUuidOfTheEdiRepresentationInstance: 14;
        processingEdiFileGeneration: 15;
        sendingEdiFile: 16;
        controlingEdiFlow: 17;
        controlingEdiMessageMapping: 18;
        controlingEdiSequentialFile: 19;
        generatingEdiImportFile: 20;
        copyingEdiTemporaryStorageSpaceAndDocumentTracking: 21;
        checkingEdiFlow: 22;
        checkingEdiMessageMapping: 23;
        checkingEdiSequentialFile: 24;
        incorrectEdiFlowParameters: 25;
        loadingEdiRepresentationInstance: 26;
        savingEdiRepresentationInstance: 27;
        testMode: 28;
        theDocumentHasAlreadyBeenProcessedSelectTheDuplicateOptionToProcessItAgain: 29;
        theDocumentIsACopyAndCannotBeProcessed: 30;
        generatingTheEdiRepresentationPrototype: 31;
        processCompletedSuccessfully: 32;
        processCompletedWithErrors: 33;
        updatingTemporaryStorageSpace: 34;
        signingEdiGeneratedFile: 35;
        userCertificateOrPrivateKeyNotFound: 36;
    }
    export type EdiEvents = keyof EdiEvents$Enum;
    export interface EdiPartnerType$Enum {
        companyControl: 1;
        bpCompanyControl: 2;
        noControl: 3;
    }
    export type EdiPartnerType = keyof EdiPartnerType$Enum;
    export interface EdiStatus$Enum {
        pending: 1;
        inProgress: 2;
        completed: 3;
        error: 4;
    }
    export type EdiStatus = keyof EdiStatus$Enum;
    export interface EfatStatus$Enum {
        notSent: 1;
        sentWithError: 2;
        pendingResponseFromEfat: 3;
        pendingResponseFromBusinessPartner: 4;
        communicationSuccessful: 5;
    }
    export type EfatStatus = keyof EfatStatus$Enum;
    export interface EinvoicingMapping$Enum {
        facturX: 1;
    }
    export type EinvoicingMapping = keyof EinvoicingMapping$Enum;
    export interface EinvoicingPartialMatching$Enum {
        no: 1;
        yes: 2;
        warning: 3;
    }
    export type EinvoicingPartialMatching = keyof EinvoicingPartialMatching$Enum;
    export interface EinvoicingStatus$Enum {
        toBeMapped: 1;
        incompleteMapping: 2;
        mapped: 3;
        generated: 4;
        error: 5;
    }
    export type EinvoicingStatus = keyof EinvoicingStatus$Enum;
    export interface ElectronicInvoiceType$Enum {
        notUsed: 1;
        xmlByMail: 2;
        pdfByMail: 3;
        eInvoiceFileByMail: 4;
        xmlByPlatform: 5;
        pdfByPlatform: 6;
        eInvoiceFileByPlatform: 7;
    }
    export type ElectronicInvoiceType = keyof ElectronicInvoiceType$Enum;
    export interface ElementsConcerned$Enum {
        all: 1;
        serviceRequest: 2;
        base: 3;
        component: 4;
        consumption: 5;
        serviceResponse: 6;
    }
    export type ElementsConcerned = keyof ElementsConcerned$Enum;
    export interface EmployeeAvailability992$Enum {
        all: 1;
        onlyWithAvailability: 2;
    }
    export type EmployeeAvailability992 = keyof EmployeeAvailability992$Enum;
    export interface EmployeeAvailability$Enum {
        available: 1;
        proposal: 2;
        unavailable: 3;
        reserved: 4;
        appointment: 5;
        serviceResponse: 6;
        absent: 7;
    }
    export type EmployeeAvailability = keyof EmployeeAvailability$Enum;
    export interface EmployeeSearchType$Enum {
        all: 1;
        competent: 2;
    }
    export type EmployeeSearchType = keyof EmployeeSearchType$Enum;
    export interface EmployeeType$Enum {
        employee: 1;
        detailedTeam: 2;
        summaryTeam: 3;
    }
    export type EmployeeType = keyof EmployeeType$Enum;
    export interface EmptyOrMain$Enum {
        empty: 1;
        main: 2;
    }
    export type EmptyOrMain = keyof EmptyOrMain$Enum;
    export interface EndOfMonthCalculation$Enum {
        no: 1;
        endOfNextMonth: 2;
        endOfCurrentMonth: 3;
    }
    export type EndOfMonthCalculation = keyof EndOfMonthCalculation$Enum;
    export interface EntitiesManagedByCompany$Enum {
        businessPartner: 1;
        customerProspect: 2;
        shipToCustomer: 3;
        supplier: 4;
        product: 5;
        productSales: 6;
        productCustomer: 7;
        productSupplier: 8;
        salesInvoicingElements: 9;
        purchaseInvoicingElements: 10;
        secondaryRepresentatives: 11;
        prospect: 12;
    }
    export type EntitiesManagedByCompany = keyof EntitiesManagedByCompany$Enum;
    export interface Entities$Enum {
        product: 1;
        customer: 2;
        supplier: 3;
        salesRep: 4;
        user: 5;
        overhead: 6;
        expensesForExpenseNotes7: 7;
        currency: 8;
        tax: 9;
        salesInvoiceFooter: 10;
        earlyDiscount: 11;
        bank: 12;
        paymentAttribute: 13;
        purchaseInvoiceFooter: 14;
        miscellaneousBp: 15;
        costingDimension: 16;
        purchaseCost: 17;
        employee: 18;
        department: 19;
        profile: 20;
        event: 21;
        natureOfActivity: 22;
        expensesForExpenseNotes: 23;
    }
    export type Entities = keyof Entities$Enum;
    export interface EntityTypeBusinessPartnerSite$Enum {
        businessPartners: 1;
        company: 2;
        site: 3;
        user: 4;
        accounts: 5;
    }
    export type EntityTypeBusinessPartnerSite = keyof EntityTypeBusinessPartnerSite$Enum;
    export interface EntryOfGridData$Enum {
        gridAndRecord: 1;
        grid: 2;
        record: 3;
    }
    export type EntryOfGridData = keyof EntryOfGridData$Enum;
    export interface Enum$Enum {
        outboundMessageVolume: 1;
        inboundMessageVolume: 2;
        archivedMessageVolume: 3;
        failedMessageVolume: 4;
        importVolume: 5;
        volumeMustBeDefined: 6;
        successful: 7;
        warning: 8;
        failed: 9;
        statusUpdate: 10;
        deletingTemporaryLog: 11;
        deletingTemporaryStorageSpace: 12;
        deletingDocumentTracking: 13;
        copyOfTemporaryDocumentTracking1ToFinalDocumentTracking2: 14;
        copyOfTemporaryStorageSpace1ToFinalStorageSpace2: 15;
        readingNewStorageSpace: 16;
        readingTemporaryStorageSpace: 17;
        transferOfTemporaryStorageSpaces: 18;
        noFilterDefined: 19;
        noIndexDefinedInCategorySetup: 20;
        noInstanceExported: 21;
        noInstanceGenerated: 22;
        noInstanceLoaded: 23;
        errorCodeNonexistent: 24;
        processing: 25;
        endOfProcessing: 26;
        summaryOfGlobalProcessing: 27;
        processingDocumentList: 28;
        noDocumentToProcess: 29;
        flowControl: 30;
        messageMappingControl: 31;
        sequentialFileControl: 32;
        recoveringCategoryFilters: 33;
        recoveringFlowProperties: 34;
        decoding: 35;
        generatingPrototype: 36;
        generatingDocumentListToProcess: 37;
        insertionIntoTemporaryLog: 38;
        serializingEntityUsingRepresentation: 39;
        launchingEdiOutboundMessageProcessing: 40;
        launchingEdiInboundProcessing: 41;
        numberOfCheckedDocuments: 42;
        numberOfDocumentsSuccessfullyGenerated: 43;
        numberOfDocumentsSuccessfullyGeneratedInImportFile: 44;
        numberOfDocumentsSuccessfullyInstantiated: 45;
        numberOfDocumentsSuccessfullyProcessed: 46;
        numberOfDocumentsSuccessfullySaved: 47;
        numberOfDocumentsSuccessfullySavedInMongo: 48;
        numberOfDocumentsSuccessfullySavedInStorageSpace: 49;
        numberOfDocumentsSuccessfullySent: 50;
        numberOfDocumentsToCheckFoundByTheQuery: 51;
        numberOfDocumentsToProcess: 52;
        numberOfValidAndActiveFlowsFound: 53;
        creationOfALogLine: 54;
        endOfLogFile: 55;
        copyingEntityInCache: 56;
        updatingEntityInCache: 57;
        deletingEntityInCache: 58;
        processingDocument: 59;
        stage: 60;
        testOutboundMessageVolume: 61;
        testInboundMessageVolume: 62;
        signedDocumentVolume: 63;
        launchedSuccessfully: 64;
        documentAlreadyInProgress: 65;
        documentAlreadyProcessed: 66;
        blindCopy: 67;
        notificationMustBeIndicated: 68;
        notificationDoesNotExist: 69;
        processingRecords: 70;
        preparingLogFile: 71;
        launchingTheUpdateProcessingOfTheMongoDbBase: 72;
        closingLogFile: 73;
        numberOfWarnings: 74;
        numberOfErrors: 75;
        viewLogFile: 76;
        noError: 77;
        theProcessingFoundNoError: 78;
        records: 79;
        ediProtocolSetup: 80;
        ediMessageMappingSetup: 81;
        ediSequentialFileSetup: 82;
        ediXsdFileSetup: 83;
        ediXmlFileSetup: 84;
        ediFlowSetup: 85;
        objectNotFound: 86;
        deletingUuidFromTheRecord: 87;
        xsdPaths: 88;
        dataClassDoesNotExist: 89;
        readingRecord: 90;
        checkingTheFileInTheMongoDbBase: 91;
        testModeEnabledNoDocumentRecorded: 92;
        numberOfRecordedDocuments: 93;
        ediProcessCompleted: 94;
        attachmentVolume: 95;
        smtpServerNotification: 96;
        notificationTheme: 97;
        destinationAddress: 98;
        subjectOfMail: 99;
        tittleOfNotification: 100;
        subtittleOfNotification: 101;
        bodyOfMail: 102;
        mailSignature: 103;
        printServerVolume: 104;
    }
    export type Enum = keyof Enum$Enum;
    export interface EscalationType$Enum {
        hidden: 1;
        archived: 2;
        incremental: 3;
    }
    export type EscalationType = keyof EscalationType$Enum;
    export interface EvaluationType$Enum {
        fixedRate: 1;
        lowerValuePrinciple: 2;
        higherValuePrinciple: 3;
    }
    export type EvaluationType = keyof EvaluationType$Enum;
    export interface EventTypes$Enum {
        action: 1;
        actionCancellation: 2;
    }
    export type EventTypes = keyof EventTypes$Enum;
    export interface ExceptionType$Enum {
        withoutCorrespondence: 1;
        multipleCorrespondence: 2;
    }
    export type ExceptionType = keyof ExceptionType$Enum;
    export interface ExecutionType2998$Enum {
        global: 1;
        byBase: 2;
    }
    export type ExecutionType2998 = keyof ExecutionType2998$Enum;
    export interface ExpenseSplitMethod$Enum {
        quantity: 1;
        amount: 2;
    }
    export type ExpenseSplitMethod = keyof ExpenseSplitMethod$Enum;
    export interface ExpirationManagement$Enum {
        notManaged: 1;
        withoutRounding: 2;
        roundingMonthEnd: 3;
        roundingBeginningMonth1: 4;
        mandatoryEntry: 5;
        manualEntry: 6;
    }
    export type ExpirationManagement = keyof ExpirationManagement$Enum;
    export interface FacfounbaSortCriterion$Enum {
        date: 1;
        dueDate: 2;
        supplier: 3;
    }
    export type FacfounbaSortCriterion = keyof FacfounbaSortCriterion$Enum;
    export interface FactoringType$Enum {
        standard: 1;
        recourse: 2;
        noRecourse: 3;
    }
    export type FactoringType = keyof FactoringType$Enum;
    export interface FieldType245$Enum {
        alphanumeric: 1;
        numeric: 2;
        date: 3;
    }
    export type FieldType245 = keyof FieldType245$Enum;
    export interface FieldType252$Enum {
        alphanumeric: 1;
        numeric: 2;
        date: 3;
        boolean: 4;
        text: 5;
        photoImageFile: 6;
        textFile: 7;
    }
    export type FieldType252 = keyof FieldType252$Enum;
    export interface FieldType3683$Enum {
        alphanumeric: 1;
        numeric: 2;
        date: 3;
    }
    export type FieldType3683 = keyof FieldType3683$Enum;
    export interface FieldTypeForStatuses$Enum {
        displayed: 1;
        hidden: 2;
    }
    export type FieldTypeForStatuses = keyof FieldTypeForStatuses$Enum;
    export interface FileSort$Enum {
        product: 1;
        supplier: 2;
    }
    export type FileSort = keyof FileSort$Enum;
    export interface FileTypeSwissIsrImport$Enum {
        fileType3: 1;
        fileType4: 2;
    }
    export type FileTypeSwissIsrImport = keyof FileTypeSwissIsrImport$Enum;
    export interface FileType$Enum {
        mt940: 1;
        csv: 2;
        camt: 3;
        bai: 4;
        cfonb: 5;
        fixedLength: 6;
    }
    export type FileType = keyof FileType$Enum;
    export interface FilterOnActions$Enum {
        accordingToBase: 1;
        accordingToRequest: 2;
        accordingToCustomer: 3;
    }
    export type FilterOnActions = keyof FilterOnActions$Enum;
    export interface FilterOnOrder$Enum {
        accordingToTheCustomer: 1;
        accordingToTheRequest: 2;
    }
    export type FilterOnOrder = keyof FilterOnOrder$Enum;
    export interface FinancialStatementPages3618$Enum {
        main: 1;
        annexR1: 2;
        annexR2: 3;
    }
    export type FinancialStatementPages3618 = keyof FinancialStatementPages3618$Enum;
    export interface FinancialYearOrPeriod$Enum {
        financialYear: 1;
        period: 2;
        periodTotal: 3;
    }
    export type FinancialYearOrPeriod = keyof FinancialYearOrPeriod$Enum;
    export interface FinancialYearType$Enum {
        closed: 1;
        current: 2;
        next: 3;
        next1: 4;
    }
    export type FinancialYearType = keyof FinancialYearType$Enum;
    export interface FiscalYearPeriodStatus$Enum {
        notOpen: 1;
        open: 2;
        closed: 3;
    }
    export type FiscalYearPeriodStatus = keyof FiscalYearPeriodStatus$Enum;
    export interface FixedAssetNumbering$Enum {
        assetReference: 1;
        expenseReference: 2;
        barCodes: 3;
        productionScheduleReference: 4;
        physicalAssetReference: 5;
        contractReference: 6;
        grantReference: 7;
        concessionContractReference: 8;
        priorDistributionReference: 9;
        locationReference: 10;
    }
    export type FixedAssetNumbering = keyof FixedAssetNumbering$Enum;
    export interface FixedAssetType$Enum {
        tangible: 1;
        intangible: 2;
        goodwill: 3;
        financial: 4;
        investmentProperties: 5;
        biologicalAssets: 6;
    }
    export type FixedAssetType = keyof FixedAssetType$Enum;
    export interface FlowClasses$Enum {
        intangible: 1;
        tangible: 2;
        inProcess: 3;
        financial: 4;
    }
    export type FlowClasses = keyof FlowClasses$Enum;
    export interface FlowRule$Enum {
        arrivals: 1;
        dispatches: 2;
        arrivalsAndDispatches: 3;
        substituteValue4: 4;
    }
    export type FlowRule = keyof FlowRule$Enum;
    export interface FlowTrackingType$Enum {
        accountGroup: 1;
        account: 2;
    }
    export type FlowTrackingType = keyof FlowTrackingType$Enum;
    export interface FlowType3694$Enum {
        standard: 1;
        reconciliationOnly: 2;
        postValidationTransfer: 3;
    }
    export type FlowType3694 = keyof FlowType3694$Enum;
    export interface FlowType$Enum {
        intersite: 1;
        intercompany: 2;
    }
    export type FlowType = keyof FlowType$Enum;
    export interface Flow$Enum {
        kit: 1;
        manufacturingBom: 2;
        subContractBom: 3;
        stock: 4;
    }
    export type Flow = keyof Flow$Enum;
    export interface FollowUpMode$Enum {
        letter: 1;
        email: 2;
        telephone: 3;
        fax: 4;
    }
    export type FollowUpMode = keyof FollowUpMode$Enum;
    export interface FollowUpTextType$Enum {
        byInvoice: 1;
        global: 2;
        byMail: 3;
    }
    export type FollowUpTextType = keyof FollowUpTextType$Enum;
    export interface ForecastStatus$Enum {
        active: 1;
        inactive: 2;
        modified: 3;
        obsolete: 4;
    }
    export type ForecastStatus = keyof ForecastStatus$Enum;
    export interface FormSelection$Enum {
        summary: 1;
        detail: 2;
    }
    export type FormSelection = keyof FormSelection$Enum;
    export interface Format$Enum {
        fixed: 1;
        variable: 2;
        csv: 3;
    }
    export type Format = keyof Format$Enum;
    export interface FormulaType$Enum {
        tax: 1;
        routingOperations: 2;
        salesRepCommissions: 3;
        freightCharges: 4;
        overheadCosts: 5;
        abcClass: 6;
        configurator: 7;
        documents: 8;
        modifyTechnicalFiles: 9;
        enterprisePlanning: 10;
        stockSelections: 11;
        weighingPlan: 12;
        returns: 13;
        timeTracking: 14;
        manufacturingPlan: 15;
        materialTrackingPlan: 16;
        putAwayPlan: 17;
        productsCount: 18;
        consumptionReorderCalculation: 19;
        locationsSubjectToReorder: 20;
        automaticJournals: 21;
        trackingWorkbenchMonitoring: 22;
        technicalRecordWorkbench: 23;
        consumptionAreas: 24;
        shortageOnLocation: 25;
        ordersToPick: 26;
        stockCount: 27;
        locationsCount: 28;
        totalsCount: 29;
        categoryChange: 30;
        bom: 31;
        qualityRecordsQuestion: 32;
        packageContent: 33;
        salesSelections: 34;
        purchaseSelection: 35;
        subcontractOrder: 36;
        workCenters: 37;
        productsWorkOrders: 38;
        operationsWorkOrders: 39;
        materialsWorkOrders: 40;
        products: 41;
        stockCountProductsWarehouses: 42;
        stockCountWarehouses: 43;
        workOrders: 44;
        scmOrders: 45;
        scmDeliveriesInvoices: 46;
        productsSubcontractOrders: 47;
        servicesSubcontractOrders: 48;
        materialSubcontractOrders: 49;
        bp: 50;
        massCreationOfProductSite: 51;
        viewRoutes: 52;
        selectComponents: 53;
        componentQuantities: 54;
        costs: 55;
        costStructure: 56;
        licensePlateNumber: 57;
    }
    export type FormulaType = keyof FormulaType$Enum;
    export interface FreeAmountCurrency$Enum {
        company: 1;
        object: 2;
    }
    export type FreeAmountCurrency = keyof FreeAmountCurrency$Enum;
    export interface FreeMiscellaneousMethodCode$Enum {
        none: 1;
        rateByAnnuity: 2;
        basisFixedTax3: 3;
        basisFixedTax: 4;
        basisMonthlyTax: 5;
        depreciationBasis: 6;
        previousFyEndNetValue: 7;
        balanceSheetValueDepreciationDuration: 8;
        netValueResidualDuration9: 9;
        toBeReintegratedInFirstFy: 10;
        toBeReintegratedInFirstPeriod: 11;
        simplificationRule: 12;
        withoutProrataCalculation: 13;
        investmentFinancialYearProrata: 14;
        investmentWithdrawalFinancialYearProrata: 15;
        prorataCalculationInMonths: 16;
        prorataCalculationInDays: 17;
        netValueResidualDuration: 18;
        netValueAtTheEndOfThePreviousFy: 19;
        depreciationBasisDepreciationDuration: 20;
        priorityToTheRate: 21;
    }
    export type FreeMiscellaneousMethodCode = keyof FreeMiscellaneousMethodCode$Enum;
    export interface FreeProductType$Enum {
        threshold: 1;
        multiple: 2;
    }
    export type FreeProductType = keyof FreeProductType$Enum;
    export interface FreeProducts$Enum {
        no: 1;
        sameProduct: 2;
        otherProducts: 3;
        orderTotal: 4;
    }
    export type FreeProducts = keyof FreeProducts$Enum;
    export interface FreightApplicationThreshold$Enum {
        orderedExTax: 1;
        shippedExTax: 2;
    }
    export type FreightApplicationThreshold = keyof FreightApplicationThreshold$Enum;
    export interface FreightCalculationRounding$Enum {
        band1: 1;
        band: 2;
        nearestBand: 3;
    }
    export type FreightCalculationRounding = keyof FreightCalculationRounding$Enum;
    export interface FreightCommodityCode$Enum {
        nmfcNumber: 1;
        hsCode: 2;
    }
    export type FreightCommodityCode = keyof FreightCommodityCode$Enum;
    export interface Frequency2231$Enum {
        day: 1;
        week: 2;
        halfMonth: 3;
        month: 4;
        quarter: 5;
        halfYear: 6;
        year: 7;
        decade: 8;
    }
    export type Frequency2231 = keyof Frequency2231$Enum;
    export interface Frequency3638$Enum {
        weekly: 1;
        monthly: 2;
        first: 3;
        last: 4;
    }
    export type Frequency3638 = keyof Frequency3638$Enum;
    export interface Frequency$Enum {
        day: 1;
        week: 2;
        month: 3;
        quarter: 4;
        year: 5;
    }
    export type Frequency = keyof Frequency$Enum;
    export interface FuelType$Enum {
        fuelAndSimilarProducts: 1;
        dieselAndSimilarProducts: 2;
        electric: 3;
        other: 4;
    }
    export type FuelType = keyof FuelType$Enum;
    export interface Function2073$Enum {
        serviceRequest: 1;
        intervention: 2;
    }
    export type Function2073 = keyof Function2073$Enum;
    export interface FunctionContact$Enum {
        ceo: 1;
        salesManager: 2;
        technicalManager: 3;
        purchasingManager: 4;
        buyer: 5;
        stockManager: 6;
        financialAndLegalManager: 7;
        importExportManager: 8;
        siteManager: 9;
        externalActor: 10;
        other: 11;
        chiefHumanResourcesOfficer: 12;
    }
    export type FunctionContact = keyof FunctionContact$Enum;
    export interface FyOrPeriod$Enum {
        fiscalYear: 1;
        period: 2;
        periodTotal: 3;
    }
    export type FyOrPeriod = keyof FyOrPeriod$Enum;
    export interface GeneralControlLevel$Enum {
        i: 1;
        ii: 2;
        iii: 3;
        undefined: 4;
    }
    export type GeneralControlLevel = keyof GeneralControlLevel$Enum;
    export interface GeneralJournalSort3264$Enum {
        sitePeriod: 1;
        periodSite: 2;
    }
    export type GeneralJournalSort3264 = keyof GeneralJournalSort3264$Enum;
    export interface GeneralLedgerTypes$Enum {
        legal: 1;
        analytical: 2;
        ias: 3;
        genLedger4: 4;
        genLedger5: 5;
        genLedger6: 6;
        genLedger7: 7;
        genLedger8: 8;
        genLedger9: 9;
        genLedger10: 10;
    }
    export type GeneralLedgerTypes = keyof GeneralLedgerTypes$Enum;
    export interface GeneratedDocument$Enum {
        purchasingInvoice: 1;
        bpSupplierInvoice: 2;
        manual: 3;
    }
    export type GeneratedDocument = keyof GeneratedDocument$Enum;
    export interface GlobalRequestCoverage3003$Enum {
        totallyCovered: 1;
        partiallyCovered: 2;
        notCovered: 3;
        coveredByServiceContract: 4;
        coveredBySalesOrder: 5;
        coveredCommercially: 6;
        coveredByDirectInvoicing: 7;
    }
    export type GlobalRequestCoverage3003 = keyof GlobalRequestCoverage3003$Enum;
    export interface GlobalRequestCoverage$Enum {
        totallyCovered: 1;
        partiallyCovered: 2;
        notCovered: 3;
    }
    export type GlobalRequestCoverage = keyof GlobalRequestCoverage$Enum;
    export interface GroupNonGroup$Enum {
        group: 1;
        nonGroup: 2;
    }
    export type GroupNonGroup = keyof GroupNonGroup$Enum;
    export interface GroupingCriterion$Enum {
        undefined: 1;
        group: 2;
        sGroup: 3;
        currencyGroup: 4;
        currencySGroup: 5;
    }
    export type GroupingCriterion = keyof GroupingCriterion$Enum;
    export interface GroupingIndicators$Enum {
        none: 1;
        groupAndCumulate: 2;
        groupTheLinesIntoASingleDocument: 3;
        cancelTheWholeDocumentInCaseOfErrorOnOneOfTheLines: 4;
    }
    export type GroupingIndicators = keyof GroupingIndicators$Enum;
    export interface GroupingLevel$Enum {
        company: 1;
        bankGroup: 2;
        bank: 3;
        site: 4;
    }
    export type GroupingLevel = keyof GroupingLevel$Enum;
    export interface HelpDeskCallAssignment$Enum {
        dispatching: 1;
        employee: 2;
        queue: 3;
        commercial: 4;
        closed: 5;
    }
    export type HelpDeskCallAssignment = keyof HelpDeskCallAssignment$Enum;
    export interface HelpDeskCounters$Enum {
        serviceContracts: 1;
        helpDeskCalls: 2;
        customerBase: 3;
        solutions: 4;
        queues: 5;
        skillGroups: 6;
        serviceContractTemplates: 7;
        warrantyRequests: 8;
        serviceRequestTemplates: 9;
        maintenancePlans: 10;
        afterSalesServiceConsumptions: 11;
        sequences: 12;
        warrantyVouchers: 13;
        escalations: 14;
    }
    export type HelpDeskCounters = keyof HelpDeskCounters$Enum;
    export interface HoldType$Enum {
        noBlock: 1;
        operationBlock: 2;
        statusBlock: 3;
        nextSheet: 4;
    }
    export type HoldType = keyof HoldType$Enum;
    export interface IdentificationType$Enum {
        tin: 1;
        other: 2;
    }
    export type IdentificationType = keyof IdentificationType$Enum;
    export interface IdentifierType$Enum {
        fiscalCode: 1;
        localCode: 2;
        gln: 3;
        duns: 4;
        vatNumber: 5;
        free: 6;
    }
    export type IdentifierType = keyof IdentifierType$Enum;
    export interface IgsCompanyType3174$Enum {
        source: 1;
        target: 2;
    }
    export type IgsCompanyType3174 = keyof IgsCompanyType3174$Enum;
    export interface IgsCompanyType$Enum {
        sourceCompany: 1;
        targetCompany: 2;
    }
    export type IgsCompanyType = keyof IgsCompanyType$Enum;
    export interface IgsDisposalStatus$Enum {
        assetToBeIssued: 1;
        issuedAssetToBeModified: 2;
        assetToBeCancelled: 3;
    }
    export type IgsDisposalStatus = keyof IgsDisposalStatus$Enum;
    export interface ImageEnum$Enum {
        image1: 1;
        image2: 2;
        none: 3;
    }
    export type ImageEnum = keyof ImageEnum$Enum;
    export interface ImpairmentLossType$Enum {
        exceptional: 1;
        aVoir: 2;
    }
    export type ImpairmentLossType = keyof ImpairmentLossType$Enum;
    export interface ImportExport$Enum {
        import: 1;
        export: 2;
    }
    export type ImportExport = keyof ImportExport$Enum;
    export interface IncludeExclude2999$Enum {
        excludeNonListedComponents: 1;
        includeNonListedComponents: 2;
    }
    export type IncludeExclude2999 = keyof IncludeExclude2999$Enum;
    export interface IncludeExclude$Enum {
        exclude: 1;
        include: 2;
    }
    export type IncludeExclude = keyof IncludeExclude$Enum;
    export interface InclusiveExclusive3002$Enum {
        excludeTheExpensesNotListed: 1;
        includeTheExpensesNotListed: 2;
    }
    export type InclusiveExclusive3002 = keyof InclusiveExclusive3002$Enum;
    export interface InclusiveExclusive$Enum {
        excludeNonListedLabor: 1;
        includeNonListedLabor: 2;
    }
    export type InclusiveExclusive = keyof InclusiveExclusive$Enum;
    export interface IncreaseDecrease$Enum {
        increase: 1;
        decrease: 2;
    }
    export type IncreaseDecrease = keyof IncreaseDecrease$Enum;
    export interface IndirectCoverageType$Enum {
        accordingToBase: 1;
        accordingToProductReference: 2;
        accordingToCommercialGroup: 3;
        allTheBase: 4;
    }
    export type IndirectCoverageType = keyof IndirectCoverageType$Enum;
    export interface InstallationType$Enum {
        endUser: 1;
        reseller: 2;
        wholesaler: 3;
        inStock: 4;
        rejected: 5;
    }
    export type InstallationType = keyof InstallationType$Enum;
    export interface InsuranceCalcBasis$Enum {
        professionalTaxBasis: 1;
        referenceBasisValue: 2;
        coAReceiptValue: 3;
        coABalanceSheetValue: 4;
    }
    export type InsuranceCalcBasis = keyof InsuranceCalcBasis$Enum;
    export interface InsuranceType$Enum {
        notInsured: 1;
        otherInsurance: 2;
        buildingInsurance: 3;
    }
    export type InsuranceType = keyof InsuranceType$Enum;
    export interface InterLedgerControl$Enum {
        balanceControl: 1;
        amountControl: 2;
        quantityControl: 3;
    }
    export type InterLedgerControl = keyof InterLedgerControl$Enum;
    export interface InternalContainerType$Enum {
        container: 1;
        pallet: 2;
        pack: 3;
        parcel: 4;
        other: 5;
        bigBags: 6;
        barrel: 7;
    }
    export type InternalContainerType = keyof InternalContainerType$Enum;
    export interface InternalExternal$Enum {
        internal: 1;
        external: 2;
    }
    export type InternalExternal = keyof InternalExternal$Enum;
    export interface InternalTextModification$Enum {
        newText: 1;
        question: 2;
    }
    export type InternalTextModification = keyof InternalTextModification$Enum;
    export interface IntraGroupSaleFiscalRule$Enum {
        favorableRule: 1;
        ordinaryRule: 2;
        others: 3;
    }
    export type IntraGroupSaleFiscalRule = keyof IntraGroupSaleFiscalRule$Enum;
    export interface IntraGroupSaleStatus$Enum {
        inPreparation: 1;
        processedIssues: 2;
        processedReceipts: 3;
    }
    export type IntraGroupSaleStatus = keyof IntraGroupSaleStatus$Enum;
    export interface IntraGroupSaleType$Enum {
        partialTransferOfAssets: 1;
        merger: 2;
        split: 3;
        intraGroupSales: 4;
    }
    export type IntraGroupSaleType = keyof IntraGroupSaleType$Enum;
    export interface IntrastatTransportMode$Enum {
        bySea: 1;
        byRail: 2;
        byRoad: 3;
        byAir: 4;
        byMail: 5;
        substituteValue6: 6;
        byInlandNavigation: 7;
        internalNavigation: 8;
        selfPropelled: 9;
    }
    export type IntrastatTransportMode = keyof IntrastatTransportMode$Enum;
    export interface InvoiceAccountingStatus$Enum {
        validated: 1;
        nonvalidated: 2;
    }
    export type InvoiceAccountingStatus = keyof InvoiceAccountingStatus$Enum;
    export interface InvoicePrintMandatory$Enum {
        no: 1;
        yes: 2;
        yesAfterPosting: 3;
    }
    export type InvoicePrintMandatory = keyof InvoicePrintMandatory$Enum;
    export interface InvoiceStatus$Enum {
        notPosted: 1;
        notUsed: 2;
        posted: 3;
    }
    export type InvoiceStatus = keyof InvoiceStatus$Enum;
    export interface InvoiceType267$Enum {
        invoice: 1;
        creditNote: 2;
    }
    export type InvoiceType267 = keyof InvoiceType267$Enum;
    export interface InvoiceType3117$Enum {
        invoice: 1;
        creditNote: 2;
        prePayment: 3;
        toBeReceived: 4;
        return: 5;
        earlyDiscountLateCharge: 6;
        stockIssue: 7;
    }
    export type InvoiceType3117 = keyof InvoiceType3117$Enum;
    export interface InvoiceUnitRequested$Enum {
        inConsumptionUnit: 1;
        inSalesUnit: 2;
    }
    export type InvoiceUnitRequested = keyof InvoiceUnitRequested$Enum;
    export interface InvoicingElement$Enum {
        distributionBasedOnInvoicingElement: 1;
        noDistribution: 2;
    }
    export type InvoicingElement = keyof InvoicingElement$Enum;
    export interface InvoicingMethod2978$Enum {
        preInvoicingTermToMature: 1;
        postInvoicingOverDueTerm: 2;
    }
    export type InvoicingMethod2978 = keyof InvoicingMethod2978$Enum;
    export interface InvoicingMethodRequested$Enum {
        withAggregation: 1;
        withoutAggregation: 2;
    }
    export type InvoicingMethodRequested = keyof InvoicingMethodRequested$Enum;
    export interface InvoicingType$Enum {
        accordingToCoverage: 1;
        alwaysInvoiced: 2;
        neverInvoiced: 3;
    }
    export type InvoicingType = keyof InvoicingType$Enum;
    export interface JournalEntryTypes$Enum {
        definitiveEntries: 1;
        provisionalEntries: 2;
        canceledEntries: 3;
        allEntries: 4;
    }
    export type JournalEntryTypes = keyof JournalEntryTypes$Enum;
    export interface KzaLocalization$Enum {
        paramRsacertCertificateNotDefinedFor: 1;
        paramRsasmtpSmtpNotificationServerNotDefinedFor: 2;
        doesNotAcceptElectronicInvoicesTransmissionCancelled: 3;
        defaultCustomerEmailAddressNotDefined: 4;
        errorInTransmittingDocumentTransmissionCanceled: 5;
        transmittedTo: 6;
        signAndEmail: 7;
        defaultReportNotDefinedOnEntryTransaction: 8;
        paramRsadestArchiveDestinationNotDefined: 9;
        destinationDoesNotExist: 10;
        destinationOutputTypeNeedsToBeArchivingAndExportFormatPdf: 11;
        preferentialProcurementTemplateFileGeneration: 12;
        couldNotGenerateLineForSupplier1: 13;
        vatNumberIsMandatory: 14;
        registrationNumberIsMandatory: 15;
        supplierNameIsMandatory: 16;
        totalSpentIsEqualTo0: 17;
        errorUploadingFile1Status2: 18;
        substituteValue19: 19;
        substituteValue20: 20;
        noSupplierLinesWillBeGeneratedForCompany1DueToMandatoryFieldsBeingEmpty: 21;
        preferentialProcurementTemplateFileGenerationForCompany1: 22;
        totalNumberOfCompanies1: 23;
        preferentialProcurementTemplateFileGenerationNotPossibleThereAreNoSupplierLines: 24;
        thereAreNoSupplierLinesToGenerate: 25;
        urlParameterNotSetForThisCompany: 26;
        base64OfUsernameAndPasswordParameterNotSetForThisCompany: 27;
        thisCompanyIsNotOfASouthAfricanLegislation: 28;
    }
    export type KzaLocalization = keyof KzaLocalization$Enum;
    export interface LateChargesExecutionType$Enum {
        thePayment: 1;
        byInterestNote: 2;
    }
    export type LateChargesExecutionType = keyof LateChargesExecutionType$Enum;
    export interface LeadLink$Enum {
        none: 1;
        massMailing: 2;
        callCampaign: 3;
        tradeShow: 4;
        mediaCampaign: 5;
        marketingCampaign: 6;
    }
    export type LeadLink = keyof LeadLink$Enum;
    export interface LeadManagement$Enum {
        noCriteria: 1;
        excludeLeads: 2;
        includeLeadsOnly: 3;
    }
    export type LeadManagement = keyof LeadManagement$Enum;
    export interface LeadStatus$Enum {
        disqualified: 1;
        onHold: 2;
        qualified: 3;
        contacted: 4;
    }
    export type LeadStatus = keyof LeadStatus$Enum;
    export interface LeadTimeUnit$Enum {
        calendarDays: 1;
        workDays: 2;
        weeks: 3;
        fortnights: 4;
        months: 5;
    }
    export type LeadTimeUnit = keyof LeadTimeUnit$Enum;
    export interface LeaseContractBalanceSheetLine$Enum {
        landConstruction: 1;
        transportEquipment: 2;
        equipmentAndTools: 3;
        itOfficeFurnitureEquip: 4;
        layoutAndInstallation: 5;
    }
    export type LeaseContractBalanceSheetLine = keyof LeaseContractBalanceSheetLine$Enum;
    export interface LeaseContractNature$Enum {
        fixedAssets: 1;
        movableAssets: 2;
    }
    export type LeaseContractNature = keyof LeaseContractNature$Enum;
    export interface LeaseContractSource$Enum {
        newContract: 1;
        transferredContract: 2;
    }
    export type LeaseContractSource = keyof LeaseContractSource$Enum;
    export interface LeaseContractStatus$Enum {
        toBeValidated: 1;
        inProcess: 2;
        completed: 3;
        buyback: 4;
        terminated: 5;
        sold: 6;
    }
    export type LeaseContractStatus = keyof LeaseContractStatus$Enum;
    export interface LeaseContractType$Enum {
        lease: 1;
        longTermRent: 2;
        rent: 3;
    }
    export type LeaseContractType = keyof LeaseContractType$Enum;
    export interface LevelOfInterest$Enum {
        low: 1;
        medium: 2;
        strong: 3;
    }
    export type LevelOfInterest = keyof LevelOfInterest$Enum;
    export interface LicenceInfo$Enum {
        fixedAssets: 1;
        configurator: 2;
        scheduling: 3;
        optimization: 4;
        weighingStation: 5;
        productType: 6;
        ias: 7;
    }
    export type LicenceInfo = keyof LicenceInfo$Enum;
    export interface LifeCycleInternalStatus$Enum {
        pending: 1;
        processed: 2;
    }
    export type LifeCycleInternalStatus = keyof LifeCycleInternalStatus$Enum;
    export interface LifeCycleInvoiceType$Enum {
        aPInvoice: 1;
        aRInvoice: 2;
        purchaseInvoice: 3;
        salesInvoice: 4;
        manual: 5;
    }
    export type LifeCycleInvoiceType = keyof LifeCycleInvoiceType$Enum;
    export interface LinePricingLongDescription$Enum {
        freightLineChanges: 1;
        linePackaging: 2;
        storing: 3;
        miscellaneousExpenses1: 4;
        increase: 5;
        discountNumber1: 6;
        discountNumber2: 7;
        discountNumber3: 8;
        expressway: 9;
        discountNumber4: 10;
    }
    export type LinePricingLongDescription = keyof LinePricingLongDescription$Enum;
    export interface LinePricingShortDescriptio$Enum {
        port: 1;
        packaging: 2;
        warehousing: 3;
        d1Expenses: 4;
        increase: 5;
        discount1: 6;
        discount2: 7;
        discount3: 8;
        motorway: 9;
        discount4: 10;
    }
    export type LinePricingShortDescriptio = keyof LinePricingShortDescriptio$Enum;
    export interface LineStatus3719$Enum {
        active: 1;
        deactivated: 2;
        deleted: 3;
    }
    export type LineStatus3719 = keyof LineStatus3719$Enum;
    export interface LineStatus$Enum {
        pending: 1;
        late: 2;
        closed: 3;
    }
    export type LineStatus = keyof LineStatus$Enum;
    export interface LinkDirection$Enum {
        towards: 1;
        from: 2;
    }
    export type LinkDirection = keyof LinkDirection$Enum;
    export interface LocationManagement$Enum {
        notManaged: 1;
        dynamicManagement: 2;
        accordingToTransaction: 3;
    }
    export type LocationManagement = keyof LocationManagement$Enum;
    export interface LocationTypePhysAsset$Enum {
        singleLocation: 1;
        multipleLocation: 2;
    }
    export type LocationTypePhysAsset = keyof LocationTypePhysAsset$Enum;
    export interface LotIssueExpirationUbd$Enum {
        noExpirationDateControl: 1;
        noUseByDateControl: 2;
        yes: 3;
    }
    export type LotIssueExpirationUbd = keyof LotIssueExpirationUbd$Enum;
    export interface LotNumberManagement$Enum {
        notManaged: 1;
        groupNumbering: 2;
        genericNumbering: 3;
        byTransaction: 4;
    }
    export type LotNumberManagement = keyof LotNumberManagement$Enum;
    export interface LowLevelType$Enum {
        business: 1;
        manufacturingSubcontracting: 2;
    }
    export type LowLevelType = keyof LowLevelType$Enum;
    export interface LvaManagement$Enum {
        none: 1;
        lva: 2;
        pool: 3;
    }
    export type LvaManagement = keyof LvaManagement$Enum;
    export interface MailingShipmentMethods$Enum {
        post: 1;
        eMail: 2;
        fax: 3;
        xml: 4;
    }
    export type MailingShipmentMethods = keyof MailingShipmentMethods$Enum;
    export interface MailingType$Enum {
        sentByTextProcessing: 1;
        sentByLabels: 2;
        sentByEMail: 3;
        sentByFax: 4;
    }
    export type MailingType = keyof MailingType$Enum;
    export interface MainExpense$Enum {
        upperExclTaxAmount: 1;
        mostRecentInvoiceDate: 2;
        oldestInvoiceDate: 3;
        mostRecentAccountingDate: 4;
        oldestAccountingDate: 5;
    }
    export type MainExpense = keyof MainExpense$Enum;
    export interface ManagementUnit$Enum {
        one: 1;
        perHundred: 2;
        perThousand: 3;
        percentage: 4;
        byLot: 5;
    }
    export type ManagementUnit = keyof ManagementUnit$Enum;
    export interface MandateStatus$Enum {
        initial: 1;
        approved: 2;
        adjourned: 3;
        revoked: 4;
        expired: 5;
        closed: 6;
    }
    export type MandateStatus = keyof MandateStatus$Enum;
    export interface Mandatory$Enum {
        optional: 1;
        mandatory: 2;
        warning: 3;
    }
    export type Mandatory = keyof Mandatory$Enum;
    export interface ManualSectorAllocation$Enum {
        alwaysRetain: 1;
        replaceOnRequest: 2;
        alwaysReplace: 3;
    }
    export type ManualSectorAllocation = keyof ManualSectorAllocation$Enum;
    export interface MarketingOperationTypes$Enum {
        massMailing: 1;
        callCampaign: 2;
        tradeShow: 3;
        mediaCampaign: 4;
        substituteValue5: 5;
    }
    export type MarketingOperationTypes = keyof MarketingOperationTypes$Enum;
    export interface MarketingResponsesType$Enum {
        tasks: 1;
        calls: 2;
        appointments: 3;
        projects: 4;
        salesOrders: 5;
        directInvoices: 6;
    }
    export type MarketingResponsesType = keyof MarketingResponsesType$Enum;
    export interface MassMailingType$Enum {
        bPs: 1;
        contacts: 2;
    }
    export type MassMailingType = keyof MassMailingType$Enum;
    export interface MatchingOption$Enum {
        allocation: 1;
        roundingVariance: 2;
    }
    export type MatchingOption = keyof MatchingOption$Enum;
    export interface MaterialReplenishType$Enum {
        internal: 1;
        toBeSentToTheSubcontractor: 2;
        suppliedByTheSubcontractor: 3;
    }
    export type MaterialReplenishType = keyof MaterialReplenishType$Enum;
    export interface MergeDescriptionField$Enum {
        no: 1;
        always: 2;
        secondPass: 3;
    }
    export type MergeDescriptionField = keyof MergeDescriptionField$Enum;
    export interface MessageFileFormat$Enum {
        sequential: 1;
        xml: 2;
        none: 3;
    }
    export type MessageFileFormat = keyof MessageFileFormat$Enum;
    export interface MessageMappingType$Enum {
        query: 1;
        attachment: 2;
    }
    export type MessageMappingType = keyof MessageMappingType$Enum;
    export interface MessageType$Enum {
        issuedInvoices: 1;
        receivedInvoices: 2;
        euOperations: 3;
        fixedAssetOperations: 4;
        cashVatCollections: 5;
        cashVatPayments: 6;
        annualOperations: 7;
        consignmentGoods: 8;
    }
    export type MessageType = keyof MessageType$Enum;
    export interface Message$Enum {
        projectStatus: 1;
        projectTask: 2;
        projectBudget: 3;
        lastAdd: 4;
    }
    export type Message = keyof Message$Enum;
    export interface MethdChgeVarianceRecovery$Enum {
        carryforward: 1;
        exceptionalDepreFiscalYear: 2;
        exceptionalDeprePeriod: 3;
        chargeFiscalYear: 4;
        chargePeriod: 5;
    }
    export type MethdChgeVarianceRecovery = keyof MethdChgeVarianceRecovery$Enum;
    export interface MethodChangeEffectiveDate$Enum {
        depreciationStart: 1;
        fyStart: 2;
        periodStart: 3;
    }
    export type MethodChangeEffectiveDate = keyof MethodChangeEffectiveDate$Enum;
    export interface Method$Enum {
        clientServer: 1;
        web: 2;
    }
    export type Method = keyof Method$Enum;
    export interface MigrationParameters3118$Enum {
        temporary: 1;
        final: 2;
        toBeDefined: 3;
    }
    export type MigrationParameters3118 = keyof MigrationParameters3118$Enum;
    export interface MigrationParameters$Enum {
        no: 1;
        yes: 2;
        toBeDefined: 3;
    }
    export type MigrationParameters = keyof MigrationParameters$Enum;
    export interface MilleageBracket$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
    }
    export type MilleageBracket = keyof MilleageBracket$Enum;
    export interface MiscInfoProcessingOption$Enum {
        doNotTakeIntoAccount: 1;
        forActionCodesValidatedAndRefused: 2;
        onlyForTheActionCodeValidated: 3;
    }
    export type MiscInfoProcessingOption = keyof MiscInfoProcessingOption$Enum;
    export interface MiscellaneousAccounts$Enum {
        suspenseAccountConso: 1;
        defaultAccount: 2;
        overflowOffsetAccount: 3;
        carryForwardAccount: 4;
        debitBalanceDecrease: 5;
        debitBalanceIncrease: 6;
        creditBalanceDecrease: 7;
        creditBalanceIncrease: 8;
        exchangeGain: 9;
        exchangeLoss: 10;
        profitAndLossAccounts: 11;
        debtorRoundingVariance: 12;
        creditorRoundingVariance: 13;
        roundingGainMatching: 14;
        roundingLossMatching: 15;
        suspenseAccountForCashCurrencyMOs: 16;
        suspenseAccountForCurrency: 17;
        unpaidExpenseAccount: 18;
    }
    export type MiscellaneousAccounts = keyof MiscellaneousAccounts$Enum;
    export interface MiscellaneousDimensions$Enum {
        intermediateDimensionForAllocation: 1;
    }
    export type MiscellaneousDimensions = keyof MiscellaneousDimensions$Enum;
    export interface Mode$Enum {
        manual: 1;
        automatic: 2;
    }
    export type Mode = keyof Mode$Enum;
    export interface MonthsOfTheYear$Enum {
        january: 1;
        february: 2;
        march: 3;
        april: 4;
        may: 5;
        june: 6;
        july: 7;
        august: 8;
        september: 9;
        october: 10;
        november: 11;
        december: 12;
    }
    export type MonthsOfTheYear = keyof MonthsOfTheYear$Enum;
    export interface MovementImport$Enum {
        errorInTheRowMax1: 1;
        invalidNumericFormat12: 2;
        invalidDateFormat12: 3;
        impossibleToSelectSeveralObjectTypesWithSelectionRanges: 4;
        movement1: 5;
        errorInObjectMovementType1: 6;
        nonExistentObject: 7;
        previousMovementInErrorObjectNotProcessed: 8;
        substituteValue9: 9;
        expenseNotRead12: 10;
        assedNotRead1: 11;
        modificationImpossibleIssuedAsset: 12;
        physicalAssetNotRead1: 13;
        substituteValue14: 14;
        fieldValue12NotSpecifiedInMiscellaneousTableNo3: 15;
        failureUponUpdateOf1: 16;
        nonExistentField1: 17;
        disposalCancellationImpossibleAssetNotDisposedOf: 18;
        disposalImpossibleAssetAlreadyDisposedOf: 19;
        transferCancellationImpossibleNonTransferredAsset: 20;
        transferCancellationImpossibleIssuedAsset: 21;
        transferImpossibleIssuedAsset: 22;
        planNo1NotFound: 23;
        field1CannotBeModifiedValue2: 24;
        noFieldSetUp: 25;
        field12: 26;
        companyMandatory: 27;
        siteMandatory: 28;
        updated: 29;
        notUpdated: 30;
        analyticalDimensionType1NotFound: 31;
        objectLocked: 32;
        movementLockedIdmvt1: 33;
        limitedRights: 34;
        someMovementsMayNotBeIntegrated: 35;
        depreciationPlanNotSelectedForField1Value2: 36;
        before: 37;
        after: 38;
        splitAsset: 39;
        generatedAssetS: 40;
        index1ForSection2GreaterThanTheNumberOfAssetsCreated3: 41;
        dateFormat: 42;
        decimalSeparator: 43;
        splitExpenseS: 44;
        generatedExpenseS: 45;
        splitImpossibleAssetLinkedToAPhysicalAsset: 46;
    }
    export type MovementImport = keyof MovementImport$Enum;
    export interface MovementOrigin$Enum {
        import: 1;
        screenEntry: 2;
        other: 3;
    }
    export type MovementOrigin = keyof MovementOrigin$Enum;
    export interface MovementStatus$Enum {
        toBeProcessed: 1;
        importInProgress: 2;
        archived: 3;
        rejected: 4;
    }
    export type MovementStatus = keyof MovementStatus$Enum;
    export interface MovementType$Enum {
        disposal: 1;
        transfer: 2;
        allocationChange: 3;
        methodChange: 4;
        modification: 5;
        all: 6;
    }
    export type MovementType = keyof MovementType$Enum;
    export interface MovementsAndFlows$Enum {
        standardDelivery: 1;
        intercompanyDelivery: 2;
        loanDelivery: 3;
        deliveryForSubcontracting: 4;
        intersiteDelivery: 5;
        exportDeliveryWithForwardingAgent: 6;
        directOrderDelivery: 7;
        standardReceipt: 8;
        subcontractReceipt: 9;
        intersiteReceipt: 10;
        intercompanyReceipt: 11;
        customerReturn: 12;
        loanReturn: 13;
        supplierReturn: 14;
        salesInvoices: 15;
        salesCreditMemos: 16;
        loanInvoices: 17;
        freeProductDelivery: 18;
        subcontractMaterialReturn: 19;
        receiptForSubcontracting: 20;
        subcontractDelivery: 21;
        subcontractEndProductSupplierReturn: 22;
        materialForSubcontractSupplierReturn: 23;
        subcontractEndProductCustomerReturn: 24;
        nonbillableDelivery: 25;
        nonbillableReturn: 26;
    }
    export type MovementsAndFlows = keyof MovementsAndFlows$Enum;
    export interface MultipCopyExtDocManagement$Enum {
        original: 1;
        duplicate: 2;
        triplicate: 3;
        quadruplicate: 4;
        quintuplicate: 5;
        additionalCopy: 6;
    }
    export type MultipCopyExtDocManagement = keyof MultipCopyExtDocManagement$Enum;
    export interface NameStructure$Enum {
        fileName: 1;
        mainKey: 2;
        mergeKey: 3;
        date: 4;
        time: 5;
        constant: 6;
        batchNumber: 7;
        extension: 8;
        month: 9;
        year: 10;
        day: 11;
    }
    export type NameStructure = keyof NameStructure$Enum;
    export interface NatureChosenForReevaluation$Enum {
        assetGroup: 1;
        accountingCode: 2;
    }
    export type NatureChosenForReevaluation = keyof NatureChosenForReevaluation$Enum;
    export interface NewApproverEmailText$Enum {
        changeRequestToApprove1: 1;
        youAreAssignedAsAnApproverForThisChangeRequest: 2;
        youAreAnApproverForTheEntities: 3;
        toViewTheChangeRequestClickTheLink: 4;
    }
    export type NewApproverEmailText = keyof NewApproverEmailText$Enum;
    export interface NewChangeManagerEmailText$Enum {
        changeRequestToManage1: 1;
        youAreAssignedAsTheChangeManagerForThisChangeRequest: 2;
        toViewTheChangeRequestClickTheLink: 3;
    }
    export type NewChangeManagerEmailText = keyof NewChangeManagerEmailText$Enum;
    export interface NewPlannerEmailText$Enum {
        changeRequestToPlan1: 1;
        youAreAssignedAsThePlannerForThisChangeRequest: 2;
        toViewThePlanClickTheLink: 3;
    }
    export type NewPlannerEmailText = keyof NewPlannerEmailText$Enum;
    export interface NoInPartInFull$Enum {
        no: 1;
        inPart: 2;
        inFull: 3;
        notManaged: 4;
        automatic: 5;
    }
    export type NoInPartInFull = keyof NoInPartInFull$Enum;
    export interface NoYesAll$Enum {
        no: 1;
        yes: 2;
        all: 3;
    }
    export type NoYesAll = keyof NoYesAll$Enum;
    export interface NoYesOnRequest$Enum {
        no: 1;
        yes: 2;
        onRequest: 3;
    }
    export type NoYesOnRequest = keyof NoYesOnRequest$Enum;
    export interface NonConformanceCreationMode$Enum {
        basic: 1;
        full: 2;
    }
    export type NonConformanceCreationMode = keyof NonConformanceCreationMode$Enum;
    export interface NonConformanceDocument$Enum {
        purchaseReceipt: 1;
        customerReturn: 2;
        productionTracking: 3;
        qualityControl: 4;
        operationTrackingResource: 5;
        operationTrackingProcess: 6;
    }
    export type NonConformanceDocument = keyof NonConformanceDocument$Enum;
    export interface NonConformanceOrigin$Enum {
        select: 1;
        customer: 2;
        supplier: 3;
        internal: 4;
        external: 5;
    }
    export type NonConformanceOrigin = keyof NonConformanceOrigin$Enum;
    export interface Not$Enum {
        substituteValue1: 1;
        not: 2;
    }
    export type Not = keyof Not$Enum;
    export interface NotesCategories$Enum {
        product: 1;
        customer: 2;
        supplier: 3;
    }
    export type NotesCategories = keyof NotesCategories$Enum;
    export interface NotesFunctions$Enum {
        salesQuotes: 1;
        salesOrders: 2;
        shipments: 3;
        salesInvoices: 4;
        salesOpenOrders: 5;
        customerBpInvoices: 6;
        supplierBpInvoices: 7;
        purchaseRequest: 8;
        purchaseOrders: 9;
        purchaseOpenOrders: 10;
        purchaseReceipts: 11;
        purchaseInvoices: 12;
        subcontractOrders: 13;
        rfQs: 14;
        workOrders: 15;
        boMs: 16;
        multilevelPlanning: 17;
        tasks: 18;
        calls: 19;
        appointment: 20;
        projects: 21;
        serviceRequests: 22;
        installedBase: 23;
        warrantyRequests: 24;
        serviceContracts: 25;
        serviceResponses: 26;
    }
    export type NotesFunctions = keyof NotesFunctions$Enum;
    export interface NotesPrSorting$Enum {
        openItemsBPs: 1;
        bPsOpenItems: 2;
        bankOpenItemsBPs: 3;
    }
    export type NotesPrSorting = keyof NotesPrSorting$Enum;
    export interface ObjectCreationOrigin$Enum {
        transactionalEntry: 1;
        split: 2;
        return: 3;
        interface: 4;
        others: 5;
        intraGroupSale: 6;
        automaticCreation: 7;
        expenseGrouping: 8;
    }
    export type ObjectCreationOrigin = keyof ObjectCreationOrigin$Enum;
    export interface ObjectToBeProcessedRecodi$Enum {
        assets: 1;
        expenses: 2;
        fundingContracts: 3;
        subsidies: 4;
        physicalAssetCountNotes: 5;
    }
    export type ObjectToBeProcessedRecodi = keyof ObjectToBeProcessedRecodi$Enum;
    export interface OldApproverEmailText$Enum {
        changeRequestToApprove1: 1;
        youAreNoLongerAssignedAsAnApproverForThisChangeRequest: 2;
        youAreNoLongerAnApproverForTheEntities: 3;
        toViewTheChangeRequestClickTheLink: 4;
    }
    export type OldApproverEmailText = keyof OldApproverEmailText$Enum;
    export interface OldChangeManagerEmailText$Enum {
        changeRequestToManage1: 1;
        youAreNoLongerTheChangeManagerForThisChangeRequest: 2;
        toViewTheChangeRequestClickTheLink: 3;
    }
    export type OldChangeManagerEmailText = keyof OldChangeManagerEmailText$Enum;
    export interface OldPlannerEmailText$Enum {
        changeRequestToPlan1: 1;
        youAreNoLongerAssignedAsThePlannerForThisChangeRequest: 2;
        toViewThePlanClickTheLink: 3;
    }
    export type OldPlannerEmailText = keyof OldPlannerEmailText$Enum;
    export interface OpenItemSelection$Enum {
        none1: 1;
        partial: 2;
        total: 3;
        dimensionAxis1: 4;
        dimensionAxis2: 5;
        dimensionAxis3: 6;
        dimensionAxis4: 7;
        dimensionAxis5: 8;
        dimensionAxis6: 9;
        dimensionAxis7: 10;
        dimensionAxis8: 11;
        dimensionAxis9: 12;
        none: 13;
    }
    export type OpenItemSelection = keyof OpenItemSelection$Enum;
    export interface OpenItemType$Enum {
        openItem: 1;
        prepayment: 2;
        holdback: 3;
    }
    export type OpenItemType = keyof OpenItemType$Enum;
    export interface OperationEnum$Enum {
        read: 1;
        create: 2;
        delete: 3;
        update: 4;
    }
    export type OperationEnum = keyof OperationEnum$Enum;
    export interface OperationType$Enum {
        notIncludedOnType4: 1;
        notUsed2: 2;
        notUsed: 3;
        triangularOperations: 4;
        services: 5;
    }
    export type OperationType = keyof OperationType$Enum;
    export interface Operators2960$Enum {
        equal: 1;
        different: 2;
        startingWith: 3;
        containing: 4;
        endingWith: 5;
        greaterThan: 6;
        greaterThanOrEqualTo: 7;
        lessThan: 8;
        lessThanOrEqualTo: 9;
        includedBetween: 10;
    }
    export type Operators2960 = keyof Operators2960$Enum;
    export interface Operators$Enum {
        valueRange: 1;
        equalTo: 2;
        greaterThanOrEqualTo: 3;
        lessThanOrEqualTo: 4;
    }
    export type Operators = keyof Operators$Enum;
    export interface OptionForBdAndBsModes$Enum {
        withoutProRata: 1;
        monthlyProRata: 2;
        dailyProRata: 3;
    }
    export type OptionForBdAndBsModes = keyof OptionForBdAndBsModes$Enum;
    export interface OptionTable$Enum {
        entryPoints: 1;
        listGenerator: 2;
        deferredPrinting: 3;
        importExport: 4;
        extensionDictionary: 5;
        crmActivities: 6;
        automaticAllocation: 7;
        loans: 8;
        reservations: 9;
        billOfMaterials: 10;
        freightPrice: 11;
        pricingDiscount: 12;
        shipToCustomers: 13;
        recurringInvoices: 14;
        statisticsForecasts: 15;
        generalPurchases: 16;
        directOrder: 17;
        multisite: 18;
        serialNumberLot: 19;
        automaticReordering: 20;
        barCodeEntry: 21;
        bankingConnections: 22;
        bankStatements: 23;
        paymentProposal: 24;
        factoring: 25;
        multideclarationSiteAccounting: 26;
        analyticalAccounting: 27;
        budgetaryAccounting: 28;
        analyticalMultidimensionTypes: 29;
        recurringEntries: 30;
        simulations: 31;
        taxStatements: 32;
        exchangeOfGoods: 33;
        postalCode: 34;
        userManagement: 35;
        tDS: 36;
        multideclarationSiteSalary: 37;
        reversePayment: 38;
        free39: 39;
        free40: 40;
        spemiReserved: 41;
        free: 42;
        development: 43;
        substituteValue44: 44;
        multicurrencyAccounting: 45;
        consolidation: 46;
        financialDataExtraction: 47;
        analyticalFinancialDataExtraction: 48;
        commitments: 49;
        dimensionGrouping: 50;
        nonfinancialUnit: 51;
        dimensionDistribution: 52;
        payByBusinessPartners: 53;
        bankingPool: 54;
        unpaid: 55;
        batchServer: 56;
        gescomAccounting: 57;
        onlineUserHelp: 58;
        faxInterface: 59;
        almacomInterface: 60;
        cergInterface: 61;
        pay62: 62;
        pay63: 63;
        pay: 64;
        time65: 65;
        time66: 66;
        time: 67;
        fixedAssets68: 68;
        fixedAssets69: 69;
        fixedAssets: 70;
        multilocation: 71;
    }
    export type OptionTable = keyof OptionTable$Enum;
    export interface OrdInvoice$Enum {
        order: 1;
        invoice: 2;
        unallocated: 3;
    }
    export type OrdInvoice = keyof OrdInvoice$Enum;
    export interface OrdersActionStatus$Enum {
        pending: 1;
        blocking: 2;
        noAction: 3;
        complete: 4;
    }
    export type OrdersActionStatus = keyof OrdersActionStatus$Enum;
    export interface OriginType$Enum {
        manual: 1;
        generated: 2;
        synchronization: 3;
        import: 4;
    }
    export type OriginType = keyof OriginType$Enum;
    export interface OriginalDepreciationBasis$Enum {
        coAValuation: 1;
        iasValuation: 2;
        subsidyAmount: 3;
        toBeEntered: 4;
    }
    export type OriginalDepreciationBasis = keyof OriginalDepreciationBasis$Enum;
    export interface OriginalEntrySupplement$Enum {
        purchaseInvoices: 1;
        bpInvoices: 2;
        journal: 3;
        payment: 4;
        import: 5;
        stockIssue: 6;
    }
    export type OriginalEntrySupplement = keyof OriginalEntrySupplement$Enum;
    export interface OutlookContactType$Enum {
        contact: 1;
        lead: 2;
        salesRep: 3;
    }
    export type OutlookContactType = keyof OutlookContactType$Enum;
    export interface PackingSlipTypes$Enum {
        customer: 1;
        supplier: 2;
        miscellaneous: 3;
    }
    export type PackingSlipTypes = keyof PackingSlipTypes$Enum;
    export interface PaymentApprovalType$Enum {
        pending: 1;
        conflict: 2;
        delayed: 3;
        authorizedToPay: 4;
    }
    export type PaymentApprovalType = keyof PaymentApprovalType$Enum;
    export interface PaymentApproval$Enum {
        approved: 1;
        partiallyApproved: 2;
        notApproved: 3;
    }
    export type PaymentApproval = keyof PaymentApproval$Enum;
    export interface PaymentCardStatus$Enum {
        selected: 1;
        verified: 2;
        authorized: 3;
        rejected: 4;
        voided: 5;
        captured: 6;
        settled: 7;
        manual: 8;
    }
    export type PaymentCardStatus = keyof PaymentCardStatus$Enum;
    export interface PaymentEntryType$Enum {
        nA: 1;
        cashRegister: 2;
        bankRegister: 3;
    }
    export type PaymentEntryType = keyof PaymentEntryType$Enum;
    export interface PaymentItemReference$Enum {
        mainAccount: 1;
        accountJournalBusinessPartner: 2;
        bankJournalAccount: 3;
        treasuryCurrencyMo: 4;
        currencyMo: 5;
        businessPartnerMo: 6;
        accountTransfer: 7;
        discountedDrafts: 8;
        draftTransfer: 9;
        taxStamp: 10;
    }
    export type PaymentItemReference = keyof PaymentItemReference$Enum;
    export interface PaymentOrderReceiptReport$Enum {
        pending: 1;
        printed: 2;
        validated: 3;
    }
    export type PaymentOrderReceiptReport = keyof PaymentOrderReceiptReport$Enum;
    export interface PaymentOrderReceipt$Enum {
        paymentOrder: 1;
        receipt: 2;
    }
    export type PaymentOrderReceipt = keyof PaymentOrderReceipt$Enum;
    export interface PaymentProcessorSelection$Enum {
        sageExchange: 1;
        sagePay: 2;
        all: 3;
    }
    export type PaymentProcessorSelection = keyof PaymentProcessorSelection$Enum;
    export interface PaymentProcessor$Enum {
        sageExchange: 1;
        sagePay: 2;
    }
    export type PaymentProcessor = keyof PaymentProcessor$Enum;
    export interface PaymentSelection$Enum {
        allPayments: 1;
        validatedPayments: 2;
        paymentsInBank: 3;
        reconciledItems: 4;
    }
    export type PaymentSelection = keyof PaymentSelection$Enum;
    export interface PaymentStatus3690$Enum {
        notValidated: 1;
        validated: 2;
        partiallyValidated: 3;
        manuallyCompleted: 4;
    }
    export type PaymentStatus3690 = keyof PaymentStatus3690$Enum;
    export interface PaymentType$Enum {
        recurring: 1;
        oneOff: 2;
    }
    export type PaymentType = keyof PaymentType$Enum;
    export interface PendingMovementControl$Enum {
        notBlocking: 1;
        blockingUponClosing: 2;
        blockingUponCostPriceCalculation: 3;
    }
    export type PendingMovementControl = keyof PendingMovementControl$Enum;
    export interface PendingMovement$Enum {
        none: 1;
        disposal: 2;
        disposalCancellation: 3;
        geographicTransfer: 4;
        geographicTransferCancellation: 5;
    }
    export type PendingMovement = keyof PendingMovement$Enum;
    export interface PeriodFiscalYearStatus$Enum {
        notOpen: 1;
        open: 2;
        closed: 3;
    }
    export type PeriodFiscalYearStatus = keyof PeriodFiscalYearStatus$Enum;
    export interface PeriodStatus$Enum {
        notOpen: 1;
        current: 2;
        open: 3;
        closed: 4;
    }
    export type PeriodStatus = keyof PeriodStatus$Enum;
    export interface PeriodicityType2990$Enum {
        recurrance: 1;
        valueCheck: 2;
        entryPoint: 3;
    }
    export type PeriodicityType2990 = keyof PeriodicityType2990$Enum;
    export interface PhoneNumberType$Enum {
        switchboardOperator: 1;
        directLine: 2;
    }
    export type PhoneNumberType = keyof PhoneNumberType$Enum;
    export interface PhysAssetEntryPersistence$Enum {
        no: 1;
        yes: 2;
    }
    export type PhysAssetEntryPersistence = keyof PhysAssetEntryPersistence$Enum;
    export interface PhysicalAssetCountEntryMethod$Enum {
        laser: 1;
        keyboard: 2;
        laserKeyboard: 3;
    }
    export type PhysicalAssetCountEntryMethod = keyof PhysicalAssetCountEntryMethod$Enum;
    export interface PhysicalAssetCountEntryRule$Enum {
        mandatory: 1;
        optional: 2;
        prohibited: 3;
    }
    export type PhysicalAssetCountEntryRule = keyof PhysicalAssetCountEntryRule$Enum;
    export interface PhysicalAssetCountOperationStatus$Enum {
        planned: 1;
        inProcess: 2;
        complete: 3;
    }
    export type PhysicalAssetCountOperationStatus = keyof PhysicalAssetCountOperationStatus$Enum;
    export interface PhysicalAssetCountResult$Enum {
        disposalCancelled: 1;
        geographicChange: 2;
        analyticalChange: 3;
        analyticalAndGeographicChange: 4;
        barCodeAllocation: 5;
        barCodeChange: 6;
        assetNotFound: 7;
        countedAsset: 8;
    }
    export type PhysicalAssetCountResult = keyof PhysicalAssetCountResult$Enum;
    export interface PhysicalAssetCountStatus$Enum {
        cNotProcessed: 1;
        cAssetNotFoundInDatabase: 2;
        cAssetDeclaredAsIssuedInTheDatabase: 3;
        cChangeToGeographicAllocation: 4;
        cChangeToAnalyticalAllocation: 5;
        cChangeToAnalyGeogAllocation: 6;
        noteMatchingTheDBase: 7;
        cAssetCountedInNonExistentLoc: 8;
        cAssetCountedInAnotherCompany: 9;
        iNotProcessed: 10;
        iAssetReconciledWithANonRegisteredAsset: 11;
        iAssetReconciledWithARegisteredAsset: 12;
        iAssetNotReconciledWithAssetInDbase: 13;
        iCountedAssetInNonExistentLoc: 14;
        iCountedAssetAlreadyExistsInDatabase: 15;
        assetInDatabaseNotFoundDuringPhysicalAssetCount: 16;
        cPhysAssetDeclaredIssuedInDatabaseGeoChange: 17;
    }
    export type PhysicalAssetCountStatus = keyof PhysicalAssetCountStatus$Enum;
    export interface PhysicalAssetCountType$Enum {
        control: 1;
        initial: 2;
        notCounted: 3;
    }
    export type PhysicalAssetCountType = keyof PhysicalAssetCountType$Enum;
    export interface PivotHeaders$Enum {
        noHeader: 1;
        standardHeader: 2;
        specificHeader: 3;
        headerWithTitles: 4;
    }
    export type PivotHeaders = keyof PivotHeaders$Enum;
    export interface PivotTypes$Enum {
        plmProducts: 1;
        plmBoMs: 2;
        woDetailedScheduling: 3;
        operationsDetailedScheduling: 4;
        successionsDetailedScheduling: 5;
        productsDetailedScheduling: 6;
        workCenterGroupDetailedScheduling: 7;
        workCenterDetailedScheduling: 8;
        workCenterDetailedSchedulingByGroup: 9;
        secondaryResourceDetailedScheduling: 10;
        replacementWorkCenterDetailedScheduling: 11;
        capacityVariationDetailedSchedulingByWorkCenter: 12;
        customerDetailedScheduling: 13;
        projectDetailedScheduling: 14;
        orderDetailedScheduling: 15;
        bomDetailedScheduling: 16;
        purchaseDetailedScheduling: 17;
        stocksDetailedScheduling: 18;
        mmsProductsSpareParts: 19;
        mmsCostCentersDimensions: 20;
        mmsStorageSites: 21;
        mmsProductStockSite: 22;
        mmsStockJournal: 23;
        mmsMovements: 24;
        mmsSuppliers: 25;
        mmsSupplierContacts: 26;
        mmsSupplierClassifications: 27;
        mmsSupplierProducts: 28;
        mmsPurchaseRequests: 29;
        mmsPurchaseRequestProgress: 30;
        mmsProjects: 31;
        mmsUnits: 32;
        mmsUsers: 33;
        mmsUnitConversions: 34;
        scmItemsProducts: 35;
        scmItemsConversions: 36;
        scmItemsCriteria: 37;
        scmCustomers: 38;
        scmSites: 39;
        scmSitesCriteria: 40;
        scmSalesHistory: 41;
        scmOrdersInProgress: 42;
        scmSalesForecasts: 43;
        scmItemsSites: 44;
        reachItems: 45;
        reachSuppliers: 46;
        energyEntries: 47;
        accountingEntryFile: 48;
    }
    export type PivotTypes = keyof PivotTypes$Enum;
    export interface PlaceOfAppointment$Enum {
        atCustomersSite: 1;
        onOurPremises: 2;
        other: 3;
    }
    export type PlaceOfAppointment = keyof PlaceOfAppointment$Enum;
    export interface PlaceType$Enum {
        harbor: 1;
        airport: 2;
        station: 3;
        warehouse: 4;
        customs: 5;
        site: 6;
        supplier: 7;
        other: 8;
    }
    export type PlaceType = keyof PlaceType$Enum;
    export interface PlanCompleteEmailText$Enum {
        planForChangeRequest1IsComplete: 1;
        thePlanForThisChangeRequestIsCompleteAndSetToStatus: 2;
        toViewTheChangeRequestClickTheLink: 3;
    }
    export type PlanCompleteEmailText = keyof PlanCompleteEmailText$Enum;
    export interface PlanStatus2045$Enum {
        inPlanning: 1;
        beingImplemented: 2;
        completed: 3;
        notApplicable: 4;
    }
    export type PlanStatus2045 = keyof PlanStatus2045$Enum;
    export interface PlanStatus$Enum {
        pending: 1;
        inProgress: 2;
        completed: 3;
    }
    export type PlanStatus = keyof PlanStatus$Enum;
    export interface PointsReport$Enum {
        mobilized: 1;
        consumed: 2;
    }
    export type PointsReport = keyof PointsReport$Enum;
    export interface PointsType$Enum {
        fixed: 1;
        supplementary: 2;
    }
    export type PointsType = keyof PointsType$Enum;
    export interface PolandDocumentType$Enum {
        allTypes: 1;
        deliveries: 2;
        customerReturns: 3;
        loanReturns: 4;
        subContMaterialReturns: 5;
        interSiteTransfers: 6;
        subContractTransfers: 7;
        subContractReturns: 8;
        purchaseReturns: 9;
        transportNote: 10;
        orders: 11;
        quotes: 12;
        proforma: 13;
    }
    export type PolandDocumentType = keyof PolandDocumentType$Enum;
    export interface PositivePayFileGeneration$Enum {
        generateNewFile: 1;
        regenerateFile: 2;
    }
    export type PositivePayFileGeneration = keyof PositivePayFileGeneration$Enum;
    export interface PositivePayRecordType$Enum {
        header: 1;
        detail: 2;
        trailer: 3;
    }
    export type PositivePayRecordType = keyof PositivePayRecordType$Enum;
    export interface PostingType$Enum {
        actual: 1;
        simulation: 2;
    }
    export type PostingType = keyof PostingType$Enum;
    export interface PrepaymentManagement$Enum {
        prepayments: 1;
        prepaymentInvoices: 2;
    }
    export type PrepaymentManagement = keyof PrepaymentManagement$Enum;
    export interface PrepaymentStatus$Enum {
        none: 1;
        created: 2;
        invoiced: 3;
        paid: 4;
    }
    export type PrepaymentStatus = keyof PrepaymentStatus$Enum;
    export interface PrevCodeManagementRecoding$Enum {
        saved: 1;
        inactive: 2;
        deleted: 3;
    }
    export type PrevCodeManagementRecoding = keyof PrevCodeManagementRecoding$Enum;
    export interface PriceAdjustment$Enum {
        no: 1;
        receiptCost: 2;
        receiptAndIssueCost: 3;
    }
    export type PriceAdjustment = keyof PriceAdjustment$Enum;
    export interface PriceAmountTaxTax$Enum {
        excludeTax: 1;
        includeTax: 2;
    }
    export type PriceAmountTaxTax = keyof PriceAmountTaxTax$Enum;
    export interface PriceClasses$Enum {
        no: 1;
        yes: 2;
        quantityBands: 3;
        grossPriceBands: 4;
        netPriceBands: 5;
    }
    export type PriceClasses = keyof PriceClasses$Enum;
    export interface PriceOrigin$Enum {
        entered: 1;
        purchasePrice: 2;
    }
    export type PriceOrigin = keyof PriceOrigin$Enum;
    export interface PriceType$Enum {
        normal: 1;
        grouped: 2;
        restricted: 3;
        component: 4;
    }
    export type PriceType = keyof PriceType$Enum;
    export interface PriceUpdateMode$Enum {
        calculated: 1;
        entered: 2;
    }
    export type PriceUpdateMode = keyof PriceUpdateMode$Enum;
    export interface Price$Enum {
        no: 1;
        value: 2;
        valueForN: 3;
        factor: 4;
        calculation: 5;
    }
    export type Price = keyof Price$Enum;
    export interface PrintCode$Enum {
        print: 1;
        reprint: 2;
    }
    export type PrintCode = keyof PrintCode$Enum;
    export interface Priority3735$Enum {
        oldestDateFirst: 1;
        earliestDateFirst: 2;
    }
    export type Priority3735 = keyof Priority3735$Enum;
    export interface ProcessType$Enum {
        integration: 1;
        validation: 2;
        import: 3;
        restoration: 4;
    }
    export type ProcessType = keyof ProcessType$Enum;
    export interface ProcessedProduct$Enum {
        unique: 1;
        all: 2;
        selection: 3;
    }
    export type ProcessedProduct = keyof ProcessedProduct$Enum;
    export interface ProcessingMode288$Enum {
        direct: 1;
        deferred: 2;
    }
    export type ProcessingMode288 = keyof ProcessingMode288$Enum;
    export interface ProcessingMode$Enum {
        modifiable: 1;
        notModifiable: 2;
        inactive: 3;
    }
    export type ProcessingMode = keyof ProcessingMode$Enum;
    export interface Processing$Enum {
        resetToZero: 1;
        constant: 2;
        factor: 3;
        formula: 4;
    }
    export type Processing = keyof Processing$Enum;
    export interface ProductAbcClass$Enum {
        classA: 1;
        classB: 2;
        classC: 3;
        classD: 4;
    }
    export type ProductAbcClass = keyof ProductAbcClass$Enum;
    export interface ProductCategoryType$Enum {
        bought: 1;
        manufactured: 2;
        purchaseManufacture: 3;
        manufacturePurchase: 4;
        subcontractedProduct: 5;
        subcontractedService: 6;
        phantom: 7;
        generic: 8;
        tool: 9;
    }
    export type ProductCategoryType = keyof ProductCategoryType$Enum;
    export interface ProductCreationMode$Enum {
        direct: 1;
        withValidation: 2;
    }
    export type ProductCreationMode = keyof ProductCreationMode$Enum;
    export interface ProductDesignStatus$Enum {
        inDevelopment: 1;
        developmentCompleted: 2;
        submittedForApproval: 3;
        pilot: 4;
        production: 5;
        suspended: 6;
        obsolete: 7;
    }
    export type ProductDesignStatus = keyof ProductDesignStatus$Enum;
    export interface ProductSearchCriteria$Enum {
        none: 1;
        supplierUpcCode: 2;
        supplierProductCode: 3;
        x3UpcCode: 4;
        x3ProductDescription: 5;
    }
    export type ProductSearchCriteria = keyof ProductSearchCriteria$Enum;
    export interface ProductStatisticalGroupsEnum$Enum {
        group1: 1;
        group2: 2;
        group3: 3;
        group4: 4;
        group5: 5;
    }
    export type ProductStatisticalGroupsEnum = keyof ProductStatisticalGroupsEnum$Enum;
    export interface ProductStatus$Enum {
        active: 1;
        inDevelopment: 2;
        onShortage: 3;
        notRenewed: 4;
        obsolete: 5;
        notUsable: 6;
    }
    export type ProductStatus = keyof ProductStatus$Enum;
    export interface ProductType$Enum {
        goods: 1;
        rawMaterialsSubsidiariesAndConsumables: 2;
        finishedAndIntermediateGoods: 3;
        byProductsWasteAndScrap: 4;
        productsAndWorksInProgress: 5;
        notApplicable: 6;
    }
    export type ProductType = keyof ProductType$Enum;
    export interface ProductVersionImpact$Enum {
        select: 1;
        major: 2;
        minor: 3;
        unknown: 4;
    }
    export type ProductVersionImpact = keyof ProductVersionImpact$Enum;
    export interface ProjectAllocationType$Enum {
        crm: 1;
        project: 2;
        mixedProject: 3;
        budget: 4;
        laborTask: 5;
        materialTask: 6;
        mixedTask: 7;
        miscellaneous: 8;
    }
    export type ProjectAllocationType = keyof ProjectAllocationType$Enum;
    export interface ProjectOrigins$Enum {
        manualCreation: 1;
        massMail: 2;
        callCampaign: 3;
        tradeShow: 4;
        mediaCampaign: 5;
        serviceRequest: 6;
        marketingCampaign: 7;
    }
    export type ProjectOrigins = keyof ProjectOrigins$Enum;
    export interface ProjectStages$Enum {
        noAssociatedAction: 1;
        firstStageOfSalesCycle: 2;
        sendingAQuote: 3;
        negotiation: 4;
        projectGained: 5;
        projectLost: 6;
        projectAbandoned: 7;
    }
    export type ProjectStages = keyof ProjectStages$Enum;
    export interface PropertyTypes$Enum {
        chemical: 1;
        paint: 2;
        food: 3;
        coatings: 4;
        manualEntry: 5;
        nutrients: 6;
        beverage: 7;
        other: 8;
    }
    export type PropertyTypes = keyof PropertyTypes$Enum;
    export interface ProposalOrder$Enum {
        businessPartner: 1;
        companyName: 2;
        transaction: 3;
        openItem: 4;
    }
    export type ProposalOrder = keyof ProposalOrder$Enum;
    export interface ProspectCustomer3043$Enum {
        prospect: 1;
        customer: 2;
    }
    export type ProspectCustomer3043 = keyof ProspectCustomer3043$Enum;
    export interface ProspectCustomer$Enum {
        prospect: 1;
        customer: 2;
    }
    export type ProspectCustomer = keyof ProspectCustomer$Enum;
    export interface ProtocolType$Enum {
        emails: 1;
        directories: 2;
    }
    export type ProtocolType = keyof ProtocolType$Enum;
    export interface ProvisionType$Enum {
        tax: 1;
        account: 2;
    }
    export type ProvisionType = keyof ProvisionType$Enum;
    export interface PurchaseInServiceDateRule$Enum {
        saleEffectiveDate: 1;
        renewalDateSourceCompany: 2;
    }
    export type PurchaseInServiceDateRule = keyof PurchaseInServiceDateRule$Enum;
    export interface PurchaseInvoiceCategory$Enum {
        invoice: 1;
        additionalInvoice: 2;
        creditMemo: 3;
        creditMemoReturn: 4;
    }
    export type PurchaseInvoiceCategory = keyof PurchaseInvoiceCategory$Enum;
    export interface Quarter$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
    }
    export type Quarter = keyof Quarter$Enum;
    export interface RateAmount$Enum {
        percent: 1;
        amount: 2;
    }
    export type RateAmount = keyof RateAmount$Enum;
    export interface RateEntryMode$Enum {
        multiplier: 1;
        divisor: 2;
        both: 3;
    }
    export type RateEntryMode = keyof RateEntryMode$Enum;
    export interface ReEvaluationAids$Enum {
        indexDevelopment: 1;
        mathematicalFormula: 2;
    }
    export type ReEvaluationAids = keyof ReEvaluationAids$Enum;
    export interface ReEvaluationMethod$Enum {
        postReEvaluation: 1;
        preReEvaluation: 2;
    }
    export type ReEvaluationMethod = keyof ReEvaluationMethod$Enum;
    export interface ReasonForRejection$Enum {
        select: 1;
        notEnoughEvidence: 2;
        notCostEffective: 3;
        changeIsOutOfScopeBudget: 4;
        requestConflictsWithOtherScheduledChange: 5;
        theImplementationDateIsInAnUnavailablePeriod: 6;
        other: 7;
        notSelected: 8;
    }
    export type ReasonForRejection = keyof ReasonForRejection$Enum;
    export interface Reasons$Enum {
        reason1: 1;
        reason2: 2;
        reason3: 3;
    }
    export type Reasons = keyof Reasons$Enum;
    export interface ReceivingAuthorizedStatus$Enum {
        statusA: 1;
        statusQ: 2;
        statusR: 3;
        statusAQ: 4;
        statusAR: 5;
        statusQR: 6;
        statusAQR: 7;
    }
    export type ReceivingAuthorizedStatus = keyof ReceivingAuthorizedStatus$Enum;
    export interface RecipientType495$Enum {
        othersSii: 1;
        batuzVizcaya: 2;
        tbaiGuipuzcoa: 3;
        tbaiAlava: 4;
        tbaiNavarra: 5;
        verifactu: 6;
    }
    export type RecipientType495 = keyof RecipientType495$Enum;
    export interface RecodingStatus$Enum {
        toBeProcessed: 1;
        toBeProcessedIntraGroupSale: 2;
        processed: 3;
        processedIntraGroupSale: 4;
    }
    export type RecodingStatus = keyof RecodingStatus$Enum;
    export interface RecordStatus$Enum {
        pending: 1;
        submitted: 2;
    }
    export type RecordStatus = keyof RecordStatus$Enum;
    export interface RecordType2029$Enum {
        normal: 1;
        manualDocumentRecovery: 2;
        backupDocumentRecovery: 3;
        externalDocument: 4;
    }
    export type RecordType2029 = keyof RecordType2029$Enum;
    export interface RecordType$Enum {
        header: 1;
        detail: 2;
        total: 3;
        subtotal: 4;
        detail2: 5;
    }
    export type RecordType = keyof RecordType$Enum;
    export interface RecovRuleTargetCompPlans$Enum {
        identicalValuesToTemplatePlan: 1;
        valuesTakenAsIdentical: 2;
        grossValueSalePrice: 3;
        grossValueTemplatePlanNetValue: 4;
    }
    export type RecovRuleTargetCompPlans = keyof RecovRuleTargetCompPlans$Enum;
    export interface RecurrencePattern$Enum {
        daily: 1;
        weekly: 2;
        monthly: 3;
    }
    export type RecurrencePattern = keyof RecurrencePattern$Enum;
    export interface Recurrence$Enum {
        customerBpInvoice: 1;
        supplierBpInvoice: 2;
    }
    export type Recurrence = keyof Recurrence$Enum;
    export interface RecurringInvoiceStatus$Enum {
        pending: 1;
        inProcess: 2;
        completed: 3;
        canceled: 4;
    }
    export type RecurringInvoiceStatus = keyof RecurringInvoiceStatus$Enum;
    export interface ReevaluationEffectiveDate$Enum {
        fyStart: 1;
        periodStart: 2;
        fyEnd: 3;
    }
    export type ReevaluationEffectiveDate = keyof ReevaluationEffectiveDate$Enum;
    export interface ReevaluationMethod$Enum {
        coefficient: 1;
        index: 2;
        marketValue: 3;
    }
    export type ReevaluationMethod = keyof ReevaluationMethod$Enum;
    export interface ReferenceDateType$Enum {
        depreciationStartDate: 1;
        assetPurchaseDate: 2;
        referenceDateForTheCalculationOfTheValue: 3;
        noReferenceDate: 4;
    }
    export type ReferenceDateType = keyof ReferenceDateType$Enum;
    export interface Reference$Enum {
        expiration: 1;
        ubd: 2;
        recontrol: 3;
    }
    export type Reference = keyof Reference$Enum;
    export interface RegionTaxesApplication$Enum {
        receipt: 1;
        issue: 2;
        always: 3;
    }
    export type RegionTaxesApplication = keyof RegionTaxesApplication$Enum;
    export interface RelatedCompanySettings$Enum {
        notRelated: 1;
        votingRightsMoreThanOrEqual10Percent: 2;
        votingRightsLessThan10Percent: 3;
    }
    export type RelatedCompanySettings = keyof RelatedCompanySettings$Enum;
    export interface RelationType$Enum {
        contact: 1;
        lead: 2;
    }
    export type RelationType = keyof RelationType$Enum;
    export interface ReleaseStatus$Enum {
        pending: 1;
        abandoned: 2;
        released: 3;
    }
    export type ReleaseStatus = keyof ReleaseStatus$Enum;
    export interface ReminderFrequencyTypes$Enum {
        threshold: 1;
        interval: 2;
    }
    export type ReminderFrequencyTypes = keyof ReminderFrequencyTypes$Enum;
    export interface ReminderType$Enum {
        noReminder: 1;
        byInvoice: 2;
        global: 3;
        globalByLevel: 4;
        globalByDate: 5;
    }
    export type ReminderType = keyof ReminderType$Enum;
    export interface RenewalHistory$Enum {
        withPreviousPeriod: 1;
        withNewPeriod: 2;
    }
    export type RenewalHistory = keyof RenewalHistory$Enum;
    export interface ReorderQuantity$Enum {
        netQuantity: 1;
        minimumQuantityWithoutRounding: 2;
        minimumQuantityWithRounding: 3;
    }
    export type ReorderQuantity = keyof ReorderQuantity$Enum;
    export interface ReportSortAssets$Enum {
        financialSite: 1;
        accountingCode: 2;
        coAAccount: 3;
        ifrsAccount: 4;
        group: 5;
        anaDistributionKey: 6;
        analyticalDimensionType1: 7;
        analyticalDimensionType2: 8;
        analyticalDimensionType3: 9;
        analyticalDimensionType4: 10;
        analyticalDimensionType5: 11;
        analyticalDimensionType6: 12;
        analyticalDimensionType7: 13;
        analyticalDimensionType8: 14;
        analyticalDimensionType9: 15;
        cgu: 16;
        geographicSite: 17;
        none: 18;
    }
    export type ReportSortAssets = keyof ReportSortAssets$Enum;
    export interface RequestOrigin$Enum {
        none: 1;
        transfertFasImpactantPhy: 2;
        detachementDepuisFasDePhy: 3;
        rattachementDepuisFasDePhy: 4;
        annulationTransfertFasImpactantPhy: 5;
        annulationSortieFasImpactantPhy: 6;
        sortieFasImpactantPhy: 7;
    }
    export type RequestOrigin = keyof RequestOrigin$Enum;
    export interface RequestResponse$Enum {
        request: 1;
        response: 2;
    }
    export type RequestResponse = keyof RequestResponse$Enum;
    export interface RequestStatsGrp$Enum {
        serviceReqStatGroupNo1: 1;
        serviceReqStatGroupNo2: 2;
        serviceReqStatGroupNo3: 3;
        serviceReqStatGroupNo4: 4;
        serviceReqStatGroupNo5: 5;
    }
    export type RequestStatsGrp = keyof RequestStatsGrp$Enum;
    export interface RequestedClosingType$Enum {
        noClosing: 1;
        fyClosing: 2;
        periodClosing: 3;
    }
    export type RequestedClosingType = keyof RequestedClosingType$Enum;
    export interface ResolutionTypes$Enum {
        large: 1;
        small: 2;
    }
    export type ResolutionTypes = keyof ResolutionTypes$Enum;
    export interface ResourceAvailability$Enum {
        available: 1;
        proposal: 2;
        unavailable: 3;
        reserved: 4;
    }
    export type ResourceAvailability = keyof ResourceAvailability$Enum;
    export interface ResourceReservationOrigin$Enum {
        manualCreation: 1;
        appointment: 2;
        afterSalesServiceAction: 3;
    }
    export type ResourceReservationOrigin = keyof ResourceReservationOrigin$Enum;
    export interface ReviewType$Enum {
        major: 1;
        minor: 2;
    }
    export type ReviewType = keyof ReviewType$Enum;
    export interface RevisionParameterMenu$Enum {
        notManaged: 1;
        managedOnDemand: 2;
        managedAutomatically: 3;
    }
    export type RevisionParameterMenu = keyof RevisionParameterMenu$Enum;
    export interface RevisionReason$Enum {
        add: 1;
        modify: 2;
        exclude: 3;
        reinstate: 4;
    }
    export type RevisionReason = keyof RevisionReason$Enum;
    export interface RoundedLot$Enum {
        none: 1;
        roundUp: 2;
        roundDown: 3;
        oneLotMinimum: 4;
    }
    export type RoundedLot = keyof RoundedLot$Enum;
    export interface RoundedType$Enum {
        roundUp: 1;
        roundDown: 2;
        roundToTheNearest: 3;
    }
    export type RoundedType = keyof RoundedType$Enum;
    export interface RoundingBreakdown$Enum {
        product: 1;
        lowLevelCode: 2;
    }
    export type RoundingBreakdown = keyof RoundingBreakdown$Enum;
    export interface RoutingConditions$Enum {
        next: 1;
        exit: 2;
        startingWith: 3;
        containing: 4;
        endingWith: 5;
        greaterThan: 6;
        greaterThanOrEqualTo: 7;
        lessThan: 8;
        lessThanOrEqualTo: 9;
        between: 10;
        isTrue: 11;
        isFalse: 12;
        beforeThe: 13;
        afterThe: 14;
        other: 15;
    }
    export type RoutingConditions = keyof RoutingConditions$Enum;
    export interface RuleFlow$Enum {
        receipt: 1;
        shipment: 2;
    }
    export type RuleFlow = keyof RuleFlow$Enum;
    export interface SafTProductType$Enum {
        none: 1;
        product: 2;
        service: 3;
        other: 4;
    }
    export type SafTProductType = keyof SafTProductType$Enum;
    export interface SafTType$Enum {
        none: 1;
        safTPtIntegrated: 2;
        safTPtInvoicing: 3;
        safTPtAccounting: 4;
        safTPtSelfBilling: 5;
        safTPtCommunicationTa: 6;
        safTPtSelfBillingTa: 7;
        safTPtShippingDocumentsTa: 8;
    }
    export type SafTType = keyof SafTType$Enum;
    export interface SaftAuditFileSchema$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
    }
    export type SaftAuditFileSchema = keyof SaftAuditFileSchema$Enum;
    export interface SaftDocumentType$Enum {
        gtTransportNote: 1;
        grPackingSlip: 2;
        gaAssetsTransport: 3;
        gcLoanPackingSlip: 4;
        gdSupplierReturns: 5;
    }
    export type SaftDocumentType = keyof SaftDocumentType$Enum;
    export interface SaftDocument$Enum {
        invoice: 1;
        simplifiedInvoice: 2;
        debitNote: 3;
        creditNote: 4;
        fixedAssetsSale: 5;
        fixedAssetsReturn: 6;
        invoiceReceipt: 7;
        proforma: 8;
        consignmentInvoice: 9;
    }
    export type SaftDocument = keyof SaftDocument$Enum;
    export interface SalesAmountType$Enum {
        none: 1;
        amountToEnter: 2;
        netValueOfThePlan: 3;
    }
    export type SalesAmountType = keyof SalesAmountType$Enum;
    export interface SalesJournalType$Enum {
        invoice: 1;
        creditMemo: 2;
        return: 3;
        delivery: 4;
        pickTicket: 5;
        preparationList: 6;
        openOrder: 7;
        order: 8;
        quote: 9;
        journal: 10;
        project: 11;
        openItem: 12;
        payment: 13;
        statement: 14;
        prepayment: 15;
        task: 16;
        call: 17;
        appointment: 18;
        serviceContract: 19;
        installedBase: 20;
        serviceRequest: 21;
        serviceResponse: 22;
        solution: 23;
        purchaseInvoice: 24;
        purchaseCreditMemo: 25;
        purchaseReturn: 26;
        purchaseReceipt: 27;
        purchaseOpenOrder: 28;
        purchaseOrder: 29;
        subcontractOrder: 30;
        purchaseRequest: 31;
        rfQs: 32;
        purchaseAdditionalInvoice: 33;
        expense: 34;
        asset: 35;
        supplierBpInvoice: 36;
        container: 37;
        shipping: 38;
        transport: 39;
        projectManagement: 40;
    }
    export type SalesJournalType = keyof SalesJournalType$Enum;
    export interface SalesOrderStage$Enum {
        order: 1;
        preparation: 2;
        delivery: 3;
    }
    export type SalesOrderStage = keyof SalesOrderStage$Enum;
    export interface SalesRepSite$Enum {
        doNothing: 1;
        suggestThatOfTheSalesRep: 2;
        replaceByThatOfTheSalesRep: 3;
    }
    export type SalesRepSite = keyof SalesRepSite$Enum;
    export interface SamplingMode$Enum {
        global: 1;
        lot: 2;
        noManagement: 3;
    }
    export type SamplingMode = keyof SamplingMode$Enum;
    export interface SamplingType$Enum {
        none: 1;
        single: 2;
    }
    export type SamplingType = keyof SamplingType$Enum;
    export interface ScalingAnalyticalPeriod$Enum {
        startOfYear: 1;
        firstRequest: 2;
        fixedDate: 3;
        numberDaysCurrentDay: 4;
    }
    export type ScalingAnalyticalPeriod = keyof ScalingAnalyticalPeriod$Enum;
    export interface ScalingControl$Enum {
        byServerBatch: 1;
        serverBatchManualRequestModifications: 2;
    }
    export type ScalingControl = keyof ScalingControl$Enum;
    export interface ScanningDevice$Enum {
        pdt3100: 1;
        sageInventoryTools: 2;
    }
    export type ScanningDevice = keyof ScanningDevice$Enum;
    export interface Schedule$Enum {
        perUnit: 1;
        amount: 2;
    }
    export type Schedule = keyof Schedule$Enum;
    export interface ScriptResponseStorage$Enum {
        businessPartners: 1;
        prospectsCustomers: 2;
        contacts: 3;
    }
    export type ScriptResponseStorage = keyof ScriptResponseStorage$Enum;
    export interface SearchDestination$Enum {
        sageX3: 1;
        file: 2;
    }
    export type SearchDestination = keyof SearchDestination$Enum;
    export interface SeasonalityType$Enum {
        decreasing: 1;
        increasing: 2;
    }
    export type SeasonalityType = keyof SeasonalityType$Enum;
    export interface SectorsManagement$Enum {
        none: 1;
        dynamic: 2;
        manual: 3;
    }
    export type SectorsManagement = keyof SectorsManagement$Enum;
    export interface SelectLeadTime3390$Enum {
        product: 1;
        routing: 2;
    }
    export type SelectLeadTime3390 = keyof SelectLeadTime3390$Enum;
    export interface SelectionAssetsEntered$Enum {
        allAssetsPresentInFiscalYearPeriod: 1;
        assetsEnteredInFiscalYearPeriod: 2;
        assetsEnteredBeforeCurrentFyPeriod: 3;
    }
    export type SelectionAssetsEntered = keyof SelectionAssetsEntered$Enum;
    export interface SelectionMaster966$Enum {
        prospectsCustomers: 1;
        businessPartners: 2;
    }
    export type SelectionMaster966 = keyof SelectionMaster966$Enum;
    export interface SelectionMaster$Enum {
        prospectsCustomers: 1;
        businessPartners: 2;
        contacts: 3;
    }
    export type SelectionMaster = keyof SelectionMaster$Enum;
    export interface SelectionOfTheIssuedAssets$Enum {
        issuedAndNonIssuedAssets: 1;
        nonIssuedAssets: 2;
        issuedAssets: 3;
    }
    export type SelectionOfTheIssuedAssets = keyof SelectionOfTheIssuedAssets$Enum;
    export interface Sense$Enum {
        outbound: 1;
        inbound: 2;
    }
    export type Sense = keyof Sense$Enum;
    export interface SeparatorType$Enum {
        character: 1;
        asciiCode: 2;
    }
    export type SeparatorType = keyof SeparatorType$Enum;
    export interface SequenceCalculationMethod$Enum {
        substituteValue1: 1;
        aToZ2: 2;
        aToZ: 3;
        substituteValue4: 4;
        substituteValue5: 5;
    }
    export type SequenceCalculationMethod = keyof SequenceCalculationMethod$Enum;
    export interface SerialNumberManagement$Enum {
        notManaged: 1;
        issued: 2;
        receivedIssued: 3;
        globalReceivedIssued: 4;
    }
    export type SerialNumberManagement = keyof SerialNumberManagement$Enum;
    export interface ServiceContractCategories$Enum {
        warranty: 1;
        meeting: 2;
        maintenance: 3;
        byPoints: 4;
    }
    export type ServiceContractCategories = keyof ServiceContractCategories$Enum;
    export interface ServiceContractInvoiceDate$Enum {
        todaysDate: 1;
        nextInvoiceDate: 2;
    }
    export type ServiceContractInvoiceDate = keyof ServiceContractInvoiceDate$Enum;
    export interface ServiceContractSort$Enum {
        number: 1;
        date: 2;
        customer: 3;
        category: 4;
    }
    export type ServiceContractSort = keyof ServiceContractSort$Enum;
    export interface ServiceContractSource$Enum {
        manualCreation: 1;
        salesOrder: 2;
        salesShipment: 3;
        salesInvoice: 4;
        warrantyRequest: 5;
        serviceContractDuplication: 6;
        pointsCredit: 7;
    }
    export type ServiceContractSource = keyof ServiceContractSource$Enum;
    export interface ServiceRequestAllocation$Enum {
        dispatching: 1;
        employee: 2;
        queue: 3;
    }
    export type ServiceRequestAllocation = keyof ServiceRequestAllocation$Enum;
    export interface ServiceRequestInvoicing$Enum {
        nonInvoicable: 1;
        invoicable: 2;
        invoiced: 3;
    }
    export type ServiceRequestInvoicing = keyof ServiceRequestInvoicing$Enum;
    export interface ServiceRequestSource$Enum {
        manualCreation: 1;
        maintenancePlan: 2;
    }
    export type ServiceRequestSource = keyof ServiceRequestSource$Enum;
    export interface ServiceStatus$Enum {
        onHold: 1;
        inProgress: 2;
        closed: 3;
        ordered: 4;
        received: 5;
        inoviced: 6;
    }
    export type ServiceStatus = keyof ServiceStatus$Enum;
    export interface SetUpOptionType$Enum {
        replacementOfConstantRate: 1;
        increaseOfConstantRate: 2;
        decreaseOfConstantRate: 3;
        replacementOfMinimumValue: 4;
        replacementOfCeilingValue: 5;
        replacementOfExceptionalDepreciation: 6;
        optionBelgianMode: 7;
        optionItalianMode: 8;
        optionGermanMode: 9;
        optionStraightLineMode: 10;
    }
    export type SetUpOptionType = keyof SetUpOptionType$Enum;
    export interface SeverityLevel$Enum {
        select: 1;
        critical: 2;
        major: 3;
        moderate: 4;
        minorCosmetic: 5;
    }
    export type SeverityLevel = keyof SeverityLevel$Enum;
    export interface Severity$Enum {
        information: 1;
        warning: 2;
        error: 3;
    }
    export type Severity = keyof Severity$Enum;
    export interface ShortageDelivery$Enum {
        no: 1;
        yes: 2;
        yesProductWithNegativeStockProhibited: 3;
    }
    export type ShortageDelivery = keyof ShortageDelivery$Enum;
    export interface Sign$Enum {
        credit: 1;
        debit: 2;
    }
    export type Sign = keyof Sign$Enum;
    export interface SignatureFormat$Enum {
        withoutSignature: 1;
        xAdEs: 2;
    }
    export type SignatureFormat = keyof SignatureFormat$Enum;
    export interface SiiMessages$Enum {
        resynchronizeTheTaxTableVatAndCash: 1;
        theDatesMustBeIncludedInTheSameYear: 2;
        emptyInvoiceNumberUseTheModificationOptionToUpdateIt: 3;
        emptySourceDocumentNumberUseTheModificationOptionToUpdateIt: 4;
        theAmountMustBeLargerThan: 5;
        thisBpAlreadyExistsForThisOperationType: 6;
        thisInvoiceDoesNotExistInTheReceivedInvoicesBook: 7;
        aRecordAlreadyExistsForThisYear: 8;
        manualInsertionIsNotAllowedWhenTheDataSourceIsNotX3: 9;
        onlyTheseValuesAreAllowed: 10;
        thisValueIsNotAllowedInIssuedInvoices: 11;
        youHaveModifiedTheIdentifierDoYouWantToDeleteTheCurrentRecordForThisIdentifierAndCreateANewOne: 12;
        annualInsurancesAreNotUsedInTheCanaryIslands: 13;
        modificationIsNotAllowedIfThisValueIsIncorrectUseTheModificationOptionToCancelTheLine: 14;
        selectAllRecords: 15;
        clearAllRecords: 16;
        reactivateTheRejectedRecordsOfUnregisteredCustomers: 17;
        reactivateAllTheRecordsForThisError: 18;
        identificationIsMandatoryForThisRecordType: 19;
        valueNotAllowedWhenDeleteOrSendOptionsAreActive: 20;
        valueIsNotAllowedReactivateCancelAndSendOptionsMustBeInactive: 21;
        valueIsNotAllowedReactivateCancelAndDeleteOptionsMustBeInactive: 22;
        thisInvoiceAlreadyExistsWithThisAsset: 23;
        nothingSelectedForTransmission: 24;
        messageTransmission: 25;
        messageTransmissionSummary: 26;
        messageTransmissionCompleted: 27;
        totalInvoicesIssued: 28;
        totalInvoicesReceived: 29;
        totalEuOperations: 30;
        totalFixedAssetsOperations: 31;
        totalCashVatCollections: 32;
        totalCashVatPayments: 33;
        totalAnnualOperations: 34;
        documentWithoutSourceDocumentNumber: 35;
        problemInProcessingTheAnswerStatusNotFound: 36;
        problemProcessingThisDocument: 37;
        problemProcessingThisInvoice: 38;
        thisInvoiceHasBeenProcessed: 39;
        thisDocumentHasBeenProcessed: 40;
        invoiceReceivedWithoutSourceDocumentNumber: 41;
        cashVatPaymentWithoutSourceDocument: 42;
        siiUpdateInProgress: 43;
        siiControl: 44;
        processedDateRange: 45;
        controlOfSiiRecordsWithoutTransmission: 46;
        siiControlSummary: 47;
        expired: 48;
        controlOfRecordsInSiiCompleted: 49;
        theDocumentDoesNotExistInTheVatTable: 50;
        operationDate: 51;
        daysBeforeTheExpirationDate: 52;
        accountingEntriesWithVatAndWithoutInvoice: 53;
        documentNotTransmitted: 54;
        theValueMustBeANumberFrom1To4: 55;
        informationTransmissionError: 56;
        errorMessage: 57;
        globalTransmissionStatus: 58;
        inquiryResult: 59;
        documentSelection: 60;
        companyCertificateNotFound: 61;
        processedBPs: 62;
        unidentifiedTiNs: 63;
        identifiedAsRevokedTiNs: 64;
        identifiedAsCancelledTiNs: 65;
        unidentifiedButSimilarTiNs: 66;
        differentTiNsFound: 67;
        allTheTiNsHaveBeenIdentified: 68;
        webserviceExecutionErrorPleaseContactTheX3SupportAndProvideThemWithTheFollowingMessage: 69;
        recordReadingError: 70;
        recordsRecoveredFromAeat: 71;
        updatingFromAeatTotalUpdatedRecords: 72;
        problemWhenTryingToDisplayTheAeatData: 73;
        noData: 74;
        errorInTheStructureOfTheFileToBeSentUseTheWrijsonEntryPointToCheckTheTestJsonFile: 75;
        problemWithTheCertificatePrivateKey: 76;
        bookType: 77;
        receiverTin: 78;
        receiverIdentification: 79;
        totalConsignment: 80;
    }
    export type SiiMessages = keyof SiiMessages$Enum;
    export interface SiiOperation$Enum {
        creation: 1;
        modification: 2;
        cancellation: 3;
        inquiry: 4;
    }
    export type SiiOperation = keyof SiiOperation$Enum;
    export interface SortAssetReports$Enum {
        financialSite: 1;
        accountingCode: 2;
        coAAccount: 3;
        ifrsAccount: 4;
        group: 5;
        analyticalDistribKey: 6;
        cgu: 7;
        geographicSite: 8;
        none: 9;
    }
    export type SortAssetReports = keyof SortAssetReports$Enum;
    export interface SortBpInvoices858$Enum {
        byNumber: 1;
        bySupplier: 2;
    }
    export type SortBpInvoices858 = keyof SortBpInvoices858$Enum;
    export interface SortBpInvoices$Enum {
        byNumber: 1;
        byCustomer: 2;
    }
    export type SortBpInvoices = keyof SortBpInvoices$Enum;
    export interface SortOption$Enum {
        dueDate: 1;
        sourceDate: 2;
        documentType: 3;
    }
    export type SortOption = keyof SortOption$Enum;
    export interface SortOptionsPrint$Enum {
        classificationBySiteLocation: 1;
        classificationBySiteGroup: 2;
    }
    export type SortOptionsPrint = keyof SortOptionsPrint$Enum;
    export interface SortOrder2627$Enum {
        paymentDateAccountingDate: 1;
        transactionType: 2;
    }
    export type SortOrder2627 = keyof SortOrder2627$Enum;
    export interface SortOrder3176$Enum {
        number: 1;
        title: 2;
        shortTitle: 3;
    }
    export type SortOrder3176 = keyof SortOrder3176$Enum;
    export interface SortPayment$Enum {
        site: 1;
        date: 2;
        paymentType: 3;
        bank: 4;
        openItem: 5;
    }
    export type SortPayment = keyof SortPayment$Enum;
    export interface SortSequence2624$Enum {
        bPs: 1;
        payment: 2;
    }
    export type SortSequence2624 = keyof SortSequence2624$Enum;
    export interface SortTraitenr$Enum {
        dueDate: 1;
        customer: 2;
    }
    export type SortTraitenr = keyof SortTraitenr$Enum;
    export interface Source$Enum {
        manual: 1;
        salesOrder: 2;
        supplierOrder: 3;
    }
    export type Source = keyof Source$Enum;
    export interface SpanishInvoiceType$Enum {
        f1FacturaArt677Y73DelRd16192012: 1;
        f2FacturaSimplificadaTicketYFacturasArt61DRd16192012: 2;
        r1RectificativaArt801Y802YErrorFundadoEnDerecho: 3;
        r2RectificativaArt803: 4;
        r3RectificativaArt804: 5;
        r4RectificativaResto: 6;
        r5RectificativaEnFacturasSimplificadas: 7;
        f3FacturaEmitidaEnSustitucionDeSimplificadas: 8;
        f4AsientoResumenDeFacturas: 9;
        f5ImportacionesDua: 10;
        f6OtrosJustificantesContables: 11;
        lcAduanasLiquidacionComplementaria: 12;
    }
    export type SpanishInvoiceType = keyof SpanishInvoiceType$Enum;
    export interface SpecificDeprecRules$Enum {
        none: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        depreciationChargeX2: 4;
        cancelDepreciationChargeX2: 5;
        substituteValue6: 6;
        substituteValue7: 7;
        energySaving: 8;
        substituteValue9: 9;
        press39Bis: 10;
        dedicatedToResearch: 11;
        substituteValue12: 12;
        software12Months: 13;
        depreciationAdjustReint: 14;
        cancelAmortizationExpense: 15;
        basedOnPeriod: 16;
        basedOnFy: 17;
        bonus: 18;
        substituteValue19: 19;
    }
    export type SpecificDeprecRules = keyof SpecificDeprecRules$Enum;
    export interface SplitObjectNumbering$Enum {
        none: 1;
        byLineNumberIncrement: 2;
        addANumericIncrement: 3;
        newNumber: 4;
    }
    export type SplitObjectNumbering = keyof SplitObjectNumbering$Enum;
    export interface SrcCompSalePriceCalcul$Enum {
        nvAtEffectiveDateForSpecPlan: 1;
        gvOfSpecifiedPlan: 2;
        distribEnvelopeAccordingToSpecPlanNv: 3;
        distribEnvelopeAccordingToSpecPlanGv: 4;
        salePriceIdenticalToThatEnteredByUser: 5;
    }
    export type SrcCompSalePriceCalcul = keyof SrcCompSalePriceCalcul$Enum;
    export interface StandardDepreciationMethods$Enum {
        straightLine: 1;
        amortGrossVal: 2;
        germanDeclining: 3;
        belgianDeclining: 4;
        decliningBalance: 5;
        spanishDeclining: 6;
        frenchDeclining: 7;
        mixedGermanDeclining: 8;
        portugueseDeclining: 9;
        mixedSpanishDeclining: 10;
        residual: 11;
        formsAndMolds: 12;
        spanishStraightlineMonth: 13;
        laundry: 14;
        frenchStraightline: 15;
        gradual: 16;
        withoutDepreciation: 17;
        softy: 18;
        productionUnit: 19;
        straightlineBeyondNullSalvageUnit: 20;
        portugueseMixedDeclining: 21;
        ordinarioAnticipato: 22;
        portugueseConstants: 23;
        portugueseDuodecimos: 24;
        amortNetVal: 25;
        belgianStraightline: 26;
        moroccanDeclining: 27;
        russianStraightline: 28;
        russianDeclining: 29;
        russianConstant: 30;
        russianSofty: 31;
        russianUnits: 32;
        polishStraightline: 33;
        polishDeclining: 34;
        romanianStraightline: 35;
        romanianAccelerated: 36;
        romanianDeclining: 37;
        spanishStraightlineDay: 38;
        onePeriod: 39;
        primeCost: 40;
        diminishingValue: 41;
        swissStraightline: 42;
        swissDeclining: 43;
        turkishStraightline: 44;
        turkishDeclining: 45;
        austrianHalfYear: 46;
    }
    export type StandardDepreciationMethods = keyof StandardDepreciationMethods$Enum;
    export interface StandardDepreciationVariant$Enum {
        depreciationCalculatedByFinancialYear: 1;
        depreciationCalculatedByPeriod: 2;
    }
    export type StandardDepreciationVariant = keyof StandardDepreciationVariant$Enum;
    export interface StandardProductCode$Enum {
        notManaged: 1;
        byProject: 2;
        availableStock: 3;
        byOrder: 4;
    }
    export type StandardProductCode = keyof StandardProductCode$Enum;
    export interface StatementStatus$Enum {
        notMatched: 1;
        matched: 2;
        validated: 3;
        reconcile: 4;
    }
    export type StatementStatus = keyof StatementStatus$Enum;
    export interface Status2806$Enum {
        notPosted: 1;
        postedSimulation: 2;
        postedActual: 3;
    }
    export type Status2806 = keyof Status2806$Enum;
    export interface Status2824$Enum {
        entered: 1;
        inProgress: 2;
        closed: 3;
    }
    export type Status2824 = keyof Status2824$Enum;
    export interface StatusEdiField$Enum {
        mandatory: 1;
        required: 2;
        dependant: 3;
        advised: 4;
        optional: 5;
        notUsed: 6;
    }
    export type StatusEdiField = keyof StatusEdiField$Enum;
    export interface StatusOfExpeditions$Enum {
        successfulTermination: 1;
        waitingDispatch: 2;
    }
    export type StatusOfExpeditions = keyof StatusOfExpeditions$Enum;
    export interface StatusOfTheFunds$Enum {
        nonGeneratedFunds: 1;
        provisionalFunds: 2;
        finalFunds: 3;
    }
    export type StatusOfTheFunds = keyof StatusOfTheFunds$Enum;
    export interface StockManagement$Enum {
        notManaged: 1;
        managed: 2;
        potencyManaged: 3;
    }
    export type StockManagement = keyof StockManagement$Enum;
    export interface StockTransactionsStatus$Enum {
        open: 1;
        deferred: 2;
        balanceAdjustment: 3;
        closed: 4;
    }
    export type StockTransactionsStatus = keyof StockTransactionsStatus$Enum;
    export interface StockValuation$Enum {
        averageCost: 1;
        fifo: 2;
        standardCost: 3;
        revisedStandardCost: 4;
        lastCost: 5;
    }
    export type StockValuation = keyof StockValuation$Enum;
    export interface StockWithdrawalMode$Enum {
        immediate: 1;
        backflush: 2;
        all: 3;
    }
    export type StockWithdrawalMode = keyof StockWithdrawalMode$Enum;
    export interface StockWithdrawal$Enum {
        immediate: 1;
        backflush: 2;
        notManaged: 3;
    }
    export type StockWithdrawal = keyof StockWithdrawal$Enum;
    export interface StoredIntermediateAmount$Enum {
        no: 1;
        amount1: 2;
        amount2: 3;
    }
    export type StoredIntermediateAmount = keyof StoredIntermediateAmount$Enum;
    export interface SubContractOrderStatus$Enum {
        onHold: 1;
        beingOptimized: 2;
        printed: 3;
        inProgress: 4;
        closed: 5;
        costPriceCalculated: 6;
    }
    export type SubContractOrderStatus = keyof SubContractOrderStatus$Enum;
    export interface SubcontractMaterialStatus$Enum {
        onHold: 1;
        underProgress: 2;
        closed: 3;
        excluded: 4;
        ordered: 5;
        received: 6;
    }
    export type SubcontractMaterialStatus = keyof SubcontractMaterialStatus$Enum;
    export interface SubcontractSort$Enum {
        bySubcontractOrderNo: 1;
        bySubcontractedProduct: 2;
        byService: 3;
        byPurchaseOrderNo: 4;
        byPurchaseOrderDate: 5;
        bySupplier: 6;
        byMaterial: 7;
        byDeliveryDate: 8;
    }
    export type SubcontractSort = keyof SubcontractSort$Enum;
    export interface SubcontractedProductStatus$Enum {
        onHold: 1;
        underProgress: 2;
        ordered: 3;
        received: 4;
        closed: 5;
    }
    export type SubcontractedProductStatus = keyof SubcontractedProductStatus$Enum;
    export interface SubjectCampaignCalls$Enum {
        readObjectOnMarketingCampaign: 1;
        readObjectOnCallCampaign: 2;
    }
    export type SubjectCampaignCalls = keyof SubjectCampaignCalls$Enum;
    export interface SubjectToControl$Enum {
        noControl: 1;
        nonChangeableControl: 2;
        changeableControl: 3;
        periodicControl: 4;
    }
    export type SubjectToControl = keyof SubjectToControl$Enum;
    export interface SubsidyStatus$Enum {
        inProcess: 1;
        investmentComplete: 2;
        deleted: 3;
        totallyReintegrated: 4;
    }
    export type SubsidyStatus = keyof SubsidyStatus$Enum;
    export interface SubsidyType$Enum {
        fixedRate: 1;
        percentage: 2;
        cappedPercentage: 3;
    }
    export type SubsidyType = keyof SubsidyType$Enum;
    export interface SuggestionType$Enum {
        noSuggestion: 1;
        purchase: 2;
        manufacturing: 3;
        intersite: 4;
        subcontracting: 5;
    }
    export type SuggestionType = keyof SuggestionType$Enum;
    export interface SupplementaryInvoicing$Enum {
        accordingToContractDueDates: 1;
        onClosingOfTheServiceRequest: 2;
    }
    export type SupplementaryInvoicing = keyof SupplementaryInvoicing$Enum;
    export interface SupplierCustomerType$Enum {
        customer: 1;
        supplier: 2;
    }
    export type SupplierCustomerType = keyof SupplierCustomerType$Enum;
    export interface SupplierSituationRisks$Enum {
        onOrder: 1;
        shippedNotInvoiced: 2;
        nonPostedInvoices: 3;
        unmatchedCreditMemos: 4;
        dueDatesApprovedForPayment: 5;
        dueDatesNotApprovedForPayment: 6;
        temporaryPayments: 7;
        notesPR1: 8;
        notesPR2: 9;
        notesPR3: 10;
    }
    export type SupplierSituationRisks = keyof SupplierSituationRisks$Enum;
    export interface SuppliersStatisticsGroups$Enum {
        supplierStat1: 1;
        supplierStat2: 2;
        supplierStat3: 3;
        supplierStat4: 4;
        supplierStat5: 5;
    }
    export type SuppliersStatisticsGroups = keyof SuppliersStatisticsGroups$Enum;
    export interface SupplyBy$Enum {
        grantor: 1;
        grantee: 2;
    }
    export type SupplyBy = keyof SupplyBy$Enum;
    export interface SwissPaymentTypes$Enum {
        normal: 1;
        dta: 2;
        ezag: 3;
        iso: 4;
    }
    export type SwissPaymentTypes = keyof SwissPaymentTypes$Enum;
    export interface SwissTypeCodes$Enum {
        nonIsr: 1;
        print: 2;
        dta: 3;
        ezag: 4;
        iso: 5;
    }
    export type SwissTypeCodes = keyof SwissTypeCodes$Enum;
    export interface TaCommunicationStatus$Enum {
        all: 1;
        sentWithSuccess: 2;
        sentWithErrors: 3;
        notSent: 4;
        notSentAndSentWithErrors: 5;
    }
    export type TaCommunicationStatus = keyof TaCommunicationStatus$Enum;
    export interface TablesOfCriteria$Enum {
        bPs: 1;
        prospectsCustomers: 2;
        addresses: 3;
        contacts: 4;
    }
    export type TablesOfCriteria = keyof TablesOfCriteria$Enum;
    export interface TargetCompDeprecDurationRule$Enum {
        remainingDuration: 1;
        previousRenewalDuration: 2;
    }
    export type TargetCompDeprecDurationRule = keyof TargetCompDeprecDurationRule$Enum;
    export interface TargetCompanyAssetStatus$Enum {
        secondHand: 1;
        renewalOfPreviousStatus: 2;
    }
    export type TargetCompanyAssetStatus = keyof TargetCompanyAssetStatus$Enum;
    export interface TaskLink$Enum {
        none: 1;
        serviceRequest: 2;
        massMailing: 3;
        callCampaign: 4;
        tradeShow: 5;
        mediaCampaign: 6;
        followUpCampaign: 7;
        marketingCampaign: 8;
    }
    export type TaskLink = keyof TaskLink$Enum;
    export interface TaxAuthorityStatus$Enum {
        pending: 1;
        accepted: 2;
        acceptedWithErrors: 3;
        rejected: 4;
    }
    export type TaxAuthorityStatus = keyof TaxAuthorityStatus$Enum;
    export interface TaxCountryRegion$Enum {
        mainland: 1;
        azores: 2;
        madeira: 3;
        nonApplicable: 4;
        oneStopShop: 5;
    }
    export type TaxCountryRegion = keyof TaxCountryRegion$Enum;
    export interface TaxLevelEnum$Enum {
        reduced: 1;
        intermediate: 2;
        normal: 3;
        exemption: 4;
        other: 5;
        notApplicable: 6;
    }
    export type TaxLevelEnum = keyof TaxLevelEnum$Enum;
    export interface TaxRule3165$Enum {
        fiscalEngineSizeHp: 1;
        co2EmissionRate: 2;
    }
    export type TaxRule3165 = keyof TaxRule3165$Enum;
    export interface TaxRuleEnum$Enum {
        product: 1;
        maximumRate: 2;
        minimumRate: 3;
        fixedRate: 4;
        distribution: 5;
    }
    export type TaxRuleEnum = keyof TaxRuleEnum$Enum;
    export interface TaxType2079$Enum {
        notApplicable: 1;
        vat: 2;
        taxStamp: 3;
        iec: 4;
        other: 5;
    }
    export type TaxType2079 = keyof TaxType2079$Enum;
    export interface TaxType$Enum {
        vat: 1;
        additionalTax: 2;
        specialTax: 3;
        localTax: 4;
    }
    export type TaxType = keyof TaxType$Enum;
    export interface TaxableHorsePower$Enum {
        lessThanOrEqualTo4: 1;
        from5To7: 2;
        from8To11: 3;
        from12To16: 4;
        higherThan16: 5;
    }
    export type TaxableHorsePower = keyof TaxableHorsePower$Enum;
    export interface TaxationRule$Enum {
        incomeTax: 1;
        corporateIncomeTax: 2;
    }
    export type TaxationRule = keyof TaxationRule$Enum;
    export interface TechnicalSheetTrackingType$Enum {
        qualityControlTracking: 1;
        workOrderTracking: 2;
    }
    export type TechnicalSheetTrackingType = keyof TechnicalSheetTrackingType$Enum;
    export interface TerritoryOfDeclaration$Enum {
        commonTerritory: 1;
        navarre: 2;
        bizkaia: 3;
        gipuzkoa: 4;
        alava: 5;
        canaryIslands: 6;
    }
    export type TerritoryOfDeclaration = keyof TerritoryOfDeclaration$Enum;
    export interface TestCp$Enum {
        excludeNonListedProducts: 1;
        includeNonListedProducts: 2;
    }
    export type TestCp = keyof TestCp$Enum;
    export interface TextTypes$Enum {
        comments: 1;
        remarks: 2;
        quoteText: 3;
        greetings: 4;
        etc: 5;
    }
    export type TextTypes = keyof TextTypes$Enum;
    export interface TextsToTranslate$Enum {
        priceColumns: 1;
        invoiceElements: 2;
        productDescriptions: 3;
        configurator: 4;
        units: 5;
        packagings: 6;
        deliveryModes: 7;
        paymentTerms: 8;
        miscellaneousTables: 9;
        other: 10;
    }
    export type TextsToTranslate = keyof TextsToTranslate$Enum;
    export interface TimeFormat$Enum {
        hhmm: 1;
        hhmmss: 2;
        hhMm: 3;
        hhMmSs: 4;
    }
    export type TimeFormat = keyof TimeFormat$Enum;
    export interface Timing$Enum {
        day: 1;
        week: 2;
        month: 3;
    }
    export type Timing = keyof Timing$Enum;
    export interface ToleranceDefinitionLevel$Enum {
        substituteValue1: 1;
        shiSheetRecord: 2;
        productSite: 3;
        bom: 4;
    }
    export type ToleranceDefinitionLevel = keyof ToleranceDefinitionLevel$Enum;
    export interface TpTfBasisRuleTargetCompany$Enum {
        renewal: 1;
        maxContributionValue80SrfTaxBasis: 2;
        substituteValue3: 3;
        contributionValue4: 4;
        substituteValue5: 5;
        contributionValue: 6;
    }
    export type TpTfBasisRuleTargetCompany = keyof TpTfBasisRuleTargetCompany$Enum;
    export interface TransactionType2039$Enum {
        select: 1;
        all: 2;
        bom: 3;
        customer: 4;
        demandForecast: 5;
        purchaseRequest: 6;
        purchaseOrder: 7;
        salesQuote: 8;
        routing: 9;
        salesOrder: 10;
        stock: 11;
        subcontractOrder: 12;
        supplier: 13;
        workOrder: 14;
        other: 15;
    }
    export type TransactionType2039 = keyof TransactionType2039$Enum;
    export interface Trigger$Enum {
        document: 1;
        sourceDocument: 2;
    }
    export type Trigger = keyof Trigger$Enum;
    export interface Type3667$Enum {
        data: 1;
        segmentId: 2;
        fieldId: 3;
        constant: 4;
    }
    export type Type3667 = keyof Type3667$Enum;
    export interface TypeCode$Enum {
        status: 1;
        summary: 2;
        detail: 3;
    }
    export type TypeCode = keyof TypeCode$Enum;
    export interface TypeOfAccountingCodes$Enum {
        account: 1;
        modifier: 2;
        control: 3;
    }
    export type TypeOfAccountingCodes = keyof TypeOfAccountingCodes$Enum;
    export interface TypeOfAddress$Enum {
        contact: 1;
        bp: 2;
        company: 3;
        site: 4;
    }
    export type TypeOfAddress = keyof TypeOfAddress$Enum;
    export interface TypeOfAfterSalesServicesEmployee$Enum {
        internalContact: 1;
        externalServiceProvider: 2;
    }
    export type TypeOfAfterSalesServicesEmployee = keyof TypeOfAfterSalesServicesEmployee$Enum;
    export interface TypeOfAllocation$Enum {
        global: 1;
        detailed: 2;
        notUsed1: 3;
        detailedShortage: 4;
        globalShortage: 5;
        notUsed2: 6;
    }
    export type TypeOfAllocation = keyof TypeOfAllocation$Enum;
    export interface TypeOfAssetUnderConcession$Enum {
        outOfNetwork: 1;
        networked: 2;
    }
    export type TypeOfAssetUnderConcession = keyof TypeOfAssetUnderConcession$Enum;
    export interface TypeOfCharge$Enum {
        exempt: 1;
        benefits: 2;
        charges: 3;
        commission: 4;
        inps: 5;
        vat: 6;
        other: 7;
    }
    export type TypeOfCharge = keyof TypeOfCharge$Enum;
    export interface TypeOfCharges$Enum {
        freight: 1;
        miscellaneous: 2;
        fixed: 3;
    }
    export type TypeOfCharges = keyof TypeOfCharges$Enum;
    export interface TypeOfConcessionInput$Enum {
        substituteValue1: 1;
        renewal: 2;
    }
    export type TypeOfConcessionInput = keyof TypeOfConcessionInput$Enum;
    export interface TypeOfConsumptionDefault$Enum {
        part: 1;
        labor: 2;
        expenses: 3;
    }
    export type TypeOfConsumptionDefault = keyof TypeOfConsumptionDefault$Enum;
    export interface TypeOfCover$Enum {
        accordingToBase: 1;
        accordingToProductReference: 2;
        accordingToCommercialGroup: 3;
    }
    export type TypeOfCover = keyof TypeOfCover$Enum;
    export interface TypeOfDocument$Enum {
        customerQuote: 1;
        customerOrder: 2;
        supplierOrder: 3;
        customerPackingSlip: 4;
        supplierPackingSlip: 5;
        customerInvoice: 6;
        supplierInvoice: 7;
        customerLoanOrder: 8;
        customerLoanPackingSlip: 9;
    }
    export type TypeOfDocument = keyof TypeOfDocument$Enum;
    export interface TypeOfDraftManagment$Enum {
        french: 1;
        spanish: 2;
        portuguese: 3;
    }
    export type TypeOfDraftManagment = keyof TypeOfDraftManagment$Enum;
    export interface TypeOfEdiField$Enum {
        alphanumeric: 1;
        numeric: 2;
        alpha: 3;
    }
    export type TypeOfEdiField = keyof TypeOfEdiField$Enum;
    export interface TypeOfMailingAddress$Enum {
        byBusinessPartner: 1;
        byContact: 2;
    }
    export type TypeOfMailingAddress = keyof TypeOfMailingAddress$Enum;
    export interface TypeOfMerge$Enum {
        useSeagateCrystalReport: 1;
        useMicrosoftWord: 2;
        generatedOnTheClientMachine: 3;
        generatedOnTheServer: 4;
    }
    export type TypeOfMerge = keyof TypeOfMerge$Enum;
    export interface TypeOfProduct$Enum {
        other: 1;
        part: 2;
        labor: 3;
        expenses: 4;
        serviceContract: 5;
    }
    export type TypeOfProduct = keyof TypeOfProduct$Enum;
    export interface TypeOfProrataTemporis$Enum {
        day: 1;
        month: 2;
        week: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        substituteValue6: 6;
    }
    export type TypeOfProrataTemporis = keyof TypeOfProrataTemporis$Enum;
    export interface TypeOfSuggestion$Enum {
        noProcessing: 1;
        withMrpPegging: 2;
        wthoutMrpPegging: 3;
        mrpPeggingOnly: 4;
    }
    export type TypeOfSuggestion = keyof TypeOfSuggestion$Enum;
    export interface Type$Enum {
        functional: 1;
        technical: 2;
        transfer: 3;
    }
    export type Type = keyof Type$Enum;
    export interface TypesOfActions2963$Enum {
        actionsPerformed: 1;
        actionsToBePerformed: 2;
    }
    export type TypesOfActions2963 = keyof TypesOfActions2963$Enum;
    export interface TypesOfActions$Enum {
        projects: 1;
        appointment: 2;
        call: 3;
        task: 4;
        helpDeskCall: 5;
        helpDeskAction: 6;
        massMailing: 7;
    }
    export type TypesOfActions = keyof TypesOfActions$Enum;
    export interface TypesOfDistances$Enum {
        kilometers: 1;
        miles: 2;
    }
    export type TypesOfDistances = keyof TypesOfDistances$Enum;
    export interface TypesOfResponse$Enum {
        alphanumeric: 1;
        numeric: 2;
        date: 3;
        boolean: 4;
    }
    export type TypesOfResponse = keyof TypesOfResponse$Enum;
    export interface TypesOfSupportOfSelection$Enum {
        regroupingOfTables: 1;
        process: 2;
        allRecords: 3;
        firstLevelLink: 4;
    }
    export type TypesOfSupportOfSelection = keyof TypesOfSupportOfSelection$Enum;
    export interface TypesOfVatUpdate$Enum {
        creationOrIntegration: 1;
        determinationOfRealDeductionCoefficient: 2;
        variationOfTheDeductionCoeffOverTime: 3;
        saleNotTaxed: 4;
        transferOfSector: 5;
        taxedSale: 6;
        legalModificationsOfTheExclusionRules: 7;
        assetBecomingUsed: 8;
        assetNoLongerUsed: 9;
        assetNoLongerUsedIssued: 10;
        cancellationOfCoefficientVarianceInTime: 11;
        saleCancelled: 12;
        cancellationOfRealDeductionCoefficientDetermination: 13;
    }
    export type TypesOfVatUpdate = keyof TypesOfVatUpdate$Enum;
    export interface UnbalancedPayment$Enum {
        bankAdjustment: 1;
        roundingVariance: 2;
        manualCorrection: 3;
    }
    export type UnbalancedPayment = keyof UnbalancedPayment$Enum;
    export interface UnpackingRulesPac$Enum {
        unpack: 1;
        adjustCoefficientRecalcPacCoeff: 2;
        fractionCalculateDecimalPac: 3;
    }
    export type UnpackingRulesPac = keyof UnpackingRulesPac$Enum;
    export interface UpdFieldsSplit$Enum {
        substituteValue1: 1;
        description1: 2;
        description2: 3;
        group: 4;
        accountingCode: 5;
        freeField1: 6;
        freeField2: 7;
        freeField3: 8;
        freeField4: 9;
        freeField5: 10;
        freeField6: 11;
        freeField7: 12;
        freeField8: 13;
        freeField9: 14;
        freeField10: 15;
    }
    export type UpdFieldsSplit = keyof UpdFieldsSplit$Enum;
    export interface UpdateDuringCount$Enum {
        held: 1;
        deferred: 2;
        direct: 3;
    }
    export type UpdateDuringCount = keyof UpdateDuringCount$Enum;
    export interface UseSearchTermList$Enum {
        no: 1;
        firstPass: 2;
        lastPass: 3;
    }
    export type UseSearchTermList = keyof UseSearchTermList$Enum;
    export interface UseStatus$Enum {
        inDevelopment: 1;
        availableToUse: 2;
    }
    export type UseStatus = keyof UseStatus$Enum;
    export interface Use$Enum {
        substituteValue1: 1;
        lastLevel: 2;
        multilevel: 3;
        multilevelCumulative: 4;
        phantomSAt1stLevel: 5;
    }
    export type Use = keyof Use$Enum;
    export interface UserDepartment$Enum {
        select: 1;
        rD: 2;
        support: 3;
        sales: 4;
    }
    export type UserDepartment = keyof UserDepartment$Enum;
    export interface UserFunctions3022$Enum {
        other: 1;
        salesEngineer: 2;
        teleSales: 3;
        commercialManager: 4;
        customerSupport: 5;
        followUp: 6;
    }
    export type UserFunctions3022 = keyof UserFunctions3022$Enum;
    export interface UserFunctionsEnum$Enum {
        salesEngineer: 1;
        telesales: 2;
        salesDirector: 3;
        customerSupport: 4;
        other: 5;
    }
    export type UserFunctionsEnum = keyof UserFunctionsEnum$Enum;
    export interface UserRole2036$Enum {
        select: 1;
        juniorDeveloper: 2;
        seniorDeveloper: 3;
        teamLeader: 4;
        productDevelopmentManager: 5;
        juniorTester: 6;
        seniorTester: 7;
        author: 8;
    }
    export type UserRole2036 = keyof UserRole2036$Enum;
    export interface UserStatus$Enum {
        permanent: 1;
        temporary: 2;
        partTime: 3;
    }
    export type UserStatus = keyof UserStatus$Enum;
    export interface ValuationType$Enum {
        fixedValue: 1;
        userValue: 2;
        mileage: 3;
    }
    export type ValuationType = keyof ValuationType$Enum;
    export interface Valuation$Enum {
        origin: 1;
        destination: 2;
    }
    export type Valuation = keyof Valuation$Enum;
    export interface ValueType$Enum {
        taxExcluded: 1;
        taxIncluded: 2;
        substituteValue3: 3;
    }
    export type ValueType = keyof ValueType$Enum;
    export interface VarianceRecoveryStrategy$Enum {
        futureEffectiveDateFyStart: 1;
        futureEffectiveDatePeriodStart: 2;
        immediateRecoveryOverThePeriod: 3;
        immediateRecoveryOverThePeriodExceptional: 4;
    }
    export type VarianceRecoveryStrategy = keyof VarianceRecoveryStrategy$Enum;
    export interface VatRuleForDispoal$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        noVatAdjustment: 4;
        deductibleVatAmountAdjustmentIncrease: 5;
        deductibleVatAmountAdjustmentDecrease: 6;
    }
    export type VatRuleForDispoal = keyof VatRuleForDispoal$Enum;
    export interface VehicleCategoryForExpenses$Enum {
        category1: 1;
        category2: 2;
        category3: 3;
    }
    export type VehicleCategoryForExpenses = keyof VehicleCategoryForExpenses$Enum;
    export interface VehicleReceiptType$Enum {
        nationalReception: 1;
        euReception: 2;
        other: 3;
    }
    export type VehicleReceiptType = keyof VehicleReceiptType$Enum;
    export interface VehicleTaxRate$Enum {
        fullRate: 1;
        substituteValue2: 2;
        totalExemption: 3;
        co2Exemtion: 4;
        ageExemption: 5;
    }
    export type VehicleTaxRate = keyof VehicleTaxRate$Enum;
    export interface VerificationStatus$Enum {
        cannotBeVerified: 1;
        verificationInProgress: 2;
        notYetVerified: 3;
        partiallyVerified: 4;
        verified: 5;
        allStatuses: 6;
    }
    export type VerificationStatus = keyof VerificationStatus$Enum;
    export interface VersionStatus$Enum {
        prototypeVersion: 1;
        activeVersion: 2;
        stoppedVersion: 3;
        toActivateVersion: 4;
    }
    export type VersionStatus = keyof VersionStatus$Enum;
    export interface VoucherCreation$Enum {
        none: 1;
        all: 2;
        productsManagedBySerialNumber: 3;
        productsNotManagedBySerialNumber: 4;
        productsManagedInSerialNumberWithWarranty: 5;
        productsNotManagedInSerialNumberWithWarranty: 6;
        productsManagedInSerialNumberWithoutWarranty: 7;
        productsNotManagedInSerialNumberWithoutWarranty: 8;
        productsWithWarranty: 9;
        productsWithoutWarranty: 10;
    }
    export type VoucherCreation = keyof VoucherCreation$Enum;
    export interface WarrantyVoucherSource$Enum {
        salesOrder: 1;
        salesDelivery: 2;
        salesInvoice: 3;
    }
    export type WarrantyVoucherSource = keyof WarrantyVoucherSource$Enum;
    export interface WasteDisposalManagement3687$Enum {
        productGroup: 1;
        packingMaterial: 2;
        packSize: 3;
        tariffType: 4;
        tariffCategory: 5;
    }
    export type WasteDisposalManagement3687 = keyof WasteDisposalManagement3687$Enum;
    export interface WasteDisposalManagement$Enum {
        germany: 1;
        austria: 2;
    }
    export type WasteDisposalManagement = keyof WasteDisposalManagement$Enum;
    export interface WebserviceForEuVatIdCheck$Enum {
        none: 1;
        eu: 2;
        germany: 3;
    }
    export type WebserviceForEuVatIdCheck = keyof WebserviceForEuVatIdCheck$Enum;
    export interface WipControlExchangeRate$Enum {
        historicalRate: 1;
        revisedRate: 2;
    }
    export type WipControlExchangeRate = keyof WipControlExchangeRate$Enum;
    export interface WipSelection$Enum {
        globalWipStatus: 1;
        statusOfPostedWip: 2;
    }
    export type WipSelection = keyof WipSelection$Enum;
    export interface WithholdingCategory$Enum {
        atSource: 1;
        inps: 2;
        enasarco: 3;
        firr: 4;
        other: 5;
        vat: 6;
        grossIncome: 7;
        gains: 8;
        suss: 9;
        w3: 10;
        w4: 11;
    }
    export type WithholdingCategory = keyof WithholdingCategory$Enum;
    export interface WithholdingType$Enum {
        onPayment: 1;
        onInvoice: 2;
    }
    export type WithholdingType = keyof WithholdingType$Enum;
    export interface WorkInProgressControl$Enum {
        check: 1;
        noCheck: 2;
        hold: 3;
    }
    export type WorkInProgressControl = keyof WorkInProgressControl$Enum;
    export interface AddressAddressEmails extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        entityNumber: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface AddressAddressEmailsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        entityNumber?: string;
        code?: string;
        addressEmail?: string;
    }
    export interface AddressAddressEmailsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        entityNumber: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface AddressAddressEmails$Operations {
        query: QueryOperation<AddressAddressEmails>;
        read: ReadOperation<AddressAddressEmails>;
        aggregate: {
            read: AggregateReadOperation<AddressAddressEmails>;
            query: AggregateQueryOperation<AddressAddressEmails>;
        };
        getDefaults: GetDefaultsOperation<AddressAddressEmails>;
    }
    export interface AddressAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        entityNumber: string;
        code: string;
        addressLine: string;
    }
    export interface AddressAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        entityNumber?: string;
        code?: string;
        addressLine?: string;
    }
    export interface AddressAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        entityNumber: string;
        code: string;
        addressLine: string;
    }
    export interface AddressAddressLines$Operations {
        query: QueryOperation<AddressAddressLines>;
        read: ReadOperation<AddressAddressLines>;
        aggregate: {
            read: AggregateReadOperation<AddressAddressLines>;
            query: AggregateQueryOperation<AddressAddressLines>;
        };
        getDefaults: GetDefaultsOperation<AddressAddressLines>;
    }
    export interface AddressAddressPhoneNumbers extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        entityNumber: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface AddressAddressPhoneNumbersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        entityNumber?: string;
        code?: string;
        addressPhoneNumber?: string;
    }
    export interface AddressAddressPhoneNumbersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        entityNumber: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface AddressAddressPhoneNumbers$Operations {
        query: QueryOperation<AddressAddressPhoneNumbers>;
        read: ReadOperation<AddressAddressPhoneNumbers>;
        aggregate: {
            read: AggregateReadOperation<AddressAddressPhoneNumbers>;
            query: AggregateQueryOperation<AddressAddressPhoneNumbers>;
        };
        getDefaults: GetDefaultsOperation<AddressAddressPhoneNumbers>;
    }
    export interface Address extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        entityNumber: string;
        code: string;
        description: string;
        defaultBankId: BankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<AddressAddressEmails>;
        addressLines: ClientCollection<AddressAddressLines>;
        addressPhoneNumbers: ClientCollection<AddressAddressPhoneNumbers>;
    }
    export interface AddressInput extends ClientNodeInput {
        entityType?: EntityType;
        entityNumber?: string;
        code?: string;
        description?: string;
        defaultBankId?: string;
        isDefault?: boolean | string;
        zipCode?: string;
        city?: string;
        state?: string;
        country?: string;
        countryName?: string;
        website?: string;
        externalIdentifier?: string;
        isValid?: boolean | string;
        addressEmails?: Partial<AddressAddressEmailsInput>[];
        addressLines?: Partial<AddressAddressLinesInput>[];
        addressPhoneNumbers?: Partial<AddressAddressPhoneNumbersInput>[];
    }
    export interface AddressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        entityNumber: string;
        code: string;
        description: string;
        defaultBankId: BankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<AddressAddressEmailsBinding>;
        addressLines: ClientCollection<AddressAddressLinesBinding>;
        addressPhoneNumbers: ClientCollection<AddressAddressPhoneNumbersBinding>;
    }
    export interface Address$Lookups {
        defaultBankId: QueryOperation<BankDetail>;
        country: QueryOperation<Country>;
    }
    export interface Address$Operations {
        query: QueryOperation<Address>;
        read: ReadOperation<Address>;
        aggregate: {
            read: AggregateReadOperation<Address>;
            query: AggregateQueryOperation<Address>;
        };
        lookups(dataOrId: string | { data: AddressInput }): Address$Lookups;
        getDefaults: GetDefaultsOperation<Address>;
    }
    export interface BankDetail extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        entityNumber: string;
        bankId: string;
        address: Address;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface BankDetailInput extends ClientNodeInput {
        entityType?: EntityType;
        entityNumber?: string;
        bankId?: string;
        address?: string;
        byDefault?: boolean | string;
        beneficiary?: string;
        payingBank1?: string;
        payingBank2?: string;
        payingBank3?: string;
        payingBank4?: string;
        ibanPrefix?: string;
        bic?: string;
        country?: string;
        currency?: string;
        intermediaryBankName?: string;
        intermediaryBankAddress1?: string;
        intermediaryBankAddress2?: string;
        intermediaryBankAddress3?: string;
        intermediaryBankBic?: string;
        intermediaryBankCountry?: string;
        nonResidentAccount?: boolean | string;
        isrCustomerNumber?: string;
    }
    export interface BankDetailBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        entityNumber: string;
        bankId: string;
        address: Address;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface BankDetail$Lookups {
        address: QueryOperation<Address>;
        country: QueryOperation<Country>;
        currency: QueryOperation<Currency>;
        intermediaryBankCountry: QueryOperation<Country>;
    }
    export interface BankDetail$Operations {
        query: QueryOperation<BankDetail>;
        read: ReadOperation<BankDetail>;
        aggregate: {
            read: AggregateReadOperation<BankDetail>;
            query: AggregateQueryOperation<BankDetail>;
        };
        lookups(dataOrId: string | { data: BankDetailInput }): BankDetail$Lookups;
        getDefaults: GetDefaultsOperation<BankDetail>;
    }
    export interface BomCodes extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        bomType: BomCodeType;
        code: integer;
        description: string;
        shortDescription: string;
        accessCode: Access;
        site: Site;
        isProductionUtilization: boolean;
        isCostUtilization: boolean;
        isMrpUtilization: boolean;
        isMpsUtilization: boolean;
    }
    export interface BomCodesInput extends ClientNodeInput {
        bomType?: BomCodeType;
        code?: integer | string;
        description?: string;
        shortDescription?: string;
        accessCode?: string;
        site?: string;
        isProductionUtilization?: boolean | string;
        isCostUtilization?: boolean | string;
        isMrpUtilization?: boolean | string;
        isMpsUtilization?: boolean | string;
    }
    export interface BomCodesBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        bomType: BomCodeType;
        code: integer;
        description: string;
        shortDescription: string;
        accessCode: Access;
        site: Site;
        isProductionUtilization: boolean;
        isCostUtilization: boolean;
        isMrpUtilization: boolean;
        isMpsUtilization: boolean;
    }
    export interface BomCodes$Lookups {
        accessCode: QueryOperation<Access>;
        site: QueryOperation<Site>;
    }
    export interface BomCodes$Operations {
        query: QueryOperation<BomCodes>;
        read: ReadOperation<BomCodes>;
        aggregate: {
            read: AggregateReadOperation<BomCodes>;
            query: AggregateQueryOperation<BomCodes>;
        };
        lookups(dataOrId: string | { data: BomCodesInput }): BomCodes$Lookups;
        getDefaults: GetDefaultsOperation<BomCodes>;
    }
    export interface BomDetail extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        parentProduct: Product;
        bomCode: BomHeader;
        sequence: integer;
        componentProduct: Product;
        bomType: BomCodeType;
        sequenceRemainder: integer;
        componentType: ComponentType;
        linkDescription: string;
        firstValidLot: string;
        lastValidLot: string;
        validityStartDate: string;
        validityEndDate: string;
        linkQuantityCode: BomQuantityLink;
        quantityRounding: ComponentRounded;
        uom: UnitOfMeasure;
        uomStockFactor: string;
        uomLinkQuantity: string;
        linkQuantity: string;
        scrapFactorPercentage: string;
        routingOperation: integer;
        routingOperationSuffix: integer;
        operationLeadTime: integer;
        isPrintMaterialNote: boolean;
        isPrintAcknowledgment: boolean;
        isPrintPackingSlip: boolean;
        isPrintInvoice: boolean;
        linkReviewIndex: string;
        isValuation: boolean;
        pickListCode: CodeToServe;
        weighingPositiveTolerancePercentage: string;
        weighingNegativeTolerancePercentage: string;
        setupLevel: ToleranceDefinitionLevel;
        typeOfSupply: MaterialReplenishType;
        selectionFormula: string;
        quantityFormula: string;
        majorVersion: string;
        minorVersion: string;
        revisionGroup: integer;
        masterContainer: string;
    }
    export interface BomDetailInput extends ClientNodeInput {
        parentProduct?: string;
        bomCode?: integer | string;
        sequence?: integer | string;
        componentProduct?: string;
        bomType?: BomCodeType;
        sequenceRemainder?: integer | string;
        componentType?: ComponentType;
        linkDescription?: string;
        firstValidLot?: string;
        lastValidLot?: string;
        validityStartDate?: string;
        validityEndDate?: string;
        linkQuantityCode?: BomQuantityLink;
        quantityRounding?: ComponentRounded;
        uom?: string;
        uomStockFactor?: decimal | string;
        uomLinkQuantity?: decimal | string;
        linkQuantity?: decimal | string;
        scrapFactorPercentage?: decimal | string;
        routingOperation?: integer | string;
        routingOperationSuffix?: integer | string;
        operationLeadTime?: integer | string;
        isPrintMaterialNote?: boolean | string;
        isPrintAcknowledgment?: boolean | string;
        isPrintPackingSlip?: boolean | string;
        isPrintInvoice?: boolean | string;
        linkReviewIndex?: string;
        isValuation?: boolean | string;
        pickListCode?: CodeToServe;
        weighingPositiveTolerancePercentage?: decimal | string;
        weighingNegativeTolerancePercentage?: decimal | string;
        setupLevel?: ToleranceDefinitionLevel;
        typeOfSupply?: MaterialReplenishType;
        selectionFormula?: string;
        quantityFormula?: string;
        majorVersion?: string;
        minorVersion?: string;
        revisionGroup?: integer | string;
        masterContainer?: string;
    }
    export interface BomDetailBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        parentProduct: Product;
        bomCode: BomHeader;
        sequence: integer;
        componentProduct: Product;
        bomType: BomCodeType;
        sequenceRemainder: integer;
        componentType: ComponentType;
        linkDescription: string;
        firstValidLot: string;
        lastValidLot: string;
        validityStartDate: string;
        validityEndDate: string;
        linkQuantityCode: BomQuantityLink;
        quantityRounding: ComponentRounded;
        uom: UnitOfMeasure;
        uomStockFactor: string;
        uomLinkQuantity: string;
        linkQuantity: string;
        scrapFactorPercentage: string;
        routingOperation: integer;
        routingOperationSuffix: integer;
        operationLeadTime: integer;
        isPrintMaterialNote: boolean;
        isPrintAcknowledgment: boolean;
        isPrintPackingSlip: boolean;
        isPrintInvoice: boolean;
        linkReviewIndex: string;
        isValuation: boolean;
        pickListCode: CodeToServe;
        weighingPositiveTolerancePercentage: string;
        weighingNegativeTolerancePercentage: string;
        setupLevel: ToleranceDefinitionLevel;
        typeOfSupply: MaterialReplenishType;
        selectionFormula: string;
        quantityFormula: string;
        majorVersion: string;
        minorVersion: string;
        revisionGroup: integer;
        masterContainer: string;
    }
    export interface BomDetail$Lookups {
        parentProduct: QueryOperation<Product>;
        bomCode: QueryOperation<BomHeader>;
        componentProduct: QueryOperation<Product>;
        uom: QueryOperation<UnitOfMeasure>;
    }
    export interface BomDetail$Operations {
        query: QueryOperation<BomDetail>;
        read: ReadOperation<BomDetail>;
        aggregate: {
            read: AggregateReadOperation<BomDetail>;
            query: AggregateQueryOperation<BomDetail>;
        };
        lookups(dataOrId: string | { data: BomDetailInput }): BomDetail$Lookups;
        getDefaults: GetDefaultsOperation<BomDetail>;
    }
    export interface BomHeader extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        parentProduct: Product;
        bomCode: BomCodes;
        bomType: BomCodeType;
        description: string;
        useStatus: UseStatus;
        isPrototype: boolean;
        validityStartDate: string;
        validityEndDate: string;
        reviewLevel: string;
        baseQuantity: string;
        managementUnit: ManagementUnit;
        headerText: string;
        journalNumberConfig: string;
        accessCode: Access;
        linkedDocuments: string;
        details: ClientCollection<BomDetail>;
    }
    export interface BomHeaderInput extends ClientNodeInput {
        parentProduct?: string;
        bomCode?: integer | string;
        bomType?: BomCodeType;
        description?: string;
        useStatus?: UseStatus;
        isPrototype?: boolean | string;
        validityStartDate?: string;
        validityEndDate?: string;
        reviewLevel?: string;
        baseQuantity?: decimal | string;
        managementUnit?: ManagementUnit;
        headerText?: string;
        journalNumberConfig?: string;
        accessCode?: string;
        linkedDocuments?: string;
        details?: Partial<BomDetailInput>[];
    }
    export interface BomHeaderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        parentProduct: Product;
        bomCode: BomCodes;
        bomType: BomCodeType;
        description: string;
        useStatus: UseStatus;
        isPrototype: boolean;
        validityStartDate: string;
        validityEndDate: string;
        reviewLevel: string;
        baseQuantity: string;
        managementUnit: ManagementUnit;
        headerText: string;
        journalNumberConfig: string;
        accessCode: Access;
        linkedDocuments: string;
        details: ClientCollection<BomDetail>;
    }
    export interface BomHeader$Lookups {
        parentProduct: QueryOperation<Product>;
        bomCode: QueryOperation<BomCodes>;
        accessCode: QueryOperation<Access>;
    }
    export interface BomHeader$Operations {
        query: QueryOperation<BomHeader>;
        read: ReadOperation<BomHeader>;
        aggregate: {
            read: AggregateReadOperation<BomHeader>;
            query: AggregateQueryOperation<BomHeader>;
        };
        lookups(dataOrId: string | { data: BomHeaderInput }): BomHeader$Lookups;
        getDefaults: GetDefaultsOperation<BomHeader>;
    }
    export interface BomProduct extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        bomCode: integer;
        lowestLevelCodeType: LowLevelType;
        lowestLevelCode: integer;
        isBomExistence: boolean;
        isWhereUsedExistence: boolean;
    }
    export interface BomProductInput extends ClientNodeInput {
        product?: string;
        bomCode?: integer | string;
        lowestLevelCodeType?: LowLevelType;
        lowestLevelCode?: integer | string;
        isBomExistence?: boolean | string;
        isWhereUsedExistence?: boolean | string;
    }
    export interface BomProductBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        bomCode: integer;
        lowestLevelCodeType: LowLevelType;
        lowestLevelCode: integer;
        isBomExistence: boolean;
        isWhereUsedExistence: boolean;
    }
    export interface BomProduct$Lookups {
        product: QueryOperation<Product>;
    }
    export interface BomProduct$Operations {
        query: QueryOperation<BomProduct>;
        read: ReadOperation<BomProduct>;
        aggregate: {
            read: AggregateReadOperation<BomProduct>;
            query: AggregateQueryOperation<BomProduct>;
        };
        lookups(dataOrId: string | { data: BomProductInput }): BomProduct$Lookups;
        getDefaults: GetDefaultsOperation<BomProduct>;
    }
    export interface BomRouting extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        description: string;
        shortDescription: string;
        accessCode: Access;
        site: Site;
        isProductionUtilization: boolean;
        isCostUtilization: boolean;
        isRccpUtilization: boolean;
        bomCode1: BomCodes;
        bomCode2: BomCodes;
        bomCode3: BomCodes;
    }
    export interface BomRoutingInput extends ClientNodeInput {
        code?: integer | string;
        description?: string;
        shortDescription?: string;
        accessCode?: string;
        site?: string;
        isProductionUtilization?: boolean | string;
        isCostUtilization?: boolean | string;
        isRccpUtilization?: boolean | string;
        bomCode1?: integer | string;
        bomCode2?: integer | string;
        bomCode3?: integer | string;
    }
    export interface BomRoutingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        description: string;
        shortDescription: string;
        accessCode: Access;
        site: Site;
        isProductionUtilization: boolean;
        isCostUtilization: boolean;
        isRccpUtilization: boolean;
        bomCode1: BomCodes;
        bomCode2: BomCodes;
        bomCode3: BomCodes;
    }
    export interface BomRouting$Lookups {
        accessCode: QueryOperation<Access>;
        site: QueryOperation<Site>;
        bomCode1: QueryOperation<BomCodes>;
        bomCode2: QueryOperation<BomCodes>;
        bomCode3: QueryOperation<BomCodes>;
    }
    export interface BomRouting$Operations {
        query: QueryOperation<BomRouting>;
        read: ReadOperation<BomRouting>;
        aggregate: {
            read: AggregateReadOperation<BomRouting>;
            query: AggregateQueryOperation<BomRouting>;
        };
        lookups(dataOrId: string | { data: BomRoutingInput }): BomRouting$Lookups;
        getDefaults: GetDefaultsOperation<BomRouting>;
    }
    export interface BusinessPartnerAddressAddressEmails extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        businessPartner: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface BusinessPartnerAddressAddressEmailsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        businessPartner?: string;
        code?: string;
        addressEmail?: string;
    }
    export interface BusinessPartnerAddressAddressEmailsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        businessPartner: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface BusinessPartnerAddressAddressEmails$Operations {
        query: QueryOperation<BusinessPartnerAddressAddressEmails>;
        read: ReadOperation<BusinessPartnerAddressAddressEmails>;
        aggregate: {
            read: AggregateReadOperation<BusinessPartnerAddressAddressEmails>;
            query: AggregateQueryOperation<BusinessPartnerAddressAddressEmails>;
        };
        getDefaults: GetDefaultsOperation<BusinessPartnerAddressAddressEmails>;
    }
    export interface BusinessPartnerAddressAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        businessPartner: string;
        code: string;
        addressLine: string;
    }
    export interface BusinessPartnerAddressAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        businessPartner?: string;
        code?: string;
        addressLine?: string;
    }
    export interface BusinessPartnerAddressAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        businessPartner: string;
        code: string;
        addressLine: string;
    }
    export interface BusinessPartnerAddressAddressLines$Operations {
        query: QueryOperation<BusinessPartnerAddressAddressLines>;
        read: ReadOperation<BusinessPartnerAddressAddressLines>;
        aggregate: {
            read: AggregateReadOperation<BusinessPartnerAddressAddressLines>;
            query: AggregateQueryOperation<BusinessPartnerAddressAddressLines>;
        };
        getDefaults: GetDefaultsOperation<BusinessPartnerAddressAddressLines>;
    }
    export interface BusinessPartnerAddressAddressPhoneNumbers extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        businessPartner: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface BusinessPartnerAddressAddressPhoneNumbersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        businessPartner?: string;
        code?: string;
        addressPhoneNumber?: string;
    }
    export interface BusinessPartnerAddressAddressPhoneNumbersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        businessPartner: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface BusinessPartnerAddressAddressPhoneNumbers$Operations {
        query: QueryOperation<BusinessPartnerAddressAddressPhoneNumbers>;
        read: ReadOperation<BusinessPartnerAddressAddressPhoneNumbers>;
        aggregate: {
            read: AggregateReadOperation<BusinessPartnerAddressAddressPhoneNumbers>;
            query: AggregateQueryOperation<BusinessPartnerAddressAddressPhoneNumbers>;
        };
        getDefaults: GetDefaultsOperation<BusinessPartnerAddressAddressPhoneNumbers>;
    }
    export interface BusinessPartnerAddress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        businessPartner: BusinessPartner;
        code: string;
        description: string;
        defaultBankId: BusinessPartnerBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<BusinessPartnerAddressAddressEmails>;
        addressLines: ClientCollection<BusinessPartnerAddressAddressLines>;
        addressPhoneNumbers: ClientCollection<BusinessPartnerAddressAddressPhoneNumbers>;
    }
    export interface BusinessPartnerAddressInput extends ClientNodeInput {
        entityType?: EntityType;
        businessPartner?: string;
        code?: string;
        description?: string;
        defaultBankId?: string;
        isDefault?: boolean | string;
        zipCode?: string;
        city?: string;
        state?: string;
        country?: string;
        countryName?: string;
        website?: string;
        externalIdentifier?: string;
        isValid?: boolean | string;
        addressEmails?: Partial<BusinessPartnerAddressAddressEmailsInput>[];
        addressLines?: Partial<BusinessPartnerAddressAddressLinesInput>[];
        addressPhoneNumbers?: Partial<BusinessPartnerAddressAddressPhoneNumbersInput>[];
    }
    export interface BusinessPartnerAddressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        businessPartner: BusinessPartner;
        code: string;
        description: string;
        defaultBankId: BusinessPartnerBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<BusinessPartnerAddressAddressEmailsBinding>;
        addressLines: ClientCollection<BusinessPartnerAddressAddressLinesBinding>;
        addressPhoneNumbers: ClientCollection<BusinessPartnerAddressAddressPhoneNumbersBinding>;
    }
    export interface BusinessPartnerAddress$Lookups {
        businessPartner: QueryOperation<BusinessPartner>;
        defaultBankId: QueryOperation<BusinessPartnerBankDetail>;
        country: QueryOperation<Country>;
    }
    export interface BusinessPartnerAddress$Operations {
        query: QueryOperation<BusinessPartnerAddress>;
        read: ReadOperation<BusinessPartnerAddress>;
        aggregate: {
            read: AggregateReadOperation<BusinessPartnerAddress>;
            query: AggregateQueryOperation<BusinessPartnerAddress>;
        };
        lookups(dataOrId: string | { data: BusinessPartnerAddressInput }): BusinessPartnerAddress$Lookups;
        getDefaults: GetDefaultsOperation<BusinessPartnerAddress>;
    }
    export interface BusinessPartnerBankDetail extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        businessPartner: BusinessPartner;
        bankId: string;
        address: BusinessPartnerAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface BusinessPartnerBankDetailInput extends ClientNodeInput {
        entityType?: EntityType;
        businessPartner?: string;
        bankId?: string;
        address?: string;
        byDefault?: boolean | string;
        beneficiary?: string;
        payingBank1?: string;
        payingBank2?: string;
        payingBank3?: string;
        payingBank4?: string;
        ibanPrefix?: string;
        bic?: string;
        country?: string;
        currency?: string;
        intermediaryBankName?: string;
        intermediaryBankAddress1?: string;
        intermediaryBankAddress2?: string;
        intermediaryBankAddress3?: string;
        intermediaryBankBic?: string;
        intermediaryBankCountry?: string;
        nonResidentAccount?: boolean | string;
        isrCustomerNumber?: string;
    }
    export interface BusinessPartnerBankDetailBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        businessPartner: BusinessPartner;
        bankId: string;
        address: BusinessPartnerAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface BusinessPartnerBankDetail$Lookups {
        businessPartner: QueryOperation<BusinessPartner>;
        address: QueryOperation<BusinessPartnerAddress>;
        country: QueryOperation<Country>;
        currency: QueryOperation<Currency>;
        intermediaryBankCountry: QueryOperation<Country>;
    }
    export interface BusinessPartnerBankDetail$Operations {
        query: QueryOperation<BusinessPartnerBankDetail>;
        read: ReadOperation<BusinessPartnerBankDetail>;
        aggregate: {
            read: AggregateReadOperation<BusinessPartnerBankDetail>;
            query: AggregateQueryOperation<BusinessPartnerBankDetail>;
        };
        lookups(dataOrId: string | { data: BusinessPartnerBankDetailInput }): BusinessPartnerBankDetail$Lookups;
        getDefaults: GetDefaultsOperation<BusinessPartnerBankDetail>;
    }
    export interface BusinessPartnerCompanyException extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        businessPartner: BusinessPartner;
        company: Company;
        isAuthorizedEntry: boolean;
        contractualPeriod: integer;
        isCashExcluded: boolean;
        electronicInvoiceType: ElectronicInvoiceType;
        mappingCode: Mapping;
        registrationAgreement: string;
    }
    export interface BusinessPartnerCompanyExceptionInput extends ClientNodeInput {
        businessPartner?: string;
        company?: string;
        isAuthorizedEntry?: boolean | string;
        contractualPeriod?: integer | string;
        isCashExcluded?: boolean | string;
        electronicInvoiceType?: ElectronicInvoiceType;
        mappingCode?: string;
        registrationAgreement?: string;
    }
    export interface BusinessPartnerCompanyExceptionBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        businessPartner: BusinessPartner;
        company: Company;
        isAuthorizedEntry: boolean;
        contractualPeriod: integer;
        isCashExcluded: boolean;
        electronicInvoiceType: ElectronicInvoiceType;
        mappingCode: Mapping;
        registrationAgreement: string;
    }
    export interface BusinessPartnerCompanyException$Lookups {
        businessPartner: QueryOperation<BusinessPartner>;
        company: QueryOperation<Company>;
        mappingCode: QueryOperation<Mapping>;
    }
    export interface BusinessPartnerCompanyException$Operations {
        query: QueryOperation<BusinessPartnerCompanyException>;
        read: ReadOperation<BusinessPartnerCompanyException>;
        aggregate: {
            read: AggregateReadOperation<BusinessPartnerCompanyException>;
            query: AggregateQueryOperation<BusinessPartnerCompanyException>;
        };
        lookups(
            dataOrId: string | { data: BusinessPartnerCompanyExceptionInput },
        ): BusinessPartnerCompanyException$Lookups;
        getDefaults: GetDefaultsOperation<BusinessPartnerCompanyException>;
    }
    export interface BusinessPartnerCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        companyName: string;
    }
    export interface BusinessPartnerCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        companyName?: string;
    }
    export interface BusinessPartnerCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        companyName: string;
    }
    export interface BusinessPartnerCompanyNames$Operations {
        query: QueryOperation<BusinessPartnerCompanyNames>;
        read: ReadOperation<BusinessPartnerCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<BusinessPartnerCompanyNames>;
            query: AggregateQueryOperation<BusinessPartnerCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<BusinessPartnerCompanyNames>;
    }
    export interface BusinessPartnerContact extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        businessPartner: BusinessPartner;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface BusinessPartnerContactInput extends ClientNodeInput {
        entityType?: EntityType;
        businessPartner?: string;
        code?: string;
        position?: FunctionContact;
        department?: string;
        role?: string;
        defaultAddress?: string;
        landline?: string;
        fax?: string;
        email?: string;
        cellPhone?: string;
        isDataProtectionOfficer?: boolean | string;
        contactRelationship?: string;
        addressLines?: Partial<ContactRelationshipAddressLinesInput>[];
        relationshipCellPhone?: string;
        relationshipCity?: string;
        relationshipCountry?: string;
        relationshipCountryName?: string;
        relationshipDateOfBirth?: string;
        relationshipEmail?: string;
        relationshipFax?: string;
        relationshipFirstName?: string;
        relationshipFullNameSearchKey?: string;
        relationshipIsMailingProhibited?: boolean | string;
        relationshipLandline?: string;
        relationshipLanguage?: string;
        relationshipLastName?: string;
        relationshipProfessionalCategory?: string;
        relationshipState?: string;
        relationshipTitle?: Title;
        relationshipType?: ContactType;
        relationshipZipCode?: string;
    }
    export interface BusinessPartnerContactBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        businessPartner: BusinessPartner;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface BusinessPartnerContact$Lookups {
        businessPartner: QueryOperation<BusinessPartner>;
        code: QueryOperation<ContactRelationship>;
        role: QueryOperation<MiscellaneousTable>;
        contactRelationship: QueryOperation<ContactRelationship>;
        relationshipCountry: QueryOperation<Country>;
        relationshipLanguage: QueryOperation<Language>;
        relationshipProfessionalCategory: QueryOperation<MiscellaneousTable>;
    }
    export interface BusinessPartnerContact$Operations {
        query: QueryOperation<BusinessPartnerContact>;
        read: ReadOperation<BusinessPartnerContact>;
        aggregate: {
            read: AggregateReadOperation<BusinessPartnerContact>;
            query: AggregateQueryOperation<BusinessPartnerContact>;
        };
        lookups(dataOrId: string | { data: BusinessPartnerContactInput }): BusinessPartnerContact$Lookups;
        getDefaults: GetDefaultsOperation<BusinessPartnerContact>;
    }
    export interface BusinessPartner extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        isActive: boolean;
        category: CustomerCategory;
        customerOrSupplierOriginCategory: string;
        companyName1: string;
        companyName2: string;
        shortCompanyName: string;
        europeanUnionVatNumber: string;
        isIntersite: boolean;
        businessPartnerSite: Site;
        country: Country;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        currency: Currency;
        language: Language;
        acronym: string;
        italianTaxNumber: string;
        fiscalCode: string;
        consolidationGroup: SiteGroupings;
        consolidationCode: string;
        isCustomer: boolean;
        isSupplier: boolean;
        isGrantor: boolean;
        isCarrier: boolean;
        isFactor: boolean;
        isSalesRep: boolean;
        isMiscellaneousBusinessPartner: boolean;
        isProspect: boolean;
        isServiceSupplier: boolean;
        isServiceCaller: boolean;
        defaultAddress: BusinessPartnerAddress;
        defaultContact: BusinessPartnerContact;
        defaultBankId: BusinessPartnerBankDetail;
        bankIdCountry: Country;
        reportAccessCode: Access;
        isMailingProhibited: boolean;
        cfonbPaymentMethod: MiscellaneousTable;
        nonResidentAccount: BusinessPartnerAddress;
        isPhysicalPerson: boolean;
        isCashExcluded: boolean;
        documentType: DocumentType;
        isPublicSector: boolean;
        relatedCompany: RelatedCompanySettings;
        consolidationPartner: BusinessPartner;
        registrationNumber: string;
        vatNumber: string;
        economicOperatorRegistrationAndIdNumber: string;
        serviceCode: string;
        routingCode: string;
        electronicInvoiceType: ElectronicInvoiceType;
        mappingCode: Mapping;
        electronicAddress: string;
        addresses: ClientCollection<BusinessPartnerAddress>;
        contacts: ClientCollection<BusinessPartnerContact>;
        bankDetails: ClientCollection<BusinessPartnerBankDetail>;
        companyException: ClientCollection<BusinessPartnerCompanyException>;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
    }
    export interface BusinessPartnerInput extends ClientNodeInput {
        code?: string;
        isActive?: boolean | string;
        category?: string;
        customerOrSupplierOriginCategory?: string;
        companyName1?: string;
        companyName2?: string;
        shortCompanyName?: string;
        europeanUnionVatNumber?: string;
        isIntersite?: boolean | string;
        businessPartnerSite?: string;
        country?: string;
        siteIdentificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        currency?: string;
        language?: string;
        acronym?: string;
        italianTaxNumber?: string;
        fiscalCode?: string;
        consolidationGroup?: string;
        consolidationCode?: string;
        isCustomer?: boolean | string;
        isSupplier?: boolean | string;
        isGrantor?: boolean | string;
        isCarrier?: boolean | string;
        isFactor?: boolean | string;
        isSalesRep?: boolean | string;
        isMiscellaneousBusinessPartner?: boolean | string;
        isProspect?: boolean | string;
        isServiceSupplier?: boolean | string;
        isServiceCaller?: boolean | string;
        defaultAddress?: string;
        defaultContact?: string;
        defaultBankId?: string;
        bankIdCountry?: string;
        reportAccessCode?: string;
        isMailingProhibited?: boolean | string;
        cfonbPaymentMethod?: string;
        nonResidentAccount?: string;
        isPhysicalPerson?: boolean | string;
        isCashExcluded?: boolean | string;
        documentType?: DocumentType;
        isPublicSector?: boolean | string;
        relatedCompany?: RelatedCompanySettings;
        consolidationPartner?: string;
        registrationNumber?: string;
        vatNumber?: string;
        economicOperatorRegistrationAndIdNumber?: string;
        serviceCode?: string;
        routingCode?: string;
        electronicInvoiceType?: ElectronicInvoiceType;
        mappingCode?: string;
        electronicAddress?: string;
        addresses?: Partial<BusinessPartnerAddressInput>[];
        contacts?: Partial<BusinessPartnerContactInput>[];
        bankDetails?: Partial<BusinessPartnerBankDetailInput>[];
        companyException?: Partial<BusinessPartnerCompanyExceptionInput>[];
        companyNames?: Partial<BusinessPartnerCompanyNamesInput>[];
    }
    export interface BusinessPartnerBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        isActive: boolean;
        category: CustomerCategory;
        customerOrSupplierOriginCategory: string;
        companyName1: string;
        companyName2: string;
        shortCompanyName: string;
        europeanUnionVatNumber: string;
        isIntersite: boolean;
        businessPartnerSite: Site;
        country: Country;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        currency: Currency;
        language: Language;
        acronym: string;
        italianTaxNumber: string;
        fiscalCode: string;
        consolidationGroup: SiteGroupings;
        consolidationCode: string;
        isCustomer: boolean;
        isSupplier: boolean;
        isGrantor: boolean;
        isCarrier: boolean;
        isFactor: boolean;
        isSalesRep: boolean;
        isMiscellaneousBusinessPartner: boolean;
        isProspect: boolean;
        isServiceSupplier: boolean;
        isServiceCaller: boolean;
        defaultAddress: BusinessPartnerAddress;
        defaultContact: BusinessPartnerContact;
        defaultBankId: BusinessPartnerBankDetail;
        bankIdCountry: Country;
        reportAccessCode: Access;
        isMailingProhibited: boolean;
        cfonbPaymentMethod: MiscellaneousTable;
        nonResidentAccount: BusinessPartnerAddress;
        isPhysicalPerson: boolean;
        isCashExcluded: boolean;
        documentType: DocumentType;
        isPublicSector: boolean;
        relatedCompany: RelatedCompanySettings;
        consolidationPartner: BusinessPartner;
        registrationNumber: string;
        vatNumber: string;
        economicOperatorRegistrationAndIdNumber: string;
        serviceCode: string;
        routingCode: string;
        electronicInvoiceType: ElectronicInvoiceType;
        mappingCode: Mapping;
        electronicAddress: string;
        addresses: ClientCollection<BusinessPartnerAddress>;
        contacts: ClientCollection<BusinessPartnerContact>;
        bankDetails: ClientCollection<BusinessPartnerBankDetail>;
        companyException: ClientCollection<BusinessPartnerCompanyException>;
        companyNames: ClientCollection<BusinessPartnerCompanyNamesBinding>;
    }
    export interface BusinessPartner$Lookups {
        category: QueryOperation<CustomerCategory>;
        businessPartnerSite: QueryOperation<Site>;
        country: QueryOperation<Country>;
        currency: QueryOperation<Currency>;
        language: QueryOperation<Language>;
        consolidationGroup: QueryOperation<SiteGroupings>;
        defaultAddress: QueryOperation<BusinessPartnerAddress>;
        defaultContact: QueryOperation<BusinessPartnerContact>;
        defaultBankId: QueryOperation<BusinessPartnerBankDetail>;
        bankIdCountry: QueryOperation<Country>;
        reportAccessCode: QueryOperation<Access>;
        cfonbPaymentMethod: QueryOperation<MiscellaneousTable>;
        nonResidentAccount: QueryOperation<BusinessPartnerAddress>;
        consolidationPartner: QueryOperation<BusinessPartner>;
        mappingCode: QueryOperation<Mapping>;
    }
    export interface BusinessPartner$Operations {
        query: QueryOperation<BusinessPartner>;
        read: ReadOperation<BusinessPartner>;
        aggregate: {
            read: AggregateReadOperation<BusinessPartner>;
            query: AggregateQueryOperation<BusinessPartner>;
        };
        lookups(dataOrId: string | { data: BusinessPartnerInput }): BusinessPartner$Lookups;
        getDefaults: GetDefaultsOperation<BusinessPartner>;
    }
    export interface Carrier extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        companyName: string;
        shortCompanyName: string;
        priceListManagement: boolean;
        weightUnit: UnitOfMeasure;
        volumeUnit: UnitOfMeasure;
        coefficient: string;
        printTransportNote: boolean;
        noOfPriceColumns: integer;
        currency: Currency;
        defaultAddress: Address;
    }
    export interface CarrierInput extends ClientNodeInput {
        code?: string;
        companyName?: string;
        shortCompanyName?: string;
        priceListManagement?: boolean | string;
        weightUnit?: string;
        volumeUnit?: string;
        coefficient?: decimal | string;
        printTransportNote?: boolean | string;
        noOfPriceColumns?: integer | string;
        currency?: string;
        defaultAddress?: string;
    }
    export interface CarrierBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        companyName: string;
        shortCompanyName: string;
        priceListManagement: boolean;
        weightUnit: UnitOfMeasure;
        volumeUnit: UnitOfMeasure;
        coefficient: string;
        printTransportNote: boolean;
        noOfPriceColumns: integer;
        currency: Currency;
        defaultAddress: Address;
    }
    export interface Carrier$Lookups {
        code: QueryOperation<BusinessPartner>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
        defaultAddress: QueryOperation<Address>;
    }
    export interface Carrier$Operations {
        query: QueryOperation<Carrier>;
        read: ReadOperation<Carrier>;
        aggregate: {
            read: AggregateReadOperation<Carrier>;
            query: AggregateQueryOperation<Carrier>;
        };
        lookups(dataOrId: string | { data: CarrierInput }): Carrier$Lookups;
        getDefaults: GetDefaultsOperation<Carrier>;
    }
    export interface CommonImage extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        identifier1: string;
        identifier2: string;
        fileName: string;
        data: BinaryStream;
        specialFileType: TypeOfNonStandardFile;
    }
    export interface CommonImageInput extends ClientNodeInput {
        code?: string;
        identifier1?: string;
        identifier2?: string;
        fileName?: string;
        data?: BinaryStream;
        specialFileType?: TypeOfNonStandardFile;
    }
    export interface CommonImageBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        identifier1: string;
        identifier2: string;
        fileName: string;
        data: BinaryStream;
        specialFileType: TypeOfNonStandardFile;
    }
    export interface CommonImage$Operations {
        query: QueryOperation<CommonImage>;
        read: ReadOperation<CommonImage>;
        aggregate: {
            read: AggregateReadOperation<CommonImage>;
            query: AggregateQueryOperation<CommonImage>;
        };
        getDefaults: GetDefaultsOperation<CommonImage>;
    }
    export interface CommonText extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        text: TextStream;
        identifier1: string;
        identifier2: string;
        identifier3: string;
    }
    export interface CommonTextInput extends ClientNodeInput {
        code?: string;
        text?: TextStream;
        identifier1?: string;
        identifier2?: string;
        identifier3?: string;
    }
    export interface CommonTextBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        text: TextStream;
        identifier1: string;
        identifier2: string;
        identifier3: string;
    }
    export interface CommonText$Operations {
        query: QueryOperation<CommonText>;
        read: ReadOperation<CommonText>;
        aggregate: {
            read: AggregateReadOperation<CommonText>;
            query: AggregateQueryOperation<CommonText>;
        };
        getDefaults: GetDefaultsOperation<CommonText>;
    }
    export interface CompanyAddressAddressEmails extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        company: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface CompanyAddressAddressEmailsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        company?: string;
        code?: string;
        addressEmail?: string;
    }
    export interface CompanyAddressAddressEmailsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        company: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface CompanyAddressAddressEmails$Operations {
        query: QueryOperation<CompanyAddressAddressEmails>;
        read: ReadOperation<CompanyAddressAddressEmails>;
        aggregate: {
            read: AggregateReadOperation<CompanyAddressAddressEmails>;
            query: AggregateQueryOperation<CompanyAddressAddressEmails>;
        };
        getDefaults: GetDefaultsOperation<CompanyAddressAddressEmails>;
    }
    export interface CompanyAddressAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        company: string;
        code: string;
        addressLine: string;
    }
    export interface CompanyAddressAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        company?: string;
        code?: string;
        addressLine?: string;
    }
    export interface CompanyAddressAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        company: string;
        code: string;
        addressLine: string;
    }
    export interface CompanyAddressAddressLines$Operations {
        query: QueryOperation<CompanyAddressAddressLines>;
        read: ReadOperation<CompanyAddressAddressLines>;
        aggregate: {
            read: AggregateReadOperation<CompanyAddressAddressLines>;
            query: AggregateQueryOperation<CompanyAddressAddressLines>;
        };
        getDefaults: GetDefaultsOperation<CompanyAddressAddressLines>;
    }
    export interface CompanyAddressAddressPhoneNumbers extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        company: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface CompanyAddressAddressPhoneNumbersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        company?: string;
        code?: string;
        addressPhoneNumber?: string;
    }
    export interface CompanyAddressAddressPhoneNumbersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        company: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface CompanyAddressAddressPhoneNumbers$Operations {
        query: QueryOperation<CompanyAddressAddressPhoneNumbers>;
        read: ReadOperation<CompanyAddressAddressPhoneNumbers>;
        aggregate: {
            read: AggregateReadOperation<CompanyAddressAddressPhoneNumbers>;
            query: AggregateQueryOperation<CompanyAddressAddressPhoneNumbers>;
        };
        getDefaults: GetDefaultsOperation<CompanyAddressAddressPhoneNumbers>;
    }
    export interface CompanyAddress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        company: Company;
        code: string;
        description: string;
        defaultBankId: CompanyBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<CompanyAddressAddressEmails>;
        addressLines: ClientCollection<CompanyAddressAddressLines>;
        addressPhoneNumbers: ClientCollection<CompanyAddressAddressPhoneNumbers>;
    }
    export interface CompanyAddressInput extends ClientNodeInput {
        entityType?: EntityType;
        company?: string;
        code?: string;
        description?: string;
        defaultBankId?: string;
        isDefault?: boolean | string;
        zipCode?: string;
        city?: string;
        state?: string;
        country?: string;
        countryName?: string;
        website?: string;
        externalIdentifier?: string;
        isValid?: boolean | string;
        addressEmails?: Partial<CompanyAddressAddressEmailsInput>[];
        addressLines?: Partial<CompanyAddressAddressLinesInput>[];
        addressPhoneNumbers?: Partial<CompanyAddressAddressPhoneNumbersInput>[];
    }
    export interface CompanyAddressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        company: Company;
        code: string;
        description: string;
        defaultBankId: CompanyBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<CompanyAddressAddressEmailsBinding>;
        addressLines: ClientCollection<CompanyAddressAddressLinesBinding>;
        addressPhoneNumbers: ClientCollection<CompanyAddressAddressPhoneNumbersBinding>;
    }
    export interface CompanyAddress$Lookups {
        company: QueryOperation<Company>;
        defaultBankId: QueryOperation<CompanyBankDetail>;
        country: QueryOperation<Country>;
    }
    export interface CompanyAddress$Operations {
        query: QueryOperation<CompanyAddress>;
        read: ReadOperation<CompanyAddress>;
        aggregate: {
            read: AggregateReadOperation<CompanyAddress>;
            query: AggregateQueryOperation<CompanyAddress>;
        };
        lookups(dataOrId: string | { data: CompanyAddressInput }): CompanyAddress$Lookups;
        getDefaults: GetDefaultsOperation<CompanyAddress>;
    }
    export interface CompanyBankDetail extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        company: Company;
        bankId: string;
        address: CompanyAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface CompanyBankDetailInput extends ClientNodeInput {
        entityType?: EntityType;
        company?: string;
        bankId?: string;
        address?: string;
        byDefault?: boolean | string;
        beneficiary?: string;
        payingBank1?: string;
        payingBank2?: string;
        payingBank3?: string;
        payingBank4?: string;
        ibanPrefix?: string;
        bic?: string;
        country?: string;
        currency?: string;
        intermediaryBankName?: string;
        intermediaryBankAddress1?: string;
        intermediaryBankAddress2?: string;
        intermediaryBankAddress3?: string;
        intermediaryBankBic?: string;
        intermediaryBankCountry?: string;
        nonResidentAccount?: boolean | string;
        isrCustomerNumber?: string;
    }
    export interface CompanyBankDetailBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        company: Company;
        bankId: string;
        address: CompanyAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface CompanyBankDetail$Lookups {
        company: QueryOperation<Company>;
        address: QueryOperation<CompanyAddress>;
        country: QueryOperation<Country>;
        currency: QueryOperation<Currency>;
        intermediaryBankCountry: QueryOperation<Country>;
    }
    export interface CompanyBankDetail$Operations {
        query: QueryOperation<CompanyBankDetail>;
        read: ReadOperation<CompanyBankDetail>;
        aggregate: {
            read: AggregateReadOperation<CompanyBankDetail>;
            query: AggregateQueryOperation<CompanyBankDetail>;
        };
        lookups(dataOrId: string | { data: CompanyBankDetailInput }): CompanyBankDetail$Lookups;
        getDefaults: GetDefaultsOperation<CompanyBankDetail>;
    }
    export interface CompanyContact extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        company: Company;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface CompanyContactInput extends ClientNodeInput {
        entityType?: EntityType;
        company?: string;
        code?: string;
        position?: FunctionContact;
        department?: string;
        role?: string;
        defaultAddress?: string;
        landline?: string;
        fax?: string;
        email?: string;
        cellPhone?: string;
        isDataProtectionOfficer?: boolean | string;
        contactRelationship?: string;
        addressLines?: Partial<ContactRelationshipAddressLinesInput>[];
        relationshipCellPhone?: string;
        relationshipCity?: string;
        relationshipCountry?: string;
        relationshipCountryName?: string;
        relationshipDateOfBirth?: string;
        relationshipEmail?: string;
        relationshipFax?: string;
        relationshipFirstName?: string;
        relationshipFullNameSearchKey?: string;
        relationshipIsMailingProhibited?: boolean | string;
        relationshipLandline?: string;
        relationshipLanguage?: string;
        relationshipLastName?: string;
        relationshipProfessionalCategory?: string;
        relationshipState?: string;
        relationshipTitle?: Title;
        relationshipType?: ContactType;
        relationshipZipCode?: string;
    }
    export interface CompanyContactBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        company: Company;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface CompanyContact$Lookups {
        company: QueryOperation<Company>;
        code: QueryOperation<ContactRelationship>;
        role: QueryOperation<MiscellaneousTable>;
        contactRelationship: QueryOperation<ContactRelationship>;
        relationshipCountry: QueryOperation<Country>;
        relationshipLanguage: QueryOperation<Language>;
        relationshipProfessionalCategory: QueryOperation<MiscellaneousTable>;
    }
    export interface CompanyContact$Operations {
        query: QueryOperation<CompanyContact>;
        read: ReadOperation<CompanyContact>;
        aggregate: {
            read: AggregateReadOperation<CompanyContact>;
            query: AggregateQueryOperation<CompanyContact>;
        };
        lookups(dataOrId: string | { data: CompanyContactInput }): CompanyContact$Lookups;
        getDefaults: GetDefaultsOperation<CompanyContact>;
    }
    export interface ContactRelationshipAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        line: string;
    }
    export interface ContactRelationshipAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        line?: string;
    }
    export interface ContactRelationshipAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        line: string;
    }
    export interface ContactRelationshipAddressLines$Operations {
        query: QueryOperation<ContactRelationshipAddressLines>;
        read: ReadOperation<ContactRelationshipAddressLines>;
        aggregate: {
            read: AggregateReadOperation<ContactRelationshipAddressLines>;
            query: AggregateQueryOperation<ContactRelationshipAddressLines>;
        };
        getDefaults: GetDefaultsOperation<ContactRelationshipAddressLines>;
    }
    export interface ContactRelationship extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        fullNameSearchKey: string;
        title: Title;
        type: ContactType;
        lastName: string;
        firstName: string;
        dateOfBirth: string;
        language: Language;
        professionalCategory: MiscellaneousTable;
        country: Country;
        countryName: string;
        zipCode: string;
        city: string;
        state: string;
        landline: string;
        fax: string;
        cellPhone: string;
        email: string;
        isMailingProhibited: boolean;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
    }
    export interface ContactRelationshipInput extends ClientNodeInput {
        code?: string;
        fullNameSearchKey?: string;
        title?: Title;
        type?: ContactType;
        lastName?: string;
        firstName?: string;
        dateOfBirth?: string;
        language?: string;
        professionalCategory?: string;
        country?: string;
        countryName?: string;
        zipCode?: string;
        city?: string;
        state?: string;
        landline?: string;
        fax?: string;
        cellPhone?: string;
        email?: string;
        isMailingProhibited?: boolean | string;
        addressLines?: Partial<ContactRelationshipAddressLinesInput>[];
    }
    export interface ContactRelationshipBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        fullNameSearchKey: string;
        title: Title;
        type: ContactType;
        lastName: string;
        firstName: string;
        dateOfBirth: string;
        language: Language;
        professionalCategory: MiscellaneousTable;
        country: Country;
        countryName: string;
        zipCode: string;
        city: string;
        state: string;
        landline: string;
        fax: string;
        cellPhone: string;
        email: string;
        isMailingProhibited: boolean;
        addressLines: ClientCollection<ContactRelationshipAddressLinesBinding>;
    }
    export interface ContactRelationship$Lookups {
        language: QueryOperation<Language>;
        professionalCategory: QueryOperation<MiscellaneousTable>;
        country: QueryOperation<Country>;
    }
    export interface ContactRelationship$Operations {
        query: QueryOperation<ContactRelationship>;
        read: ReadOperation<ContactRelationship>;
        aggregate: {
            read: AggregateReadOperation<ContactRelationship>;
            query: AggregateQueryOperation<ContactRelationship>;
        };
        lookups(dataOrId: string | { data: ContactRelationshipInput }): ContactRelationship$Lookups;
        getDefaults: GetDefaultsOperation<ContactRelationship>;
    }
    export interface Contact extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        entityNumber: string;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface ContactInput extends ClientNodeInput {
        entityType?: EntityType;
        entityNumber?: string;
        code?: string;
        position?: FunctionContact;
        department?: string;
        role?: string;
        defaultAddress?: string;
        landline?: string;
        fax?: string;
        email?: string;
        cellPhone?: string;
        isDataProtectionOfficer?: boolean | string;
        contactRelationship?: string;
        addressLines?: Partial<ContactRelationshipAddressLinesInput>[];
        relationshipCellPhone?: string;
        relationshipCity?: string;
        relationshipCountry?: string;
        relationshipCountryName?: string;
        relationshipDateOfBirth?: string;
        relationshipEmail?: string;
        relationshipFax?: string;
        relationshipFirstName?: string;
        relationshipFullNameSearchKey?: string;
        relationshipIsMailingProhibited?: boolean | string;
        relationshipLandline?: string;
        relationshipLanguage?: string;
        relationshipLastName?: string;
        relationshipProfessionalCategory?: string;
        relationshipState?: string;
        relationshipTitle?: Title;
        relationshipType?: ContactType;
        relationshipZipCode?: string;
    }
    export interface ContactBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        entityNumber: string;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface Contact$Lookups {
        code: QueryOperation<ContactRelationship>;
        role: QueryOperation<MiscellaneousTable>;
        contactRelationship: QueryOperation<ContactRelationship>;
        relationshipCountry: QueryOperation<Country>;
        relationshipLanguage: QueryOperation<Language>;
        relationshipProfessionalCategory: QueryOperation<MiscellaneousTable>;
    }
    export interface Contact$Operations {
        query: QueryOperation<Contact>;
        read: ReadOperation<Contact>;
        aggregate: {
            read: AggregateReadOperation<Contact>;
            query: AggregateQueryOperation<Contact>;
        };
        lookups(dataOrId: string | { data: ContactInput }): Contact$Lookups;
        getDefaults: GetDefaultsOperation<Contact>;
    }
    export interface Container extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        containerType: InternalContainerType;
        isActive: boolean;
        description: string;
        shortDescription: string;
        sizeUnit: UnitOfMeasure;
        weightUnit: UnitOfMeasure;
        tareWeight: string;
        maxWeight: string;
        length: string;
        width: string;
        height: string;
        volumeUnit: UnitOfMeasure;
        volume: string;
        usableVolume: string;
        twentyFootEquivalentUnit: integer;
        isRefrigerated: boolean;
        isInternal: boolean;
        isFreight: boolean;
        isSingleProduct: boolean;
        isSingleLot: boolean;
        labelFormat: GenericPrintReport;
    }
    export interface ContainerInput extends ClientNodeInput {
        code?: string;
        containerType?: InternalContainerType;
        isActive?: boolean | string;
        description?: string;
        shortDescription?: string;
        sizeUnit?: string;
        weightUnit?: string;
        tareWeight?: decimal | string;
        maxWeight?: decimal | string;
        length?: decimal | string;
        width?: decimal | string;
        height?: decimal | string;
        volumeUnit?: string;
        volume?: decimal | string;
        usableVolume?: decimal | string;
        twentyFootEquivalentUnit?: integer | string;
        isRefrigerated?: boolean | string;
        isInternal?: boolean | string;
        isFreight?: boolean | string;
        isSingleProduct?: boolean | string;
        isSingleLot?: boolean | string;
        labelFormat?: string;
    }
    export interface ContainerBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        containerType: InternalContainerType;
        isActive: boolean;
        description: string;
        shortDescription: string;
        sizeUnit: UnitOfMeasure;
        weightUnit: UnitOfMeasure;
        tareWeight: string;
        maxWeight: string;
        length: string;
        width: string;
        height: string;
        volumeUnit: UnitOfMeasure;
        volume: string;
        usableVolume: string;
        twentyFootEquivalentUnit: integer;
        isRefrigerated: boolean;
        isInternal: boolean;
        isFreight: boolean;
        isSingleProduct: boolean;
        isSingleLot: boolean;
        labelFormat: GenericPrintReport;
    }
    export interface Container$Lookups {
        sizeUnit: QueryOperation<UnitOfMeasure>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        labelFormat: QueryOperation<GenericPrintReport>;
    }
    export interface Container$Operations {
        query: QueryOperation<Container>;
        read: ReadOperation<Container>;
        aggregate: {
            read: AggregateReadOperation<Container>;
            query: AggregateQueryOperation<Container>;
        };
        lookups(dataOrId: string | { data: ContainerInput }): Container$Lookups;
        getDefaults: GetDefaultsOperation<Container>;
    }
    export interface CurrencyRate extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        rateType: ExchangeRateType;
        sourceCurrency: Currency;
        destinationCurrency: Currency;
        rateDate: string;
        inverseRate: string;
        rate: string;
        divisor: string;
    }
    export interface CurrencyRateInput extends ClientNodeInput {
        rateType?: ExchangeRateType;
        sourceCurrency?: string;
        destinationCurrency?: string;
        rateDate?: string;
        inverseRate?: decimal | string;
        rate?: decimal | string;
        divisor?: decimal | string;
    }
    export interface CurrencyRateBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        rateType: ExchangeRateType;
        sourceCurrency: Currency;
        destinationCurrency: Currency;
        rateDate: string;
        inverseRate: string;
        rate: string;
        divisor: string;
    }
    export interface CurrencyRate$Lookups {
        sourceCurrency: QueryOperation<Currency>;
        destinationCurrency: QueryOperation<Currency>;
    }
    export interface CurrencyRate$Operations {
        query: QueryOperation<CurrencyRate>;
        read: ReadOperation<CurrencyRate>;
        aggregate: {
            read: AggregateReadOperation<CurrencyRate>;
            query: AggregateQueryOperation<CurrencyRate>;
        };
        lookups(dataOrId: string | { data: CurrencyRateInput }): CurrencyRate$Lookups;
        getDefaults: GetDefaultsOperation<CurrencyRate>;
    }
    export interface Currency extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isEuro: boolean;
        euroDate: string;
        currencyRates: ClientCollection<CurrencyRate>;
    }
    export interface CurrencyInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        isEuro?: boolean | string;
        euroDate?: string;
        currencyRates?: Partial<CurrencyRateInput>[];
    }
    export interface CurrencyBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        isEuro: boolean;
        euroDate: string;
        currencyRates: ClientCollection<CurrencyRate>;
    }
    export interface Currency$Operations {
        query: QueryOperation<Currency>;
        read: ReadOperation<Currency>;
        aggregate: {
            read: AggregateReadOperation<Currency>;
            query: AggregateQueryOperation<Currency>;
        };
        getDefaults: GetDefaultsOperation<Currency>;
    }
    export interface CustomerAddressAddressEmails extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        customer: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface CustomerAddressAddressEmailsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        customer?: string;
        code?: string;
        addressEmail?: string;
    }
    export interface CustomerAddressAddressEmailsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        customer: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface CustomerAddressAddressEmails$Operations {
        query: QueryOperation<CustomerAddressAddressEmails>;
        read: ReadOperation<CustomerAddressAddressEmails>;
        aggregate: {
            read: AggregateReadOperation<CustomerAddressAddressEmails>;
            query: AggregateQueryOperation<CustomerAddressAddressEmails>;
        };
        getDefaults: GetDefaultsOperation<CustomerAddressAddressEmails>;
    }
    export interface CustomerAddressAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        customer: string;
        code: string;
        addressLine: string;
    }
    export interface CustomerAddressAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        customer?: string;
        code?: string;
        addressLine?: string;
    }
    export interface CustomerAddressAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        customer: string;
        code: string;
        addressLine: string;
    }
    export interface CustomerAddressAddressLines$Operations {
        query: QueryOperation<CustomerAddressAddressLines>;
        read: ReadOperation<CustomerAddressAddressLines>;
        aggregate: {
            read: AggregateReadOperation<CustomerAddressAddressLines>;
            query: AggregateQueryOperation<CustomerAddressAddressLines>;
        };
        getDefaults: GetDefaultsOperation<CustomerAddressAddressLines>;
    }
    export interface CustomerAddressAddressPhoneNumbers extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        customer: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface CustomerAddressAddressPhoneNumbersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        customer?: string;
        code?: string;
        addressPhoneNumber?: string;
    }
    export interface CustomerAddressAddressPhoneNumbersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        customer: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface CustomerAddressAddressPhoneNumbers$Operations {
        query: QueryOperation<CustomerAddressAddressPhoneNumbers>;
        read: ReadOperation<CustomerAddressAddressPhoneNumbers>;
        aggregate: {
            read: AggregateReadOperation<CustomerAddressAddressPhoneNumbers>;
            query: AggregateQueryOperation<CustomerAddressAddressPhoneNumbers>;
        };
        getDefaults: GetDefaultsOperation<CustomerAddressAddressPhoneNumbers>;
    }
    export interface CustomerAddress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        customer: Customer;
        code: string;
        description: string;
        defaultBankId: CustomerBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<CustomerAddressAddressEmails>;
        addressLines: ClientCollection<CustomerAddressAddressLines>;
        addressPhoneNumbers: ClientCollection<CustomerAddressAddressPhoneNumbers>;
    }
    export interface CustomerAddressInput extends ClientNodeInput {
        entityType?: EntityType;
        customer?: string;
        code?: string;
        description?: string;
        defaultBankId?: string;
        isDefault?: boolean | string;
        zipCode?: string;
        city?: string;
        state?: string;
        country?: string;
        countryName?: string;
        website?: string;
        externalIdentifier?: string;
        isValid?: boolean | string;
        addressEmails?: Partial<CustomerAddressAddressEmailsInput>[];
        addressLines?: Partial<CustomerAddressAddressLinesInput>[];
        addressPhoneNumbers?: Partial<CustomerAddressAddressPhoneNumbersInput>[];
    }
    export interface CustomerAddressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        customer: Customer;
        code: string;
        description: string;
        defaultBankId: CustomerBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<CustomerAddressAddressEmailsBinding>;
        addressLines: ClientCollection<CustomerAddressAddressLinesBinding>;
        addressPhoneNumbers: ClientCollection<CustomerAddressAddressPhoneNumbersBinding>;
    }
    export interface CustomerAddress$Lookups {
        customer: QueryOperation<Customer>;
        defaultBankId: QueryOperation<CustomerBankDetail>;
        country: QueryOperation<Country>;
    }
    export interface CustomerAddress$Operations {
        query: QueryOperation<CustomerAddress>;
        read: ReadOperation<CustomerAddress>;
        aggregate: {
            read: AggregateReadOperation<CustomerAddress>;
            query: AggregateQueryOperation<CustomerAddress>;
        };
        lookups(dataOrId: string | { data: CustomerAddressInput }): CustomerAddress$Lookups;
        getDefaults: GetDefaultsOperation<CustomerAddress>;
    }
    export interface CustomerBankDetail extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        customer: Customer;
        bankId: string;
        address: CustomerAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface CustomerBankDetailInput extends ClientNodeInput {
        entityType?: EntityType;
        customer?: string;
        bankId?: string;
        address?: string;
        byDefault?: boolean | string;
        beneficiary?: string;
        payingBank1?: string;
        payingBank2?: string;
        payingBank3?: string;
        payingBank4?: string;
        ibanPrefix?: string;
        bic?: string;
        country?: string;
        currency?: string;
        intermediaryBankName?: string;
        intermediaryBankAddress1?: string;
        intermediaryBankAddress2?: string;
        intermediaryBankAddress3?: string;
        intermediaryBankBic?: string;
        intermediaryBankCountry?: string;
        nonResidentAccount?: boolean | string;
        isrCustomerNumber?: string;
    }
    export interface CustomerBankDetailBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        customer: Customer;
        bankId: string;
        address: CustomerAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface CustomerBankDetail$Lookups {
        customer: QueryOperation<Customer>;
        address: QueryOperation<CustomerAddress>;
        country: QueryOperation<Country>;
        currency: QueryOperation<Currency>;
        intermediaryBankCountry: QueryOperation<Country>;
    }
    export interface CustomerBankDetail$Operations {
        query: QueryOperation<CustomerBankDetail>;
        read: ReadOperation<CustomerBankDetail>;
        aggregate: {
            read: AggregateReadOperation<CustomerBankDetail>;
            query: AggregateQueryOperation<CustomerBankDetail>;
        };
        lookups(dataOrId: string | { data: CustomerBankDetailInput }): CustomerBankDetail$Lookups;
        getDefaults: GetDefaultsOperation<CustomerBankDetail>;
    }
    export interface CustomerCashTaxRules extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        isActive: boolean;
        startDate: string;
        endDate: string;
    }
    export interface CustomerCashTaxRulesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        isActive?: boolean | string;
        startDate?: string;
        endDate?: string;
    }
    export interface CustomerCashTaxRulesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        isActive: boolean;
        startDate: string;
        endDate: string;
    }
    export interface CustomerCashTaxRules$Operations {
        query: QueryOperation<CustomerCashTaxRules>;
        read: ReadOperation<CustomerCashTaxRules>;
        aggregate: {
            read: AggregateReadOperation<CustomerCashTaxRules>;
            query: AggregateQueryOperation<CustomerCashTaxRules>;
        };
        getDefaults: GetDefaultsOperation<CustomerCashTaxRules>;
    }
    export interface CustomerCategory extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        shortDescription: string;
        currency: Currency;
    }
    export interface CustomerCategoryInput extends ClientNodeInput {
        code?: string;
        description?: string;
        shortDescription?: string;
        currency?: string;
    }
    export interface CustomerCategoryBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        shortDescription: string;
        currency: Currency;
    }
    export interface CustomerCategory$Lookups {
        currency: QueryOperation<Currency>;
    }
    export interface CustomerCategory$Operations {
        query: QueryOperation<CustomerCategory>;
        read: ReadOperation<CustomerCategory>;
        aggregate: {
            read: AggregateReadOperation<CustomerCategory>;
            query: AggregateQueryOperation<CustomerCategory>;
        };
        lookups(dataOrId: string | { data: CustomerCategoryInput }): CustomerCategory$Lookups;
        getDefaults: GetDefaultsOperation<CustomerCategory>;
    }
    export interface CustomerContact extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        customer: Customer;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface CustomerContactInput extends ClientNodeInput {
        entityType?: EntityType;
        customer?: string;
        code?: string;
        position?: FunctionContact;
        department?: string;
        role?: string;
        defaultAddress?: string;
        landline?: string;
        fax?: string;
        email?: string;
        cellPhone?: string;
        isDataProtectionOfficer?: boolean | string;
        contactRelationship?: string;
        addressLines?: Partial<ContactRelationshipAddressLinesInput>[];
        relationshipCellPhone?: string;
        relationshipCity?: string;
        relationshipCountry?: string;
        relationshipCountryName?: string;
        relationshipDateOfBirth?: string;
        relationshipEmail?: string;
        relationshipFax?: string;
        relationshipFirstName?: string;
        relationshipFullNameSearchKey?: string;
        relationshipIsMailingProhibited?: boolean | string;
        relationshipLandline?: string;
        relationshipLanguage?: string;
        relationshipLastName?: string;
        relationshipProfessionalCategory?: string;
        relationshipState?: string;
        relationshipTitle?: Title;
        relationshipType?: ContactType;
        relationshipZipCode?: string;
    }
    export interface CustomerContactBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        customer: Customer;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface CustomerContact$Lookups {
        customer: QueryOperation<Customer>;
        code: QueryOperation<ContactRelationship>;
        role: QueryOperation<MiscellaneousTable>;
        contactRelationship: QueryOperation<ContactRelationship>;
        relationshipCountry: QueryOperation<Country>;
        relationshipLanguage: QueryOperation<Language>;
        relationshipProfessionalCategory: QueryOperation<MiscellaneousTable>;
    }
    export interface CustomerContact$Operations {
        query: QueryOperation<CustomerContact>;
        read: ReadOperation<CustomerContact>;
        aggregate: {
            read: AggregateReadOperation<CustomerContact>;
            query: AggregateQueryOperation<CustomerContact>;
        };
        lookups(dataOrId: string | { data: CustomerContactInput }): CustomerContact$Lookups;
        getDefaults: GetDefaultsOperation<CustomerContact>;
    }
    export interface CustomerPaymentDays extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        paymentDay: integer;
    }
    export interface CustomerPaymentDaysInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        paymentDay?: integer | string;
    }
    export interface CustomerPaymentDaysBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        paymentDay: integer;
    }
    export interface CustomerPaymentDays$Operations {
        query: QueryOperation<CustomerPaymentDays>;
        read: ReadOperation<CustomerPaymentDays>;
        aggregate: {
            read: AggregateReadOperation<CustomerPaymentDays>;
            query: AggregateQueryOperation<CustomerPaymentDays>;
        };
        getDefaults: GetDefaultsOperation<CustomerPaymentDays>;
    }
    export interface CustomerProduct extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        customer: BusinessPartner;
        isActive: boolean;
        customerProduct: string;
        customerProductDescription: string;
        salesUnit: UnitOfMeasure;
        salesUnitToStockUnitConversion: string;
        packingUnit1: UnitOfMeasure;
        packingUnit1ToSalesUnitConversion: string;
        packingUnit2: UnitOfMeasure;
        packingUnit2ToSalesUnitConversion: string;
        customerUseByDateCoefficient: string;
        journalNumberConfigurator: string;
        isVersionPreloaded: boolean;
        pickingText: TextStream;
        salesText: TextStream;
    }
    export interface CustomerProductInput extends ClientNodeInput {
        product?: string;
        customer?: string;
        isActive?: boolean | string;
        customerProduct?: string;
        customerProductDescription?: string;
        salesUnit?: string;
        salesUnitToStockUnitConversion?: decimal | string;
        packingUnit1?: string;
        packingUnit1ToSalesUnitConversion?: decimal | string;
        packingUnit2?: string;
        packingUnit2ToSalesUnitConversion?: decimal | string;
        customerUseByDateCoefficient?: decimal | string;
        journalNumberConfigurator?: string;
        isVersionPreloaded?: boolean | string;
        pickingText?: TextStream;
        salesText?: TextStream;
    }
    export interface CustomerProductBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        customer: BusinessPartner;
        isActive: boolean;
        customerProduct: string;
        customerProductDescription: string;
        salesUnit: UnitOfMeasure;
        salesUnitToStockUnitConversion: string;
        packingUnit1: UnitOfMeasure;
        packingUnit1ToSalesUnitConversion: string;
        packingUnit2: UnitOfMeasure;
        packingUnit2ToSalesUnitConversion: string;
        customerUseByDateCoefficient: string;
        journalNumberConfigurator: string;
        isVersionPreloaded: boolean;
        pickingText: TextStream;
        salesText: TextStream;
    }
    export interface CustomerProduct$Lookups {
        product: QueryOperation<Product>;
        customer: QueryOperation<BusinessPartner>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        packingUnit1: QueryOperation<UnitOfMeasure>;
        packingUnit2: QueryOperation<UnitOfMeasure>;
    }
    export interface CustomerProduct$Operations {
        query: QueryOperation<CustomerProduct>;
        read: ReadOperation<CustomerProduct>;
        aggregate: {
            read: AggregateReadOperation<CustomerProduct>;
            query: AggregateQueryOperation<CustomerProduct>;
        };
        lookups(dataOrId: string | { data: CustomerProductInput }): CustomerProduct$Lookups;
        getDefaults: GetDefaultsOperation<CustomerProduct>;
    }
    export interface CustomerSalesReps extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        salesRep: SalesRep;
    }
    export interface CustomerSalesRepsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        salesRep?: string;
    }
    export interface CustomerSalesRepsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        salesRep: SalesRep;
    }
    export interface CustomerSalesReps$Lookups {
        salesRep: QueryOperation<SalesRep>;
    }
    export interface CustomerSalesReps$Operations {
        query: QueryOperation<CustomerSalesReps>;
        read: ReadOperation<CustomerSalesReps>;
        aggregate: {
            read: AggregateReadOperation<CustomerSalesReps>;
            query: AggregateQueryOperation<CustomerSalesReps>;
        };
        lookups(dataOrId: string | { data: CustomerSalesRepsInput }): CustomerSalesReps$Lookups;
        getDefaults: GetDefaultsOperation<CustomerSalesReps>;
    }
    export interface CustomerStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        value: MiscellaneousTable;
    }
    export interface CustomerStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        value?: string;
    }
    export interface CustomerStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        value: MiscellaneousTable;
    }
    export interface CustomerStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface CustomerStatisticalGroups$Operations {
        query: QueryOperation<CustomerStatisticalGroups>;
        read: ReadOperation<CustomerStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<CustomerStatisticalGroups>;
            query: AggregateQueryOperation<CustomerStatisticalGroups>;
        };
        lookups(dataOrId: string | { data: CustomerStatisticalGroupsInput }): CustomerStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<CustomerStatisticalGroups>;
    }
    export interface Customer extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        customerCategory: CustomerCategory;
        billToCustomer: Customer;
        billToCustomerAddress: CustomerAddress;
        payByCustomer: BusinessPartner;
        payByCustomerAddress: BusinessPartnerAddress;
        groupCustomer: Customer;
        riskCustomer: Customer;
        defaultAddress: CustomerAddress;
        defaultShipToAddress: ShipToCustomerAddress;
        defaultContact: CustomerContact;
        isActive: boolean;
        ourSupplierCode: string;
        currency: Currency;
        rateType: ExchangeRateType;
        commissionCategory: CommissionCategory;
        exemptionTaxNumber: string;
        priceOrAmountType: PriceAmountTaxTax;
        creditControl: WorkInProgressControl;
        authorizedCreditAmount: string;
        minimumOrderAmount: string;
        creditInsuranceAmount: string;
        insuranceDate: string;
        insuranceCompany: BusinessPartner;
        reminderType: ReminderType;
        minimumReminderAmount: string;
        canBeMatched: boolean;
        isLoanAllowed: boolean;
        mustPrintAcknowledgment: boolean;
        isOrderClosingAllowed: boolean;
        mustContainOneOrderPerDelivery: boolean;
        businessSector: MiscellaneousTable;
        prospectOrigin: MiscellaneousTable;
        tokenCredit: integer;
        manualAdditionalToken: integer;
        totalTokenCredit: integer;
        necessaryTokensForServiceContract: integer;
        firstContactDate: string;
        firstOrderDate: string;
        lastQuoteDate: string;
        lastContactDate: string;
        nextContactDate: string;
        customerAbcClass: ProductAbcClass;
        printTemplate: PrintTemplate;
        initialDateSinceCustomer: string;
        unavailablePaymentPeriod: UnavailablePeriods;
        isSubjectToTax: boolean;
        isEfatElectronicInvoicingAllowed: boolean;
        contact: CustomerContact;
        startDateforElectronicInvoice: string;
        isElectronicInvoiceAllowed: boolean;
        addresses: ClientCollection<CustomerAddress>;
        contacts: ClientCollection<CustomerContact>;
        bankDetails: ClientCollection<CustomerBankDetail>;
        businessPartner: BusinessPartner;
        shipToCustomers: ClientCollection<ShipToCustomerAddress>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        electronicAddress: string;
        electronicInvoiceType: ElectronicInvoiceType;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        invoiceHeaderText: TextStream;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        orderHeaderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        routingCode: string;
        serviceCode: string;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        cashTaxRules: ClientCollection<CustomerCashTaxRules>;
        paymentDays: ClientCollection<CustomerPaymentDays>;
        salesReps: ClientCollection<CustomerSalesReps>;
        statisticalGroups: ClientCollection<CustomerStatisticalGroups>;
    }
    export interface CustomerInput extends ClientNodeInput {
        code?: string;
        customerCategory?: string;
        billToCustomer?: string;
        billToCustomerAddress?: string;
        payByCustomer?: string;
        payByCustomerAddress?: string;
        groupCustomer?: string;
        riskCustomer?: string;
        defaultAddress?: string;
        defaultShipToAddress?: string;
        defaultContact?: string;
        isActive?: boolean | string;
        ourSupplierCode?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        commissionCategory?: CommissionCategory;
        exemptionTaxNumber?: string;
        priceOrAmountType?: PriceAmountTaxTax;
        creditControl?: WorkInProgressControl;
        authorizedCreditAmount?: decimal | string;
        minimumOrderAmount?: decimal | string;
        creditInsuranceAmount?: decimal | string;
        insuranceDate?: string;
        insuranceCompany?: string;
        reminderType?: ReminderType;
        minimumReminderAmount?: decimal | string;
        canBeMatched?: boolean | string;
        isLoanAllowed?: boolean | string;
        mustPrintAcknowledgment?: boolean | string;
        isOrderClosingAllowed?: boolean | string;
        mustContainOneOrderPerDelivery?: boolean | string;
        businessSector?: string;
        prospectOrigin?: string;
        tokenCredit?: integer | string;
        manualAdditionalToken?: integer | string;
        totalTokenCredit?: integer | string;
        necessaryTokensForServiceContract?: integer | string;
        firstContactDate?: string;
        firstOrderDate?: string;
        lastQuoteDate?: string;
        lastContactDate?: string;
        nextContactDate?: string;
        customerAbcClass?: ProductAbcClass;
        printTemplate?: string;
        initialDateSinceCustomer?: string;
        unavailablePaymentPeriod?: string;
        isSubjectToTax?: boolean | string;
        isEfatElectronicInvoicingAllowed?: boolean | string;
        contact?: string;
        startDateforElectronicInvoice?: string;
        isElectronicInvoiceAllowed?: boolean | string;
        addresses?: Partial<CustomerAddressInput>[];
        contacts?: Partial<CustomerContactInput>[];
        bankDetails?: Partial<CustomerBankDetailInput>[];
        businessPartner?: string;
        shipToCustomers?: Partial<ShipToCustomerAddressInput>[];
        acronym?: string;
        businessPartnerSite?: string;
        cfonbPaymentMethod?: string;
        companyName1?: string;
        companyName2?: string;
        companyNames?: Partial<BusinessPartnerCompanyNamesInput>[];
        consolidationCode?: string;
        consolidationGroup?: string;
        consolidationPartner?: string;
        country?: string;
        customerOrSupplierOriginCategory?: string;
        documentType?: DocumentType;
        economicOperatorRegistrationAndIdNumber?: string;
        electronicAddress?: string;
        electronicInvoiceType?: ElectronicInvoiceType;
        europeanUnionVatNumber?: string;
        fiscalCode?: string;
        invoiceHeaderText?: TextStream;
        isCashExcluded?: boolean | string;
        isIntersite?: boolean | string;
        isMailingProhibited?: boolean | string;
        isPhysicalPerson?: boolean | string;
        isPublicSector?: boolean | string;
        isServiceCaller?: boolean | string;
        isServiceSupplier?: boolean | string;
        italianTaxNumber?: string;
        language?: string;
        nonResidentAccount?: string;
        orderHeaderText?: TextStream;
        registrationNumber?: string;
        relatedCompany?: RelatedCompanySettings;
        reportAccessCode?: string;
        routingCode?: string;
        serviceCode?: string;
        shortCompanyName?: string;
        siteIdentificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        vatNumber?: string;
        cashTaxRules?: Partial<CustomerCashTaxRulesInput>[];
        paymentDays?: Partial<CustomerPaymentDaysInput>[];
        salesReps?: Partial<CustomerSalesRepsInput>[];
        statisticalGroups?: Partial<CustomerStatisticalGroupsInput>[];
    }
    export interface CustomerBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        customerCategory: CustomerCategory;
        billToCustomer: Customer;
        billToCustomerAddress: CustomerAddress;
        payByCustomer: BusinessPartner;
        payByCustomerAddress: BusinessPartnerAddress;
        groupCustomer: Customer;
        riskCustomer: Customer;
        defaultAddress: CustomerAddress;
        defaultShipToAddress: ShipToCustomerAddress;
        defaultContact: CustomerContact;
        isActive: boolean;
        ourSupplierCode: string;
        currency: Currency;
        rateType: ExchangeRateType;
        commissionCategory: CommissionCategory;
        exemptionTaxNumber: string;
        priceOrAmountType: PriceAmountTaxTax;
        creditControl: WorkInProgressControl;
        authorizedCreditAmount: string;
        minimumOrderAmount: string;
        creditInsuranceAmount: string;
        insuranceDate: string;
        insuranceCompany: BusinessPartner;
        reminderType: ReminderType;
        minimumReminderAmount: string;
        canBeMatched: boolean;
        isLoanAllowed: boolean;
        mustPrintAcknowledgment: boolean;
        isOrderClosingAllowed: boolean;
        mustContainOneOrderPerDelivery: boolean;
        businessSector: MiscellaneousTable;
        prospectOrigin: MiscellaneousTable;
        tokenCredit: integer;
        manualAdditionalToken: integer;
        totalTokenCredit: integer;
        necessaryTokensForServiceContract: integer;
        firstContactDate: string;
        firstOrderDate: string;
        lastQuoteDate: string;
        lastContactDate: string;
        nextContactDate: string;
        customerAbcClass: ProductAbcClass;
        printTemplate: PrintTemplate;
        initialDateSinceCustomer: string;
        unavailablePaymentPeriod: UnavailablePeriods;
        isSubjectToTax: boolean;
        isEfatElectronicInvoicingAllowed: boolean;
        contact: CustomerContact;
        startDateforElectronicInvoice: string;
        isElectronicInvoiceAllowed: boolean;
        addresses: ClientCollection<CustomerAddress>;
        contacts: ClientCollection<CustomerContact>;
        bankDetails: ClientCollection<CustomerBankDetail>;
        businessPartner: BusinessPartner;
        shipToCustomers: ClientCollection<ShipToCustomerAddress>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        electronicAddress: string;
        electronicInvoiceType: ElectronicInvoiceType;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        invoiceHeaderText: TextStream;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        orderHeaderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        routingCode: string;
        serviceCode: string;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        cashTaxRules: ClientCollection<CustomerCashTaxRulesBinding>;
        paymentDays: ClientCollection<CustomerPaymentDaysBinding>;
        salesReps: ClientCollection<CustomerSalesRepsBinding>;
        statisticalGroups: ClientCollection<CustomerStatisticalGroupsBinding>;
    }
    export interface Customer$Lookups {
        code: QueryOperation<BusinessPartner>;
        customerCategory: QueryOperation<CustomerCategory>;
        billToCustomer: QueryOperation<Customer>;
        billToCustomerAddress: QueryOperation<CustomerAddress>;
        payByCustomer: QueryOperation<BusinessPartner>;
        payByCustomerAddress: QueryOperation<BusinessPartnerAddress>;
        groupCustomer: QueryOperation<Customer>;
        riskCustomer: QueryOperation<Customer>;
        defaultAddress: QueryOperation<CustomerAddress>;
        defaultShipToAddress: QueryOperation<ShipToCustomerAddress>;
        defaultContact: QueryOperation<CustomerContact>;
        currency: QueryOperation<Currency>;
        insuranceCompany: QueryOperation<BusinessPartner>;
        businessSector: QueryOperation<MiscellaneousTable>;
        prospectOrigin: QueryOperation<MiscellaneousTable>;
        printTemplate: QueryOperation<PrintTemplate>;
        unavailablePaymentPeriod: QueryOperation<UnavailablePeriods>;
        contact: QueryOperation<CustomerContact>;
        businessPartner: QueryOperation<BusinessPartner>;
        businessPartnerSite: QueryOperation<Site>;
        cfonbPaymentMethod: QueryOperation<MiscellaneousTable>;
        consolidationGroup: QueryOperation<SiteGroupings>;
        consolidationPartner: QueryOperation<BusinessPartner>;
        country: QueryOperation<Country>;
        language: QueryOperation<Language>;
        nonResidentAccount: QueryOperation<BusinessPartnerAddress>;
        reportAccessCode: QueryOperation<Access>;
    }
    export interface Customer$Operations {
        query: QueryOperation<Customer>;
        read: ReadOperation<Customer>;
        aggregate: {
            read: AggregateReadOperation<Customer>;
            query: AggregateQueryOperation<Customer>;
        };
        create: CreateOperation<CustomerInput, Customer>;
        getDuplicate: GetDuplicateOperation<Customer>;
        update: UpdateOperation<CustomerInput, Customer>;
        updateById: UpdateByIdOperation<CustomerInput, Customer>;
        lookups(dataOrId: string | { data: CustomerInput }): Customer$Lookups;
        getDefaults: GetDefaultsOperation<Customer>;
    }
    export interface Incoterm extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        isActive: boolean;
    }
    export interface IncotermInput extends ClientNodeInput {
        code?: string;
        description?: string;
        isActive?: boolean | string;
    }
    export interface IncotermBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        isActive: boolean;
    }
    export interface Incoterm$Operations {
        query: QueryOperation<Incoterm>;
        read: ReadOperation<Incoterm>;
        aggregate: {
            read: AggregateReadOperation<Incoterm>;
            query: AggregateQueryOperation<Incoterm>;
        };
        getDefaults: GetDefaultsOperation<Incoterm>;
    }
    export interface Mapping extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        mappingCode: string;
        localizedDescription: string;
        company: Company;
        site: Site;
        legislation: MiscellaneousTable;
        version: string;
        direction: Sense;
    }
    export interface MappingInput extends ClientNodeInput {
        code?: string;
        mappingCode?: string;
        localizedDescription?: string;
        company?: string;
        site?: string;
        legislation?: string;
        version?: string;
        direction?: Sense;
    }
    export interface MappingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        mappingCode: string;
        localizedDescription: string;
        company: Company;
        site: Site;
        legislation: MiscellaneousTable;
        version: string;
        direction: Sense;
    }
    export interface Mapping$Lookups {
        company: QueryOperation<Company>;
        site: QueryOperation<Site>;
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface Mapping$Operations {
        query: QueryOperation<Mapping>;
        read: ReadOperation<Mapping>;
        aggregate: {
            read: AggregateReadOperation<Mapping>;
            query: AggregateQueryOperation<Mapping>;
        };
        lookups(dataOrId: string | { data: MappingInput }): Mapping$Lookups;
        getDefaults: GetDefaultsOperation<Mapping>;
    }
    export interface MobileAutomationSetup extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        criteria1: ProductSearchCriteria;
        criteria2: ProductSearchCriteria;
        stockLabel: GenericPrintReport;
        productionLabel: GenericPrintReport;
        isAlwaysLabelDestination: boolean;
        isTheoreticalQuantityDisplayed: boolean;
        isLocationPreloaded: boolean;
    }
    export interface MobileAutomationSetupInput extends ClientNodeInput {
        site?: string;
        criteria1?: ProductSearchCriteria;
        criteria2?: ProductSearchCriteria;
        stockLabel?: string;
        productionLabel?: string;
        isAlwaysLabelDestination?: boolean | string;
        isTheoreticalQuantityDisplayed?: boolean | string;
        isLocationPreloaded?: boolean | string;
    }
    export interface MobileAutomationSetupBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        criteria1: ProductSearchCriteria;
        criteria2: ProductSearchCriteria;
        stockLabel: GenericPrintReport;
        productionLabel: GenericPrintReport;
        isAlwaysLabelDestination: boolean;
        isTheoreticalQuantityDisplayed: boolean;
        isLocationPreloaded: boolean;
    }
    export interface MobileAutomationSetup$Lookups {
        site: QueryOperation<Site>;
        stockLabel: QueryOperation<GenericPrintReport>;
        productionLabel: QueryOperation<GenericPrintReport>;
    }
    export interface MobileAutomationSetup$Operations {
        query: QueryOperation<MobileAutomationSetup>;
        read: ReadOperation<MobileAutomationSetup>;
        aggregate: {
            read: AggregateReadOperation<MobileAutomationSetup>;
            query: AggregateQueryOperation<MobileAutomationSetup>;
        };
        lookups(dataOrId: string | { data: MobileAutomationSetupInput }): MobileAutomationSetup$Lookups;
        getDefaults: GetDefaultsOperation<MobileAutomationSetup>;
    }
    export interface PrintTemplate extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface PrintTemplateInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface PrintTemplateBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface PrintTemplate$Operations {
        query: QueryOperation<PrintTemplate>;
        read: ReadOperation<PrintTemplate>;
        aggregate: {
            read: AggregateReadOperation<PrintTemplate>;
            query: AggregateQueryOperation<PrintTemplate>;
        };
        getDefaults: GetDefaultsOperation<PrintTemplate>;
    }
    export interface ProductCategoryStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        statisticalGroup: MiscellaneousTable;
    }
    export interface ProductCategoryStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        stockSite?: string;
        code?: string;
        statisticalGroup?: string;
    }
    export interface ProductCategoryStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        statisticalGroup: MiscellaneousTable;
    }
    export interface ProductCategoryStatisticalGroups$Lookups {
        statisticalGroup: QueryOperation<MiscellaneousTable>;
    }
    export interface ProductCategoryStatisticalGroups$Operations {
        query: QueryOperation<ProductCategoryStatisticalGroups>;
        read: ReadOperation<ProductCategoryStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<ProductCategoryStatisticalGroups>;
            query: AggregateQueryOperation<ProductCategoryStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: ProductCategoryStatisticalGroupsInput },
        ): ProductCategoryStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<ProductCategoryStatisticalGroups>;
    }
    export interface ProductCategory extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroups>;
    }
    export interface ProductCategoryInput extends ClientNodeInput {
        stockSite?: string;
        code?: string;
        description?: string;
        localizedDescription?: string;
        shortDescription?: string;
        localizedShortDescription?: string;
        isSold?: boolean | string;
        productSequenceNumber?: string;
        creationMethod?: ProductCreationMode;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticUnit?: string;
        euUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        euUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseConversionFactorEntryAllowed?: boolean | string;
        isSalesConversionFactorEntryAllowed?: boolean | string;
        weightUnit?: string;
        stockUnitWeight?: decimal | string;
        volumeUnit?: string;
        stockUnitVolume?: decimal | string;
        labelFormatForStockUnit?: string;
        stockManagementMode?: StockManagement;
        managementMode?: StandardProductCode;
        isNegativeStockAuthorized?: boolean | string;
        lotSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        serialSequenceNumber?: string;
        valuationMethod?: string;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        userAccessCode?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        buyer?: string;
        planner?: string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        salesPriceOrigin?: PriceOrigin;
        percentagePricePurchaseApplied?: decimal | string;
        configuratorProductLine?: string;
        isLocationManaged?: boolean | string;
        salesOrderAllocationRule?: string;
        workOrderAllocationRule?: string;
        shipmentAllocationRule?: string;
        materialConsumptionAllocationRule?: string;
        transferAllocationRule?: string;
        subcontractReplenishmentAllocationRule?: string;
        subcontractConsumptionAllocationRule?: string;
        afterSalesAllocationRule?: string;
        isStatusAAuthorizedInGlobalAllocation?: boolean | string;
        isStatusQAuthorizedInGlobalAllocation?: boolean | string;
        isStatusRAuthorizedInGlobalAllocation?: boolean | string;
        abcClass?: ProductAbcClass;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        shrinkagePercent?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningRequestHorizon?: integer | string;
        planningRequestHorizonTimeUnit?: LeadTimeUnit;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        stockCoverageInWeeks?: integer | string;
        safetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        isReleasedIfShortage?: boolean | string;
        automaticClosingPercentage?: decimal | string;
        salesDeliveryTolerance?: decimal | string;
        salesMinimumQuantity?: decimal | string;
        salesMaximumQuantity?: decimal | string;
        isLoanAuthorized?: boolean | string;
        isBackToBackOrderManaged?: boolean | string;
        directBackToBackOrderQuantity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTool?: boolean | string;
        isDeliverable?: boolean | string;
        isIntermediary?: boolean | string;
        isMaintenance?: boolean | string;
        packagingCapacity?: decimal | string;
        assignmentRules?: string;
        isStockDetailedInPacking?: boolean | string;
        technicalSheet?: string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        afterSalesWarehouse?: string;
        canBeCapitalized?: boolean | string;
        isPackingManaged?: boolean | string;
        sageSalesTax?: string;
        saftProductType?: SafTProductType;
        freightClass?: string;
        freightCommodityCode?: string;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        inventoryProductType?: ProductType;
        containerManagement?: boolean | string;
        statisticalGroups?: Partial<ProductCategoryStatisticalGroupsInput>[];
    }
    export interface ProductCategoryBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroupsBinding>;
    }
    export interface ProductCategory$Lookups {
        stockSite: QueryOperation<Site>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        purchaseUnit: QueryOperation<UnitOfMeasure>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        statisticUnit: QueryOperation<UnitOfMeasure>;
        euUnit: QueryOperation<UnitOfMeasure>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        labelFormatForStockUnit: QueryOperation<GenericPrintReport>;
        buyer: QueryOperation<User>;
        planner: QueryOperation<User>;
        reorderingSite: QueryOperation<Site>;
        technicalSheet: QueryOperation<TechnicalSheet>;
        sageSalesTax: QueryOperation<MiscellaneousTable>;
    }
    export interface ProductCategory$Operations {
        query: QueryOperation<ProductCategory>;
        read: ReadOperation<ProductCategory>;
        aggregate: {
            read: AggregateReadOperation<ProductCategory>;
            query: AggregateQueryOperation<ProductCategory>;
        };
        create: CreateOperation<ProductCategoryInput, ProductCategory>;
        getDuplicate: GetDuplicateOperation<ProductCategory>;
        lookups(dataOrId: string | { data: ProductCategoryInput }): ProductCategory$Lookups;
        getDefaults: GetDefaultsOperation<ProductCategory>;
    }
    export interface ProductPackingUnits extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        packingUnit: UnitOfMeasure;
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
        issuingPackingRule: UnpackingRulesPac;
        labelFormat: GenericPrintReport;
    }
    export interface ProductPackingUnitsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        packingUnit?: string;
        packingUnitToStockUnitConversionFactor?: decimal | string;
        isPackingFactorEntryAllowed?: boolean | string;
        issuingPackingRule?: UnpackingRulesPac;
        labelFormat?: string;
    }
    export interface ProductPackingUnitsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        packingUnit: UnitOfMeasure;
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
        issuingPackingRule: UnpackingRulesPac;
        labelFormat: GenericPrintReport;
    }
    export interface ProductPackingUnits$Lookups {
        packingUnit: QueryOperation<UnitOfMeasure>;
        labelFormat: QueryOperation<GenericPrintReport>;
    }
    export interface ProductPackingUnits$Operations {
        query: QueryOperation<ProductPackingUnits>;
        read: ReadOperation<ProductPackingUnits>;
        aggregate: {
            read: AggregateReadOperation<ProductPackingUnits>;
            query: AggregateQueryOperation<ProductPackingUnits>;
        };
        lookups(dataOrId: string | { data: ProductPackingUnitsInput }): ProductPackingUnits$Lookups;
        getDefaults: GetDefaultsOperation<ProductPackingUnits>;
    }
    export interface ProductSite extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        stockSite: Site;
        isBeingCounted: boolean;
        countWorksheet: string;
        abcClass: ProductAbcClass;
        isLocationManaged: boolean;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        numberOfStockCoverageWeeks: integer;
        multilevelLeadTime: string;
        qualityControlLeadTime: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningDemandHorizon: integer;
        planningDemandHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        productionLeadTime: string;
        pickingLeadTime: string;
        reductionFactor: integer;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        safetyStock: string;
        calculatedSafetyStock: string;
        reorderingThreshold: string;
        calculatedReorderingThreshold: string;
        reorderingMaximumStock: string;
        calculatedReorderingMaximumStock: string;
        economicOrderQuantity: string;
        calculatedEconomicOrderQuantity: string;
        technicalLotQuantity: string;
        shrinkagePercentage: string;
        planner: User;
        buyer: User;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        productionRouting: string;
        costRouting: string;
        roughCut: string;
        productionRoutingCode: BomRouting;
        costRoutingCode: BomRouting;
        roughCutCapacityPlanningRoutingCode: BomRouting;
        isReleasedIfShortage: boolean;
        isShrinkedWithRelease: boolean;
        yearOfLastMonthlyUpdate: integer;
        monthOfLastMonthlyUpdate: integer;
        lastAnnualUpdate: integer;
        automaticClosingPercentage: string;
        configurationCode: string;
        storageHandling: string;
        weighingAccessCode: string;
        weighingTolerance: string;
        productTolerance: string;
        valuationMethod: string;
        prorataQuantityAdjustment: string;
        protectionWip: boolean;
        packagingCapacity: string;
        stockManagementMode: StockManagement;
        assignmentRule: string;
        isStockDetailedInPacking: boolean;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        qualityControlFrequency: integer;
        numberOfEntriesSinceLastQualityControl: integer;
        sampling: SamplingType;
        samplingMode: SamplingMode;
        samplingGeneralCheckLevel: GeneralControlLevel;
        samplingAcceptableQualityLevel: AcceptableQualityLevel;
        qualityControlFrequencyToReview: integer;
        qualityEntriesProcess: integer;
        recontrolLeadTime: integer;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionsWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        isPackingManaged: boolean;
        freightClass: string;
        freightCommodityCode: string;
        isLicensePlateNumberManaged: boolean;
        products: ClientCollection<Product>;
    }
    export interface ProductSiteInput extends ClientNodeInput {
        product?: string;
        stockSite?: string;
        isBeingCounted?: boolean | string;
        countWorksheet?: string;
        abcClass?: ProductAbcClass;
        isLocationManaged?: boolean | string;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        numberOfStockCoverageWeeks?: integer | string;
        multilevelLeadTime?: decimal | string;
        qualityControlLeadTime?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningDemandHorizon?: integer | string;
        planningDemandHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        productionLeadTime?: decimal | string;
        pickingLeadTime?: decimal | string;
        reductionFactor?: integer | string;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        safetyStock?: decimal | string;
        calculatedSafetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        calculatedReorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        calculatedReorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        calculatedEconomicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        shrinkagePercentage?: decimal | string;
        planner?: string;
        buyer?: string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        productionRouting?: string;
        costRouting?: string;
        roughCut?: string;
        productionRoutingCode?: integer | string;
        costRoutingCode?: integer | string;
        roughCutCapacityPlanningRoutingCode?: integer | string;
        isReleasedIfShortage?: boolean | string;
        isShrinkedWithRelease?: boolean | string;
        yearOfLastMonthlyUpdate?: integer | string;
        monthOfLastMonthlyUpdate?: integer | string;
        lastAnnualUpdate?: integer | string;
        automaticClosingPercentage?: decimal | string;
        configurationCode?: string;
        storageHandling?: string;
        weighingAccessCode?: string;
        weighingTolerance?: decimal | string;
        productTolerance?: decimal | string;
        valuationMethod?: string;
        prorataQuantityAdjustment?: decimal | string;
        protectionWip?: boolean | string;
        packagingCapacity?: decimal | string;
        stockManagementMode?: StockManagement;
        assignmentRule?: string;
        isStockDetailedInPacking?: boolean | string;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        qualityControlFrequency?: integer | string;
        numberOfEntriesSinceLastQualityControl?: integer | string;
        sampling?: SamplingType;
        samplingMode?: SamplingMode;
        samplingGeneralCheckLevel?: GeneralControlLevel;
        samplingAcceptableQualityLevel?: AcceptableQualityLevel;
        qualityControlFrequencyToReview?: integer | string;
        qualityEntriesProcess?: integer | string;
        recontrolLeadTime?: integer | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionsWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        isPackingManaged?: boolean | string;
        freightClass?: string;
        freightCommodityCode?: string;
        isLicensePlateNumberManaged?: boolean | string;
    }
    export interface ProductSiteBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        stockSite: Site;
        isBeingCounted: boolean;
        countWorksheet: string;
        abcClass: ProductAbcClass;
        isLocationManaged: boolean;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        numberOfStockCoverageWeeks: integer;
        multilevelLeadTime: string;
        qualityControlLeadTime: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningDemandHorizon: integer;
        planningDemandHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        productionLeadTime: string;
        pickingLeadTime: string;
        reductionFactor: integer;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        safetyStock: string;
        calculatedSafetyStock: string;
        reorderingThreshold: string;
        calculatedReorderingThreshold: string;
        reorderingMaximumStock: string;
        calculatedReorderingMaximumStock: string;
        economicOrderQuantity: string;
        calculatedEconomicOrderQuantity: string;
        technicalLotQuantity: string;
        shrinkagePercentage: string;
        planner: User;
        buyer: User;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        productionRouting: string;
        costRouting: string;
        roughCut: string;
        productionRoutingCode: BomRouting;
        costRoutingCode: BomRouting;
        roughCutCapacityPlanningRoutingCode: BomRouting;
        isReleasedIfShortage: boolean;
        isShrinkedWithRelease: boolean;
        yearOfLastMonthlyUpdate: integer;
        monthOfLastMonthlyUpdate: integer;
        lastAnnualUpdate: integer;
        automaticClosingPercentage: string;
        configurationCode: string;
        storageHandling: string;
        weighingAccessCode: string;
        weighingTolerance: string;
        productTolerance: string;
        valuationMethod: string;
        prorataQuantityAdjustment: string;
        protectionWip: boolean;
        packagingCapacity: string;
        stockManagementMode: StockManagement;
        assignmentRule: string;
        isStockDetailedInPacking: boolean;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        qualityControlFrequency: integer;
        numberOfEntriesSinceLastQualityControl: integer;
        sampling: SamplingType;
        samplingMode: SamplingMode;
        samplingGeneralCheckLevel: GeneralControlLevel;
        samplingAcceptableQualityLevel: AcceptableQualityLevel;
        qualityControlFrequencyToReview: integer;
        qualityEntriesProcess: integer;
        recontrolLeadTime: integer;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionsWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        isPackingManaged: boolean;
        freightClass: string;
        freightCommodityCode: string;
        isLicensePlateNumberManaged: boolean;
        products: ClientCollection<Product>;
    }
    export interface ProductSite$Lookups {
        product: QueryOperation<Product>;
        stockSite: QueryOperation<Site>;
        reorderingSite: QueryOperation<Site>;
        planner: QueryOperation<User>;
        buyer: QueryOperation<User>;
        productionRoutingCode: QueryOperation<BomRouting>;
        costRoutingCode: QueryOperation<BomRouting>;
        roughCutCapacityPlanningRoutingCode: QueryOperation<BomRouting>;
    }
    export interface ProductSite$Operations {
        query: QueryOperation<ProductSite>;
        read: ReadOperation<ProductSite>;
        aggregate: {
            read: AggregateReadOperation<ProductSite>;
            query: AggregateQueryOperation<ProductSite>;
        };
        lookups(dataOrId: string | { data: ProductSiteInput }): ProductSite$Lookups;
        getDefaults: GetDefaultsOperation<ProductSite>;
    }
    export interface ProductStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        statisticalGroup: MiscellaneousTable;
    }
    export interface ProductStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        statisticalGroup?: string;
    }
    export interface ProductStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        statisticalGroup: MiscellaneousTable;
    }
    export interface ProductStatisticalGroups$Lookups {
        statisticalGroup: QueryOperation<MiscellaneousTable>;
    }
    export interface ProductStatisticalGroups$Operations {
        query: QueryOperation<ProductStatisticalGroups>;
        read: ReadOperation<ProductStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<ProductStatisticalGroups>;
            query: AggregateQueryOperation<ProductStatisticalGroups>;
        };
        lookups(dataOrId: string | { data: ProductStatisticalGroupsInput }): ProductStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<ProductStatisticalGroups>;
    }
    export interface ProductVersion extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        majorVersion: string;
        minorVersion: string;
        type: Flow;
        sequence: integer;
        useStatus: UseStatus;
        startDate: string;
        endDate: string;
        isSubjectToException: boolean;
        exceptionDate: string;
    }
    export interface ProductVersionInput extends ClientNodeInput {
        product?: string;
        majorVersion?: string;
        minorVersion?: string;
        type?: Flow;
        sequence?: integer | string;
        useStatus?: UseStatus;
        startDate?: string;
        endDate?: string;
        isSubjectToException?: boolean | string;
        exceptionDate?: string;
    }
    export interface ProductVersionBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        majorVersion: string;
        minorVersion: string;
        type: Flow;
        sequence: integer;
        useStatus: UseStatus;
        startDate: string;
        endDate: string;
        isSubjectToException: boolean;
        exceptionDate: string;
    }
    export interface ProductVersion$Lookups {
        product: QueryOperation<Product>;
    }
    export interface ProductVersion$Operations {
        query: QueryOperation<ProductVersion>;
        read: ReadOperation<ProductVersion>;
        aggregate: {
            read: AggregateReadOperation<ProductVersion>;
            query: AggregateQueryOperation<ProductVersion>;
        };
        lookups(dataOrId: string | { data: ProductVersionInput }): ProductVersion$Lookups;
        getDefaults: GetDefaultsOperation<ProductVersion>;
    }
    export interface Product extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnits>;
        statisticalGroups: ClientCollection<ProductStatisticalGroups>;
    }
    export interface ProductInput extends ClientNodeInput {
        code?: string;
        company?: string;
        productCategory?: string;
        searchKey?: string;
        description1?: string;
        description2?: string;
        description3?: string;
        localizedDescription1?: string;
        localizedDescription2?: string;
        localizedDescription3?: string;
        managementMode?: StandardProductCode;
        standard?: string;
        upc?: string;
        productStatus?: ProductStatus;
        isPrototype?: boolean | string;
        defaultPotencyInPercentage?: decimal | string;
        defaultPotencyInInternationalUnit?: decimal | string;
        serviceLifeStartDate?: string;
        serviceLifeEndDate?: string;
        storageSheet?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticalUnit?: string;
        eeUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseFactorEntryAllowed?: boolean | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        isSalesFactorEntryAllowed?: boolean | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        eeUnitToStockUnitConversionFactor?: decimal | string;
        weightUnit?: string;
        productWeight?: decimal | string;
        volumeUnit?: string;
        productVolume?: decimal | string;
        lotSequenceNumber?: string;
        serialSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        expirationLeadTime?: integer | string;
        checkLeadTime?: integer | string;
        isNegativeStockAuthorized?: boolean | string;
        costGroup?: string;
        userAccessCode?: string;
        alternateProduct?: string;
        isIntrastatDeclarationSubmitted?: boolean | string;
        intrastatCommodity?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        buyer?: string;
        planner?: string;
        reorderLeadTime?: integer | string;
        purchaseBasePrice?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        exemptionFlag?: string;
        taxFlagStatusLocal?: string;
        configuratorProductLine?: string;
        configuratorNumericField1?: decimal | string;
        configuratorNumericField2?: decimal | string;
        configuratorNumericField3?: decimal | string;
        configuratorNumericField4?: decimal | string;
        configuratorNumericField5?: decimal | string;
        configuratorNumericField6?: decimal | string;
        configuratorAlphaField1?: string;
        configuratorAlphaField2?: string;
        configuratorAlphaField3?: string;
        configuratorAlphaField4?: string;
        configuratorAlphaField5?: string;
        configuratorAlphaField6?: string;
        configurationJournal?: string;
        configuratorBusinessPartner?: string;
        configuratorBusinessPartnerReference?: string;
        configuratorReferenceProduct?: string;
        configuratorPurgeDate?: string;
        isInstalledBaseCreated?: boolean | string;
        voucherCategory?: string;
        tokensToBeCredited?: integer | string;
        creditUnit?: string;
        labelFormatForStockUnit?: string;
        bomCodeForAfterSales?: integer | string;
        productTypeForAfterSales?: TypeOfProduct;
        isAfterSalesProductIssuedByDefault?: boolean | string;
        daysUnit?: string;
        hourUnit?: string;
        minuteUnit?: string;
        productDensity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTools?: boolean | string;
        isDeliverable?: boolean | string;
        isSold?: boolean | string;
        isIntermediary?: boolean | string;
        isCapitalized?: boolean | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        intrastatFederalStateOrRegion?: string;
        plmProductReference?: string;
        plmLinkedDocuments?: string;
        plmProductHistory?: string;
        sageSalesTax?: string;
        allergens?: string;
        allergenChangeDate?: string;
        allergenBomCode?: integer | string;
        saftProductType?: SafTProductType;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        productType?: ProductType;
        globalTradeItemNumber?: string;
        supplierProduct?: Partial<SupplierProductInput>[];
        customerProduct?: Partial<CustomerProductInput>[];
        manufacturingText?: TextStream;
        picture?: BinaryStream;
        purchasingText?: TextStream;
        packingUnits?: Partial<ProductPackingUnitsInput>[];
        statisticalGroups?: Partial<ProductStatisticalGroupsInput>[];
    }
    export interface ProductBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnitsBinding>;
        statisticalGroups: ClientCollection<ProductStatisticalGroupsBinding>;
    }
    export interface Product$Lookups {
        company: QueryOperation<Company>;
        productCategory: QueryOperation<ProductCategory>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        purchaseUnit: QueryOperation<UnitOfMeasure>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        statisticalUnit: QueryOperation<UnitOfMeasure>;
        eeUnit: QueryOperation<UnitOfMeasure>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        userAccessCode: QueryOperation<Access>;
        alternateProduct: QueryOperation<Product>;
        buyer: QueryOperation<User>;
        planner: QueryOperation<User>;
        configuratorBusinessPartner: QueryOperation<BusinessPartner>;
        configuratorReferenceProduct: QueryOperation<Product>;
        voucherCategory: QueryOperation<MiscellaneousTable>;
        creditUnit: QueryOperation<UnitOfMeasure>;
        labelFormatForStockUnit: QueryOperation<GenericPrintReport>;
        bomCodeForAfterSales: QueryOperation<BomCodes>;
        daysUnit: QueryOperation<UnitOfMeasure>;
        hourUnit: QueryOperation<UnitOfMeasure>;
        minuteUnit: QueryOperation<UnitOfMeasure>;
        intrastatFederalStateOrRegion: QueryOperation<MiscellaneousTable>;
        sageSalesTax: QueryOperation<MiscellaneousTable>;
    }
    export interface Product$Operations {
        query: QueryOperation<Product>;
        read: ReadOperation<Product>;
        aggregate: {
            read: AggregateReadOperation<Product>;
            query: AggregateQueryOperation<Product>;
        };
        lookups(dataOrId: string | { data: ProductInput }): Product$Lookups;
        getDefaults: GetDefaultsOperation<Product>;
    }
    export interface ProspectAddressAddressEmails extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        prospect: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface ProspectAddressAddressEmailsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        prospect?: string;
        code?: string;
        addressEmail?: string;
    }
    export interface ProspectAddressAddressEmailsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        prospect: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface ProspectAddressAddressEmails$Operations {
        query: QueryOperation<ProspectAddressAddressEmails>;
        read: ReadOperation<ProspectAddressAddressEmails>;
        aggregate: {
            read: AggregateReadOperation<ProspectAddressAddressEmails>;
            query: AggregateQueryOperation<ProspectAddressAddressEmails>;
        };
        getDefaults: GetDefaultsOperation<ProspectAddressAddressEmails>;
    }
    export interface ProspectAddressAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        prospect: string;
        code: string;
        addressLine: string;
    }
    export interface ProspectAddressAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        prospect?: string;
        code?: string;
        addressLine?: string;
    }
    export interface ProspectAddressAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        prospect: string;
        code: string;
        addressLine: string;
    }
    export interface ProspectAddressAddressLines$Operations {
        query: QueryOperation<ProspectAddressAddressLines>;
        read: ReadOperation<ProspectAddressAddressLines>;
        aggregate: {
            read: AggregateReadOperation<ProspectAddressAddressLines>;
            query: AggregateQueryOperation<ProspectAddressAddressLines>;
        };
        getDefaults: GetDefaultsOperation<ProspectAddressAddressLines>;
    }
    export interface ProspectAddressAddressPhoneNumbers extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        prospect: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface ProspectAddressAddressPhoneNumbersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        prospect?: string;
        code?: string;
        addressPhoneNumber?: string;
    }
    export interface ProspectAddressAddressPhoneNumbersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        prospect: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface ProspectAddressAddressPhoneNumbers$Operations {
        query: QueryOperation<ProspectAddressAddressPhoneNumbers>;
        read: ReadOperation<ProspectAddressAddressPhoneNumbers>;
        aggregate: {
            read: AggregateReadOperation<ProspectAddressAddressPhoneNumbers>;
            query: AggregateQueryOperation<ProspectAddressAddressPhoneNumbers>;
        };
        getDefaults: GetDefaultsOperation<ProspectAddressAddressPhoneNumbers>;
    }
    export interface ProspectAddress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        prospect: Prospect;
        code: string;
        description: string;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        addressEmails: ClientCollection<ProspectAddressAddressEmails>;
        addressLines: ClientCollection<ProspectAddressAddressLines>;
        addressPhoneNumbers: ClientCollection<ProspectAddressAddressPhoneNumbers>;
    }
    export interface ProspectAddressInput extends ClientNodeInput {
        entityType?: EntityType;
        prospect?: string;
        code?: string;
        description?: string;
        isDefault?: boolean | string;
        zipCode?: string;
        city?: string;
        state?: string;
        country?: string;
        countryName?: string;
        website?: string;
        addressEmails?: Partial<ProspectAddressAddressEmailsInput>[];
        addressLines?: Partial<ProspectAddressAddressLinesInput>[];
        addressPhoneNumbers?: Partial<ProspectAddressAddressPhoneNumbersInput>[];
    }
    export interface ProspectAddressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        prospect: Prospect;
        code: string;
        description: string;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        addressEmails: ClientCollection<ProspectAddressAddressEmailsBinding>;
        addressLines: ClientCollection<ProspectAddressAddressLinesBinding>;
        addressPhoneNumbers: ClientCollection<ProspectAddressAddressPhoneNumbersBinding>;
    }
    export interface ProspectAddress$Lookups {
        prospect: QueryOperation<Prospect>;
        country: QueryOperation<Country>;
    }
    export interface ProspectAddress$Operations {
        query: QueryOperation<ProspectAddress>;
        read: ReadOperation<ProspectAddress>;
        aggregate: {
            read: AggregateReadOperation<ProspectAddress>;
            query: AggregateQueryOperation<ProspectAddress>;
        };
        lookups(dataOrId: string | { data: ProspectAddressInput }): ProspectAddress$Lookups;
        getDefaults: GetDefaultsOperation<ProspectAddress>;
    }
    export interface ProspectContact extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        prospect: Prospect;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface ProspectContactInput extends ClientNodeInput {
        entityType?: EntityType;
        prospect?: string;
        code?: string;
        position?: FunctionContact;
        department?: string;
        role?: string;
        defaultAddress?: string;
        landline?: string;
        fax?: string;
        email?: string;
        cellPhone?: string;
        isDataProtectionOfficer?: boolean | string;
        contactRelationship?: string;
        addressLines?: Partial<ContactRelationshipAddressLinesInput>[];
        relationshipCellPhone?: string;
        relationshipCity?: string;
        relationshipCountry?: string;
        relationshipCountryName?: string;
        relationshipDateOfBirth?: string;
        relationshipEmail?: string;
        relationshipFax?: string;
        relationshipFirstName?: string;
        relationshipFullNameSearchKey?: string;
        relationshipIsMailingProhibited?: boolean | string;
        relationshipLandline?: string;
        relationshipLanguage?: string;
        relationshipLastName?: string;
        relationshipProfessionalCategory?: string;
        relationshipState?: string;
        relationshipTitle?: Title;
        relationshipType?: ContactType;
        relationshipZipCode?: string;
    }
    export interface ProspectContactBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        prospect: Prospect;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface ProspectContact$Lookups {
        prospect: QueryOperation<Prospect>;
        code: QueryOperation<ContactRelationship>;
        role: QueryOperation<MiscellaneousTable>;
        contactRelationship: QueryOperation<ContactRelationship>;
        relationshipCountry: QueryOperation<Country>;
        relationshipLanguage: QueryOperation<Language>;
        relationshipProfessionalCategory: QueryOperation<MiscellaneousTable>;
    }
    export interface ProspectContact$Operations {
        query: QueryOperation<ProspectContact>;
        read: ReadOperation<ProspectContact>;
        aggregate: {
            read: AggregateReadOperation<ProspectContact>;
            query: AggregateQueryOperation<ProspectContact>;
        };
        lookups(dataOrId: string | { data: ProspectContactInput }): ProspectContact$Lookups;
        getDefaults: GetDefaultsOperation<ProspectContact>;
    }
    export interface ProspectSalesReps extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        salesRep: SalesRep;
    }
    export interface ProspectSalesRepsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        salesRep?: string;
    }
    export interface ProspectSalesRepsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        salesRep: SalesRep;
    }
    export interface ProspectSalesReps$Lookups {
        salesRep: QueryOperation<SalesRep>;
    }
    export interface ProspectSalesReps$Operations {
        query: QueryOperation<ProspectSalesReps>;
        read: ReadOperation<ProspectSalesReps>;
        aggregate: {
            read: AggregateReadOperation<ProspectSalesReps>;
            query: AggregateQueryOperation<ProspectSalesReps>;
        };
        lookups(dataOrId: string | { data: ProspectSalesRepsInput }): ProspectSalesReps$Lookups;
        getDefaults: GetDefaultsOperation<ProspectSalesReps>;
    }
    export interface ProspectStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        value: MiscellaneousTable;
    }
    export interface ProspectStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        value?: string;
    }
    export interface ProspectStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        value: MiscellaneousTable;
    }
    export interface ProspectStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface ProspectStatisticalGroups$Operations {
        query: QueryOperation<ProspectStatisticalGroups>;
        read: ReadOperation<ProspectStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<ProspectStatisticalGroups>;
            query: AggregateQueryOperation<ProspectStatisticalGroups>;
        };
        lookups(dataOrId: string | { data: ProspectStatisticalGroupsInput }): ProspectStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<ProspectStatisticalGroups>;
    }
    export interface Prospect extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        customerCategory: CustomerCategory;
        groupCustomer: Customer;
        defaultAddress: ProspectAddress;
        defaultContact: ProspectContact;
        isActive: boolean;
        currency: Currency;
        commissionCategory: CommissionCategory;
        addresses: ClientCollection<ProspectAddress>;
        contacts: ClientCollection<ProspectContact>;
        acronym: string;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        country: Country;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        language: Language;
        salesReps: ClientCollection<ProspectSalesReps>;
        statisticalGroups: ClientCollection<ProspectStatisticalGroups>;
    }
    export interface ProspectInput extends ClientNodeInput {
        code?: string;
        customerCategory?: string;
        groupCustomer?: string;
        defaultAddress?: string;
        defaultContact?: string;
        isActive?: boolean | string;
        currency?: string;
        commissionCategory?: CommissionCategory;
        addresses?: Partial<ProspectAddressInput>[];
        contacts?: Partial<ProspectContactInput>[];
        acronym?: string;
        companyName1?: string;
        companyName2?: string;
        companyNames?: Partial<BusinessPartnerCompanyNamesInput>[];
        country?: string;
        europeanUnionVatNumber?: string;
        fiscalCode?: string;
        isMailingProhibited?: boolean | string;
        isPhysicalPerson?: boolean | string;
        language?: string;
        salesReps?: Partial<ProspectSalesRepsInput>[];
        statisticalGroups?: Partial<ProspectStatisticalGroupsInput>[];
    }
    export interface ProspectBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        customerCategory: CustomerCategory;
        groupCustomer: Customer;
        defaultAddress: ProspectAddress;
        defaultContact: ProspectContact;
        isActive: boolean;
        currency: Currency;
        commissionCategory: CommissionCategory;
        addresses: ClientCollection<ProspectAddress>;
        contacts: ClientCollection<ProspectContact>;
        acronym: string;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        country: Country;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        language: Language;
        salesReps: ClientCollection<ProspectSalesRepsBinding>;
        statisticalGroups: ClientCollection<ProspectStatisticalGroupsBinding>;
    }
    export interface Prospect$Lookups {
        code: QueryOperation<BusinessPartner>;
        customerCategory: QueryOperation<CustomerCategory>;
        groupCustomer: QueryOperation<Customer>;
        defaultAddress: QueryOperation<ProspectAddress>;
        defaultContact: QueryOperation<ProspectContact>;
        currency: QueryOperation<Currency>;
        country: QueryOperation<Country>;
        language: QueryOperation<Language>;
    }
    export interface Prospect$Operations {
        query: QueryOperation<Prospect>;
        read: ReadOperation<Prospect>;
        aggregate: {
            read: AggregateReadOperation<Prospect>;
            query: AggregateQueryOperation<Prospect>;
        };
        lookups(dataOrId: string | { data: ProspectInput }): Prospect$Lookups;
        getDefaults: GetDefaultsOperation<Prospect>;
    }
    export interface SalesRep extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        name: string;
        businessPartner: BusinessPartner;
    }
    export interface SalesRepInput extends ClientNodeInput {
        code?: string;
        name?: string;
        businessPartner?: string;
    }
    export interface SalesRepBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        name: string;
        businessPartner: BusinessPartner;
    }
    export interface SalesRep$Lookups {
        code: QueryOperation<BusinessPartner>;
        businessPartner: QueryOperation<BusinessPartner>;
    }
    export interface SalesRep$Operations {
        query: QueryOperation<SalesRep>;
        read: ReadOperation<SalesRep>;
        aggregate: {
            read: AggregateReadOperation<SalesRep>;
            query: AggregateQueryOperation<SalesRep>;
        };
        lookups(dataOrId: string | { data: SalesRepInput }): SalesRep$Lookups;
        getDefaults: GetDefaultsOperation<SalesRep>;
    }
    export interface ShipToCustomerAddressCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        customer: string;
        shipToAddress: string;
        companyName: string;
    }
    export interface ShipToCustomerAddressCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        customer?: string;
        shipToAddress?: string;
        companyName?: string;
    }
    export interface ShipToCustomerAddressCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        customer: string;
        shipToAddress: string;
        companyName: string;
    }
    export interface ShipToCustomerAddressCompanyNames$Operations {
        query: QueryOperation<ShipToCustomerAddressCompanyNames>;
        read: ReadOperation<ShipToCustomerAddressCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<ShipToCustomerAddressCompanyNames>;
            query: AggregateQueryOperation<ShipToCustomerAddressCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<ShipToCustomerAddressCompanyNames>;
    }
    export interface ShipToCustomerAddressSalesReps extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        customer: string;
        shipToAddress: string;
        salesRep: SalesRep;
    }
    export interface ShipToCustomerAddressSalesRepsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        customer?: string;
        shipToAddress?: string;
        salesRep?: string;
    }
    export interface ShipToCustomerAddressSalesRepsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        customer: string;
        shipToAddress: string;
        salesRep: SalesRep;
    }
    export interface ShipToCustomerAddressSalesReps$Lookups {
        salesRep: QueryOperation<SalesRep>;
    }
    export interface ShipToCustomerAddressSalesReps$Operations {
        query: QueryOperation<ShipToCustomerAddressSalesReps>;
        read: ReadOperation<ShipToCustomerAddressSalesReps>;
        aggregate: {
            read: AggregateReadOperation<ShipToCustomerAddressSalesReps>;
            query: AggregateQueryOperation<ShipToCustomerAddressSalesReps>;
        };
        lookups(
            dataOrId: string | { data: ShipToCustomerAddressSalesRepsInput },
        ): ShipToCustomerAddressSalesReps$Lookups;
        getDefaults: GetDefaultsOperation<ShipToCustomerAddressSalesReps>;
    }
    export interface ShipToCustomerAddress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        customer: Customer;
        shipToAddress: CustomerAddress;
        company: Company;
        isActive: boolean;
        shippingSite: Site;
        receiptSite: Site;
        language: Language;
        carrier: Carrier;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        deliveryLeadTime: integer;
        isMondayWorkday: boolean;
        isTuesdayWorkday: boolean;
        isWednesdayWorkday: boolean;
        isThursdayWorkday: boolean;
        isFridayWorkday: boolean;
        isSaturdayWorkday: boolean;
        isSundayWorkday: boolean;
        unavailablePeriod: UnavailablePeriods;
        intrastatIncreaseCoefficient: string;
        europeanUnionVatNumber: string;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: Address;
        geographicCode: string;
        insideCityLimits: string;
        taxExemptionNumber: string;
        exemptionFlag: string;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        entityUse: MiscellaneousTable;
        deliveryHeaderText: TextStream;
        pickingHeaderText: TextStream;
        companyNames: ClientCollection<ShipToCustomerAddressCompanyNames>;
        salesReps: ClientCollection<ShipToCustomerAddressSalesReps>;
    }
    export interface ShipToCustomerAddressInput extends ClientNodeInput {
        customer?: string;
        shipToAddress?: string;
        company?: string;
        isActive?: boolean | string;
        shippingSite?: string;
        receiptSite?: string;
        language?: string;
        carrier?: string;
        incoterm?: string;
        intrastatTransportLocation?: CountryLocation;
        deliveryLeadTime?: integer | string;
        isMondayWorkday?: boolean | string;
        isTuesdayWorkday?: boolean | string;
        isWednesdayWorkday?: boolean | string;
        isThursdayWorkday?: boolean | string;
        isFridayWorkday?: boolean | string;
        isSaturdayWorkday?: boolean | string;
        isSundayWorkday?: boolean | string;
        unavailablePeriod?: string;
        intrastatIncreaseCoefficient?: decimal | string;
        europeanUnionVatNumber?: string;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        geographicCode?: string;
        insideCityLimits?: string;
        taxExemptionNumber?: string;
        exemptionFlag?: string;
        mustPrintPickTicket?: boolean | string;
        mustPrintPackingSlip?: boolean | string;
        entityUse?: string;
        deliveryHeaderText?: TextStream;
        pickingHeaderText?: TextStream;
        companyNames?: Partial<ShipToCustomerAddressCompanyNamesInput>[];
        salesReps?: Partial<ShipToCustomerAddressSalesRepsInput>[];
    }
    export interface ShipToCustomerAddressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        customer: Customer;
        shipToAddress: CustomerAddress;
        company: Company;
        isActive: boolean;
        shippingSite: Site;
        receiptSite: Site;
        language: Language;
        carrier: Carrier;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        deliveryLeadTime: integer;
        isMondayWorkday: boolean;
        isTuesdayWorkday: boolean;
        isWednesdayWorkday: boolean;
        isThursdayWorkday: boolean;
        isFridayWorkday: boolean;
        isSaturdayWorkday: boolean;
        isSundayWorkday: boolean;
        unavailablePeriod: UnavailablePeriods;
        intrastatIncreaseCoefficient: string;
        europeanUnionVatNumber: string;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: Address;
        geographicCode: string;
        insideCityLimits: string;
        taxExemptionNumber: string;
        exemptionFlag: string;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        entityUse: MiscellaneousTable;
        deliveryHeaderText: TextStream;
        pickingHeaderText: TextStream;
        companyNames: ClientCollection<ShipToCustomerAddressCompanyNamesBinding>;
        salesReps: ClientCollection<ShipToCustomerAddressSalesRepsBinding>;
    }
    export interface ShipToCustomerAddress$Lookups {
        customer: QueryOperation<Customer>;
        shipToAddress: QueryOperation<CustomerAddress>;
        company: QueryOperation<Company>;
        shippingSite: QueryOperation<Site>;
        receiptSite: QueryOperation<Site>;
        language: QueryOperation<Language>;
        carrier: QueryOperation<Carrier>;
        incoterm: QueryOperation<Incoterm>;
        unavailablePeriod: QueryOperation<UnavailablePeriods>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<Address>;
        entityUse: QueryOperation<MiscellaneousTable>;
    }
    export interface ShipToCustomerAddress$Operations {
        query: QueryOperation<ShipToCustomerAddress>;
        read: ReadOperation<ShipToCustomerAddress>;
        aggregate: {
            read: AggregateReadOperation<ShipToCustomerAddress>;
            query: AggregateQueryOperation<ShipToCustomerAddress>;
        };
        lookups(dataOrId: string | { data: ShipToCustomerAddressInput }): ShipToCustomerAddress$Lookups;
        getDefaults: GetDefaultsOperation<ShipToCustomerAddress>;
    }
    export interface SiteAddressAddressEmails extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        site: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface SiteAddressAddressEmailsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        site?: string;
        code?: string;
        addressEmail?: string;
    }
    export interface SiteAddressAddressEmailsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        site: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface SiteAddressAddressEmails$Operations {
        query: QueryOperation<SiteAddressAddressEmails>;
        read: ReadOperation<SiteAddressAddressEmails>;
        aggregate: {
            read: AggregateReadOperation<SiteAddressAddressEmails>;
            query: AggregateQueryOperation<SiteAddressAddressEmails>;
        };
        getDefaults: GetDefaultsOperation<SiteAddressAddressEmails>;
    }
    export interface SiteAddressAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        site: string;
        code: string;
        addressLine: string;
    }
    export interface SiteAddressAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        site?: string;
        code?: string;
        addressLine?: string;
    }
    export interface SiteAddressAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        site: string;
        code: string;
        addressLine: string;
    }
    export interface SiteAddressAddressLines$Operations {
        query: QueryOperation<SiteAddressAddressLines>;
        read: ReadOperation<SiteAddressAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SiteAddressAddressLines>;
            query: AggregateQueryOperation<SiteAddressAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SiteAddressAddressLines>;
    }
    export interface SiteAddressAddressPhoneNumbers extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        site: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface SiteAddressAddressPhoneNumbersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        site?: string;
        code?: string;
        addressPhoneNumber?: string;
    }
    export interface SiteAddressAddressPhoneNumbersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        site: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface SiteAddressAddressPhoneNumbers$Operations {
        query: QueryOperation<SiteAddressAddressPhoneNumbers>;
        read: ReadOperation<SiteAddressAddressPhoneNumbers>;
        aggregate: {
            read: AggregateReadOperation<SiteAddressAddressPhoneNumbers>;
            query: AggregateQueryOperation<SiteAddressAddressPhoneNumbers>;
        };
        getDefaults: GetDefaultsOperation<SiteAddressAddressPhoneNumbers>;
    }
    export interface SiteAddress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        site: Site;
        code: string;
        description: string;
        defaultBankId: SiteBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<SiteAddressAddressEmails>;
        addressLines: ClientCollection<SiteAddressAddressLines>;
        addressPhoneNumbers: ClientCollection<SiteAddressAddressPhoneNumbers>;
    }
    export interface SiteAddressInput extends ClientNodeInput {
        entityType?: EntityType;
        site?: string;
        code?: string;
        description?: string;
        defaultBankId?: string;
        isDefault?: boolean | string;
        zipCode?: string;
        city?: string;
        state?: string;
        country?: string;
        countryName?: string;
        website?: string;
        externalIdentifier?: string;
        isValid?: boolean | string;
        addressEmails?: Partial<SiteAddressAddressEmailsInput>[];
        addressLines?: Partial<SiteAddressAddressLinesInput>[];
        addressPhoneNumbers?: Partial<SiteAddressAddressPhoneNumbersInput>[];
    }
    export interface SiteAddressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        site: Site;
        code: string;
        description: string;
        defaultBankId: SiteBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<SiteAddressAddressEmailsBinding>;
        addressLines: ClientCollection<SiteAddressAddressLinesBinding>;
        addressPhoneNumbers: ClientCollection<SiteAddressAddressPhoneNumbersBinding>;
    }
    export interface SiteAddress$Lookups {
        site: QueryOperation<Site>;
        defaultBankId: QueryOperation<SiteBankDetail>;
        country: QueryOperation<Country>;
    }
    export interface SiteAddress$Operations {
        query: QueryOperation<SiteAddress>;
        read: ReadOperation<SiteAddress>;
        aggregate: {
            read: AggregateReadOperation<SiteAddress>;
            query: AggregateQueryOperation<SiteAddress>;
        };
        lookups(dataOrId: string | { data: SiteAddressInput }): SiteAddress$Lookups;
        getDefaults: GetDefaultsOperation<SiteAddress>;
    }
    export interface SiteBankDetail extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        site: Site;
        bankId: string;
        address: SiteAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface SiteBankDetailInput extends ClientNodeInput {
        entityType?: EntityType;
        site?: string;
        bankId?: string;
        address?: string;
        byDefault?: boolean | string;
        beneficiary?: string;
        payingBank1?: string;
        payingBank2?: string;
        payingBank3?: string;
        payingBank4?: string;
        ibanPrefix?: string;
        bic?: string;
        country?: string;
        currency?: string;
        intermediaryBankName?: string;
        intermediaryBankAddress1?: string;
        intermediaryBankAddress2?: string;
        intermediaryBankAddress3?: string;
        intermediaryBankBic?: string;
        intermediaryBankCountry?: string;
        nonResidentAccount?: boolean | string;
        isrCustomerNumber?: string;
    }
    export interface SiteBankDetailBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        site: Site;
        bankId: string;
        address: SiteAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface SiteBankDetail$Lookups {
        site: QueryOperation<Site>;
        address: QueryOperation<SiteAddress>;
        country: QueryOperation<Country>;
        currency: QueryOperation<Currency>;
        intermediaryBankCountry: QueryOperation<Country>;
    }
    export interface SiteBankDetail$Operations {
        query: QueryOperation<SiteBankDetail>;
        read: ReadOperation<SiteBankDetail>;
        aggregate: {
            read: AggregateReadOperation<SiteBankDetail>;
            query: AggregateQueryOperation<SiteBankDetail>;
        };
        lookups(dataOrId: string | { data: SiteBankDetailInput }): SiteBankDetail$Lookups;
        getDefaults: GetDefaultsOperation<SiteBankDetail>;
    }
    export interface SiteContact extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        site: Site;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface SiteContactInput extends ClientNodeInput {
        entityType?: EntityType;
        site?: string;
        code?: string;
        position?: FunctionContact;
        department?: string;
        role?: string;
        defaultAddress?: string;
        landline?: string;
        fax?: string;
        email?: string;
        cellPhone?: string;
        isDataProtectionOfficer?: boolean | string;
        contactRelationship?: string;
        addressLines?: Partial<ContactRelationshipAddressLinesInput>[];
        relationshipCellPhone?: string;
        relationshipCity?: string;
        relationshipCountry?: string;
        relationshipCountryName?: string;
        relationshipDateOfBirth?: string;
        relationshipEmail?: string;
        relationshipFax?: string;
        relationshipFirstName?: string;
        relationshipFullNameSearchKey?: string;
        relationshipIsMailingProhibited?: boolean | string;
        relationshipLandline?: string;
        relationshipLanguage?: string;
        relationshipLastName?: string;
        relationshipProfessionalCategory?: string;
        relationshipState?: string;
        relationshipTitle?: Title;
        relationshipType?: ContactType;
        relationshipZipCode?: string;
    }
    export interface SiteContactBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        site: Site;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface SiteContact$Lookups {
        site: QueryOperation<Site>;
        code: QueryOperation<ContactRelationship>;
        role: QueryOperation<MiscellaneousTable>;
        contactRelationship: QueryOperation<ContactRelationship>;
        relationshipCountry: QueryOperation<Country>;
        relationshipLanguage: QueryOperation<Language>;
        relationshipProfessionalCategory: QueryOperation<MiscellaneousTable>;
    }
    export interface SiteContact$Operations {
        query: QueryOperation<SiteContact>;
        read: ReadOperation<SiteContact>;
        aggregate: {
            read: AggregateReadOperation<SiteContact>;
            query: AggregateQueryOperation<SiteContact>;
        };
        lookups(dataOrId: string | { data: SiteContactInput }): SiteContact$Lookups;
        getDefaults: GetDefaultsOperation<SiteContact>;
    }
    export interface SupplierAddressAddressEmails extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        supplier: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface SupplierAddressAddressEmailsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        supplier?: string;
        code?: string;
        addressEmail?: string;
    }
    export interface SupplierAddressAddressEmailsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        supplier: string;
        code: string;
        addressEmail: string;
        emailType: EmailAddressType;
    }
    export interface SupplierAddressAddressEmails$Operations {
        query: QueryOperation<SupplierAddressAddressEmails>;
        read: ReadOperation<SupplierAddressAddressEmails>;
        aggregate: {
            read: AggregateReadOperation<SupplierAddressAddressEmails>;
            query: AggregateQueryOperation<SupplierAddressAddressEmails>;
        };
        getDefaults: GetDefaultsOperation<SupplierAddressAddressEmails>;
    }
    export interface SupplierAddressAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        supplier: string;
        code: string;
        addressLine: string;
    }
    export interface SupplierAddressAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        supplier?: string;
        code?: string;
        addressLine?: string;
    }
    export interface SupplierAddressAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        supplier: string;
        code: string;
        addressLine: string;
    }
    export interface SupplierAddressAddressLines$Operations {
        query: QueryOperation<SupplierAddressAddressLines>;
        read: ReadOperation<SupplierAddressAddressLines>;
        aggregate: {
            read: AggregateReadOperation<SupplierAddressAddressLines>;
            query: AggregateQueryOperation<SupplierAddressAddressLines>;
        };
        getDefaults: GetDefaultsOperation<SupplierAddressAddressLines>;
    }
    export interface SupplierAddressAddressPhoneNumbers extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        supplier: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface SupplierAddressAddressPhoneNumbersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        supplier?: string;
        code?: string;
        addressPhoneNumber?: string;
    }
    export interface SupplierAddressAddressPhoneNumbersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        supplier: string;
        code: string;
        addressPhoneNumber: string;
        phoneType: TelephoneType;
    }
    export interface SupplierAddressAddressPhoneNumbers$Operations {
        query: QueryOperation<SupplierAddressAddressPhoneNumbers>;
        read: ReadOperation<SupplierAddressAddressPhoneNumbers>;
        aggregate: {
            read: AggregateReadOperation<SupplierAddressAddressPhoneNumbers>;
            query: AggregateQueryOperation<SupplierAddressAddressPhoneNumbers>;
        };
        getDefaults: GetDefaultsOperation<SupplierAddressAddressPhoneNumbers>;
    }
    export interface SupplierAddress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        supplier: Supplier;
        code: string;
        description: string;
        defaultBankId: SupplierBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<SupplierAddressAddressEmails>;
        addressLines: ClientCollection<SupplierAddressAddressLines>;
        addressPhoneNumbers: ClientCollection<SupplierAddressAddressPhoneNumbers>;
    }
    export interface SupplierAddressInput extends ClientNodeInput {
        entityType?: EntityType;
        supplier?: string;
        code?: string;
        description?: string;
        defaultBankId?: string;
        isDefault?: boolean | string;
        zipCode?: string;
        city?: string;
        state?: string;
        country?: string;
        countryName?: string;
        website?: string;
        externalIdentifier?: string;
        isValid?: boolean | string;
        addressEmails?: Partial<SupplierAddressAddressEmailsInput>[];
        addressLines?: Partial<SupplierAddressAddressLinesInput>[];
        addressPhoneNumbers?: Partial<SupplierAddressAddressPhoneNumbersInput>[];
    }
    export interface SupplierAddressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        supplier: Supplier;
        code: string;
        description: string;
        defaultBankId: SupplierBankDetail;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        isValid: boolean;
        addressEmails: ClientCollection<SupplierAddressAddressEmailsBinding>;
        addressLines: ClientCollection<SupplierAddressAddressLinesBinding>;
        addressPhoneNumbers: ClientCollection<SupplierAddressAddressPhoneNumbersBinding>;
    }
    export interface SupplierAddress$Lookups {
        supplier: QueryOperation<Supplier>;
        defaultBankId: QueryOperation<SupplierBankDetail>;
        country: QueryOperation<Country>;
    }
    export interface SupplierAddress$Operations {
        query: QueryOperation<SupplierAddress>;
        read: ReadOperation<SupplierAddress>;
        aggregate: {
            read: AggregateReadOperation<SupplierAddress>;
            query: AggregateQueryOperation<SupplierAddress>;
        };
        lookups(dataOrId: string | { data: SupplierAddressInput }): SupplierAddress$Lookups;
        getDefaults: GetDefaultsOperation<SupplierAddress>;
    }
    export interface SupplierBankDetail extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        supplier: Supplier;
        bankId: string;
        address: SupplierAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface SupplierBankDetailInput extends ClientNodeInput {
        entityType?: EntityType;
        supplier?: string;
        bankId?: string;
        address?: string;
        byDefault?: boolean | string;
        beneficiary?: string;
        payingBank1?: string;
        payingBank2?: string;
        payingBank3?: string;
        payingBank4?: string;
        ibanPrefix?: string;
        bic?: string;
        country?: string;
        currency?: string;
        intermediaryBankName?: string;
        intermediaryBankAddress1?: string;
        intermediaryBankAddress2?: string;
        intermediaryBankAddress3?: string;
        intermediaryBankBic?: string;
        intermediaryBankCountry?: string;
        nonResidentAccount?: boolean | string;
        isrCustomerNumber?: string;
    }
    export interface SupplierBankDetailBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        supplier: Supplier;
        bankId: string;
        address: SupplierAddress;
        byDefault: boolean;
        beneficiary: string;
        payingBank1: string;
        payingBank2: string;
        payingBank3: string;
        payingBank4: string;
        ibanPrefix: string;
        bic: string;
        country: Country;
        currency: Currency;
        intermediaryBankName: string;
        intermediaryBankAddress1: string;
        intermediaryBankAddress2: string;
        intermediaryBankAddress3: string;
        intermediaryBankBic: string;
        intermediaryBankCountry: Country;
        nonResidentAccount: boolean;
        isrCustomerNumber: string;
    }
    export interface SupplierBankDetail$Lookups {
        supplier: QueryOperation<Supplier>;
        address: QueryOperation<SupplierAddress>;
        country: QueryOperation<Country>;
        currency: QueryOperation<Currency>;
        intermediaryBankCountry: QueryOperation<Country>;
    }
    export interface SupplierBankDetail$Operations {
        query: QueryOperation<SupplierBankDetail>;
        read: ReadOperation<SupplierBankDetail>;
        aggregate: {
            read: AggregateReadOperation<SupplierBankDetail>;
            query: AggregateQueryOperation<SupplierBankDetail>;
        };
        lookups(dataOrId: string | { data: SupplierBankDetailInput }): SupplierBankDetail$Lookups;
        getDefaults: GetDefaultsOperation<SupplierBankDetail>;
    }
    export interface SupplierCategory extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        currency: Currency;
    }
    export interface SupplierCategoryInput extends ClientNodeInput {
        code?: string;
        description?: string;
        currency?: string;
    }
    export interface SupplierCategoryBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        currency: Currency;
    }
    export interface SupplierCategory$Lookups {
        currency: QueryOperation<Currency>;
    }
    export interface SupplierCategory$Operations {
        query: QueryOperation<SupplierCategory>;
        read: ReadOperation<SupplierCategory>;
        aggregate: {
            read: AggregateReadOperation<SupplierCategory>;
            query: AggregateQueryOperation<SupplierCategory>;
        };
        lookups(dataOrId: string | { data: SupplierCategoryInput }): SupplierCategory$Lookups;
        getDefaults: GetDefaultsOperation<SupplierCategory>;
    }
    export interface SupplierContact extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        supplier: Supplier;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface SupplierContactInput extends ClientNodeInput {
        entityType?: EntityType;
        supplier?: string;
        code?: string;
        position?: FunctionContact;
        department?: string;
        role?: string;
        defaultAddress?: string;
        landline?: string;
        fax?: string;
        email?: string;
        cellPhone?: string;
        isDataProtectionOfficer?: boolean | string;
        contactRelationship?: string;
        addressLines?: Partial<ContactRelationshipAddressLinesInput>[];
        relationshipCellPhone?: string;
        relationshipCity?: string;
        relationshipCountry?: string;
        relationshipCountryName?: string;
        relationshipDateOfBirth?: string;
        relationshipEmail?: string;
        relationshipFax?: string;
        relationshipFirstName?: string;
        relationshipFullNameSearchKey?: string;
        relationshipIsMailingProhibited?: boolean | string;
        relationshipLandline?: string;
        relationshipLanguage?: string;
        relationshipLastName?: string;
        relationshipProfessionalCategory?: string;
        relationshipState?: string;
        relationshipTitle?: Title;
        relationshipType?: ContactType;
        relationshipZipCode?: string;
    }
    export interface SupplierContactBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        supplier: Supplier;
        code: ContactRelationship;
        position: FunctionContact;
        department: string;
        role: MiscellaneousTable;
        defaultAddress: string;
        landline: string;
        fax: string;
        email: string;
        cellPhone: string;
        isDataProtectionOfficer: boolean;
        contactRelationship: ContactRelationship;
        addressLines: ClientCollection<ContactRelationshipAddressLines>;
        relationshipCellPhone: string;
        relationshipCity: string;
        relationshipCountry: Country;
        relationshipCountryName: string;
        relationshipDateOfBirth: string;
        relationshipEmail: string;
        relationshipFax: string;
        relationshipFirstName: string;
        relationshipFullNameSearchKey: string;
        relationshipIsMailingProhibited: boolean;
        relationshipLandline: string;
        relationshipLanguage: Language;
        relationshipLastName: string;
        relationshipProfessionalCategory: MiscellaneousTable;
        relationshipState: string;
        relationshipTitle: Title;
        relationshipType: ContactType;
        relationshipZipCode: string;
    }
    export interface SupplierContact$Lookups {
        supplier: QueryOperation<Supplier>;
        code: QueryOperation<ContactRelationship>;
        role: QueryOperation<MiscellaneousTable>;
        contactRelationship: QueryOperation<ContactRelationship>;
        relationshipCountry: QueryOperation<Country>;
        relationshipLanguage: QueryOperation<Language>;
        relationshipProfessionalCategory: QueryOperation<MiscellaneousTable>;
    }
    export interface SupplierContact$Operations {
        query: QueryOperation<SupplierContact>;
        read: ReadOperation<SupplierContact>;
        aggregate: {
            read: AggregateReadOperation<SupplierContact>;
            query: AggregateQueryOperation<SupplierContact>;
        };
        lookups(dataOrId: string | { data: SupplierContactInput }): SupplierContact$Lookups;
        getDefaults: GetDefaultsOperation<SupplierContact>;
    }
    export interface SupplierProduct extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        supplier: BusinessPartner;
        priority: integer;
        supplierProduct: string;
        supplierProductDescription: string;
        supplierUpc: string;
        purchaseUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        packingUnit: UnitOfMeasure;
        packingUnitToPurchaseUnitConversionFactor: string;
        euStatisticsIncrease: string;
        minimumPurchaseQuantity: string;
        landingCostCoefficient: string;
        fixedCostPerUnit: string;
        qualityRank: integer;
        qualityControlManagementMode: SubjectToControl;
        isBackToBackOrder: boolean;
        configurationJournal: string;
        subcontractLeadTime: integer;
        qualityControlFrequency: integer;
        qualityControlNumberEntries: integer;
        qualityProcessIdFrequency: integer;
        qualityProcessIdEntries: integer;
        isVersionPreloaded: boolean;
        text1004082: boolean;
        text1004085: boolean;
        purchasingText: TextStream;
    }
    export interface SupplierProductInput extends ClientNodeInput {
        product?: string;
        supplier?: string;
        priority?: integer | string;
        supplierProduct?: string;
        supplierProductDescription?: string;
        supplierUpc?: string;
        purchaseUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        packingUnit?: string;
        packingUnitToPurchaseUnitConversionFactor?: decimal | string;
        euStatisticsIncrease?: decimal | string;
        minimumPurchaseQuantity?: decimal | string;
        landingCostCoefficient?: decimal | string;
        fixedCostPerUnit?: decimal | string;
        qualityRank?: integer | string;
        qualityControlManagementMode?: SubjectToControl;
        isBackToBackOrder?: boolean | string;
        configurationJournal?: string;
        subcontractLeadTime?: integer | string;
        qualityControlFrequency?: integer | string;
        qualityControlNumberEntries?: integer | string;
        qualityProcessIdFrequency?: integer | string;
        qualityProcessIdEntries?: integer | string;
        isVersionPreloaded?: boolean | string;
        text1004082?: boolean | string;
        text1004085?: boolean | string;
        purchasingText?: TextStream;
    }
    export interface SupplierProductBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        supplier: BusinessPartner;
        priority: integer;
        supplierProduct: string;
        supplierProductDescription: string;
        supplierUpc: string;
        purchaseUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        packingUnit: UnitOfMeasure;
        packingUnitToPurchaseUnitConversionFactor: string;
        euStatisticsIncrease: string;
        minimumPurchaseQuantity: string;
        landingCostCoefficient: string;
        fixedCostPerUnit: string;
        qualityRank: integer;
        qualityControlManagementMode: SubjectToControl;
        isBackToBackOrder: boolean;
        configurationJournal: string;
        subcontractLeadTime: integer;
        qualityControlFrequency: integer;
        qualityControlNumberEntries: integer;
        qualityProcessIdFrequency: integer;
        qualityProcessIdEntries: integer;
        isVersionPreloaded: boolean;
        text1004082: boolean;
        text1004085: boolean;
        purchasingText: TextStream;
    }
    export interface SupplierProduct$Lookups {
        product: QueryOperation<Product>;
        supplier: QueryOperation<BusinessPartner>;
        purchaseUnit: QueryOperation<UnitOfMeasure>;
        packingUnit: QueryOperation<UnitOfMeasure>;
    }
    export interface SupplierProduct$Operations {
        query: QueryOperation<SupplierProduct>;
        read: ReadOperation<SupplierProduct>;
        aggregate: {
            read: AggregateReadOperation<SupplierProduct>;
            query: AggregateQueryOperation<SupplierProduct>;
        };
        lookups(dataOrId: string | { data: SupplierProductInput }): SupplierProduct$Lookups;
        getDefaults: GetDefaultsOperation<SupplierProduct>;
    }
    export interface Supplier extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        category: SupplierCategory;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        groupSupplier: Supplier;
        riskSupplier: Supplier;
        ourCustomerNumberForSupplier: string;
        carrier: Carrier;
        defaultContact: SupplierContact;
        location: string;
        supplierABCClass: ProductAbcClass;
        rateType: ExchangeRateType;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        addressByDefault: SupplierAddress;
        isMultiLineOrder: boolean;
        leadTimeRankingCoefficient: string;
        priceRankingCoefficient: string;
        qualityRankingCoefficient: string;
        quantityRankingCoefficient: string;
        freeRankingCoefficient: string;
        leadTimeRanking: string;
        priceRanking: string;
        qualityRanking: string;
        quantityRanking: string;
        freeRanking: string;
        totalRanking: string;
        creditControl: WorkInProgressControl;
        intrastatIncreaseCoefficient: string;
        mustRemindDelivery: boolean;
        mustRemindAcknowledgment: boolean;
        isDas2Submitted: boolean;
        isActive: boolean;
        isPaymentHeld: boolean;
        mustPrintOrderForm: boolean;
        mustPrintReceiptNote: boolean;
        mustPrintReturnSlip: boolean;
        ourCustomerNameForSupplier: string;
        is281Submitted: boolean;
        amountType: PriceAmountTaxTax;
        isCashVat: boolean;
        cashVatDeadline: string;
        selfBillingCode: string;
        rexNumber: string;
        hasNoWhiteListVerification: boolean;
        isElectronicInvoicingAllowed: boolean;
        contact: SupplierContact;
        startDateForElectronicInvoice: string;
        addresses: ClientCollection<SupplierAddress>;
        contacts: ClientCollection<SupplierContact>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        purchaseOrderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        returnOrderText: TextStream;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
    }
    export interface SupplierInput extends ClientNodeInput {
        code?: string;
        category?: string;
        payToBusinessPartner?: string;
        payToBusinessPartnerAddress?: string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        groupSupplier?: string;
        riskSupplier?: string;
        ourCustomerNumberForSupplier?: string;
        carrier?: string;
        defaultContact?: string;
        location?: string;
        supplierABCClass?: ProductAbcClass;
        rateType?: ExchangeRateType;
        incoterm?: string;
        intrastatTransportLocation?: CountryLocation;
        addressByDefault?: string;
        isMultiLineOrder?: boolean | string;
        leadTimeRankingCoefficient?: decimal | string;
        priceRankingCoefficient?: decimal | string;
        qualityRankingCoefficient?: decimal | string;
        quantityRankingCoefficient?: decimal | string;
        freeRankingCoefficient?: decimal | string;
        leadTimeRanking?: decimal | string;
        priceRanking?: decimal | string;
        qualityRanking?: decimal | string;
        quantityRanking?: decimal | string;
        freeRanking?: decimal | string;
        totalRanking?: decimal | string;
        creditControl?: WorkInProgressControl;
        intrastatIncreaseCoefficient?: decimal | string;
        mustRemindDelivery?: boolean | string;
        mustRemindAcknowledgment?: boolean | string;
        isDas2Submitted?: boolean | string;
        isActive?: boolean | string;
        isPaymentHeld?: boolean | string;
        mustPrintOrderForm?: boolean | string;
        mustPrintReceiptNote?: boolean | string;
        mustPrintReturnSlip?: boolean | string;
        ourCustomerNameForSupplier?: string;
        is281Submitted?: boolean | string;
        amountType?: PriceAmountTaxTax;
        isCashVat?: boolean | string;
        cashVatDeadline?: string;
        selfBillingCode?: string;
        rexNumber?: string;
        hasNoWhiteListVerification?: boolean | string;
        isElectronicInvoicingAllowed?: boolean | string;
        contact?: string;
        startDateForElectronicInvoice?: string;
        addresses?: Partial<SupplierAddressInput>[];
        contacts?: Partial<SupplierContactInput>[];
        acronym?: string;
        businessPartnerSite?: string;
        cfonbPaymentMethod?: string;
        companyName1?: string;
        companyName2?: string;
        companyNames?: Partial<BusinessPartnerCompanyNamesInput>[];
        consolidationCode?: string;
        consolidationGroup?: string;
        consolidationPartner?: string;
        country?: string;
        customerOrSupplierOriginCategory?: string;
        documentType?: DocumentType;
        economicOperatorRegistrationAndIdNumber?: string;
        europeanUnionVatNumber?: string;
        fiscalCode?: string;
        isCashExcluded?: boolean | string;
        isIntersite?: boolean | string;
        isMailingProhibited?: boolean | string;
        isPhysicalPerson?: boolean | string;
        isPublicSector?: boolean | string;
        isServiceCaller?: boolean | string;
        isServiceSupplier?: boolean | string;
        italianTaxNumber?: string;
        language?: string;
        nonResidentAccount?: string;
        purchaseOrderText?: TextStream;
        registrationNumber?: string;
        relatedCompany?: RelatedCompanySettings;
        reportAccessCode?: string;
        returnOrderText?: TextStream;
        shortCompanyName?: string;
        siteIdentificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        vatNumber?: string;
    }
    export interface SupplierBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        category: SupplierCategory;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        groupSupplier: Supplier;
        riskSupplier: Supplier;
        ourCustomerNumberForSupplier: string;
        carrier: Carrier;
        defaultContact: SupplierContact;
        location: string;
        supplierABCClass: ProductAbcClass;
        rateType: ExchangeRateType;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        addressByDefault: SupplierAddress;
        isMultiLineOrder: boolean;
        leadTimeRankingCoefficient: string;
        priceRankingCoefficient: string;
        qualityRankingCoefficient: string;
        quantityRankingCoefficient: string;
        freeRankingCoefficient: string;
        leadTimeRanking: string;
        priceRanking: string;
        qualityRanking: string;
        quantityRanking: string;
        freeRanking: string;
        totalRanking: string;
        creditControl: WorkInProgressControl;
        intrastatIncreaseCoefficient: string;
        mustRemindDelivery: boolean;
        mustRemindAcknowledgment: boolean;
        isDas2Submitted: boolean;
        isActive: boolean;
        isPaymentHeld: boolean;
        mustPrintOrderForm: boolean;
        mustPrintReceiptNote: boolean;
        mustPrintReturnSlip: boolean;
        ourCustomerNameForSupplier: string;
        is281Submitted: boolean;
        amountType: PriceAmountTaxTax;
        isCashVat: boolean;
        cashVatDeadline: string;
        selfBillingCode: string;
        rexNumber: string;
        hasNoWhiteListVerification: boolean;
        isElectronicInvoicingAllowed: boolean;
        contact: SupplierContact;
        startDateForElectronicInvoice: string;
        addresses: ClientCollection<SupplierAddress>;
        contacts: ClientCollection<SupplierContact>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        purchaseOrderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        returnOrderText: TextStream;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
    }
    export interface Supplier$Lookups {
        code: QueryOperation<BusinessPartner>;
        category: QueryOperation<SupplierCategory>;
        payToBusinessPartner: QueryOperation<BusinessPartner>;
        payToBusinessPartnerAddress: QueryOperation<BusinessPartnerAddress>;
        billBySupplier: QueryOperation<Supplier>;
        billBySupplierAddress: QueryOperation<SupplierAddress>;
        groupSupplier: QueryOperation<Supplier>;
        riskSupplier: QueryOperation<Supplier>;
        carrier: QueryOperation<Carrier>;
        defaultContact: QueryOperation<SupplierContact>;
        incoterm: QueryOperation<Incoterm>;
        addressByDefault: QueryOperation<SupplierAddress>;
        contact: QueryOperation<SupplierContact>;
        businessPartnerSite: QueryOperation<Site>;
        cfonbPaymentMethod: QueryOperation<MiscellaneousTable>;
        consolidationGroup: QueryOperation<SiteGroupings>;
        consolidationPartner: QueryOperation<BusinessPartner>;
        country: QueryOperation<Country>;
        language: QueryOperation<Language>;
        nonResidentAccount: QueryOperation<BusinessPartnerAddress>;
        reportAccessCode: QueryOperation<Access>;
    }
    export interface Supplier$Operations {
        query: QueryOperation<Supplier>;
        read: ReadOperation<Supplier>;
        aggregate: {
            read: AggregateReadOperation<Supplier>;
            query: AggregateQueryOperation<Supplier>;
        };
        lookups(dataOrId: string | { data: SupplierInput }): Supplier$Lookups;
        getDefaults: GetDefaultsOperation<Supplier>;
    }
    export interface TechnicalSheet extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        technicalSheet: string;
        lineNumber: integer;
        localizedDescription: string;
        sequence: integer;
    }
    export interface TechnicalSheetInput extends ClientNodeInput {
        technicalSheet?: string;
        lineNumber?: integer | string;
        localizedDescription?: string;
        sequence?: integer | string;
    }
    export interface TechnicalSheetBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        technicalSheet: string;
        lineNumber: integer;
        localizedDescription: string;
        sequence: integer;
    }
    export interface TechnicalSheet$Operations {
        query: QueryOperation<TechnicalSheet>;
        read: ReadOperation<TechnicalSheet>;
        aggregate: {
            read: AggregateReadOperation<TechnicalSheet>;
            query: AggregateQueryOperation<TechnicalSheet>;
        };
        getDefaults: GetDefaultsOperation<TechnicalSheet>;
    }
    export interface TimeTableSchemaTimes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        startTime: string;
        endTime: string;
    }
    export interface TimeTableSchemaTimesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        startTime?: string;
        endTime?: string;
    }
    export interface TimeTableSchemaTimesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        startTime: string;
        endTime: string;
    }
    export interface TimeTableSchemaTimes$Operations {
        query: QueryOperation<TimeTableSchemaTimes>;
        read: ReadOperation<TimeTableSchemaTimes>;
        aggregate: {
            read: AggregateReadOperation<TimeTableSchemaTimes>;
            query: AggregateQueryOperation<TimeTableSchemaTimes>;
        };
        getDefaults: GetDefaultsOperation<TimeTableSchemaTimes>;
    }
    export interface TimeTableSchema extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        shortDescription: string;
        times: ClientCollection<TimeTableSchemaTimes>;
    }
    export interface TimeTableSchemaInput extends ClientNodeInput {
        code?: string;
        description?: string;
        shortDescription?: string;
        times?: Partial<TimeTableSchemaTimesInput>[];
    }
    export interface TimeTableSchemaBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        shortDescription: string;
        times: ClientCollection<TimeTableSchemaTimesBinding>;
    }
    export interface TimeTableSchema$Operations {
        query: QueryOperation<TimeTableSchema>;
        read: ReadOperation<TimeTableSchema>;
        aggregate: {
            read: AggregateReadOperation<TimeTableSchema>;
            query: AggregateQueryOperation<TimeTableSchema>;
        };
        getDefaults: GetDefaultsOperation<TimeTableSchema>;
    }
    export interface TransitAreaAddressAddressEmails extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        transitArea: string;
        code: string;
        addressEmail: string;
    }
    export interface TransitAreaAddressAddressEmailsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        transitArea?: string;
        code?: string;
        addressEmail?: string;
    }
    export interface TransitAreaAddressAddressEmailsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        transitArea: string;
        code: string;
        addressEmail: string;
    }
    export interface TransitAreaAddressAddressEmails$Operations {
        query: QueryOperation<TransitAreaAddressAddressEmails>;
        read: ReadOperation<TransitAreaAddressAddressEmails>;
        aggregate: {
            read: AggregateReadOperation<TransitAreaAddressAddressEmails>;
            query: AggregateQueryOperation<TransitAreaAddressAddressEmails>;
        };
        getDefaults: GetDefaultsOperation<TransitAreaAddressAddressEmails>;
    }
    export interface TransitAreaAddressAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        transitArea: string;
        code: string;
        addressLine: string;
    }
    export interface TransitAreaAddressAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        transitArea?: string;
        code?: string;
        addressLine?: string;
    }
    export interface TransitAreaAddressAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        transitArea: string;
        code: string;
        addressLine: string;
    }
    export interface TransitAreaAddressAddressLines$Operations {
        query: QueryOperation<TransitAreaAddressAddressLines>;
        read: ReadOperation<TransitAreaAddressAddressLines>;
        aggregate: {
            read: AggregateReadOperation<TransitAreaAddressAddressLines>;
            query: AggregateQueryOperation<TransitAreaAddressAddressLines>;
        };
        getDefaults: GetDefaultsOperation<TransitAreaAddressAddressLines>;
    }
    export interface TransitAreaAddressAddressPhoneNumbers extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        transitArea: string;
        code: string;
        addressPhoneNumber: string;
    }
    export interface TransitAreaAddressAddressPhoneNumbersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        entityType?: EntityType;
        transitArea?: string;
        code?: string;
        addressPhoneNumber?: string;
    }
    export interface TransitAreaAddressAddressPhoneNumbersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        entityType: EntityType;
        transitArea: string;
        code: string;
        addressPhoneNumber: string;
    }
    export interface TransitAreaAddressAddressPhoneNumbers$Operations {
        query: QueryOperation<TransitAreaAddressAddressPhoneNumbers>;
        read: ReadOperation<TransitAreaAddressAddressPhoneNumbers>;
        aggregate: {
            read: AggregateReadOperation<TransitAreaAddressAddressPhoneNumbers>;
            query: AggregateQueryOperation<TransitAreaAddressAddressPhoneNumbers>;
        };
        getDefaults: GetDefaultsOperation<TransitAreaAddressAddressPhoneNumbers>;
    }
    export interface TransitAreaAddress extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        transitArea: TransitArea;
        code: string;
        description: string;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        addressEmails: ClientCollection<TransitAreaAddressAddressEmails>;
        addressLines: ClientCollection<TransitAreaAddressAddressLines>;
        addressPhoneNumbers: ClientCollection<TransitAreaAddressAddressPhoneNumbers>;
    }
    export interface TransitAreaAddressInput extends ClientNodeInput {
        entityType?: EntityType;
        transitArea?: string;
        code?: string;
        description?: string;
        isDefault?: boolean | string;
        zipCode?: string;
        city?: string;
        state?: string;
        country?: string;
        countryName?: string;
        website?: string;
        externalIdentifier?: string;
        addressEmails?: Partial<TransitAreaAddressAddressEmailsInput>[];
        addressLines?: Partial<TransitAreaAddressAddressLinesInput>[];
        addressPhoneNumbers?: Partial<TransitAreaAddressAddressPhoneNumbersInput>[];
    }
    export interface TransitAreaAddressBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entityType: EntityType;
        transitArea: TransitArea;
        code: string;
        description: string;
        isDefault: boolean;
        zipCode: string;
        city: string;
        state: string;
        country: Country;
        countryName: string;
        website: string;
        externalIdentifier: string;
        addressEmails: ClientCollection<TransitAreaAddressAddressEmailsBinding>;
        addressLines: ClientCollection<TransitAreaAddressAddressLinesBinding>;
        addressPhoneNumbers: ClientCollection<TransitAreaAddressAddressPhoneNumbersBinding>;
    }
    export interface TransitAreaAddress$Lookups {
        transitArea: QueryOperation<TransitArea>;
        country: QueryOperation<Country>;
    }
    export interface TransitAreaAddress$Operations {
        query: QueryOperation<TransitAreaAddress>;
        read: ReadOperation<TransitAreaAddress>;
        aggregate: {
            read: AggregateReadOperation<TransitAreaAddress>;
            query: AggregateQueryOperation<TransitAreaAddress>;
        };
        lookups(dataOrId: string | { data: TransitAreaAddressInput }): TransitAreaAddress$Lookups;
        getDefaults: GetDefaultsOperation<TransitAreaAddress>;
    }
    export interface TransitArea extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        placeType: PlaceType;
        longDescription: string;
        shortDescription: string;
        releaseTime: integer;
        site: Site;
        supplier: Supplier;
        transitAreaAddress: TransitAreaAddress;
        isActive: boolean;
    }
    export interface TransitAreaInput extends ClientNodeInput {
        code?: string;
        placeType?: PlaceType;
        longDescription?: string;
        shortDescription?: string;
        releaseTime?: integer | string;
        site?: string;
        supplier?: string;
        transitAreaAddress?: string;
        isActive?: boolean | string;
    }
    export interface TransitAreaBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        placeType: PlaceType;
        longDescription: string;
        shortDescription: string;
        releaseTime: integer;
        site: Site;
        supplier: Supplier;
        transitAreaAddress: TransitAreaAddress;
        isActive: boolean;
    }
    export interface TransitArea$Lookups {
        site: QueryOperation<Site>;
        supplier: QueryOperation<Supplier>;
        transitAreaAddress: QueryOperation<TransitAreaAddress>;
    }
    export interface TransitArea$Operations {
        query: QueryOperation<TransitArea>;
        read: ReadOperation<TransitArea>;
        aggregate: {
            read: AggregateReadOperation<TransitArea>;
            query: AggregateQueryOperation<TransitArea>;
        };
        lookups(dataOrId: string | { data: TransitAreaInput }): TransitArea$Lookups;
        getDefaults: GetDefaultsOperation<TransitArea>;
    }
    export interface UnavailablePeriodsLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        startDate: string;
        endDate: string;
        dateDescription: string;
    }
    export interface UnavailablePeriodsLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        startDate?: string;
        endDate?: string;
        dateDescription?: string;
    }
    export interface UnavailablePeriodsLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        startDate: string;
        endDate: string;
        dateDescription: string;
    }
    export interface UnavailablePeriodsLines$Operations {
        query: QueryOperation<UnavailablePeriodsLines>;
        read: ReadOperation<UnavailablePeriodsLines>;
        aggregate: {
            read: AggregateReadOperation<UnavailablePeriodsLines>;
            query: AggregateQueryOperation<UnavailablePeriodsLines>;
        };
        getDefaults: GetDefaultsOperation<UnavailablePeriodsLines>;
    }
    export interface UnavailablePeriods extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        siteCompanyGroup: SiteGroupings;
        lines: ClientCollection<UnavailablePeriodsLines>;
    }
    export interface UnavailablePeriodsInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        siteCompanyGroup?: string;
        lines?: Partial<UnavailablePeriodsLinesInput>[];
    }
    export interface UnavailablePeriodsBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        siteCompanyGroup: SiteGroupings;
        lines: ClientCollection<UnavailablePeriodsLinesBinding>;
    }
    export interface UnavailablePeriods$Lookups {
        siteCompanyGroup: QueryOperation<SiteGroupings>;
    }
    export interface UnavailablePeriods$Operations {
        query: QueryOperation<UnavailablePeriods>;
        read: ReadOperation<UnavailablePeriods>;
        aggregate: {
            read: AggregateReadOperation<UnavailablePeriods>;
            query: AggregateQueryOperation<UnavailablePeriods>;
        };
        lookups(dataOrId: string | { data: UnavailablePeriodsInput }): UnavailablePeriods$Lookups;
        getDefaults: GetDefaultsOperation<UnavailablePeriods>;
    }
    export interface UnitOfMeasure extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        numberOfDecimals: integer;
        unitType: UnitType;
        codeCeeOnu: MiscellaneousTable;
    }
    export interface UnitOfMeasureInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        numberOfDecimals?: integer | string;
        unitType?: UnitType;
        codeCeeOnu?: string;
    }
    export interface UnitOfMeasureBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
        numberOfDecimals: integer;
        unitType: UnitType;
        codeCeeOnu: MiscellaneousTable;
    }
    export interface UnitOfMeasure$Lookups {
        codeCeeOnu: QueryOperation<MiscellaneousTable>;
    }
    export interface UnitOfMeasure$Operations {
        query: QueryOperation<UnitOfMeasure>;
        read: ReadOperation<UnitOfMeasure>;
        aggregate: {
            read: AggregateReadOperation<UnitOfMeasure>;
            query: AggregateQueryOperation<UnitOfMeasure>;
        };
        lookups(dataOrId: string | { data: UnitOfMeasureInput }): UnitOfMeasure$Lookups;
        getDefaults: GetDefaultsOperation<UnitOfMeasure>;
    }
    export interface WeeklyStructureWeeklyStructureDailyCapacity extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        dailyCapicity: string;
        timeTableSchema: TimeTableSchema;
        capacityDayName: string;
    }
    export interface WeeklyStructureWeeklyStructureDailyCapacityInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        code?: string;
        dailyCapicity?: decimal | string;
        timeTableSchema?: string;
    }
    export interface WeeklyStructureWeeklyStructureDailyCapacityBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        code: string;
        dailyCapicity: string;
        timeTableSchema: TimeTableSchema;
        capacityDayName: string;
    }
    export interface WeeklyStructureWeeklyStructureDailyCapacity$Lookups {
        timeTableSchema: QueryOperation<TimeTableSchema>;
    }
    export interface WeeklyStructureWeeklyStructureDailyCapacity$Operations {
        query: QueryOperation<WeeklyStructureWeeklyStructureDailyCapacity>;
        read: ReadOperation<WeeklyStructureWeeklyStructureDailyCapacity>;
        aggregate: {
            read: AggregateReadOperation<WeeklyStructureWeeklyStructureDailyCapacity>;
            query: AggregateQueryOperation<WeeklyStructureWeeklyStructureDailyCapacity>;
        };
        lookups(
            dataOrId: string | { data: WeeklyStructureWeeklyStructureDailyCapacityInput },
        ): WeeklyStructureWeeklyStructureDailyCapacity$Lookups;
        getDefaults: GetDefaultsOperation<WeeklyStructureWeeklyStructureDailyCapacity>;
    }
    export interface WeeklyStructure extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        standardCapicity: string;
        localizedDescription: string;
        localizedShortDescription: string;
        weeklyStructureDailyCapacity: ClientCollection<WeeklyStructureWeeklyStructureDailyCapacity>;
        weeklyCapacity: string;
    }
    export interface WeeklyStructureInput extends ClientNodeInput {
        code?: string;
        standardCapicity?: decimal | string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        weeklyStructureDailyCapacity?: Partial<WeeklyStructureWeeklyStructureDailyCapacityInput>[];
    }
    export interface WeeklyStructureBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        standardCapicity: string;
        localizedDescription: string;
        localizedShortDescription: string;
        weeklyStructureDailyCapacity: ClientCollection<WeeklyStructureWeeklyStructureDailyCapacityBinding>;
        weeklyCapacity: string;
    }
    export interface WeeklyStructure$Operations {
        query: QueryOperation<WeeklyStructure>;
        read: ReadOperation<WeeklyStructure>;
        aggregate: {
            read: AggregateReadOperation<WeeklyStructure>;
            query: AggregateQueryOperation<WeeklyStructure>;
        };
        getDefaults: GetDefaultsOperation<WeeklyStructure>;
    }
    export interface CompanyExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortDescription: string;
        isLegalCompany: boolean;
        legislation: MiscellaneousTable;
        logo: Image;
        serviceId: string;
        addresses: ClientCollection<CompanyAddress>;
        contacts: ClientCollection<CompanyContact>;
        bankDetails: ClientCollection<CompanyBankDetail>;
    }
    export interface CompanyInputExtension {
        code?: string;
        name?: string;
        shortDescription?: string;
        isLegalCompany?: boolean | string;
        legislation?: string;
        logo?: string;
        serviceId?: string;
        addresses?: Partial<CompanyAddressInput>[];
        contacts?: Partial<CompanyContactInput>[];
        bankDetails?: Partial<CompanyBankDetailInput>[];
    }
    export interface CompanyBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        shortDescription: string;
        isLegalCompany: boolean;
        legislation: MiscellaneousTable;
        logo: Image;
        serviceId: string;
        addresses: ClientCollection<CompanyAddress>;
        contacts: ClientCollection<CompanyContact>;
        bankDetails: ClientCollection<CompanyBankDetail>;
    }
    export interface GenericPrintReportExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        reportName: string;
    }
    export interface GenericPrintReportInputExtension {
        reportName?: string;
    }
    export interface GenericPrintReportBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        reportName: string;
    }
    export interface GenericPrintReportExtension$Mutations {
        printReport: Node$Operation<
            {
                parameters?: {
                    reportName: string;
                    language: string;
                    destination: string;
                    parametersNames: string[];
                    parametersValues: string[];
                    errorCode: integer | string;
                };
            },
            {
                errorCode: integer;
            }
        >;
    }
    export interface GenericPrintReportExtension$Operations {
        mutations: GenericPrintReportExtension$Mutations;
        getDefaults: GetDefaultsOperation<GenericPrintReport>;
    }
    export interface SiteExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        isManufacturing: boolean;
        isStockSite: boolean;
        legalCompany: Company;
        unavailabilityCode: UnavailablePeriods;
        routingCode: string;
        electronicAddress: string;
        addresses: ClientCollection<SiteAddress>;
        contacts: ClientCollection<SiteContact>;
        bankDetails: ClientCollection<SiteBankDetail>;
    }
    export interface SiteInputExtension {
        code?: string;
        name?: string;
        isManufacturing?: boolean | string;
        isStockSite?: boolean | string;
        legalCompany?: string;
        unavailabilityCode?: string;
        routingCode?: string;
        electronicAddress?: string;
        addresses?: Partial<SiteAddressInput>[];
        contacts?: Partial<SiteContactInput>[];
        bankDetails?: Partial<SiteBankDetailInput>[];
    }
    export interface SiteBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        name: string;
        isManufacturing: boolean;
        isStockSite: boolean;
        legalCompany: Company;
        unavailabilityCode: UnavailablePeriods;
        routingCode: string;
        electronicAddress: string;
        addresses: ClientCollection<SiteAddress>;
        contacts: ClientCollection<SiteContact>;
        bankDetails: ClientCollection<SiteBankDetail>;
    }
    export interface SiteExtension$Lookups {
        unavailabilityCode: QueryOperation<UnavailablePeriods>;
    }
    export interface SiteExtension$Operations {
        lookups(dataOrId: string | { data: SiteInput }): SiteExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-master-data/AddressAddressEmails': AddressAddressEmails$Operations;
        '@sage/x3-master-data/AddressAddressLines': AddressAddressLines$Operations;
        '@sage/x3-master-data/AddressAddressPhoneNumbers': AddressAddressPhoneNumbers$Operations;
        '@sage/x3-master-data/Address': Address$Operations;
        '@sage/x3-master-data/BankDetail': BankDetail$Operations;
        '@sage/x3-master-data/BomCodes': BomCodes$Operations;
        '@sage/x3-master-data/BomDetail': BomDetail$Operations;
        '@sage/x3-master-data/BomHeader': BomHeader$Operations;
        '@sage/x3-master-data/BomProduct': BomProduct$Operations;
        '@sage/x3-master-data/BomRouting': BomRouting$Operations;
        '@sage/x3-master-data/BusinessPartnerAddressAddressEmails': BusinessPartnerAddressAddressEmails$Operations;
        '@sage/x3-master-data/BusinessPartnerAddressAddressLines': BusinessPartnerAddressAddressLines$Operations;
        '@sage/x3-master-data/BusinessPartnerAddressAddressPhoneNumbers': BusinessPartnerAddressAddressPhoneNumbers$Operations;
        '@sage/x3-master-data/BusinessPartnerAddress': BusinessPartnerAddress$Operations;
        '@sage/x3-master-data/BusinessPartnerBankDetail': BusinessPartnerBankDetail$Operations;
        '@sage/x3-master-data/BusinessPartnerCompanyException': BusinessPartnerCompanyException$Operations;
        '@sage/x3-master-data/BusinessPartnerCompanyNames': BusinessPartnerCompanyNames$Operations;
        '@sage/x3-master-data/BusinessPartnerContact': BusinessPartnerContact$Operations;
        '@sage/x3-master-data/BusinessPartner': BusinessPartner$Operations;
        '@sage/x3-master-data/Carrier': Carrier$Operations;
        '@sage/x3-master-data/CommonImage': CommonImage$Operations;
        '@sage/x3-master-data/CommonText': CommonText$Operations;
        '@sage/x3-master-data/CompanyAddressAddressEmails': CompanyAddressAddressEmails$Operations;
        '@sage/x3-master-data/CompanyAddressAddressLines': CompanyAddressAddressLines$Operations;
        '@sage/x3-master-data/CompanyAddressAddressPhoneNumbers': CompanyAddressAddressPhoneNumbers$Operations;
        '@sage/x3-master-data/CompanyAddress': CompanyAddress$Operations;
        '@sage/x3-master-data/CompanyBankDetail': CompanyBankDetail$Operations;
        '@sage/x3-master-data/CompanyContact': CompanyContact$Operations;
        '@sage/x3-master-data/ContactRelationshipAddressLines': ContactRelationshipAddressLines$Operations;
        '@sage/x3-master-data/ContactRelationship': ContactRelationship$Operations;
        '@sage/x3-master-data/Contact': Contact$Operations;
        '@sage/x3-master-data/Container': Container$Operations;
        '@sage/x3-master-data/CurrencyRate': CurrencyRate$Operations;
        '@sage/x3-master-data/Currency': Currency$Operations;
        '@sage/x3-master-data/CustomerAddressAddressEmails': CustomerAddressAddressEmails$Operations;
        '@sage/x3-master-data/CustomerAddressAddressLines': CustomerAddressAddressLines$Operations;
        '@sage/x3-master-data/CustomerAddressAddressPhoneNumbers': CustomerAddressAddressPhoneNumbers$Operations;
        '@sage/x3-master-data/CustomerAddress': CustomerAddress$Operations;
        '@sage/x3-master-data/CustomerBankDetail': CustomerBankDetail$Operations;
        '@sage/x3-master-data/CustomerCashTaxRules': CustomerCashTaxRules$Operations;
        '@sage/x3-master-data/CustomerCategory': CustomerCategory$Operations;
        '@sage/x3-master-data/CustomerContact': CustomerContact$Operations;
        '@sage/x3-master-data/CustomerPaymentDays': CustomerPaymentDays$Operations;
        '@sage/x3-master-data/CustomerProduct': CustomerProduct$Operations;
        '@sage/x3-master-data/CustomerSalesReps': CustomerSalesReps$Operations;
        '@sage/x3-master-data/CustomerStatisticalGroups': CustomerStatisticalGroups$Operations;
        '@sage/x3-master-data/Customer': Customer$Operations;
        '@sage/x3-master-data/Incoterm': Incoterm$Operations;
        '@sage/x3-master-data/Mapping': Mapping$Operations;
        '@sage/x3-master-data/MobileAutomationSetup': MobileAutomationSetup$Operations;
        '@sage/x3-master-data/PrintTemplate': PrintTemplate$Operations;
        '@sage/x3-master-data/ProductCategoryStatisticalGroups': ProductCategoryStatisticalGroups$Operations;
        '@sage/x3-master-data/ProductCategory': ProductCategory$Operations;
        '@sage/x3-master-data/ProductPackingUnits': ProductPackingUnits$Operations;
        '@sage/x3-master-data/ProductSite': ProductSite$Operations;
        '@sage/x3-master-data/ProductStatisticalGroups': ProductStatisticalGroups$Operations;
        '@sage/x3-master-data/ProductVersion': ProductVersion$Operations;
        '@sage/x3-master-data/Product': Product$Operations;
        '@sage/x3-master-data/ProspectAddressAddressEmails': ProspectAddressAddressEmails$Operations;
        '@sage/x3-master-data/ProspectAddressAddressLines': ProspectAddressAddressLines$Operations;
        '@sage/x3-master-data/ProspectAddressAddressPhoneNumbers': ProspectAddressAddressPhoneNumbers$Operations;
        '@sage/x3-master-data/ProspectAddress': ProspectAddress$Operations;
        '@sage/x3-master-data/ProspectContact': ProspectContact$Operations;
        '@sage/x3-master-data/ProspectSalesReps': ProspectSalesReps$Operations;
        '@sage/x3-master-data/ProspectStatisticalGroups': ProspectStatisticalGroups$Operations;
        '@sage/x3-master-data/Prospect': Prospect$Operations;
        '@sage/x3-master-data/SalesRep': SalesRep$Operations;
        '@sage/x3-master-data/ShipToCustomerAddressCompanyNames': ShipToCustomerAddressCompanyNames$Operations;
        '@sage/x3-master-data/ShipToCustomerAddressSalesReps': ShipToCustomerAddressSalesReps$Operations;
        '@sage/x3-master-data/ShipToCustomerAddress': ShipToCustomerAddress$Operations;
        '@sage/x3-master-data/SiteAddressAddressEmails': SiteAddressAddressEmails$Operations;
        '@sage/x3-master-data/SiteAddressAddressLines': SiteAddressAddressLines$Operations;
        '@sage/x3-master-data/SiteAddressAddressPhoneNumbers': SiteAddressAddressPhoneNumbers$Operations;
        '@sage/x3-master-data/SiteAddress': SiteAddress$Operations;
        '@sage/x3-master-data/SiteBankDetail': SiteBankDetail$Operations;
        '@sage/x3-master-data/SiteContact': SiteContact$Operations;
        '@sage/x3-master-data/SupplierAddressAddressEmails': SupplierAddressAddressEmails$Operations;
        '@sage/x3-master-data/SupplierAddressAddressLines': SupplierAddressAddressLines$Operations;
        '@sage/x3-master-data/SupplierAddressAddressPhoneNumbers': SupplierAddressAddressPhoneNumbers$Operations;
        '@sage/x3-master-data/SupplierAddress': SupplierAddress$Operations;
        '@sage/x3-master-data/SupplierBankDetail': SupplierBankDetail$Operations;
        '@sage/x3-master-data/SupplierCategory': SupplierCategory$Operations;
        '@sage/x3-master-data/SupplierContact': SupplierContact$Operations;
        '@sage/x3-master-data/SupplierProduct': SupplierProduct$Operations;
        '@sage/x3-master-data/Supplier': Supplier$Operations;
        '@sage/x3-master-data/TechnicalSheet': TechnicalSheet$Operations;
        '@sage/x3-master-data/TimeTableSchemaTimes': TimeTableSchemaTimes$Operations;
        '@sage/x3-master-data/TimeTableSchema': TimeTableSchema$Operations;
        '@sage/x3-master-data/TransitAreaAddressAddressEmails': TransitAreaAddressAddressEmails$Operations;
        '@sage/x3-master-data/TransitAreaAddressAddressLines': TransitAreaAddressAddressLines$Operations;
        '@sage/x3-master-data/TransitAreaAddressAddressPhoneNumbers': TransitAreaAddressAddressPhoneNumbers$Operations;
        '@sage/x3-master-data/TransitAreaAddress': TransitAreaAddress$Operations;
        '@sage/x3-master-data/TransitArea': TransitArea$Operations;
        '@sage/x3-master-data/UnavailablePeriodsLines': UnavailablePeriodsLines$Operations;
        '@sage/x3-master-data/UnavailablePeriods': UnavailablePeriods$Operations;
        '@sage/x3-master-data/UnitOfMeasure': UnitOfMeasure$Operations;
        '@sage/x3-master-data/WeeklyStructureWeeklyStructureDailyCapacity': WeeklyStructureWeeklyStructureDailyCapacity$Operations;
        '@sage/x3-master-data/WeeklyStructure': WeeklyStructure$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-master-data-api' {
    export type * from '@sage/x3-master-data-api-partial';
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-master-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-master-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-master-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-master-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type {
        CompanyBindingExtension,
        CompanyExtension,
        CompanyInputExtension,
        GenericPrintReportBindingExtension,
        GenericPrintReportExtension,
        GenericPrintReportExtension$Mutations,
        GenericPrintReportExtension$Operations,
        GenericPrintReportInputExtension,
        SiteBindingExtension,
        SiteExtension,
        SiteExtension$Lookups,
        SiteExtension$Operations,
        SiteInputExtension,
    } from '@sage/x3-master-data-api';
    export interface Company extends CompanyExtension {}
    export interface CompanyBinding extends CompanyBindingExtension {}
    export interface CompanyInput extends CompanyInputExtension {}
    export interface GenericPrintReport extends GenericPrintReportExtension {}
    export interface GenericPrintReportBinding extends GenericPrintReportBindingExtension {}
    export interface GenericPrintReportInput extends GenericPrintReportInputExtension {}
    export interface GenericPrintReport$Mutations extends GenericPrintReportExtension$Mutations {}
    export interface GenericPrintReport$Operations extends GenericPrintReportExtension$Operations {}
    export interface Site extends SiteExtension {}
    export interface SiteBinding extends SiteBindingExtension {}
    export interface SiteInput extends SiteInputExtension {}
    export interface Site$Lookups extends SiteExtension$Lookups {}
    export interface Site$Operations extends SiteExtension$Operations {}
}
