import { ProductSite } from '@sage/x3-master-data-api';
import { MobileMaterialsConsumptionDetails } from '../mobile-materials-consumption-details';

export class ProductSiteData {
    constructor(productCode: string, site: string, page: MobileMaterialsConsumptionDetails) {
        this.product = productCode;
        this.site = site;
        this.page = page;
    }

    private page: MobileMaterialsConsumptionDetails;
    private product: string;
    private site: string;
    private _productSite: ProductSite;

    private async _lazyLoadProductSite(): Promise<ProductSite | null> {
        if (this._productSite) {
            return this._productSite;
        }

        // read product site record
        try {
            const productSiteToReceive = (await this.page.$.graph
                .node('@sage/x3-master-data/ProductSite')
                .read(
                    {
                        isLocationManaged: true,
                        isLicensePlateNumberManaged: true,
                        stockSite: {
                            code: true,
                        },
                        product: {
                            code: true,
                            productCategory: { code: true },
                            serialNumberManagementMode: true,
                            serialSequenceNumber: true,
                            localizedDescription1: true,
                            lotManagementMode: true,
                            lotSequenceNumber: true,
                            stockVersionMode: true,
                            expirationManagementMode: true,
                            stockManagementMode: true,
                            defaultPotencyInPercentage: true,
                            useByDateCoefficient: true,
                            expirationLeadTime: true,
                            expirationTimeUnit: true,
                            stockUnit: {
                                code: true,
                                numberOfDecimals: true,
                            },
                        },
                    },
                    `${this.product}|${this.site}`,
                )
                .execute()) as ProductSite;
            this._productSite = productSiteToReceive;
        } catch (e) {
            this.page.$.dialog.message('error', 'Error loading product-site.', String(e));
            return null;
        }
        return this._productSite;
    }

    get productSite() {
        return this._lazyLoadProductSite();
    }
}
