import { GeneralParameter } from '@sage/x3-system-api';
import { extractEdges, ExtractEdges } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';

export async function readParameterValue(
    parameter: string,
    user: string,
    stockSite: string,
    pageInstance: ui.Page,
): Promise<string> {
    try {
        // Note that all parameter values are stored as strings.  They can have different meanings such as a local menu option.
        let resp: string = '';
        // Check parameter level
        const response = extractEdges(
            await pageInstance.$.graph
                .node('@sage/x3-system/GeneralParameter')
                .query(
                    ui.queryUtils.edgesSelector(
                        {
                            _id: true,
                            definitionLevel: true,
                        },
                        {
                            filter: {
                                code: parameter,
                            },
                        },
                    ),
                )
                .execute(),
        ) as ExtractEdges<GeneralParameter[]>;
        // Call appropriate function depending on parameter level
        if (response[0].definitionLevel == 'user') {
            resp = (await pageInstance.$.graph
                .node('@sage/x3-system/GeneralParameter')
                .queries.getGeneralParameterUserValue(true, {
                    user: user,
                    site: stockSite,
                    parameter: parameter,
                })
                .execute()) as string;
        } else {
            resp = (await pageInstance.$.graph
                .node('@sage/x3-system/GeneralParameter')
                .queries.getGeneralParameterValue(true, {
                    code: stockSite,
                    parameter: parameter,
                })
                .execute()) as string;
        }
        return resp;
    } catch (e) {
        pageInstance.$.dialog.message(
            'error',
            ui.localize('@sage/x3-manufacturing/dialog-error-title', 'Error'),
            ui.localize(
                '@sage/x3-manufacturing/utils-error-reading-parameter-value',
                'Error reading parameter value: {{ param }}',
                { param: parameter },
            ),
        );
        return '';
    }
}
