import * as ui from '@sage/xtrem-ui';

async function errorSelectedStockSite(pageInstance: ui.Page): Promise<void> {
    pageInstance.$.dialog.message(
        'error',
        ui.localize('@sage/x3-manufacturing/dialog-error-location-inquiry-title', 'Error'),
        ui.localize(
            '@sage/x3-manufacturing/dialog-error-location-inquiry-set-site',
            'Define a default stock site on the user function profile.',
        ),
    );
}

export async function getSelectedStockSite(pageInstance: ui.Page): Promise<string | null> {
    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');
    if (!selectedSite) {
        await errorSelectedStockSite(pageInstance);
        return null;
    } else {
        return selectedSite.toString();
    }
}
