import { X3Response } from '../pages/utils/types';

export async function formatImportMessagefile(
    result: X3Response,
    severityCode?: number,
    importName?: string,
): Promise<string> {
    let trackingMessageArray: string;
    if (typeof severityCode === 'undefined') {
        trackingMessageArray = JSON.stringify(result.diagnoses, ['message']);
    } else {
        const filteredTrackingMessageArray =
            result.diagnoses?.filter((diagnoses: { severity: number; message: string }) => {
                if (diagnoses && diagnoses.severity > severityCode) {
                    return true;
                }
            }) ?? [];

        trackingMessageArray = JSON.stringify(filteredTrackingMessageArray, ['message']);
    }

    let msg: string;
    msg = trackingMessageArray.replace(/[^\.^\-\p{L}\p{M}\/'\/!\w\s]/gu, '');
    msg = msg.replace(/messagedescription/g, ' ');
    msg = msg.replace(/message/g, ' ');
    msg = msg.replace(/\//g, ' ');
    return msg;
}
