// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/index.d.ts
declare module '@sage/x3-manufacturing/index' {
	export * from '@sage/x3-manufacturing/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/index.d.ts
declare module '@sage/x3-manufacturing/lib/index' {
	export * as enums from '@sage/x3-manufacturing/lib/enums/index';
	export * as menuItems from '@sage/x3-manufacturing/lib/menu-items/index';
	export * as nodeExtensions from '@sage/x3-manufacturing/lib/node-extensions/index';
	export * as nodes from '@sage/x3-manufacturing/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-manufacturing/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/service-options/index.d.ts
declare module '@sage/x3-manufacturing/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, decimal, integer, Collection, Context } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrder extends Node {
	    readonly number: Promise<string>;
	    readonly orderStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
	    readonly planningSite: Reference<sageX3System.nodes.Site>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly releaseMode: Promise<sageX3ManufacturingData.enums.ReleaseMode | null>;
	    readonly modeType: Promise<sageX3ManufacturingData.enums.ModeType | null>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly scheduleMode: Promise<sageX3ManufacturingData.enums.SchedulingMode | null>;
	    readonly percLTReduction: Promise<decimal | null>;
	    readonly plannedQuantity: Promise<decimal | null>;
	    readonly initialObjective: Promise<date | null>;
	    readonly releasedRouting: Reference<sageX3Manufacturing.nodes.RoutingHeader | null>;
	    readonly routingCode: Reference<sageX3MasterData.nodes.BomRouting | null>;
	    readonly priority: Promise<sageX3ManufacturingData.enums.Priority | null>;
	    readonly schedulingStatus: Promise<sageX3ManufacturingData.enums.SchedulingStatus | null>;
	    readonly numberOfMaterials: Promise<integer | null>;
	    readonly allocationStatus: Promise<sageX3ManufacturingData.enums.WorkOrderAllocationStatus | null>;
	    readonly trackingFlag: Promise<sageX3ManufacturingData.enums.WorkOrderSituation | null>;
	    readonly workOrderOptimized: Promise<boolean>;
	    readonly workOrderSuspendedFlag: Promise<boolean>;
	    readonly workOrderProductLines: Collection<sageX3Manufacturing.nodes.WorkOrderProductLine>;
	    readonly workOrderOperationLines: Collection<sageX3Manufacturing.nodes.WorkOrderOperationLine>;
	    readonly workOrderOperationSchedulingLines: Collection<sageX3Manufacturing.nodes.WorkOrderOperationScheduling>;
	    readonly workOrderMaterialLines: Collection<sageX3Manufacturing.nodes.WorkOrderMaterialLine>;
	    static workOrderOptimization(context: Context, parameters: {
	        productionSite: string;
	        number: string;
	        product: string;
	        operationNumber: number[];
	        operationSplit: number[];
	        operationStartDateTime: string[];
	        operationEndDateTime: string[];
	        operationRunStartDateTime: string[];
	        operationRunEndDateTime: string[];
	        forcedStartDateTime: string[];
	        expectedWorkCenter: string[];
	        setupTimeSeconds: number[];
	        sequenceOrder: number[];
	        forcedPlacement: number[];
	        status: number;
	        message: string;
	    }): Promise<{
	        status: number;
	        message: string;
	    }>;
	}
	//# sourceMappingURL=work-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-suggestion.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-suggestion' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderSuggestion extends Node {
	    readonly orderType: Promise<sageX3ManufacturingData.enums.WorkOrderType>;
	    readonly code: Promise<string>;
	    readonly productCode: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly orderStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress>;
	    readonly originalSite: Reference<sageX3System.nodes.Site | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly startDate: Promise<date | null>;
	    readonly remainingQuantity: Promise<decimal | null>;
	    readonly optimized: Promise<boolean>;
	    readonly workOrderSuggestionLines: Collection<sageX3Manufacturing.nodes.WorkOrderSuggestionLine>;
	    readonly workOrderOperationSchedulingLines: Collection<sageX3Manufacturing.nodes.WorkOrderOperationScheduling>;
	}
	//# sourceMappingURL=work-order-suggestion.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-suggestion-line.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-suggestion-line' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, date, decimal } from '@sage/xtrem-core';
	export class WorkOrderSuggestionLine extends Node {
	    readonly code: Promise<string>;
	    readonly operationNumber: Promise<integer | null>;
	    readonly operationSplit: Promise<integer | null>;
	    readonly operationKey: Promise<string>;
	    readonly manufacturingSite: Reference<sageX3System.nodes.Site>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly operationStatus: Promise<sageX3ManufacturingData.enums.OperationStatus | null>;
	    readonly expectedWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly actualWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly operationUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockOperationConversion: Promise<decimal | null>;
	    readonly expectedQuantity: Promise<decimal | null>;
	    readonly completedQuantity: Promise<decimal | null>;
	    readonly rejectQuantity: Promise<decimal | null>;
	    readonly routingOperationTimeCode: Promise<sageX3ManufacturingData.enums.RunTimeType | null>;
	    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
	    readonly preparationTime: Promise<decimal | null>;
	    readonly setupTime: Promise<decimal | null>;
	    readonly completedSetupTime: Promise<decimal | null>;
	    readonly runTime: Promise<decimal | null>;
	    readonly completedOperationTime: Promise<decimal | null>;
	    readonly waitingTime: Promise<decimal | null>;
	    readonly postRunTime: Promise<decimal | null>;
	    readonly laborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly actualLaborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly numberOfResources: Promise<integer | null>;
	}
	//# sourceMappingURL=work-order-suggestion-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-scheduling.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-scheduling' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	export class WorkOrderScheduling extends Node {
	    readonly workOrder: Promise<string>;
	    readonly operationNumber: Promise<integer | null>;
	    readonly operationSplit: Promise<integer | null>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly downstreamOperationNumber: Promise<integer | null>;
	    readonly scheduleCode: Promise<sageX3ManufacturingData.enums.SchedulingCode | null>;
	    readonly overlappingTime: Promise<decimal | null>;
	    readonly overlappingQuantity: Promise<decimal | null>;
	    readonly lotQuantity: Promise<decimal | null>;
	    readonly numberOfLots: Promise<decimal | null>;
	    readonly milestone: Promise<sageX3ManufacturingData.enums.ScheduleType | null>;
	}
	//# sourceMappingURL=work-order-scheduling.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-production-reporting.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-production-reporting' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderProductionReporting extends Node {
	    readonly trackingNumber: Promise<string>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly workOrderProductionReportingLines: Collection<sageX3Manufacturing.nodes.WorkOrderProductionReportingLine>;
	}
	//# sourceMappingURL=work-order-production-reporting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-production-reporting-line.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-production-reporting-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderProductionReportingLine extends Node {
	    readonly trackingNumber: Promise<string>;
	    readonly line: Promise<integer | null>;
	    readonly orderNo: Promise<string>;
	    readonly orderLineNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly bomAlternative: Reference<sageX3MasterData.nodes.BomCodes | null>;
	    readonly lot: Promise<string>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly actualAcceptedQuantity: Promise<decimal | null>;
	    readonly stkConversion: Promise<decimal | null>;
	    readonly actualQuantity: Promise<decimal | null>;
	    readonly releaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly serialNumber: Promise<string>;
	    readonly stockJournal: Collection<sageX3StockData.nodes.StockJournal>;
	    readonly workOrderProductionReporting: Reference<sageX3Manufacturing.nodes.WorkOrderProductionReporting>;
	    readonly balance: Promise<decimal | null>;
	    readonly destinationCode: Promise<string>;
	    readonly labelDestination: Promise<string>;
	    readonly postingDate: Promise<string>;
	    readonly rejectedQty: Promise<decimal | null>;
	    readonly transactionCode: Promise<string>;
	}
	//# sourceMappingURL=work-order-production-reporting-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-product-line.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-product-line' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderProductLine extends Node {
	    readonly workOrder: Reference<sageX3Manufacturing.nodes.WorkOrder | null>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productType: Promise<sageX3Manufacturing.enums.ManufacturingProductType | null>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly productCategory: Reference<sageX3MasterData.nodes.ProductCategory>;
	    readonly projectTaskNumber: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly releaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly releaseQuantity: Promise<decimal | null>;
	    readonly releaseStkConversion: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly expectedQuantity: Promise<decimal | null>;
	    readonly remainingQuantity: Promise<decimal | null>;
	    readonly lot: Promise<string>;
	    readonly bomCode: Reference<sageX3MasterData.nodes.BomCodes | null>;
	    readonly originalDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly salesOrder: Promise<string>;
	    readonly lineStatus: Promise<sageX3ManufacturingData.enums.ProductionStatus | null>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Promise<string>;
	    readonly productSiteAttribute: Collection<sageX3Manufacturing.nodes.ProductSiteAttribute>;
	    readonly productAnalysis: Collection<sageX3Manufacturing.nodes.WorkOrderProductLineProductAnalysis>;
	}
	//# sourceMappingURL=work-order-product-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-product-line-product-analysis.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-product-line-product-analysis' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderProductLineProductAnalysis extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly workOrder: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Manufacturing.nodes.WorkOrderProductLine>;
	    readonly analysis: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=work-order-product-line-product-analysis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-operation-tracking.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-operation-tracking' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderOperationTracking extends Node {
	    readonly trackingNumber: Promise<string>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly workOrderOperationTrackingLines: Collection<sageX3Manufacturing.nodes.WorkOrderOperationTrackingLine>;
	}
	//# sourceMappingURL=work-order-operation-tracking.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-operation-tracking-line.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-operation-tracking-line' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderOperationTrackingLine extends Node {
	    readonly trackingNumber: Promise<string>;
	    readonly line: Promise<integer | null>;
	    readonly workOrderNumber: Promise<string>;
	    readonly operationNumber: Promise<integer | null>;
	    readonly operationSplit: Promise<integer | null>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly routing: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly routingCode: Reference<sageX3Manufacturing.nodes.RoutingHeader | null>;
	    readonly operationUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly operationConversion: Promise<decimal | null>;
	    readonly totalCompletedQuantity: Promise<decimal | null>;
	    readonly actualRejectedQuantity: Promise<decimal | null>;
	    readonly actualWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly actualSetupTime: Promise<decimal | null>;
	    readonly actualRunTime: Promise<decimal | null>;
	    readonly employeeId: Promise<integer | null>;
	    readonly message: Promise<integer | null>;
	    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
	    readonly alternativeIndex: Promise<integer | null>;
	    readonly standardOperation: Reference<sageX3Manufacturing.nodes.StandardOperations | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly workOrderOperationTracking: Reference<sageX3Manufacturing.nodes.WorkOrderOperationTracking>;
	    readonly balance: Promise<decimal | null>;
	    readonly bom: Promise<string>;
	    readonly bomCode: Promise<string>;
	    readonly postingDate: Promise<string>;
	    readonly transaction: Promise<string>;
	    readonly rejections: Collection<sageX3Manufacturing.nodes.WorkOrderOperationTrackingLineRejections>;
	}
	//# sourceMappingURL=work-order-operation-tracking-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-operation-tracking-line-rejections.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-operation-tracking-line-rejections' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderOperationTrackingLineRejections extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly trackingNumber: Promise<string>;
	    readonly line: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Manufacturing.nodes.WorkOrderOperationTrackingLine>;
	    readonly rejection: Promise<integer | null>;
	}
	//# sourceMappingURL=work-order-operation-tracking-line-rejections.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-operation-scheduling.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-operation-scheduling' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	export class WorkOrderOperationScheduling extends Node {
	    readonly workOrder: Promise<string>;
	    readonly operationNumber: Promise<integer | null>;
	    readonly operationSplit: Promise<integer | null>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly downstreamOperationNumber: Promise<integer | null>;
	    readonly scheduleCode: Promise<sageX3ManufacturingData.enums.SchedulingCode | null>;
	    readonly overlappingTime: Promise<decimal | null>;
	    readonly overlappingQuantity: Promise<decimal | null>;
	    readonly lotQuantity: Promise<decimal | null>;
	    readonly numberOfLots: Promise<decimal | null>;
	    readonly milestone: Promise<sageX3ManufacturingData.enums.ScheduleType | null>;
	    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
	}
	//# sourceMappingURL=work-order-operation-scheduling.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-operation-line.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-operation-line' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, datetime, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderOperationLine extends Node {
	    readonly workOrder: Reference<sageX3Manufacturing.nodes.WorkOrder | null>;
	    readonly operationNumber: Promise<integer | null>;
	    readonly operationSplit: Promise<integer | null>;
	    readonly manufacturingSite: Reference<sageX3System.nodes.Site>;
	    readonly expectedWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter>;
	    readonly actualWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly laborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly actualLaborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly operationStatus: Promise<sageX3ManufacturingData.enums.OperationStatus | null>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly forcedStartDate: Promise<date | null>;
	    readonly forcedStartTime: Promise<string>;
	    readonly operationDescription: Promise<string>;
	    readonly operationUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockOperationConversion: Promise<decimal | null>;
	    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
	    readonly routingOperationTimeCode: Promise<sageX3ManufacturingData.enums.RunTimeType | null>;
	    readonly operationPlanNumber: Promise<string>;
	    readonly technicalSheet: Promise<string>;
	    readonly tool: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly fixture: Promise<string>;
	    readonly program: Promise<string>;
	    readonly numberOfResources: Promise<integer | null>;
	    readonly preparationTime: Promise<decimal | null>;
	    readonly setupTime: Promise<decimal | null>;
	    readonly completedSetupTime: Promise<decimal | null>;
	    readonly unitTime: Promise<decimal | null>;
	    readonly completedUnitaryTime: Promise<decimal | null>;
	    readonly runTime: Promise<decimal | null>;
	    readonly completedOperationTime: Promise<decimal | null>;
	    readonly waitingTime: Promise<decimal | null>;
	    readonly postRunTime: Promise<decimal | null>;
	    readonly expectedQuantity: Promise<decimal | null>;
	    readonly completedQuantity: Promise<decimal | null>;
	    readonly rejectQuantity: Promise<decimal | null>;
	    readonly subcontract: Promise<sageX3ManufacturingData.enums.Subcontracting | null>;
	    readonly subcontractWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly subcontractLeadTimeDays: Promise<decimal | null>;
	    readonly groupingCriterion: Promise<string>;
	    readonly distinctionCriteria: Promise<string>;
	    readonly firstAvailability: Promise<datetime | null>;
	    readonly workOrderScheduling: Collection<sageX3Manufacturing.nodes.WorkOrderScheduling>;
	}
	//# sourceMappingURL=work-order-operation-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-material-tracking.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-material-tracking' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderMaterialTracking extends Node {
	    readonly trackingNumber: Promise<string>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly workOrderMaterialTrackingLines: Collection<sageX3Manufacturing.nodes.WorkOrderMaterialTrackingLine>;
	}
	//# sourceMappingURL=work-order-material-tracking.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-material-tracking-line.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-material-tracking-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderMaterialTrackingLine extends Node {
	    readonly mfgTrackingNumber: Promise<string>;
	    readonly materialTrackingLine: Promise<integer | null>;
	    readonly workOrder: Promise<string>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly bomNumber: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly bomAlternative: Reference<sageX3MasterData.nodes.BomCodes | null>;
	    readonly product: Reference<sageX3MasterData.nodes.ProductSite>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly consumedQuantity: Promise<decimal | null>;
	    readonly bomSequence: Promise<integer | null>;
	    readonly preferredLot: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly stockJournal: Collection<sageX3StockData.nodes.StockJournal>;
	    readonly workOrderMaterialTracking: Reference<sageX3Manufacturing.nodes.WorkOrderMaterialTracking>;
	    readonly balance: Promise<decimal | null>;
	    readonly postingDate: Promise<string>;
	    readonly transaction: Promise<string>;
	}
	//# sourceMappingURL=work-order-material-tracking-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-order-material-line.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-order-material-line' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkOrderMaterialLine extends Node {
	    readonly number: Reference<sageX3Manufacturing.nodes.WorkOrder | null>;
	    readonly lineNumber: Reference<sageX3Manufacturing.nodes.WorkOrderProductLine | null>;
	    readonly bomSequence: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly productionSite: Reference<sageX3System.nodes.Site>;
	    readonly requirementDate: Promise<date | null>;
	    readonly bomOperationNumber: Promise<integer | null>;
	    readonly cumulTotalQuantity: Promise<decimal | null>;
	    readonly bomUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly bomUnitStockFactor: Promise<decimal | null>;
	    readonly requiredQuantity: Promise<decimal | null>;
	    readonly consumedQuantity: Promise<decimal | null>;
	    readonly allocatedQuantity: Promise<decimal | null>;
	    readonly shortageQuantity: Promise<decimal | null>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly materialStatus: Promise<sageX3ManufacturingData.enums.ProductionStatus | null>;
	    readonly componentType: Promise<sageX3MasterData.enums.ComponentType | null>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Promise<string>;
	}
	//# sourceMappingURL=work-order-material-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-center-replacement.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-center-replacement' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkCenterReplacement extends Node {
	    readonly workCenter: Promise<string>;
	    readonly manufacturingSite: Reference<sageX3System.nodes.Site>;
	    readonly workCenterReplacementLines: Collection<sageX3Manufacturing.nodes.WorkCenterReplacementWorkCenterReplacementLines>;
	}
	//# sourceMappingURL=work-center-replacement.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/work-center-replacement-work-center-replacement-lines.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/work-center-replacement-work-center-replacement-lines' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkCenterReplacementWorkCenterReplacementLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly workCenter: Promise<string>;
	    readonly manufacturingSite: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Manufacturing.nodes.WorkCenterReplacement>;
	    readonly replacementworkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly replacementworkCenterDescription: Promise<string>;
	    readonly workCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup | null>;
	    readonly workCenterType: Promise<sageX3ManufacturingData.enums.WorkCenterType | null>;
	    readonly priority: Promise<integer | null>;
	}
	//# sourceMappingURL=work-center-replacement-work-center-replacement-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/transaction-production-reporting.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/transaction-production-reporting' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	export class TransactionProductionReporting extends Node {
	    readonly type: Promise<integer | null>;
	    readonly transaction: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly description: Promise<string>;
	    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly isActive: Promise<boolean>;
	    readonly group: Reference<sageX3Structure.nodes.SiteGroupings | null>;
	    readonly isWorkOrderTracking: Promise<boolean>;
	    readonly isRoutingTracking: Promise<boolean>;
	    readonly isWorkCenterTracking: Promise<boolean>;
	    readonly isBomTracking: Promise<boolean>;
	    readonly employeeEntry: Promise<sageX3ManufacturingData.enums.EnterMeasurement | null>;
	    readonly isProductionReporting: Promise<boolean>;
	    readonly isMaterialConsumption: Promise<boolean>;
	    readonly stockWithdrawalMode: Promise<sageX3MasterData.enums.StockWithdrawalMode | null>;
	    readonly sortCriteria1: Promise<sageX3ManufacturingData.enums.OperationSortCriteria | null>;
	    readonly sortCriteria2: Promise<sageX3ManufacturingData.enums.OperationSortCriteria | null>;
	    readonly materialConsumption: Promise<sageX3ManufacturingData.enums.MaterialConsumptionMode | null>;
	    readonly isManualOnly: Promise<boolean>;
	    readonly releaseQuantity: Promise<sageX3ManufacturingData.enums.DefaultQuantity | null>;
	    readonly isUnitCanBeModified: Promise<boolean>;
	    readonly defaultUnit: Promise<sageX3ManufacturingData.enums.EntryUnit | null>;
	    readonly isPreloading: Promise<boolean>;
	    readonly automaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly isUOMEntry: Promise<boolean>;
	    readonly isEnterPac: Promise<boolean>;
	    readonly labelPrinting: Promise<sageX3StockData.enums.LabelPrinting | null>;
	    readonly formTableEntryModePrinting: Promise<sageX3System.enums.FormOrTableEntryMode | null>;
	    readonly isNumberOfPrints: Promise<boolean>;
	    readonly formTableEntryModeNumberOfPrints: Promise<sageX3System.enums.FormOrTableEntryMode | null>;
	    readonly entryModeAvailableStock: Promise<sageX3System.enums.EntryMode | null>;
	    readonly formTableEntryModeAvailableStock: Promise<sageX3System.enums.FormOrTableEntryMode | null>;
	    readonly isExpiration: Promise<boolean>;
	    readonly isPotency: Promise<boolean>;
	    readonly isLotCustomText1: Promise<boolean>;
	    readonly isLotCustomText2: Promise<boolean>;
	    readonly isLotCustomNumber: Promise<boolean>;
	    readonly isLotCustomDate: Promise<boolean>;
	    readonly entryModeAnalyticalDimension: Promise<sageX3System.enums.EntryMode | null>;
	    readonly isAutomaticIssue: Promise<boolean>;
	    readonly isReceiptAtDock: Promise<boolean>;
	    readonly materialFilterOperation: Promise<sageX3ManufacturingData.enums.FilterOperations | null>;
	    readonly productFilterOperation: Promise<sageX3ManufacturingData.enums.FilterOperations | null>;
	    readonly entryModeWarehouse: Promise<sageX3System.enums.EntryMode | null>;
	    readonly isSingleWarehouse: Promise<boolean>;
	    readonly unplannedMaterials: Promise<boolean>;
	    readonly unplannedOperations: Promise<boolean>;
	}
	//# sourceMappingURL=transaction-production-reporting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/standard-operations.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/standard-operations' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	export class StandardOperations extends Node {
	    readonly code: Promise<integer>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly description: Promise<string>;
	    readonly mainWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter>;
	    readonly workCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup>;
	    readonly mainWorkCenterType: Promise<sageX3ManufacturingData.enums.WorkCenterType | null>;
	    readonly laborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly laborWorkCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup | null>;
	    readonly laborWorkCenterType: Promise<sageX3ManufacturingData.enums.WorkCenterType | null>;
	    readonly laborTimeSetupFactor: Promise<decimal | null>;
	    readonly laborRunTimeFactor: Promise<decimal | null>;
	    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
	    readonly managementUnit: Promise<sageX3ManufacturingData.enums.OperationTimeCodes | null>;
	    readonly baseQuantity: Promise<decimal | null>;
	    readonly operationUom: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly operationPlan: Promise<string>;
	    readonly operationImage: Promise<string>;
	    readonly operationText: Promise<string>;
	    readonly technicalSheet: Reference<sageX3MasterData.nodes.TechnicalSheet | null>;
	    readonly tools: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly fixture: Promise<string>;
	    readonly program: Promise<string>;
	    readonly numberOfRessources: Promise<integer | null>;
	    readonly numberLaborRessources: Promise<integer | null>;
	    readonly efficiencyPercentage: Promise<decimal | null>;
	    readonly shrinkagePercentage: Promise<decimal | null>;
	    readonly runTimeType: Promise<sageX3ManufacturingData.enums.RunTimeType | null>;
	    readonly preparationTime: Promise<decimal | null>;
	    readonly setupTime: Promise<decimal | null>;
	    readonly runTime: Promise<decimal | null>;
	    readonly rate: Promise<decimal | null>;
	    readonly waitingTime: Promise<decimal | null>;
	    readonly postRunTime: Promise<decimal | null>;
	    readonly subcontractCode: Promise<sageX3ManufacturingData.enums.Subcontracting | null>;
	    readonly subcontractedProducts: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly subcontractWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly subcontractWorkCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly businessPartnerAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly referencePrice: Promise<decimal | null>;
	    readonly splitting: Promise<sageX3ManufacturingData.enums.Splitting | null>;
	    readonly maximumSplits: Promise<integer | null>;
	    readonly machineRestriction: Promise<string>;
	    readonly groupingCriterion: Promise<string>;
	    readonly groupingFormula: Promise<string>;
	    readonly groupSetupTime: Promise<decimal | null>;
	}
	//# sourceMappingURL=standard-operations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/setup-time.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/setup-time' {
	import { Node, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class SetupTime extends Node {
	    readonly setupTimeCode: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly attributeCode: Reference<sageX3Manufacturing.nodes.Attribute>;
	    readonly setupTimeDifferent: Promise<decimal | null>;
	    readonly setupTimeSame: Promise<decimal | null>;
	    readonly setupTimeExceptions: Collection<sageX3Manufacturing.nodes.SetupTimeException>;
	}
	//# sourceMappingURL=setup-time.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/setup-time-exception.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/setup-time-exception' {
	import { Node, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class SetupTimeException extends Node {
	    readonly setupTimeCode: Reference<sageX3Manufacturing.nodes.SetupTime>;
	    readonly lineNumber: Promise<string>;
	    readonly fromAttributeValue: Promise<string>;
	    readonly toAttributeValue: Promise<string>;
	    readonly setupTime: Promise<decimal | null>;
	}
	//# sourceMappingURL=setup-time-exception.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/routing-version.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/routing-version' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class RoutingVersion extends Node {
	    readonly product: Reference<sageX3Manufacturing.nodes.RoutingHeader>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly majorVersion: Promise<string>;
	    readonly minorVersion: Promise<string>;
	    readonly sequence: Promise<integer>;
	    readonly useStatus: Promise<sageX3MasterData.enums.UseStatus | null>;
	    readonly routingCode: Promise<integer>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly isDerogation: Promise<boolean>;
	    readonly exceptionDate: Promise<date | null>;
	}
	//# sourceMappingURL=routing-version.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/routing-scheduling.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/routing-scheduling' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	export class RoutingScheduling extends Node {
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly routing: Reference<sageX3MasterData.nodes.Product>;
	    readonly routingCode: Promise<integer | null>;
	    readonly operationNumber: Promise<integer | null>;
	    readonly downstreamOperation: Promise<integer | null>;
	    readonly milestone: Promise<sageX3ManufacturingData.enums.ScheduleType | null>;
	    readonly isProductionStep: Promise<boolean>;
	    readonly schedulingCode: Promise<sageX3ManufacturingData.enums.SchedulingCode | null>;
	    readonly overlappingTime: Promise<decimal | null>;
	    readonly overlappingQuantity: Promise<decimal | null>;
	    readonly numberOfOverlappingLots: Promise<decimal | null>;
	}
	//# sourceMappingURL=routing-scheduling.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/routing-operation.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/routing-operation' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class RoutingOperation extends Node {
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly routing: Reference<sageX3MasterData.nodes.Product>;
	    readonly routingCode: Reference<sageX3Manufacturing.nodes.RoutingHeader>;
	    readonly operationNumber: Promise<integer | null>;
	    readonly alternateIndex: Promise<integer | null>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly standardOperation: Reference<sageX3Manufacturing.nodes.StandardOperations | null>;
	    readonly mainWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter>;
	    readonly laborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly laborTimeSetupFactor: Promise<decimal | null>;
	    readonly laborRunTimeFactor: Promise<decimal | null>;
	    readonly operationDescription: Promise<string>;
	    readonly stockOperationConversion: Promise<decimal | null>;
	    readonly stockOperationFormula: Promise<string>;
	    readonly operationPlan: Promise<string>;
	    readonly operationImage: Promise<string>;
	    readonly technicalSheet: Promise<string>;
	    readonly tools: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly fixture: Promise<string>;
	    readonly program: Promise<string>;
	    readonly numberOfRessources: Promise<integer | null>;
	    readonly numberLaborRessources: Promise<integer | null>;
	    readonly efficiencyPercentage: Promise<decimal | null>;
	    readonly shrinkagePercentage: Promise<decimal | null>;
	    readonly runTimeType: Promise<sageX3ManufacturingData.enums.RunTimeType | null>;
	    readonly managementUnit: Promise<sageX3ManufacturingData.enums.OperationTimeCodes | null>;
	    readonly baseQuantity: Promise<decimal | null>;
	    readonly preparationTime: Promise<decimal | null>;
	    readonly setupTime: Promise<decimal | null>;
	    readonly runTime: Promise<decimal | null>;
	    readonly rate: Promise<decimal | null>;
	    readonly waitingTime: Promise<decimal | null>;
	    readonly postRunTime: Promise<decimal | null>;
	    readonly subcontractCode: Promise<sageX3ManufacturingData.enums.Subcontracting | null>;
	    readonly subcontractedProducts: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly subcontractWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly businessPartnerAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly referencePrice: Promise<decimal | null>;
	    readonly splitting: Promise<sageX3ManufacturingData.enums.Splitting | null>;
	    readonly maximumSplits: Promise<integer | null>;
	    readonly operationSuffix: Promise<integer | null>;
	    readonly isRoutingCodeOperation: Promise<boolean>;
	    readonly machineRestriction: Promise<string>;
	    readonly groupingCriterion: Promise<string>;
	    readonly groupingFormula: Promise<string>;
	    readonly distinctionCriteria: Promise<string>;
	    readonly distinctionFormula: Promise<string>;
	    readonly groupSetupTime: Promise<decimal | null>;
	}
	//# sourceMappingURL=routing-operation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/routing-header.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/routing-header' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, decimal } from '@sage/xtrem-core';
	export class RoutingHeader extends Node {
	    readonly routing: Reference<sageX3MasterData.nodes.Product>;
	    readonly routingCode: Reference<sageX3MasterData.nodes.BomRouting>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly description: Promise<string>;
	    readonly useStatus: Promise<sageX3MasterData.enums.UseStatus | null>;
	    readonly isValidated: Promise<boolean>;
	    readonly validityStartDate: Promise<date | null>;
	    readonly validityEndDate: Promise<date | null>;
	    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
	    readonly workOrderManagementMode: Promise<sageX3ManufacturingData.enums.WorkOrderManagementMode | null>;
	    readonly routingHeaderText: Promise<string>;
	    readonly routingHeaderPlan: Promise<string>;
	    readonly routingHeaderImage: Promise<string>;
	    readonly minimumReleaseQuantity: Promise<decimal | null>;
	    readonly maximumReleaseQuantity: Promise<decimal | null>;
	    readonly lastReleaseQuantity: Promise<decimal | null>;
	    readonly lastReleaseDate: Promise<date | null>;
	    readonly journalNumberConfig: Promise<string>;
	    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
	}
	//# sourceMappingURL=routing-header.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/product-site-attribute.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/product-site-attribute' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class ProductSiteAttribute extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.ProductSite | null>;
	    readonly stockSite: Reference<sageX3System.nodes.Site | null>;
	    readonly attributeCode: Reference<sageX3Manufacturing.nodes.Attribute>;
	    readonly attributeValue: Reference<sageX3Manufacturing.nodes.AttributeLine>;
	}
	//# sourceMappingURL=product-site-attribute.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/optimization.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/optimization' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import { Node, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class Optimization extends Node {
	    readonly optimizationCode: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly setupTimeType: Promise<sageX3ManufacturingData.enums.SetupTimeType | null>;
	    readonly optimizationLines: Collection<sageX3Manufacturing.nodes.OptimizationLine>;
	}
	//# sourceMappingURL=optimization.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/optimization-line.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/optimization-line' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class OptimizationLine extends Node {
	    readonly optimizationCode: Reference<sageX3Manufacturing.nodes.Optimization>;
	    readonly lineNumber: Promise<string>;
	    readonly setupTimeCode: Reference<sageX3Manufacturing.nodes.SetupTime>;
	}
	//# sourceMappingURL=optimization-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/index.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/index' {
	export * from '@sage/x3-manufacturing/lib/nodes/attribute-line';
	export * from '@sage/x3-manufacturing/lib/nodes/attribute';
	export * from '@sage/x3-manufacturing/lib/nodes/capacity-variation-capacity-variation-groups';
	export * from '@sage/x3-manufacturing/lib/nodes/capacity-variation';
	export * from '@sage/x3-manufacturing/lib/nodes/finite-scheduler-custom-value-lines';
	export * from '@sage/x3-manufacturing/lib/nodes/finite-scheduler-custom-value';
	export * from '@sage/x3-manufacturing/lib/nodes/finite-scheduler-object';
	export * from '@sage/x3-manufacturing/lib/nodes/optimization-line';
	export * from '@sage/x3-manufacturing/lib/nodes/optimization';
	export * from '@sage/x3-manufacturing/lib/nodes/product-site-attribute';
	export * from '@sage/x3-manufacturing/lib/nodes/routing-header';
	export * from '@sage/x3-manufacturing/lib/nodes/routing-operation';
	export * from '@sage/x3-manufacturing/lib/nodes/routing-scheduling';
	export * from '@sage/x3-manufacturing/lib/nodes/routing-version';
	export * from '@sage/x3-manufacturing/lib/nodes/setup-time-exception';
	export * from '@sage/x3-manufacturing/lib/nodes/setup-time';
	export * from '@sage/x3-manufacturing/lib/nodes/standard-operations';
	export * from '@sage/x3-manufacturing/lib/nodes/transaction-production-reporting';
	export * from '@sage/x3-manufacturing/lib/nodes/work-center-replacement-work-center-replacement-lines';
	export * from '@sage/x3-manufacturing/lib/nodes/work-center-replacement';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-material-line';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-material-tracking-line';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-material-tracking';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-operation-line';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-operation-scheduling';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-operation-tracking-line-rejections';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-operation-tracking-line';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-operation-tracking';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-product-line-product-analysis';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-product-line';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-production-reporting-line';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-production-reporting';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-scheduling';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-suggestion-line';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order-suggestion';
	export * from '@sage/x3-manufacturing/lib/nodes/work-order';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/finite-scheduler-object.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/finite-scheduler-object' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, Context } from '@sage/xtrem-core';
	export class FiniteSchedulerObject extends Node {
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly object: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly information1: Promise<string>;
	    readonly information2: Promise<string>;
	    readonly information3: Promise<string>;
	    readonly information4: Promise<string>;
	    readonly createDate: Promise<date | null>;
	    readonly deletionFlag: Promise<boolean>;
	    static maintainFiniteSchedulerObject(context: Context, parameters: {
	        object: string;
	        site: string;
	        timestamp: string;
	        oStatus: number;
	        oMessage: string;
	    }): Promise<{
	        oStatus: number;
	        oMessage: string;
	    }>;
	}
	//# sourceMappingURL=finite-scheduler-object.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/finite-scheduler-custom-value.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/finite-scheduler-custom-value' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class FiniteSchedulerCustomValue extends Node {
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly default: Promise<boolean>;
	    readonly lines: Collection<sageX3Manufacturing.nodes.FiniteSchedulerCustomValueLines>;
	}
	//# sourceMappingURL=finite-scheduler-custom-value.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/finite-scheduler-custom-value-lines.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/finite-scheduler-custom-value-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class FiniteSchedulerCustomValueLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Manufacturing.nodes.FiniteSchedulerCustomValue>;
	    readonly workOrderCustomField: Promise<sageX3Manufacturing.enums.WorkOrderField | null>;
	    readonly workOrderOperationCustomField: Promise<sageX3Manufacturing.enums.WorkOrderOperationField | null>;
	}
	//# sourceMappingURL=finite-scheduler-custom-value-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/capacity-variation.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/capacity-variation' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class CapacityVariation extends Node {
	    readonly workCenter: Promise<string>;
	    readonly manufacturingSite: Reference<sageX3System.nodes.Site>;
	    readonly capacityVariationGroups: Collection<sageX3Manufacturing.nodes.CapacityVariationCapacityVariationGroups>;
	}
	//# sourceMappingURL=capacity-variation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/capacity-variation-capacity-variation-groups.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/capacity-variation-capacity-variation-groups' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, date } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class CapacityVariationCapacityVariationGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly workCenter: Promise<string>;
	    readonly manufacturingSite: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Manufacturing.nodes.CapacityVariation>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly weeklyStructure: Reference<sageX3MasterData.nodes.WeeklyStructure | null>;
	    readonly numberOfResources: Promise<integer | null>;
	    readonly text: Promise<string>;
	}
	//# sourceMappingURL=capacity-variation-capacity-variation-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/attribute.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/attribute' {
	import { Node, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class Attribute extends Node {
	    readonly attributeCode: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly attributeLines: Collection<sageX3Manufacturing.nodes.AttributeLine>;
	}
	//# sourceMappingURL=attribute.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/nodes/attribute-line.d.ts
declare module '@sage/x3-manufacturing/lib/nodes/attribute-line' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class AttributeLine extends Node {
	    readonly attributeCode: Reference<sageX3Manufacturing.nodes.Attribute>;
	    readonly attributeValue: Promise<string>;
	    readonly attributeValueDescription: Promise<string>;
	}
	//# sourceMappingURL=attribute-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/node-extensions/work-center-extension.d.ts
declare module '@sage/x3-manufacturing/lib/node-extensions/work-center-extension' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class WorkCenterExtension extends NodeExtension<sageX3ManufacturingData.nodes.WorkCenter> {
	    readonly type: Promise<sageX3ManufacturingData.enums.WorkCenterType | null>;
	    readonly optimizationCode: Reference<sageX3Manufacturing.nodes.Optimization | null>;
	    readonly workOrderOperationLines: Collection<sageX3Manufacturing.nodes.WorkOrderOperationLine>;
	}
	declare module '@sage/x3-manufacturing-data/lib/nodes/work-center' {
	    interface WorkCenter extends WorkCenterExtension {
	    }
	}
	//# sourceMappingURL=work-center-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/node-extensions/product-site-extension.d.ts
declare module '@sage/x3-manufacturing/lib/node-extensions/product-site-extension' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Collection } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class ProductSiteExtension extends NodeExtension<sageX3MasterData.nodes.ProductSite> {
	    readonly methodOfCorrection: Promise<sageX3ManufacturingData.enums.MethodOfCorrection | null>;
	    readonly productSiteAttribute: Collection<sageX3Manufacturing.nodes.ProductSiteAttribute>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product-site' {
	    interface ProductSite extends ProductSiteExtension {
	    }
	}
	//# sourceMappingURL=product-site-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-manufacturing/lib/node-extensions/index' {
	export * from '@sage/x3-manufacturing/lib/node-extensions/assignment-extension';
	export * from '@sage/x3-manufacturing/lib/node-extensions/product-site-extension';
	export * from '@sage/x3-manufacturing/lib/node-extensions/work-center-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/node-extensions/assignment-extension.d.ts
declare module '@sage/x3-manufacturing/lib/node-extensions/assignment-extension' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3Manufacturing from '@sage/x3-manufacturing/lib/index';
	export class AssignmentExtension extends NodeExtension<sageX3ManufacturingData.nodes.Assignment> {
	    readonly parentWorkOrder: Reference<sageX3Manufacturing.nodes.WorkOrder | null>;
	    readonly childWorkOrder: Reference<sageX3Manufacturing.nodes.WorkOrder | null>;
	}
	declare module '@sage/x3-manufacturing-data/lib/nodes/assignment' {
	    interface Assignment extends AssignmentExtension {
	    }
	}
	//# sourceMappingURL=assignment-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/menu-items/manufacturing.d.ts
declare module '@sage/x3-manufacturing/lib/menu-items/manufacturing' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const manufacturing: RootMenuItem;
	//# sourceMappingURL=manufacturing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/menu-items/index.d.ts
declare module '@sage/x3-manufacturing/lib/menu-items/index' {
	export * from '@sage/x3-manufacturing/lib/menu-items/manufacturing';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/enums/work-order-operation-field.d.ts
declare module '@sage/x3-manufacturing/lib/enums/work-order-operation-field' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkOrderOperationFieldEnum {
	    laborCenter = 1,
	    technicalSheet = 2,
	    operationPlanNumber = 3,
	    fixture = 4,
	    program = 5,
	    groupingCriterion = 6,
	    distinctionCriteria = 7
	}
	export interface WorkOrderOperationField$EnumInterface {
	    laborCenter: 1;
	    technicalSheet: 2;
	    operationPlanNumber: 3;
	    fixture: 4;
	    program: 5;
	    groupingCriterion: 6;
	    distinctionCriteria: 7;
	}
	export type WorkOrderOperationField = keyof WorkOrderOperationField$EnumInterface;
	export const workOrderOperationFieldDatatype: X3EnumDataType<keyof WorkOrderOperationField$EnumInterface, unknown>;
	//# sourceMappingURL=work-order-operation-field.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/enums/work-order-field.d.ts
declare module '@sage/x3-manufacturing/lib/enums/work-order-field' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkOrderFieldEnum {
	    customerNameNumber = 1,
	    customerName = 2,
	    projectTaskNumber = 3,
	    productCategory = 4,
	    productLine = 5,
	    statisticalAnalysis1 = 6,
	    statisticalAnalysis2 = 7,
	    statisticalAnalysis3 = 8,
	    salesOrderNumber = 9
	}
	export interface WorkOrderField$EnumInterface {
	    customerNameNumber: 1;
	    customerName: 2;
	    projectTaskNumber: 3;
	    productCategory: 4;
	    productLine: 5;
	    statisticalAnalysis1: 6;
	    statisticalAnalysis2: 7;
	    statisticalAnalysis3: 8;
	    salesOrderNumber: 9;
	}
	export type WorkOrderField = keyof WorkOrderField$EnumInterface;
	export const workOrderFieldDatatype: X3EnumDataType<keyof WorkOrderField$EnumInterface, unknown>;
	//# sourceMappingURL=work-order-field.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/enums/manufacturing-product-type.d.ts
declare module '@sage/x3-manufacturing/lib/enums/manufacturing-product-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ManufacturingProductTypeEnum {
	    product = 1,
	    byProduct = 2
	}
	export interface ManufacturingProductType$EnumInterface {
	    product: 1;
	    byProduct: 2;
	}
	export type ManufacturingProductType = keyof ManufacturingProductType$EnumInterface;
	export const manufacturingProductTypeDatatype: X3EnumDataType<keyof ManufacturingProductType$EnumInterface, unknown>;
	//# sourceMappingURL=manufacturing-product-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-manufacturing/build/lib/enums/index.d.ts
declare module '@sage/x3-manufacturing/lib/enums/index' {
	export * from '@sage/x3-manufacturing/lib/enums/manufacturing-product-type';
	export * from '@sage/x3-manufacturing/lib/enums/work-order-field';
	export * from '@sage/x3-manufacturing/lib/enums/work-order-operation-field';
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/x3-manufacturing' {
	export * from '@sage/x3-manufacturing/index';
}
