/// <reference path="../../../../../shared/x3-manufacturing-data/api/api.d.ts" />
import { WorkOrder, WorkOrderOperationLine } from '@sage/x3-manufacturing-api';
import { RoutingHeader } from '@sage/x3-manufacturing-api-partial';
import { EmployeeId } from '@sage/x3-manufacturing-data-api';
import { ExtractEdges } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';
import { SelectedOperationMethod, TimeTrackingLine, TimeTrackingStorageObject, TrackingLineTable, X3Response } from './utils/types';
export declare class MobileTimeTracking extends ui.Page {
    private transactionsList;
    section: ui.containers.Section;
    block: ui.containers.Block;
    trackingDate: ui.fields.Date;
    stockSite: ui.fields.Label;
    transaction: ui.fields.Select;
    employeeId: ui.fields.Reference;
    workOrder: ui.fields.Reference;
    releaseUOM: ui.fields.Text;
    releaseTimeUnit: ui.fields.Text;
    unplannedOperations: ui.fields.Checkbox;
    stdOperation: ui.fields.Reference;
    operationLine: ui.fields.Reference;
    stdOperationDescription: ui.fields.Text;
    unplannedOperationsLine: ui.fields.Numeric;
    trackingLinesBlock: ui.containers.Block;
    trackingLinesTable: ui.fields.Table<TrackingLineTable>;
    createButton: ui.PageAction;
    /** Fields Management */
    initPage(): Promise<void>;
    setMandatoryFields(transactions: any[]): Promise<boolean | undefined>;
    setEntryTransaction(transaction: any[], transactionIsDisabled: boolean, allFieldsDisabled: boolean): void;
    /**
     * Is the employee id mandatory
     * @param transactions
     * @param currentTransaction
     * @returns boolean
     */
    isEmployeeMandatory(transactions: any[], currentTransaction: string | undefined | null): Promise<boolean>;
    /**
     * Is the employee id fiedls to be hidden
     * @param transactions
     * @param currentTransaction
     * @returns boolean
     */
    isEmployeeHidden(transactions: any[], currentTransaction: string | undefined | null): Promise<boolean>;
    /** Function returns whether unplanned operations checkbox is hidden based on unplanned operation flag
        in the entry transaction - True | False */
    isUnplannedOperationsHidden(transactions: any[], currentTransaction: string | undefined | null): Promise<boolean>;
    getLines(): TimeTrackingLine[] | null | undefined;
    getLinesLength(): number;
    setStorageObject(): Promise<void>;
    setCurrentWorkOrder(): Promise<WorkOrder>;
    setCurrentEmployee(): EmployeeId;
    setOperationFieldsDisabledStatus(): void;
    isUnplannedOperationsEnabled(): void;
    isTableHidden(lines: TimeTrackingLine[]): boolean;
    setTableTitle(lines: TimeTrackingLine[], tableLineDelete?: boolean): string;
    setTableLines(lines: TimeTrackingLine[]): Partial<TrackingLineTable>[];
    mapTableLines(lines: TimeTrackingLine[]): {
        _id: string;
        workOrder: any;
        operationNumber: number;
        operationDescription: string;
        quantityAndStockUnit: string;
    }[];
    toggleCreateButton(linesLength: number): boolean;
    private storageObject;
    initStorageObject(): void;
    getSessionStorage(): TimeTrackingStorageObject;
    updatePageStorage(operationMethod: SelectedOperationMethod): void;
    setSessionStorage(data?: TimeTrackingStorageObject): void;
    getStockSite(): Promise<string>;
    getDate(): Promise<string>;
    setDefaultEmployee(): Promise<void>;
    getEntryTransaction(): Promise<any[]>;
    getWorkOrderRoutingList(): Promise<ExtractEdges<RoutingHeader>[]>;
    /** function to get value for paramter CTLOPEPRE */
    private getGeneralParameters;
    /** function to test if operation can be tracked - tracking is only permitted if previous operation
     *  has already been tracked and exists X3 or has been added to the grid pending creation */
    isPreviousOperationTracked(operationNumber: number, workOrder: any, operationMilestonetype: string | undefined): Promise<boolean>;
    /** function to test if an operation number exists on the mobile page 1 tracking grid */
    isOperationOnTrackingGrid(operationNumber: number | undefined, workOrderNumber: number): Promise<boolean>;
    /** function to test if the previous operation for the current operation has been tracking in X3 */
    isPreviousOperationTrackedDB(opNumber: number, opList: ExtractEdges<WorkOrderOperationLine>[]): Promise<boolean | undefined>;
    /** Function prepare creation - remove the description from the storage lines */
    prepareCreation(): void;
    /** Function to call the API for creation */
    callCreationAPI(): Promise<X3Response>;
    /** Create Button Methods */
    /**
     * Checks the response from X3 for errors. Controls the display success error screen.
     * First it handles a special case when in X3response:
     * severities 3 exists (hard fail),
     * workOrderProductionReporting.create.trackingNumber = null,
     * It Looks for severity 3 and 4, when none found Counts as success.
     * The rest is just an error.
     * @param {*} result The response from X3.
     * @return {*}  {boolean} True for win. False for fail.
     */
    getCreationStatus(result: X3Response): boolean;
    checkForErrorSeverities(result: X3Response | any): boolean;
    errorScreen(result: X3Response): Promise<void>;
    successScreen(result: X3Response): Promise<void>;
    getTrackingNumber(result: X3Response): string;
    /** Function to set gotLines to false will cause initPageStorageObject to reset the page and storage object */
    resetSessionStorage(): void;
    infoDialogOption(): ui.dialogs.DialogOptions;
    successDialogOption(): ui.dialogs.DialogOptions;
    errorDialogOption(): ui.dialogs.DialogOptions;
    /** function to return the milestone type for an operation */
    getOperationMilestoneType(operation: number, woNumber: string): Promise<string | undefined>;
    /** Function to get release time unit for selected work order **/
    getReleaseTimeUnit(): Promise<string>;
    getReleaseUOM(): Promise<string>;
    /** Function to return the previous operation number */
    getPreviousOperation(operation: number | undefined, woNumber: string | undefined): Promise<number | undefined>;
    /**
     * Read Parameter Value
     *
     * @param parameterName
     * @param site
     * @returns
     */
    getParamValue(site: string | null, parameterName: string): Promise<string>;
}
//# sourceMappingURL=mobile-time-tracking.d.ts.map