import { WorkOrder } from '@sage/x3-manufacturing-api';
import { StandardOperations } from '@sage/x3-manufacturing-api-partial';
import { decimal } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';
import { OperationLine, TimeTrackingLine, TimeTrackingStorageObject } from './utils/types';
export declare class MobileTimeTrackingDetails extends ui.Page {
    section: ui.containers.Section;
    block: ui.containers.Block;
    expectedWorkCenter: ui.fields.Reference;
    blank: ui.fields.Separator;
    timeUnit: ui.fields.Text;
    stockUnit: ui.fields.Text;
    remainingQuantity: ui.fields.Numeric;
    rejectedQuantity: ui.fields.Numeric;
    setupTime: ui.fields.Numeric;
    runTime: ui.fields.Numeric;
    enteredSetupTimeHours: ui.fields.Numeric;
    enteredSetupTimeMinutes: ui.fields.Numeric;
    enteredRunTimeHours: ui.fields.Numeric;
    enteredRunTimeMinutes: ui.fields.Numeric;
    close: ui.fields.Checkbox;
    addQuantity: ui.PageAction;
    nextPage: ui.PageAction;
    /**  Header Fields */
    workOrderNumber: ui.fields.Text;
    releasedRouting: ui.fields.Text;
    routingCode: ui.fields.Text;
    operationNumber: ui.fields.Numeric;
    operationDescription: ui.fields.Text;
    bom: ui.fields.Text;
    bomCode: ui.fields.Text;
    initPage(): Promise<void>;
    setHeaderFields(userDefinedOperationNumber: number | null, operationLine: Partial<OperationLine> | null, workOrder: WorkOrder, operationMethod: number, userDefinedOperationDescription: string | null | undefined): void;
    /** function Set initial page field values */
    setDefaultValues(operationLine: Partial<OperationLine>, standardOperations: Partial<StandardOperations>, operationMethod: number, releaseUOM: string, releaseTimeUnit: string): Promise<void>;
    /** Set the scale for numeric field based on their unit of measure */
    setScaleForNumericFields(stockUnit: string): Promise<void>;
    /** set the remaining quantity value. Expected qty minus the completed qty
     *  if completed exceeds expected then set qty to zero */
    setRemainingQuantity(): Promise<void>;
    getStockSite(): string;
    getStorageObject(): TimeTrackingStorageObject | undefined;
    getTrackingLines(): TimeTrackingLine[];
    showStorageError(): void;
    initTrackingLines(storageObject: any): TimeTrackingLine[];
    saveTimeTracking(storageObject: TimeTrackingStorageObject): void;
    buttonsLogic(displayMsg: boolean): Promise<void>;
    /** Function coverts the setup time entered by the user to operation time unit
     *  updates runtime page field with new value return: true | false was calculation successfully
     */
    setActualRunTime(): Promise<boolean>;
    /** Function coverts the setup time entered by the user to operation time unit
     *  updates setuptime page field with new value return: true | fales was calculation succefully
     */
    setActualSetupTime(): Promise<boolean>;
    setWorkCenter(workCenter: string): Promise<void>;
    /** function verify if the time and quantity values enter are permitted - True | False */
    isTimeAndQuantityValid(): Promise<boolean>;
    /** function to set the Close field - yes/no based on the quantity being tracked */
    setCloseField(): Promise<void>;
    /** for the current work order and operation set the total tracked quantity
     *  return = qty already tracked in X3 + qty tracked on device */
    getQtyAvailableToTrack(): number;
    /**
     * Calculate the total quantity - lines tracked for a given work order and operation
     * @param lines
     * @param operationLine
     * @returns
     */
    calculateLineQuantity(lines: TimeTrackingLine[], operationLine: Partial<OperationLine>): number;
    /**
     * Automatic closing percentage for expected work center & site
     * @param workCenter
     * @returns
     */
    getAutomaticClosingPercent(workCenter: string): Promise<decimal>;
    /**
     * get BOM code required for operation tracking/creation of lines
     * @returns
     */
    getBomCode(): Promise<any>;
    /**
     * Set the rejected qnatity field to zero
     */
    setRejectedQuantityToZero(): Promise<void>;
    /**
     * Set all runtime and setup time fields to zero
     */
    SetAllTimeFieldsToZero(): Promise<void>;
}
//# sourceMappingURL=mobile-time-tracking-details.d.ts.map