import { WorkOrder } from '@sage/x3-manufacturing-api';
import * as ui from '@sage/xtrem-ui';
import { StorageObject, TrackingLine, TrackingLineTable, X3Response } from './utils/types';
export declare class MobileProductionReporting extends ui.Page {
    section: ui.containers.Section;
    block: ui.containers.Block;
    trackingDate: ui.fields.Date;
    stockSite: ui.fields.Label;
    transaction: ui.fields.Select;
    workOrder: ui.fields.Reference;
    productLine: ui.fields.Reference;
    trackingLinesBlock: ui.containers.Block;
    trackingLinesTable: ui.fields.Table<TrackingLineTable>;
    createButton: ui.PageAction;
    /** Create Button Methods */
    /**
     * Checks the response from X3 for errors. Controls the display success error screen.
     * First it handles a special case when in X3response:
     * severities 3 exists (hard fail),
     * workOrderProductionReporting.create.trackingNumber = null,
     * It Looks for severity 3 and 4, when none found Counts as success.
     * The rest is just an error.
     * @param {*} result The response from X3.
     * @return {*}  {boolean} True for win. False for fail.
     */
    getCreationStatus(result: X3Response): boolean;
    checkForErrorSeverities(result: X3Response): boolean;
    errorScreen(result: X3Response): Promise<void>;
    successScreen(result: X3Response): Promise<void>;
    getTrackingNumber(result: X3Response): string;
    /** The result diagnoses messages are formatted in such a way that even displaying them is a subject to debate
     * getResultMessage(result: X3Response): string {
     *   return result.diagnoses ? result.diagnoses[0]?.message : result.message;
     * }
     */
    resetSessionStorage(): void;
    successDialogOption(): ui.dialogs.DialogOptions;
    errorDialogOption(): ui.dialogs.DialogOptions;
    toggleCreateButton(linesLength: number): boolean;
    prepareCreation(): void;
    callCreationAPI(): Promise<X3Response>;
    initPage(): Promise<void>;
    /** Storage Methods */
    /**
     * Page Storage refers to the storageObject on page one.
     * Session Storage refers to the browsers Session Storage.
     */
    setStorageObject(): Promise<void>;
    private storageObject;
    initPageStorageObject(): void;
    /** Updates the Page Storage with Session Storage */
    getSessionStorage(): StorageObject;
    /** Updates the Session Storage with the Page Storage */
    setSessionStorage(data?: StorageObject): void;
    /** Executed on Product selection */
    updatePageStorage(): void;
    /** Fields Management */
    /** Stock site value comes from the sticker */
    getStockSite(): Promise<string>;
    getDate(): Promise<string>;
    setMandatoryFields(transactions: string[]): Promise<boolean>;
    setEntryTransaction(transaction: string[], transactionIsDisabled: boolean, workOrderIsDisabled: boolean): void;
    toggleProductLineField(): void;
    /** Methods active when at least one production tracking line have been created */
    getLines(): TrackingLine[] | null | undefined;
    getLinesLength(): number;
    disableEntryTransaction(): void;
    setCurrentTrackingDate(): void;
    setCurrentWorkOrder(): WorkOrder;
    /**
     * If production line is present in the storage show the table,
     * execute the setTableTitle, setTableLines and Order 66.
     * @param {TrackingLine[]} lines workOrderProductionReportingLines from the Page Storage.
     * @return {*}  {boolean} toggle the Table.
     */
    toggleTable(lines: TrackingLine[]): boolean;
    /** The product counter number becomes a part of table title string. Needs a special handling when deleting lines */
    setTableTitle(lines: TrackingLine[], tableLineDelete?: boolean): string;
    /** Get the lines from Page Storage and map them to the Table lines */
    setTableLines(lines: TrackingLine[]): Partial<TrackingLineTable>[];
    mapTableLines(lines: TrackingLine[]): {
        _id: string;
        product: string;
        description: string;
        quantityAndStockUnit: string;
    }[];
    /** GraphQL Getters */
    getEntryTransaction(): Promise<string[]>;
    /** Get the product line details and set the field value when work order has only one released product */
    getSetWOProduct(): Promise<void>;
    /** Validate the page, set storage and session, go to the details page */
    validateGoToDetailsPage(): Promise<void>;
}
//# sourceMappingURL=mobile-production-reporting.d.ts.map