/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/get-unit-of-measure.ts":
/*!*****************************************************!*\
  !*** ./lib/client-functions/get-unit-of-measure.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getUOM = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * This function retrieves the unit of measure details for a given unit of measure code.\n * @param pageInstance The current page instance where the function is called.\n * @param uom The unit of measure code to retrieve details for.\n * @returns An object containing the unit of measure details, or an empty object if an error occurs.\n */\nasync function getUOM(pageInstance, uom) {\n    try {\n        const UnitOfMeasure = await pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .read({\n            _id: true,\n            code: true,\n            numberOfDecimals: true,\n        }, `${uom}`)\n            .execute();\n        return UnitOfMeasure;\n    }\n    catch (error) {\n        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__utils__get_unit_of_measure_error', 'An error occurred when loading unit of measure'), String(error));\n        return {};\n    }\n}\nexports.getUOM = getUOM;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/get-unit-of-measure.ts\n");

/***/ }),

/***/ "./lib/client-functions/stock-management-rules.ts":
/*!********************************************************!*\
  !*** ./lib/client-functions/stock-management-rules.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.findDefaultLocation = exports.findStockManagementRules = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance) {\n    try {\n        //read the stock management rules\n        const stockManagementRules = await pageInstance.$.graph\n            .node('@sage/x3-stock-data/StockManagementRules')\n            .query(ui.queryUtils.edgesSelector({\n            productCategory: { code: true },\n            stockSite: { code: true },\n            transactionType: true,\n            stockMovementCode: { code: true },\n            defaultStatus: true,\n            locationNumber: true,\n            locationNumber2: true,\n            locationNumber3: true,\n            authorizedStatus: true,\n            authorizedSubstatus: true,\n            hasAnalysisRequest: true,\n            lotEntry: true,\n            lotByDefault: true,\n            outputLot: true,\n            isExclusiveEntryVersion: true,\n            activeVersion: true,\n            licensePlateNumberEntry: true,\n            versionStopped: true,\n            prototypeVersion: true,\n        }, {\n            filter: {\n                productCategory: { code: productCategory },\n                stockSite: { code: stockSite },\n                transactionType: transactionType,\n                stockMovementCode: { code: stockMovementCode },\n            },\n        }))\n            .execute();\n        if (typesLib.gt(stockManagementRules.edges.length, 0))\n            return stockManagementRules.edges[0].node;\n        else\n            return null;\n    }\n    catch (e) { }\n}\nasync function findStockManagementRules(stockSite, productCategory, transactionType, //TRSTYP, menu 704\nstockMovementCode, //TRSCOD\npageInstance) {\n    // for the stock site, the product category and the movement code\n    let stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for stock site and product category\n    stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category and movement code\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // general rules\n    stockManagementRules = await _readStockManagementRules(null, null, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    throw new Error(ui.localize('@sage/x3-manufacturing/stock_management_rules__notification__no_management_rules_error', `Could not retrieve the management rules for your product category {{ productCategory }} and for the site {{ siteCode }}`, { productCategory: productCategory, siteCode: stockSite }));\n}\nexports.findStockManagementRules = findStockManagementRules;\nasync function _readProductCategorySite(stockSite, productCategory, pageInstance) {\n    try {\n        //read the product category site\n        const productCategorySite = await pageInstance.$.graph\n            .node('@sage/x3-master-data/productCategory')\n            .read({\n            stockSite: { code: true },\n            code: true,\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: { code: true },\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n        }, `${stockSite}|${productCategory}`)\n            .execute();\n        return productCategorySite ?? null;\n    }\n    catch (e) {\n        return null;\n    }\n}\nasync function findDefaultLocation(productSite, stockManagementRules, pageInstance) {\n    // find the default location for the product site\n    const defaultLocation = productSite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n    if (defaultLocation &&\n        defaultLocation.node.defaultLocation &&\n        !defaultLocation.node.defaultLocation.match(/[* ! # ?]/))\n        return defaultLocation.node.defaultLocation;\n    // find the default location for the product category site\n    const ProductCategorySite = await _readProductCategorySite(productSite.stockSite.code, productSite.product.productCategory.code, pageInstance);\n    if (ProductCategorySite) {\n        const defaultLocationCateg = ProductCategorySite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n        if (defaultLocationCateg &&\n            defaultLocationCateg.node.defaultLocation &&\n            !defaultLocationCateg.node.defaultLocation.match(/[* ! # ?]/))\n            return defaultLocationCateg.node.defaultLocation;\n    }\n    return null;\n}\nexports.findDefaultLocation = findDefaultLocation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/stock-management-rules.ts\n");

/***/ }),

/***/ "./lib/client-functions/validation.ts":
/*!********************************************!*\
  !*** ./lib/client-functions/validation.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.validateWithDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n//TODO: not a fan of passing \"this\" in argument as the execution context. Class constructor, bind?\nasync function validateWithDetails(pageInstance) {\n    await pageInstance.$.commitValueAndPropertyChanges(); // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-manufacturing/pages__utils__notification__invalid_inputs_error', `Please check your inputs for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        fieldNames: errors.map((error) => \n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/validation.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-production-reporting-details.ts":
/*!**********************************************************!*\
  !*** ./lib/pages/mobile-production-reporting-details.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileProductionReportingDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst get_unit_of_measure_1 = __webpack_require__(/*! ../client-functions/get-unit-of-measure */ \"./lib/client-functions/get-unit-of-measure.ts\");\nconst stock_management_rules_1 = __webpack_require__(/*! ../client-functions/stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\nconst validation_1 = __webpack_require__(/*! ../client-functions/validation */ \"./lib/client-functions/validation.ts\");\nlet lotManagement = '';\nlet stockManagementRule;\nlet MobileProductionReportingDetails = class MobileProductionReportingDetails extends ui.Page {\n    async initPage() {\n        const stockSite = this.getStockSite();\n        const { productLine, workOrderNumber } = this.getStorageObject();\n        const { product, stockUnit, productCategory, lot } = productLine;\n        const unitOfMeasure = stockUnit?.code;\n        const { serialNumberManagementMode, code } = product;\n        const lines = this.getTrackingLines();\n        const locationManagementMode = await this.getLocationManagementRules(code, stockSite);\n        const { defaultInternalContainer } = locationManagementMode;\n        lotManagement = await this.lotManagement(lot, productCategory);\n        stockManagementRule = await (0, stock_management_rules_1.findStockManagementRules)(this.getStockSite(), productCategory || '', '5', // Work order receipt\n        null, this);\n        this.setHeaderFields(product, stockSite);\n        this.workOrderNumber.value = workOrderNumber.number;\n        this.stockStatus.options = await this.getStockStatuses();\n        this.stockStatus.value = stockManagementRule.defaultStatus;\n        await this.expirationManagement(lotManagement, productLine.product.code);\n        this.container.value = defaultInternalContainer;\n        this.containerFieldLogic(this.container.value, this.location.value);\n        this.close.value = true;\n        this.toggleManageByLocationFields(locationManagementMode);\n        this.toggleManageBySerialNumberField(serialNumberManagementMode);\n        await this.setLotFieldBehaviour(lotManagement);\n        this.productSite = await this.getProductSite();\n        try {\n            if (!this.suggestedLocation.isHidden) {\n                this.suggestedLocation.value = await this.getLocations(stockSite);\n                this.suggestedLocation.value.code = await (0, stock_management_rules_1.findDefaultLocation)(this.productSite, stockManagementRule, this);\n                if (this.suggestedLocation.value.code && !this.location.isHidden) {\n                    this.location.value = this.suggestedLocation.value;\n                    this.location.value.code = this.suggestedLocation.value.code;\n                }\n                if (!this.suggestedLocation.value.code)\n                    this.suggestedLocation.isHidden = true;\n            }\n        }\n        catch (error) {\n            this.suggestedLocation.isHidden = true;\n        }\n        this.initPackingUnitFields();\n        this.stockUnit.value = unitOfMeasure ?? 'UN';\n        this.initPackingUnitToStockUnitConversionFactor();\n        this.remainingQuantity.value = this.calculateQuantity(lines, productLine);\n    }\n    async getProductSite() {\n        try {\n            const productSiteToReceive = await this.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .read({\n                stockSite: { code: true },\n                isLocationManaged: true,\n                isLicensePlateNumberManaged: true,\n                defaultInternalContainer: {\n                    code: true,\n                },\n                defaultLocations: {\n                    query: {\n                        edges: {\n                            node: {\n                                defaultLocation: true,\n                                locationNumber: true,\n                                defaultLocationType: true,\n                            },\n                        },\n                    },\n                },\n                product: {\n                    code: true,\n                    localizedDescription1: true,\n                    productCategory: {\n                        code: true,\n                    },\n                    lotManagementMode: true,\n                    serialNumberManagementMode: true,\n                    stockVersionMode: true,\n                    expirationManagementMode: true,\n                    serialSequenceNumber: true,\n                    lotSequenceNumber: true,\n                    stockManagementMode: true,\n                    defaultPotencyInPercentage: true,\n                    expirationLeadTime: true,\n                    expirationTimeUnit: true,\n                    useByDateCoefficient: true,\n                    stockUnit: {\n                        code: true,\n                        numberOfDecimals: true,\n                        _id: true,\n                    },\n                    packingUnits: {\n                        query: {\n                            edges: {\n                                node: {\n                                    packingUnit: {\n                                        code: true,\n                                        numberOfDecimals: true,\n                                        _id: true,\n                                    },\n                                    packingUnitToStockUnitConversionFactor: true,\n                                    isPackingFactorEntryAllowed: true,\n                                    _id: true,\n                                },\n                            },\n                        },\n                    },\n                },\n            }, `${this.product.value}|${this.site.value}`)\n                .execute();\n            return productSiteToReceive;\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___product_site_error', 'Error while reading product site {{product_site}} for the product {{product}}.', {\n                product_site: this.site.value,\n                product: this.product.value,\n            }), String(err));\n            return {};\n        }\n    }\n    /**\n     * Get stock site from this.$.storage\n     * @returns string -  site code\n     */\n    getStockSite() {\n        try {\n            const stockSite = this.$.storage.get('mobile-selected-stock-site');\n            return stockSite;\n        }\n        catch (err) {\n            this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_completed_quantity___stock_site_error', 'The stock site is not defined'), { type: 'error', timeout: 5000 });\n            return '';\n        }\n    }\n    getStorageObject() {\n        try {\n            let storageObject = this.$.storage.get('production_reporting');\n            return storageObject;\n        }\n        catch (err) {\n            this.showStorageError();\n            return undefined;\n        }\n    }\n    getProductLine() {\n        try {\n            let { productLine } = this.getStorageObject() || {};\n            return productLine;\n        }\n        catch (err) {\n            this.showStorageError();\n            return {};\n        }\n    }\n    getTrackingLines() {\n        try {\n            let { quantityTracking } = this.getStorageObject() || {};\n            return quantityTracking.workOrderProductionReportingLines;\n        }\n        catch (err) {\n            this.showStorageError();\n            return [];\n        }\n    }\n    showStorageError() {\n        this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___empty_storage_object_error', 'Storage object is empty'), { type: 'error', timeout: 5000 });\n        this.$.router.goTo('@sage/x3-manufacturing/MobileProductionReporting');\n    }\n    initTrackingLines(storageObject) {\n        let { transaction, trackingDate, productLine, quantityTracking } = storageObject;\n        let { product, stockUnit, workOrder } = productLine;\n        let stockSite = this.getStockSite();\n        let trackingLine = quantityTracking.workOrderProductionReportingLines;\n        let lineCounter = 0;\n        let actualQuantityStockUnit = 0;\n        const YYYYMMDDdate = (date) => {\n            const year = date.slice(0, 4);\n            const month = date.slice(5, 7);\n            const day = date.slice(8, 10);\n            return `${year}-${month}-${day}`;\n        };\n        let close = 1;\n        if (typesLib.strictEq(this.close.value, true)) {\n            close = 2;\n        }\n        let lotValue = typesLib.strictEq(this.lotText.value, '') ? this.lot.value?.code : this.lotText.value;\n        actualQuantityStockUnit = this.convertUnitToStockUnit(this, product.code, stockSite, Number(this.remainingQuantity.value), this.stockUnit.value ?? '', stockUnit.code, this.conversionFactor.value ?? 1);\n        typesLib.strictNe(trackingLine.length, 0) && (lineCounter = trackingLine.length);\n        trackingLine[lineCounter] = {\n            ...trackingLine[lineCounter],\n            productionSite: stockSite,\n            orderNo: workOrder.number,\n            product: product.code,\n            orderLineNumber: productLine.lineNumber,\n            actualQuantity: this.remainingQuantity.value,\n            releaseUnit: this.stockUnit.value,\n            stkConversion: this.conversionFactor.value ?? 1,\n            postingDate: trackingDate,\n            transactionCode: transaction,\n            balance: close,\n            rejectedQty: '',\n            project: '',\n            licensePlateNumber: this.licensePlateNumber.value?.code ?? '',\n            serialNumber: this.serialNumber.value ?? '',\n            destinationCode: this.$.storage.get('mobile-label-destination'),\n            /** description removed before mutation */\n            description: product.localizedDescription1,\n            quantityInStockUnit: actualQuantityStockUnit,\n            stockJournal: [\n                {\n                    expirationDate: YYYYMMDDdate(this.expirationDate.value ?? '2099-12-31'),\n                    packingUnit: this.stockUnit.value,\n                    quantityInPackingUnit: this.remainingQuantity.value,\n                    packingUnitToStockUnitConversionFactor: this.conversionFactor.value ?? 1,\n                    location: this.location.value?.code ?? '',\n                    status: this.stockStatus.value,\n                    lot: lotValue ?? '',\n                    sublot: this.sublot.value ?? '',\n                    identifier1: '',\n                    identifier2: '',\n                },\n            ],\n        };\n        return trackingLine;\n    }\n    saveQuantityTracking(storageObject) {\n        let { quantityTracking } = storageObject;\n        quantityTracking.workOrderProductionReportingLines = this.initTrackingLines(storageObject);\n        this.$.storage.set('production_reporting', storageObject);\n    }\n    async buttonsLogic(displayMsg) {\n        let storageObject = this.getStorageObject();\n        this.saveQuantityTracking(storageObject);\n        if (typesLib.strictEq(displayMsg, true)) {\n            this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___quantity_added', 'Quantity added.'), { type: 'success', timeout: 3000 });\n        }\n        this.$.setPageClean();\n    }\n    /** Fields Methods */\n    calculateQuantity(lines, productLine) {\n        let { product, remainingQuantity, workOrder } = productLine;\n        let currentProduct = lines.filter((line) => typesLib.strictEq(line.product, product?.code) && typesLib.strictEq(line.orderNo, workOrder?.number));\n        let blockedQuantity = currentProduct.reduce((sum, item) => {\n            return (sum = typesLib.add(sum, item.quantityInStockUnit));\n        }, 0);\n        const workOrderRemainingQuantity = Number(remainingQuantity) || 0;\n        let availableQuantity = typesLib.max(0, typesLib.sub(workOrderRemainingQuantity, blockedQuantity));\n        return availableQuantity;\n    }\n    toggleManageBySerialNumberField(serialNumberManagementMode) {\n        if (typesLib.strictEq(serialNumberManagementMode, 'notManaged')) {\n            return (this.serialNumber.isHidden = true);\n        }\n        else {\n            return (this.serialNumber.isHidden = false);\n        }\n    }\n    toggleManageByLocationFields(locationManagementMode) {\n        let { isLocationManaged, isLicensePlateNumberManaged } = locationManagementMode;\n        this.location.isHidden = !isLocationManaged;\n        this.container.isHidden = !isLicensePlateNumberManaged;\n        this.licensePlateNumber.isHidden = !isLicensePlateNumberManaged;\n    }\n    async lotManagement(lot, productCategory) {\n        const lotManagementMode = await this.getLotManagementMode();\n        let lotManaged = 0;\n        lotManaged = typesLib.strictEq(lotManagementMode, 'notManaged') ? 0 : 1;\n        if (typesLib.strictNe(lotManaged, 0)) {\n            if (typesLib.strictNe(lot, '')) {\n                this.lotText.value = lot;\n                this.lotText.isReadOnly = true;\n                this.lot.isReadOnly = true;\n                this.sublot.value = '00001';\n                this.sublot.isReadOnly = true;\n            }\n        }\n        return lotManagementMode;\n    }\n    async expirationManagement(lotManagement, product) {\n        if (!lotManagement) {\n            this.expirationDate.isHidden = true;\n        }\n        else {\n            let expirationManagement = await this.getExpirationManagementMode(product);\n            let expirationUOM = 0;\n            expirationUOM = typesLib.strictEq(expirationManagement[0].expirationTimeUnit, 'month') ? 0 : 1;\n            let calculatedDate = xtrem_date_time_1.DateValue.today();\n            switch (expirationManagement[0].expirationManagementMode) {\n                case 'notManaged': {\n                    this.expirationDate.isDisabled = true;\n                    return;\n                }\n                case 'withoutRounding':\n                case 'mandatoryEntry': {\n                    if (expirationUOM) {\n                        calculatedDate = calculatedDate.addDays(expirationManagement[0].expirationLeadTime);\n                    }\n                    else {\n                        calculatedDate = calculatedDate.addMonths(expirationManagement[0].expirationLeadTime);\n                    }\n                    break;\n                }\n                case 'roundingMonthEnd': {\n                    if (expirationUOM) {\n                        calculatedDate = calculatedDate.endOfMonth();\n                    }\n                    else {\n                        calculatedDate = calculatedDate\n                            .addMonths(expirationManagement[0].expirationLeadTime)\n                            .endOfMonth();\n                    }\n                    break;\n                }\n                case 'roundingBeginningMonth1': {\n                    if (expirationUOM) {\n                        calculatedDate = calculatedDate.addMonths(1).begOfMonth();\n                    }\n                    else {\n                        calculatedDate = calculatedDate\n                            .addMonths(typesLib.add(expirationManagement[0].expirationLeadTime, 1))\n                            .begOfMonth();\n                    }\n                    break;\n                }\n                case 'manualEntry': {\n                    return;\n                }\n            }\n            this.expirationDate.value = calculatedDate.toString();\n        }\n    }\n    containerFieldLogic(containerValue, locationValue) {\n        if (containerValue && locationValue) {\n            this.licensePlateNumber.isDisabled = false;\n        }\n        else {\n            this.licensePlateNumber.isDisabled = true;\n            this.licensePlateNumber.value = null;\n        }\n    }\n    /**\n     * Populate header card\n     * @param {Partial<Product>} { code, localizedDescription1 }\n     * @param {string} site\n     * @memberof MobileProductionReportingDetails\n     */\n    async setHeaderFields({ code, localizedDescription1 }, site) {\n        this.product.value = code;\n        this.localizedDescription.value = localizedDescription1;\n        this.site.value = site;\n        // Display product picture\n        const productPicture = await this.$.graph\n            .node('@sage/x3-master-data/Product')\n            .read({ picture: { value: true } }, `${this.product.value}| `)\n            .execute();\n        this.image.value = productPicture?.picture ?? undefined;\n        this.$.setPageClean();\n    }\n    async getStockStatuses() {\n        try {\n            return (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/StockStatus')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }))\n                .execute()).map((status) => status.code);\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___loading_stock_status_error', 'Error loading stock statuses'), String(err));\n            return [''];\n        }\n    }\n    /**\n     * Get the locations for the stock site\n     * @param site\n     * @returns StockLocation[]\n     */\n    async getLocations(site) {\n        const response = await this.$.graph\n            .node('@sage/x3-stock-data/Stock')\n            .query(ui.queryUtils.edgesSelector({\n            location: { code: true, type: true },\n        }, {\n            filter: {\n                stockSite: { code: site },\n            },\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details__loading_location_error', 'No location found for the stock site'));\n        }\n        return response.edges.map(({ node: { location } }) => location);\n    }\n    async getLocationManagementRules(product, stockSite) {\n        try {\n            const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .query(ui.queryUtils.edgesSelector({\n                isLocationManaged: true,\n                isLicensePlateNumberManaged: true,\n                defaultInternalContainer: { code: true },\n            }, {\n                filter: {\n                    product: { code: product },\n                    stockSite: {\n                        code: stockSite,\n                    },\n                },\n            }))\n                .execute());\n            return result[0];\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___loading_location_management_error', 'Error loading location management status'), String(err));\n            return;\n        }\n    }\n    async getLotManagementMode() {\n        let { product } = this.getProductLine();\n        try {\n            const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-master-data/Product')\n                .query(ui.queryUtils.edgesSelector({\n                lotManagementMode: true,\n            }, {\n                filter: {\n                    code: product?.code,\n                },\n            }))\n                .execute());\n            return result[0].lotManagementMode;\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___getting_lot_management_product_error', 'Error getting lot management for product'), String(err));\n            return '';\n        }\n    }\n    async getCategoryLotManagementMode(productCategory) {\n        try {\n            const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-master-data/ProductCategory')\n                .query(ui.queryUtils.edgesSelector({\n                lotManagementMode: true,\n            }, {\n                filter: {\n                    code: productCategory,\n                },\n            }))\n                .execute());\n            return result[0].lotManagementMode;\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___getting_lot_management_product_category_error', 'Error getting lot management for product category'), String(err));\n            return '';\n        }\n    }\n    async lotExists(lotCode, product) {\n        try {\n            const response = await this.$.graph\n                .node('@sage/x3-stock-data/Lot')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n                sublot: true,\n            }, {\n                filter: {\n                    code: lotCode,\n                    product: product,\n                },\n            }))\n                .execute();\n            return response.edges.length;\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___loading_lot_error', 'Error loading lot'), String(err));\n            return 0;\n        }\n    }\n    /**\n     * findSerialNumber - search table STOSER for a selected product serial number\n     * @param product\n     * @param serialNumber\n     * @returns boolean\n     */\n    async findSerialNumber(product, serialNumber) {\n        try {\n            const serialNoResults = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/SerialNumber')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }, {\n                filter: {\n                    product: product.code,\n                    code: serialNumber,\n                },\n            }))\n                .execute());\n            if (typesLib.gt(serialNoResults.length, 0)) {\n                return false;\n            }\n            else {\n                return true;\n            }\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___checking_serial_number_error', 'Error checking existing serial numbers'), String(err));\n            return false;\n        }\n    }\n    async getExpirationManagementMode(product) {\n        try {\n            const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-master-data/Product')\n                .query(ui.queryUtils.edgesSelector({\n                expirationManagementMode: true,\n                expirationStockStatus: true,\n                expirationLeadTime: true,\n                expirationTimeUnit: true,\n            }, {\n                filter: {\n                    code: product,\n                },\n            }))\n                .execute());\n            return result;\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___expiration_management_error', 'Error getting expiration management for product'), String(err));\n            return;\n        }\n    }\n    /** Get the LOT sequence for a product */\n    async getLotSequence() {\n        let { product } = this.getProductLine();\n        try {\n            const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-master-data/Product')\n                .query(ui.queryUtils.edgesSelector({\n                lotSequenceNumber: true,\n            }, {\n                filter: {\n                    code: product?.code,\n                },\n            }))\n                .execute());\n            return result[0].lotSequenceNumber;\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___getting_lot_sequence_product_error', 'Error getting lot sequence for product.'), String(err));\n            return '';\n        }\n    }\n    /**\n     *  Set the isHidden and isMandatory values for UI\n     *  properties affected by a products lot management mode\n     *\n     * @private\n     * @param {string} mode\n     * @memberof MobileProductionReportingDetails\n     */\n    async setLotFieldBehaviour(mode) {\n        if (typesLib.strictEq(mode, 'notManaged')) {\n            this.lot.isHidden = true;\n            this.lotText.isHidden = true;\n            this.sublot.isHidden = true;\n            this.expirationDate.isHidden = true;\n        }\n        if (typesLib.strictEq(mode, 'optionalLot') || typesLib.strictEq(lotManagement, 'mandatoryLot')) {\n            this.lot.isHidden = false;\n            this.lotText.isHidden = false;\n            this.lot.isMandatory = false;\n            this.lotText.isMandatory = false;\n            this.sublot.isHidden = true;\n        }\n        if (typesLib.strictEq(mode, 'lotAndSublot')) {\n            this.lot.isHidden = false;\n            this.lotText.isHidden = false;\n            this.lot.isMandatory = false;\n            this.lotText.isMandatory = false;\n            this.sublot.isHidden = false;\n        }\n    }\n    /**\n     * Test that the required lot values have been entered as\n     * required by the products lot management rules\n     * @param {*} mode\n     * @return {*}  {Promise<boolean>}\n     * @memberof MobileProductionReportingDetails\n     */\n    async lotValuesAreValid(mode) {\n        if (typesLib.strictEq(mode, 'mandatoryLot') || typesLib.strictEq(mode, 'lotAndSublot')) {\n            if (typesLib.strictNe(stockManagementRule.lotEntry, 'free')) {\n                if (!this.lot.value && !this.lotText.value) {\n                    this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details___lot_not_set_error', 'A lot has not been entered'), { type: 'error', timeout: 5000 });\n                    return false;\n                }\n            }\n        }\n        return true;\n    }\n    // Hotfix functions for unit of measure - packing units\n    /**\n     * Determines all the packing units of the product site and sets them to the packingUnits array.\n     * Fills the stock unit options with the stock unit and packing units.\n     */\n    initPackingUnitFields() {\n        // Gets all the packing units from the product site.\n        let productPackingList = (0, xtrem_client_1.extractEdges)(this.productSite.product.packingUnits.query).filter(productPacking => {\n            return !!productPacking.packingUnit?.code;\n        });\n        // Gets the node for each packing unit.\n        this.packingUnits = productPackingList.map(productPacking => {\n            return { node: productPacking };\n        });\n        // Adds the stock unit as a packing unit.\n        this.packingUnits.push({\n            node: {\n                packingUnit: {\n                    code: this.productSite.product.stockUnit.code,\n                    numberOfDecimals: this.productSite.product.stockUnit.numberOfDecimals,\n                    _id: this.productSite.product.stockUnit._id,\n                },\n                packingUnitToStockUnitConversionFactor: '1',\n                isPackingFactorEntryAllowed: false,\n                _id: this.productSite.product.stockUnit._id,\n            },\n        });\n        // Gets only the packing unit codes from the product packing list.\n        let productPackingUnitSelectValues = productPackingList.map(productPacking => {\n            return productPacking.packingUnit.code;\n        });\n        this.conversionFactor.isHidden = false;\n        this.stockUnit.isHidden = false;\n        // Fills the stock unit options with the stock unit and packing units.\n        this.stockUnit.options = [this.productSite.product.stockUnit.code, ...productPackingUnitSelectValues];\n    }\n    /**\n     * Determines for the stock unit the conversion factor and enables or disables the conversion factor due to the packing unit array.\n     * Sets the number of decimals (scale) for the remaining quantity field.\n     */\n    async initPackingUnitToStockUnitConversionFactor() {\n        const selectedValue = this.stockUnit.value;\n        const packingUnitIndex = selectedValue\n            ? this.packingUnits.map(packingUnit => packingUnit.node.packingUnit.code).indexOf(selectedValue)\n            : -1;\n        if (typesLib.strictNe(packingUnitIndex, -1)) {\n            const selectedUnit = this.packingUnits[packingUnitIndex].node;\n            this.conversionFactor.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n            this.conversionFactor.isDisabled = !selectedUnit.isPackingFactorEntryAllowed;\n            this.remainingQuantity.scale = selectedUnit.packingUnit.numberOfDecimals;\n        }\n        else {\n            this.conversionFactor.value = 1;\n            this.conversionFactor.isDisabled = true;\n            if (this.stockUnit.value) {\n                this.productUnitOfMeasure = await (0, get_unit_of_measure_1.getUOM)(this, this.stockUnit.value ?? '');\n                this.remainingQuantity.scale = this.productUnitOfMeasure.numberOfDecimals;\n            }\n        }\n    }\n    /**\n     * Converts a quantity from a given unit of measure (UOM) to the stock unit.\n     * @param page The current page instance.\n     * @param productCode The product code for which the conversion is done.\n     * @param stockSite The stock site code where the product is located.\n     * @param quantity The quantity to convert.\n     * @param uom The unit of measure code of the quantity.\n     * @param stockUnitUom The stock unit of measure code.\n     * @param conversionFactor The conversion factor to apply if different to the definition entered.\n     * @returns The converted quantity in stock unit.\n     */\n    convertUnitToStockUnit(page, productCode, stockSite, quantity, uom, stockUnitUom, conversionFactor) {\n        if (!productCode || !stockSite || !quantity || !uom || !stockUnitUom || !conversionFactor)\n            return 0;\n        let packingUnits;\n        let convertedQuantity = 0;\n        packingUnits = page.productSite.product.packingUnits?.query.edges.map(packingUnit => {\n            return packingUnit;\n        });\n        packingUnits.push({\n            node: {\n                packingUnit: {\n                    code: page.productSite.product.stockUnit.code,\n                    numberOfDecimals: page.productSite.product.stockUnit.numberOfDecimals,\n                    _id: page.productSite.product.stockUnit._id,\n                },\n                packingUnitToStockUnitConversionFactor: '1',\n                isPackingFactorEntryAllowed: false,\n                _id: page.productSite.product.stockUnit._id,\n            },\n        });\n        const packingUnit = packingUnits.find(pu => typesLib.strictEq(pu.node.packingUnit.code, uom));\n        let factor = packingUnit ? Number(packingUnit.node.packingUnitToStockUnitConversionFactor) || 1 : 1;\n        if (typesLib.strictNe(conversionFactor, factor)) {\n            factor = conversionFactor;\n        }\n        let decimals = 0;\n        const stockUnit = packingUnits.find(pu => typesLib.strictEq(pu.node.packingUnit.code, stockUnitUom));\n        if (packingUnit && typesLib.strictNe(stockUnit?.node.packingUnit.numberOfDecimals, undefined)) {\n            decimals = stockUnit.node.packingUnit.numberOfDecimals;\n        }\n        convertedQuantity = Number(typesLib.mul(quantity, factor));\n        convertedQuantity = Number(convertedQuantity.toFixed(decimals));\n        return convertedQuantity;\n    }\n};\nexports.MobileProductionReportingDetails = MobileProductionReportingDetails;\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n    })\n], MobileProductionReportingDetails.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n    })\n], MobileProductionReportingDetails.prototype, \"localizedDescription\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n        isHidden: true,\n        prefix: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__site____prefix\", \"Site:\"),\n    })\n], MobileProductionReportingDetails.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n    })\n], MobileProductionReportingDetails.prototype, \"workOrderNumber\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileProductionReportingDetails.prototype, \"section\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.section;\n        },\n        isTitleHidden: true,\n    })\n], MobileProductionReportingDetails.prototype, \"block\", void 0);\n__decorate([\n    ui.decorators.imageField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileProductionReportingDetails.prototype, \"image\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__stockUnit____title\", \"Unit\"),\n        width: 'small',\n        options: ['UN'],\n        placeholder: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__stockUnit____placeholder\", \"Scan or select...\"),\n        isMandatory: true,\n        async onChange() {\n            if (!this.stockUnit.value)\n                return;\n            const selectedValue = this.stockUnit.value;\n            const packingUnitIndex = this.packingUnits\n                .map(packingUnit => packingUnit.node.packingUnit.code)\n                .indexOf(selectedValue);\n            if (typesLib.strictNe(packingUnitIndex, -1)) {\n                const selectedUnit = this.packingUnits[packingUnitIndex].node;\n                this.conversionFactor.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n                this.conversionFactor.isDisabled = !selectedUnit.isPackingFactorEntryAllowed;\n                this.remainingQuantity.value = 0;\n                this.remainingQuantity.scale = selectedUnit.packingUnit.numberOfDecimals;\n            }\n            else {\n                this.conversionFactor.value = 1;\n                this.conversionFactor.isDisabled = true;\n                if (this.stockUnit.value) {\n                    this.productUnitOfMeasure = await (0, get_unit_of_measure_1.getUOM)(this, this.stockUnit.value ?? '');\n                    this.remainingQuantity.value = 0;\n                    this.remainingQuantity.scale = this.productUnitOfMeasure.numberOfDecimals;\n                }\n            }\n        },\n    })\n], MobileProductionReportingDetails.prototype, \"stockUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__remainingQuantity____title\", \"Quantity\"),\n        isNotZero: true,\n        isMandatory: true,\n        validation: /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/,\n        onChange() {\n            let lines = this.getTrackingLines();\n            let productLine = this.getProductLine();\n            let remainingQuantity = this.calculateQuantity(lines, productLine);\n            let actualQuantityStockUnit = 0;\n            let stockSite = this.getStockSite();\n            actualQuantityStockUnit = this.convertUnitToStockUnit(this, productLine.product?.code ?? '', stockSite, Number(this.remainingQuantity.value), this.stockUnit.value ?? '', productLine.stockUnit?.code ?? '', this.conversionFactor.value ?? 1);\n            if (actualQuantityStockUnit) {\n                if (typesLib.gt(actualQuantityStockUnit, remainingQuantity)) {\n                    this.$.showToast(ui.localize('@sage/x3-manufacturing/pages__mobile_time_tracking_details___quantity__larger__expected__warning', 'The quantity is larger than expected.'), { type: 'warning', timeout: 5000 });\n                }\n                if (typesLib.gte(actualQuantityStockUnit, remainingQuantity)) {\n                    this.close.value = true;\n                }\n                else {\n                    this.close.value = false;\n                }\n            }\n        },\n    })\n], MobileProductionReportingDetails.prototype, \"remainingQuantity\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__conversionFactor____title\", \"Conversion factor\"),\n        isDisabled: true,\n        isTransient: true,\n        isMandatory: true,\n        isTransientInput: true,\n        placeholder: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__conversionFactor____placeholder\", \"Enter...\"),\n        isNotZero: true,\n        scale: 6,\n    })\n], MobileProductionReportingDetails.prototype, \"conversionFactor\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__stockStatus____title\", \"Status\"),\n        isMandatory: true,\n        isTransient: false,\n    })\n], MobileProductionReportingDetails.prototype, \"stockStatus\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__suggestedLocation____title\", \"Suggested location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isReadOnly: true,\n        width: 'large',\n        isTransient: true,\n        canFilter: false,\n    })\n], MobileProductionReportingDetails.prototype, \"suggestedLocation\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.block;\n        },\n        node: '@sage/x3-stock-data/Location',\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__location____title\", \"Location\"),\n        valueField: 'code',\n        placeholder: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__location____placeholder\", \"Scan or select...\"),\n        isMandatory: true,\n        isAutoSelectEnabled: true,\n        minLookupCharacters: 1,\n        isFullWidth: true,\n        isHidden: true,\n        filter() {\n            let stockSite = this.getStockSite();\n            return {\n                stockSite: { code: stockSite },\n            };\n        },\n        onChange() {\n            this.containerFieldLogic(this.container.value, this.location.value);\n            this.location.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__location____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__location____columns__title__type\", \"Type\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileProductionReportingDetails.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.block;\n        },\n        node: '@sage/x3-stock-data/Lot',\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__lot____title\", \"Lot\"),\n        valueField: 'code',\n        isMandatory: false,\n        placeholder: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__lot____placeholder\", \"Scan or select...\"),\n        isAutoSelectEnabled: true,\n        filter() {\n            let { product } = this.getProductLine();\n            let filter = {\n                product: { code: product?.code },\n                code: { _ne: '' },\n            };\n            return filter;\n        },\n        async onChange() {\n            if (this.lot.value) {\n                this.lot.value.code = this.lot.value.code.toUpperCase();\n                if (!this.sublot.isHidden) {\n                    this.sublot.value = this.lot.value.sublot;\n                    this.sublot.isDisabled = true;\n                    await this.$.commitValueAndPropertyChanges();\n                }\n            }\n            else {\n                if (!this.sublot.isHidden) {\n                    this.sublot.value = '';\n                    await this.$.commitValueAndPropertyChanges();\n                }\n            }\n            if (this.sublot.isHidden || this.sublot.isDisabled) {\n                this.container.focus();\n            }\n            this.lotText.value = '';\n            this.sublot.isReadOnly = false;\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__lot____columns__title__code\", \"Lot\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__lot____columns__title__sublot\", \"Sublot\"),\n            }),\n        ],\n    })\n], MobileProductionReportingDetails.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__lotText____title\", \"Lot\"),\n        maxLength: 15,\n        validation: /^$|^[^|]+$/,\n        async onChange() {\n            if (typesLib.strictNe(this.lotText.value, null)) {\n                this.lotText.value = this.lotText.value.trim().toUpperCase();\n                const stocklot = await this.lotExists(this.lotText.value, this.product.value);\n                if (typesLib.gt(stocklot, 0)) {\n                    await this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details_quantity_notification__Lot_error', 'Error with the lot number'), ui.localize('@sage/x3-manufacturing/pages__mobile_production_reporting_details_quantity_notification__Lot_exists_error', 'The lot number already exists'));\n                    this.lotText.value = '';\n                    this.lotText.focus();\n                }\n            }\n            this.lot.value = null;\n            this.sublot.isReadOnly = false;\n            this.sublot.isDisabled = false;\n        },\n    })\n], MobileProductionReportingDetails.prototype, \"lotText\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__sublot____title\", \"Sub-lot\"),\n        isMandatory: true,\n        maxLength: 5,\n        validation: /^$|^[^|]+$/,\n    })\n], MobileProductionReportingDetails.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__expirationDate____title\", \"Expiration date\"),\n        isMandatory: true,\n    })\n], MobileProductionReportingDetails.prototype, \"expirationDate\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__serialNumber____title\", \"Serial number\"),\n        validation: /^$|^[^|]+$/,\n        isMandatory: true,\n        isHidden: true,\n        async onChange() {\n            let { product } = this.getProductLine();\n            let serialNumberCheck = await this.findSerialNumber(product, this.serialNumber.value);\n            if (!serialNumberCheck) {\n                await this.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/pages__mobile_completed_quantity-details-quantity_notification__serial_number_error', 'Error with the serial number'), ui.localize('@sage/x3-manufacturing/pages__mobile_completed_quantity-details-quantity_notification__serial_number_exists_error', 'The serial number already exists'));\n                this.serialNumber.value = '';\n                this.serialNumber.focus();\n            }\n        },\n    })\n], MobileProductionReportingDetails.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.block;\n        },\n        node: '@sage/x3-master-data/Container',\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__container____title\", \"Container\"),\n        valueField: 'code',\n        placeholder: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__container____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isFullWidth: true,\n        isMandatory: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n            }),\n        ],\n        onChange() {\n            this.containerFieldLogic(this.container.value, this.location.value);\n            if (!this.licensePlateNumber.isDisabled) {\n                this.licensePlateNumber.focus();\n            }\n        },\n        onError(error, sourceScreenId, sourceElementId) {\n            return 'An error!';\n        },\n        isHidden: true,\n    })\n], MobileProductionReportingDetails.prototype, \"container\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.block;\n        },\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__licensePlateNumber____title\", \"License plate number\"),\n        valueField: 'code',\n        placeholder: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        isMandatory: true,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n            }),\n            ui.nestedFields.reference({\n                bind: 'container',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n            }),\n        ],\n        onChange() {\n            this.close.focus();\n        },\n        filter() {\n            try {\n                return {\n                    container: this.container.value,\n                    isActive: { _eq: true },\n                    stockSite: { code: this.site.value },\n                    location: {\n                        code: {\n                            _in: [this.location.value.code, undefined],\n                        },\n                    },\n                };\n            }\n            catch (err) {\n                return;\n            }\n        },\n        isHidden: true,\n    })\n], MobileProductionReportingDetails.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__close____title\", \"Close\"),\n    })\n], MobileProductionReportingDetails.prototype, \"close\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isTransient: true,\n        isReadOnly: true,\n        isHidden: true,\n    })\n], MobileProductionReportingDetails.prototype, \"lotManaged\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isTransient: true,\n        isReadOnly: true,\n        isHidden: true,\n    })\n], MobileProductionReportingDetails.prototype, \"sublotManaged\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__addQuantity____title\", \"Add quantity\"),\n        buttonType: 'secondary',\n        shortcut: ['f2'],\n        async onClick() {\n            if (!(await this.lotValuesAreValid(lotManagement)))\n                return;\n            if (!(await (0, validation_1.validateWithDetails)(this)))\n                return;\n            await this.buttonsLogic(true);\n            this.$.router.goTo('@sage/x3-manufacturing/MobileProductionReportingDetails');\n        },\n    })\n], MobileProductionReportingDetails.prototype, \"addQuantity\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details__nextPage____title\", \"Next\"),\n        buttonType: 'primary',\n        shortcut: ['f3'],\n        async onClick() {\n            if (!(await this.lotValuesAreValid(lotManagement)))\n                return;\n            if (!(await (0, validation_1.validateWithDetails)(this)))\n                return;\n            await this.buttonsLogic(false);\n            this.$.router.goTo('@sage/x3-manufacturing/MobileProductionReporting', {\n                gotLines: 'true',\n            });\n        },\n    })\n], MobileProductionReportingDetails.prototype, \"nextPage\", void 0);\nexports.MobileProductionReportingDetails = MobileProductionReportingDetails = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_production_reporting_details____title\", \"Production reporting details\"),\n        isTransient: false,\n        isTitleHidden: true,\n        module: 'x3-manufacturing',\n        mode: 'default',\n        headerCard() {\n            return {\n                title: this.product,\n                line2: this.localizedDescription,\n                titleRight: this.workOrderNumber,\n                line2Right: this.site,\n                image: this.image,\n            };\n        },\n        businessActions() {\n            return [this.addQuantity, this.nextPage];\n        },\n        async onLoad() {\n            await this.initPage();\n            this.remainingQuantity.focus();\n        },\n    })\n], MobileProductionReportingDetails);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-production-reporting-details.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-date-time":
/*!****************************************!*\
  !*** external "@sage/xtrem-date-time" ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-date-time");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-production-reporting-details.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;