import { GraphApi } from '@sage/x3-manufacturing-api';
import * as ui from '@sage/xtrem-ui';
import { MaterialTrackingLine, X3Response } from './utils/types';
export declare class MobileMaterialsConsumption extends ui.Page<GraphApi> {
    private _materialsConsumptionRecordManager;
    private _materialsConsumptionSession;
    private _gDosFab;
    private _gMtkAllMgt;
    private _productIsNotReleasedIfShortage;
    createButton: ui.PageAction;
    /** Create Button Methods */
    /**
     * Checks the response from X3 for errors. Controls the display success error screen.
     * First it handles a special case when in X3response:
     * severities 3 exists (hard fail),
     * workOrderProductionReporting.create.trackingNumber = null,
     * but the MFGTRACKNUM is being returned in diagnoses.message. Counts as success.
     * Than it Looks for severity 3 and 4, when none found Counts as success.
     * The rest is just an error.
     * @param {*} result The response from X3.
     * @return {*}  {boolean} True for win. False for fail.
     */
    getCreationStatus(result: X3Response): boolean;
    getTrackingNumber(result: X3Response): string | undefined;
    checkForErrorSeverities(result: X3Response): boolean;
    errorScreen(result: X3Response): Promise<void>;
    successScreen(result: X3Response): Promise<void>;
    errorDialogOption(): ui.dialogs.DialogOptions;
    successDialogOption(): ui.dialogs.DialogOptions;
    resetSessionStorage(): void;
    mainSection: ui.containers.Section;
    productBlock: ui.containers.Block;
    workOrderBlock: ui.containers.Block;
    trackingDate: ui.fields.Date;
    materialsConsumptionSite: ui.fields.Label;
    transaction: ui.fields.Select;
    legalCompany: ui.fields.Label;
    workOrder: ui.fields.Reference;
    unplannedMaterials: ui.fields.Checkbox;
    workCurrentUnplannedMaterials: ui.fields.Checkbox;
    productsReleased: ui.fields.Reference;
    private _isReleasedIfShortage;
    product: ui.fields.Reference;
    unplannedProduct: ui.fields.Reference;
    materialsConsumptionToCreate: ui.fields.Table<any>;
    initMaterialsConsumptionPage(): Promise<void>;
    private _initSite;
    private getListTransaction;
    private getGeneralParameters;
    private getMaterialsConsumptionSession;
    private goToDetailsPage;
    private _getLegalCompany;
    callCreationAPI(): Promise<X3Response>;
    private _mapMaterialsConsumptionDetails;
    calcProductsReleased(): Promise<void>;
    private storageObject;
    prepareCreation(): void;
    insertMaterialLine(materialLine: MaterialTrackingLine): void;
    initStorageObjectMaterial(): void;
    sortCreation(): void;
    calculateQuantityCreation(): void;
    /**
     * Get the stock withdrawal mode to be used when selecting componenets
     * @param type Entry Tranaction type
     * @param code Entry Tranaction Code
     * @returns string mode to be used
     */
    getStockWithdrawalMode(type: number, code: string): Promise<string>;
    /**
     * Get all the product codes for a given work order / product site
     *  with a selected stock withdrawal mode
     * @param workOrder
     * @param Site
     * @param stockWithdrawalMode
     * @returns componentList an aArray of product codes
     */
    getComponents(workOrder: string | null, site: string | null, withdrawalMode: string | null): Promise<string[]>;
    /**
     * Read Parameter Value
     *
     * @param parameterName
     * @param site
     * @returns
     */
    getParamValue(site: string | null, parameterName: string): Promise<string>;
}
//# sourceMappingURL=mobile-materials-consumption.d.ts.map