import { GraphApi } from '@sage/x3-manufacturing-api';
import { integer } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';
interface EntryTransaction {
    type: integer;
    transaction: string;
    isPreloading: boolean;
}
declare const EntryTransaction: EntryTransaction;
export declare class MobileMaterialsConsumptionDetails extends ui.Page<GraphApi> {
    private _materialsConsumptionRecordManager;
    private _materialsConsumptionSession;
    private _materialsConsumptionStockManagementRules;
    private getProductSettings;
    titleTextRight: ui.fields.Text;
    product: ui.fields.Text;
    description: ui.fields.Text;
    image: ui.fields.Image;
    addDetails: ui.PageAction;
    addProduct: ui.PageAction;
    sectionHeader: ui.containers.Section;
    blockProduct: ui.containers.Block;
    unit: ui.fields.Text;
    quantity: ui.fields.Numeric;
    status: ui.fields.Select;
    serialNumber: ui.fields.Reference;
    lot: ui.fields.Reference;
    sublot: ui.fields.Select;
    /** Location */
    location: ui.fields.Select;
    getLocations(): Promise<string[]>;
    setLocations(): Promise<void>;
    /** Licence Plate Number */
    licensePlateNumber: ui.fields.Select;
    getLicensePlateNumbers(_excludeBlank: boolean): Promise<string[]>;
    setLicensePlateNumbers(): Promise<void>;
    closeWoLine: ui.fields.Checkbox;
    lineNumber: ui.fields.Numeric;
    bomSequence: ui.fields.Numeric;
    bomNumber: ui.fields.Text;
    bomAlternative: ui.fields.Numeric;
    trackingDate: ui.fields.Text;
    private _validate;
    private _isFieldInvalid;
    private _initHeader;
    private _calQuantity;
    private _getTotalConsumedQTY;
    private _getTotalLotConsumedQTY;
    private _getSubLot;
    /**
     * Gets setting of the chosen entry transaction
     * @param keys transaction code
     * @returns isPreloading
     */
    getEntryTransactionSettings(keys: EntryTransaction): Promise<boolean>;
}
export {};
//# sourceMappingURL=mobile-materials-consumption-details.d.ts.map