/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/validation.ts":
/*!********************************************!*\
  !*** ./lib/client-functions/validation.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.validateWithDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n//TODO: not a fan of passing \"this\" in argument as the execution context. Class constructor, bind?\nasync function validateWithDetails(pageInstance) {\n    await pageInstance.$.commitValueAndPropertyChanges(); // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-manufacturing/pages__utils__notification__invalid_inputs_error', `Please check your inputs for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        fieldNames: errors.map((error) => \n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/validation.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-manufacturing-label-printing.ts":
/*!**********************************************************!*\
  !*** ./lib/pages/mobile-manufacturing-label-printing.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileManufacturingLabelPrinting = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_selected_stock_site_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-selected-stock-site */ \"../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\");\nconst other_1 = __webpack_require__(/*! @sage/x3-stock-data/build/lib/menu-items/other */ \"../../shared/x3-stock-data/build/lib/menu-items/other.js\");\nconst generic_print_report_1 = __webpack_require__(/*! @sage/x3-system/lib/client-functions/generic-print-report */ \"../../shared/x3-system/lib/client-functions/generic-print-report.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst validation_1 = __webpack_require__(/*! ../client-functions/validation */ \"./lib/client-functions/validation.ts\");\nlet MobileManufacturingLabelPrinting = class MobileManufacturingLabelPrinting extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this.productionLabel = '';\n    }\n    async _initSite() {\n        this.site.value = await (0, get_selected_stock_site_1.getSelectedStockSite)(this, ui.localize('@sage/x3-manufacturing/dialog-error-title', 'Error'), ui.localize('@sage/x3-manufacturing/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));\n    }\n    async _init() {\n        await this._initSite();\n        if (this.site.value) {\n            this.numberOfLabel.value = 1;\n            this.expirationDate.value = await this._getDate();\n            if (await this._getLabel()) {\n                this._setPrintButtonEnabled();\n                await this._getListStockUnit();\n                return true;\n            }\n        }\n        return false;\n    }\n    _setPrintButtonEnabled() {\n        this.printButton.isDisabled =\n            typesLib.strictEq(this.product.value, null) || typesLib.strictEq(this.destination.value, null) || typesLib.strictEq(this.stockUnit.value, '') || typesLib.strictEq(this.numberOfLabel.value, 0);\n    }\n    async _getDate() {\n        return xtrem_date_time_1.DateValue.today().toString();\n    }\n    async _getLabel() {\n        const options = {\n            acceptButton: {\n                text: ui.localize('@sage/x3-manufacturing/button-accept-ok', 'OK'),\n            },\n        };\n        const _response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-master-data/MobileAutomationSetup')\n            .query(ui.queryUtils.edgesSelector({\n            productionLabel: { reportName: true },\n            isAlwaysLabelDestination: true,\n        }, {\n            filter: {\n                _and: [\n                    { site: { code: this.site.value ?? '' } },\n                    { productionLabel: { reportName: { _ne: null } } },\n                ],\n            },\n            orderBy: { site: { code: -1 } },\n        }))\n            .execute());\n        if (!this._assignLabelWhenExisting(_response)) {\n            const _response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-master-data/MobileAutomationSetup')\n                .query(ui.queryUtils.edgesSelector({\n                productionLabel: { reportName: true },\n                isAlwaysLabelDestination: true,\n            }, {\n                filter: {\n                    _and: [{ site: '' }, { productionLabel: { reportName: { _ne: null } } }],\n                },\n            }))\n                .execute());\n            if (!this.site.value || !this._assignLabelWhenExisting(_response)) {\n                this.productionLabel = '';\n                this.isAlwaysLabelDestination = false;\n            }\n        }\n        if (typesLib.strictEq(this.productionLabel, '')) {\n            // CAUTION: Do not use await here\n            (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-manufacturing/dialog-error-title', 'Error'), ui.localize('@sage/x3-manufacturing/dialog-error-no-production-label-setup', 'No production label setup'), options);\n            return false;\n        }\n        const mobileLabelDestination = this.$.storage.get('mobile-label-destination');\n        if (typesLib.strictEq(this.isAlwaysLabelDestination, true)) {\n            if (!mobileLabelDestination) {\n                // CAUTION: Do not use await here\n                (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-manufacturing/dialog-error-title', 'Error'), ui.localize('@sage/x3-manufacturing/dialog-error-no-label-destination-defined', 'No label destination defined'), {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-manufacturing/button-accept-ok', 'OK'),\n                    },\n                });\n                return false;\n            }\n            else {\n                this.destination.isDisabled = true;\n                this.destination.value = { code: mobileLabelDestination };\n            }\n        }\n        else {\n            if (typesLib.strictNe(this.productionLabel, '')) {\n                this.destination.isDisabled = false;\n            }\n            if (mobileLabelDestination) {\n                this.destination.value = { code: mobileLabelDestination };\n            }\n        }\n        return true;\n    }\n    /**\n     * assign label when existing.\n     * @param _response\n     * @returns true when label assigned\n     */\n    _assignLabelWhenExisting(_response) {\n        return (!!_response?.length &&\n            _response.some(edge => {\n                const _label = edge.productionLabel?.reportName;\n                if (_label) {\n                    this.productionLabel = _label ?? '';\n                    this.isAlwaysLabelDestination = edge.isAlwaysLabelDestination;\n                }\n                return !!_label;\n            }));\n    }\n    showButDisablePage() {\n        this.product.isDisabled = true;\n        this.entryNumber.isDisabled = true;\n        this.stockUnit.isDisabled = true;\n        this.lot.isDisabled = true;\n        this.subLot.isDisabled = true;\n        this.receiptQuantity.isDisabled = true;\n        this.expirationDate.isDisabled = true;\n        this.numberOfLabel.isDisabled = true;\n        this.destination.isDisabled = true;\n    }\n    async _getListStockUnit() {\n        const response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n        }, {\n            first: 500,\n        }))\n            .execute());\n        if (response.length) {\n            const stockUnits = [];\n            response.some(edge => {\n                stockUnits.push(edge.code);\n            });\n            this.stockUnit.options = stockUnits;\n        }\n    }\n    async _callPrintAPI() {\n        let result;\n        const customParameters = {\n            site: this.site.value,\n            product: this.product?.value?.code,\n            entry: this.entryNumber.value,\n            stockunit: this.stockUnit.value,\n            lot: this.lot.value,\n            sublot: this.subLot.value,\n            receiptquantity: this.receiptQuantity.value,\n            expirationdate: this.expirationDate.value,\n            numberoflabels: this.numberOfLabel.value,\n        };\n        try {\n            result = await (0, generic_print_report_1.genericPrintReport)(this, this.productionLabel, '', this.destination.value?.code ?? '', customParameters);\n        }\n        catch (error) {\n            return error;\n        }\n        return result;\n    }\n};\nexports.MobileManufacturingLabelPrinting = MobileManufacturingLabelPrinting;\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__printButton____title\", \"Print\"),\n        buttonType: 'primary',\n        shortcut: ['f2'],\n        isDisabled: true,\n        async onClick() {\n            if (!(await (0, validation_1.validateWithDetails)(this)))\n                return;\n            this.printButton.isDisabled = true;\n            this.$.loader.isHidden = false;\n            const result = await this._callPrintAPI();\n            this.$.loader.isHidden = true;\n            if ((!result && typesLib.strictNe(result, 0)) || result instanceof Error) {\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-manufacturing/button-goback', 'Go back'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-manufacturing/button-cancel', 'Cancel'),\n                    },\n                    size: 'small',\n                };\n                let message = '';\n                if (!result?.message) {\n                    message = `${ui.localize('@sage/x3-manufacturing/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.')}`;\n                }\n                else {\n                    const _messages = [];\n                    const _results = result;\n                    let _diagnoses = _results?.diagnoses;\n                    if (typesLib.gt(_diagnoses?.length, 1)) {\n                        _diagnoses = _diagnoses.splice(0, typesLib.sub(_diagnoses.length, 1));\n                    }\n                    // This is used to retrieve messages from the Client() class otherwise BusinessRuleError\n                    ((_results?.errors\n                        ? _results.errors[0]?.extensions?.diagnoses\n                        : (_results?.innerError?.errors[0]?.extensions?.diagnoses ??\n                            _results.extensions?.diagnoses ??\n                            _diagnoses)) ?? [])\n                        .filter((d) => typesLib.gt(d.severity, 2) && d.message)\n                        .forEach((d) => {\n                        const _message = d.message.split(`\\n`);\n                        _messages.push(..._message);\n                    });\n                    const _result = _messages.length ? _messages : result.message.split(`\\n`);\n                    options.mdContent = true;\n                    message = `**${ui.localize('@sage/x3-manufacturing/dialog-print-an-error-occurred', 'An error occurred.')}**\\n\\n`;\n                    if (typesLib.strictEq(_result.length, 1)) {\n                        message = typesLib.add(message, `${_result[0]}`);\n                    }\n                    else {\n                        message = typesLib.add(message, _result.map(item => `* ${item}`).join('\\n'));\n                    }\n                }\n                this.$.loader.isHidden = true;\n                this.printButton.isDisabled = false;\n                await this.$.sound.error();\n                if (!(await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-manufacturing/dialog-error-title', 'Error'), message, options))) {\n                    return;\n                }\n            }\n            else {\n                // if success, first clean up session & reload the page, then display success message\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-manufacturing/button-accept-ok', 'OK'),\n                    },\n                };\n                await this.$.sound.success();\n                await (0, dialogs_1.dialogMessage)(this, 'success', ui.localize('@sage/x3-manufacturing/dialog-success-title', 'Success'), ui.localize('@sage/x3-manufacturing/dialog-success-production-labels-printed', '{{productionLabel}} labels printed.', {\n                    productionLabel: this.productionLabel,\n                }), options);\n                this.$.setPageClean();\n                await this.$.router.refresh();\n                this.product.focus();\n            }\n            this._setPrintButtonEnabled();\n        },\n    })\n], MobileManufacturingLabelPrinting.prototype, \"printButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: true,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"productBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: true,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"parametersBlock\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__product____title\", \"Product\"),\n        placeholder: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__product____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        helperTextField: 'description1',\n        filter() {\n            return {\n                productSites: {\n                    _atLeast: 1,\n                    stockSite: this.site.value ?? undefined,\n                },\n            };\n        },\n        onChange() {\n            this._setPrintButtonEnabled();\n        },\n        onError(error, originScreenId, originElementId) {\n            ui.console.warn(`Error on ${originScreenId} ${originElementId}: ${error.message || error}`);\n        },\n        isAutoSelectEnabled: true,\n        isTransient: true,\n        isMandatory: true,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__product____columns__title__code\", \"Product\"),\n                isReadOnly: true,\n                isTitleHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'description1',\n                title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__product____columns__title__description1\", \"Description\"),\n                isReadOnly: true,\n                isTitleHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/ProductCategory',\n                bind: 'productCategory',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__product____columns__title__productCategory__code\", \"Category\"),\n                isReadOnly: true,\n                isTitleHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productStatus',\n                title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__product____columns__title__productStatus\", \"Status\"),\n                isReadOnly: true,\n                isTitleHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'upc',\n                title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__product____columns__title__upc\", \"UPC code\"),\n                isReadOnly: true,\n                isTitleHidden: false,\n            }),\n        ],\n    })\n], MobileManufacturingLabelPrinting.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__entryNumber____title\", \"Entry no.\"),\n        maxLength: 20,\n        isMandatory: false,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"entryNumber\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__stockUnit____title\", \"Stock unit\"),\n        isMandatory: true,\n        onChange() {\n            this.stockUnit.getNextField(true)?.focus();\n        },\n    })\n], MobileManufacturingLabelPrinting.prototype, \"stockUnit\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__lot____title\", \"Lot\"),\n        maxLength: 15,\n        isMandatory: false,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__subLot____title\", \"Sub-lot\"),\n        maxLength: 5,\n        isMandatory: false,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"subLot\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__receiptQuantity____title\", \"Receipt quantity\"),\n        isMandatory: true,\n        validation: /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals) excluding 0\n        min: 0,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"receiptQuantity\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__expirationDate____title\", \"Expiration date\"),\n        isTransient: true,\n        isMandatory: false,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"expirationDate\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__numberOfLabel____title\", \"Number of labels\"),\n        isMandatory: true,\n        validation: /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals) excluding 0\n        min: 1,\n    })\n], MobileManufacturingLabelPrinting.prototype, \"numberOfLabel\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        node: '@sage/x3-system/Destination',\n        filter() {\n            return {\n                isActive: true,\n                destination: { _in: ['printer', 'zplPrinter'] },\n            };\n        },\n        valueField: 'code',\n        columns: [\n            ui.nestedFields.text({ bind: 'code', title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__destination____columns__title__code\", \"Code\"), canFilter: true }),\n            ui.nestedFields.text({ bind: 'description', title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__destination____columns__title__description\", \"Description\"), canFilter: true }),\n            ui.nestedFields.text({ bind: 'destination', title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__destination____columns__title__destination\", \"Type\"), canFilter: true }),\n            ui.nestedFields.text({ bind: 'printerName', title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__destination____columns__title__printerName\", \"Name\"), canFilter: true }),\n            ui.nestedFields.checkbox({ bind: 'isActive', isHidden: true }),\n            ui.nestedFields.text({ bind: 'destination', isHidden: true }),\n        ],\n        isAutoSelectEnabled: true,\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing__destination____title\", \"Label destination\"),\n        helperTextField: 'description',\n        canFilter: false,\n        parent() {\n            return this.parametersBlock;\n        },\n        onChange() {\n            this._setPrintButtonEnabled();\n        },\n    })\n], MobileManufacturingLabelPrinting.prototype, \"destination\", void 0);\nexports.MobileManufacturingLabelPrinting = MobileManufacturingLabelPrinting = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-manufacturing/pages__mobile_manufacturing_label_printing____title\", \"Production label printing\"),\n        mode: 'default',\n        menuItem: other_1.other,\n        priority: 400,\n        isTransient: false,\n        isTitleHidden: true,\n        authorizationCode: 'CWSPLP',\n        access: { node: '@sage/x3-system/GenericPrintReport' },\n        async onLoad() {\n            if (!(await this._init())) {\n                this.showButDisablePage();\n            }\n        },\n        businessActions() {\n            return [this.printButton];\n        },\n    })\n], MobileManufacturingLabelPrinting);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-manufacturing-label-printing.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL2RpYWxvZ3MudHMiLCJtYXBwaW5ncyI6Ijs7O0FBRUE7Ozs7Ozs7O0dBUUc7QUFDSSxLQUFLLFVBQVUsYUFBYSxDQUMvQixZQUFpQixFQUNqQixXQUFtQyxFQUNuQyxLQUFhLEVBQ2IsT0FBZSxFQUNmLE9BQWtDO0lBRWxDLE9BQU8sQ0FBQyxNQUFNLFlBQVksQ0FBQyxDQUFDLENBQUMsTUFBTTtTQUM5QixPQUFPLENBQUMsV0FBVyxFQUFFLEtBQUssRUFBRSxPQUFPLEVBQUUsT0FBTyxDQUFDO1NBQzdDLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUM7U0FDaEIsS0FBSyxDQUFDLEdBQUcsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFZLENBQUM7QUFDeEMsQ0FBQztBQVhELHNDQVdDO0FBRUQ7Ozs7Ozs7O0dBUUc7QUFDSSxLQUFLLFVBQVUsa0JBQWtCLENBQ3BDLFlBQWlCLEVBQ2pCLFdBQW1DLEVBQ25DLEtBQWEsRUFDYixPQUFlLEVBQ2YsT0FBa0M7SUFFbEMsT0FBTyxDQUFDLE1BQU0sWUFBWSxDQUFDLENBQUMsQ0FBQyxNQUFNO1NBQzlCLFlBQVksQ0FBQyxXQUFXLEVBQUUsS0FBSyxFQUFFLE9BQU8sRUFBRSxPQUFPLENBQUM7U0FDbEQsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQztTQUNoQixLQUFLLENBQUMsR0FBRyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQVksQ0FBQztBQUN4QyxDQUFDO0FBWEQsZ0RBV0MiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly94dHJlbUFydGlmYWN0Ly4uLy4uL3NoYXJlZC94My1tYXN0ZXItZGF0YS9saWIvY2xpZW50LWZ1bmN0aW9ucy9kaWFsb2dzLnRzP2Y0MGMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgdWkgZnJvbSAnQHNhZ2UveHRyZW0tdWknO1xuXG4vKipcbiAqIERpc3BsYXkgYSBkaWFsb2cgdHlwZWQgaW5mbyB3aXRoIGdpdmVuIHBhZ2UgaW5zdGFuY2UsIGRpYWxvZyBsZXZlbCwgbWVzc2FnZSBhbmQgb3B0aW9uYWxzIG9wdGlvbnMgYW5kIHRpdGxlXG4gKiBAcGFyYW0gcGFnZUluc3RhbmNlXG4gKiBAcGFyYW0gZGlhbG9nTGV2ZWwgbXVzdCBiZSBlcnJvciwgaW5mbywgc3VjY2VzcyBvciB3YXJuLlxuICogQHBhcmFtIHRpdGxlIGN1cnJlbnQgdGl0bGVcbiAqIEBwYXJhbSBtZXNzYWdlIG1lc3NhZ2UgdG8gZGlzcGxheS5cbiAqIEBwYXJhbSBvcHRpb25zIG9wdGlvbmFsIG9wdGlvbnMuXG4gKiBAcmV0dXJuc1xuICovXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gZGlhbG9nTWVzc2FnZShcbiAgICBwYWdlSW5zdGFuY2U6IGFueSxcbiAgICBkaWFsb2dMZXZlbDogdWkuZGlhbG9ncy5EaWFsb2dMZXZlbCxcbiAgICB0aXRsZTogc3RyaW5nLFxuICAgIG1lc3NhZ2U6IHN0cmluZyxcbiAgICBvcHRpb25zPzogdWkuZGlhbG9ncy5EaWFsb2dPcHRpb25zLFxuKTogUHJvbWlzZTxib29sZWFuPiB7XG4gICAgcmV0dXJuIChhd2FpdCBwYWdlSW5zdGFuY2UuJC5kaWFsb2dcbiAgICAgICAgLm1lc3NhZ2UoZGlhbG9nTGV2ZWwsIHRpdGxlLCBtZXNzYWdlLCBvcHRpb25zKVxuICAgICAgICAudGhlbigoKSA9PiB0cnVlKVxuICAgICAgICAuY2F0Y2goKCkgPT4gZmFsc2UpKSBhcyBib29sZWFuO1xufVxuXG4vKipcbiAqIERpc3BsYXkgYSBpbnF1aXJ5IGRpYWxvZyB3aXRoIGdpdmVuIHBhZ2UgaW5zdGFuY2UsIGRpYWxvZyBsZXZlbCwgbWVzc2FnZSBhbmQgb3B0aW9uYWxzIG9wdGlvbnMgYW5kIHRpdGxlXG4gKiBAcGFyYW0gcGFnZUluc3RhbmNlXG4gKiBAcGFyYW0gZGlhbG9nTGV2ZWwgbXVzdCBiZSBlcnJvciwgaW5mbywgc3VjY2VzcyBvciB3YXJuLlxuICogQHBhcmFtIHRpdGxlIGN1cnJlbnQgdGl0bGVcbiAqIEBwYXJhbSBtZXNzYWdlIG1lc3NhZ2UgdG8gZGlzcGxheS5cbiAqIEBwYXJhbSBvcHRpb25zIG9wdGlvbmFsIG9wdGlvbnMuXG4gKiBAcmV0dXJuc1xuICovXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gZGlhbG9nQ29uZmlybWF0aW9uKFxuICAgIHBhZ2VJbnN0YW5jZTogYW55LFxuICAgIGRpYWxvZ0xldmVsOiB1aS5kaWFsb2dzLkRpYWxvZ0xldmVsLFxuICAgIHRpdGxlOiBzdHJpbmcsXG4gICAgbWVzc2FnZTogc3RyaW5nLFxuICAgIG9wdGlvbnM/OiB1aS5kaWFsb2dzLkRpYWxvZ09wdGlvbnMsXG4pOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgICByZXR1cm4gKGF3YWl0IHBhZ2VJbnN0YW5jZS4kLmRpYWxvZ1xuICAgICAgICAuY29uZmlybWF0aW9uKGRpYWxvZ0xldmVsLCB0aXRsZSwgbWVzc2FnZSwgb3B0aW9ucylcbiAgICAgICAgLnRoZW4oKCkgPT4gdHJ1ZSlcbiAgICAgICAgLmNhdGNoKCgpID0+IGZhbHNlKSkgYXMgYm9vbGVhbjtcbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts":
/*!***********************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getSelectedStockSite = void 0;\nconst dialogs_1 = __webpack_require__(/*! ./dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\n/**\n * Return selected stock site for current application\n * @param pageInstance Current page instance\n * @param errorTitle error title when no default site exist\n * @param errorMessage error message when no default site exist\n * @returns default site or null\n */\nasync function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {\n    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');\n    if (!selectedSite) {\n        // Please note that there asynchronous processing is not prefixed by an await on purpose\n        // so that it can be processed in parallel and not block the main process.\n        // Be careful not to leave the current page before the user has closed this dialog box.\n        pageInstance.$.sound.error();\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);\n        return null;\n    }\n    else {\n        return selectedSite.toString();\n    }\n}\nexports.getSelectedStockSite = getSelectedStockSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/generic-print-payload-mapping.ts":
/*!************************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/generic-print-payload-mapping.ts ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GenericPrintPayloadMapping = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\n/** @internal */\nclass GenericPrintPayloadMapping {\n    /**\n     * Parse xtrem variable such as boolean and date to X3 format\n     * @param valueFromPayload\n     * @return value or undefined when type object is not authorized.\n     */\n    static xtremToLegacyDataFormatting(value) {\n        let valueFromPayload = value;\n        /**\n         * check if the variable is an instance of date\n         */\n        if (valueFromPayload instanceof xtrem_date_time_1.DateValue) {\n            valueFromPayload = valueFromPayload.value;\n        }\n        else if (typesLib.strictEq(typeof valueFromPayload, 'object') || typesLib.strictEq(typeof valueFromPayload, 'function')) {\n            /**\n             * check if the variable is an unsupported object instance or function\n             */\n            return undefined;\n        }\n        /**\n         * check if is in date format YYYY-MM-DD\n         */\n        const found = valueFromPayload?.toString().match(/([12]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01]))/g);\n        if (typesLib.strictNe(found, null)) {\n            return found?.toString().replace(/-/g, '');\n        }\n        /**\n         * if boolean translate\n         *  true -> 1 and false -> 0 to meet x3 variables\n         */\n        if (typesLib.strictEq(Boolean(valueFromPayload), valueFromPayload)) {\n            return valueFromPayload ? '2' : '1';\n        }\n        return String(valueFromPayload);\n    }\n    /**\n     *\n     * @param content Format content entry\n     * @returns JSON formatted objet\n     */\n    static stringifyContent(content) {\n        return JSON.stringify(content, (_key, value) => {\n            return value ?? '';\n        }, 4);\n    }\n    /**\n     * Convert a object to a string contain all properties/values\n     * @param object Object to convert.\n     * @returns String formatted.\n     */\n    static convertObjectToParameters(object) {\n        const _parameters = {\n            parametersNames: [],\n            parametersValues: [],\n        };\n        Object.entries(object).forEach(([key, value]) => {\n            const valueFormatted = GenericPrintPayloadMapping.xtremToLegacyDataFormatting(value);\n            if (typesLib.strictNe(valueFormatted, undefined)) {\n                _parameters.parametersNames.push(key);\n                _parameters.parametersValues.push(valueFormatted);\n            }\n        });\n        return _parameters;\n    }\n    /**\n     * Create a updated value of object ready to export (JSON) / specif format\n     * @param payloadContent\n     * @return updated payload\n     */\n    static updatePrintPayload(payloadContent) {\n        const _UpdatedPayloadContent = {};\n        const _payloadContent = JSON.parse(GenericPrintPayloadMapping.stringifyContent(payloadContent));\n        // prepare object to export without processing any object : boolean, date,number, string only\n        Object.entries(_payloadContent).forEach(([key, value]) => {\n            const valueComputed = GenericPrintPayloadMapping.xtremToLegacyDataFormatting(value);\n            if (typesLib.strictNe(valueComputed, undefined)) {\n                _UpdatedPayloadContent[key] = valueComputed;\n            }\n        });\n        return _UpdatedPayloadContent;\n    }\n    /**\n     * Build the page payload from the graphql one\n     * @param graphQLPayload\n     * @return parameters values\n     */\n    static buildGraphQLPayload(graphQLPayload) {\n        const _parameters = {\n            parametersNames: [],\n            parametersValues: [],\n        };\n        // Custom parameters has object\n        if (typesLib.eq(graphQLPayload, null) || typesLib.strictNe(typeof graphQLPayload, 'object') || typesLib.strictEq(Object.keys(graphQLPayload).length, 0)) {\n            throw Error('Custom parameters is mandatory');\n        }\n        const updatedGraphQLPayload = GenericPrintPayloadMapping.updatePrintPayload(graphQLPayload);\n        return GenericPrintPayloadMapping.convertObjectToParameters(updatedGraphQLPayload);\n    }\n}\nexports.GenericPrintPayloadMapping = GenericPrintPayloadMapping;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/generic-print-payload-mapping.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/generic-print-report.ts":
/*!***************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/generic-print-report.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.genericPrintReport = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst generic_print_payload_mapping_1 = __webpack_require__(/*! ./generic-print-payload-mapping */ \"../../shared/x3-system/lib/client-functions/generic-print-payload-mapping.ts\");\nasync function genericPrintReport(pageInstance, reportName, language, destination, graphQlPayload) {\n    let result;\n    if (typesLib.strictEq((reportName || ''), '')) {\n        throw new xtrem_shared_1.SystemError('Report name is mandatory');\n    }\n    if (typesLib.strictEq((destination || ''), '')) {\n        throw new xtrem_shared_1.SystemError('Destination is mandatory');\n    }\n    // Custom parameters has object\n    if (typesLib.eq(graphQlPayload, null) || typesLib.strictNe(typeof graphQlPayload, 'object') || typesLib.strictEq(Object.keys(graphQlPayload).length, 0)) {\n        throw new xtrem_shared_1.SystemError('Custom parameters is mandatory');\n    }\n    ui.console.debug(`Custom payload in input : ${JSON.stringify(graphQlPayload)}`);\n    const _customParameters = generic_print_payload_mapping_1.GenericPrintPayloadMapping.buildGraphQLPayload(graphQlPayload);\n    ui.console.debug(`Prepared custom payload : ${JSON.stringify(_customParameters)}`);\n    /**\n     * Explanation of errorCode cases :\n     *  n = Error code number.\n     *  0 = Done.\n     * -1 = Result of mutation not return expected errorCode message.\n     * -2 = Failure without error when calling mutation (unchanged value).\n     */\n    // Populate required arguments\n    const _mutationArgs = {\n        reportName: reportName,\n        language: language,\n        destination: destination,\n        parametersNames: _customParameters.parametersNames,\n        parametersValues: _customParameters.parametersValues,\n        errorCode: -2,\n    };\n    ui.console.debug(`Prepared mutation arguments : ${JSON.stringify(_mutationArgs)}`);\n    try {\n        result =\n            (await pageInstance.$.graph\n                .node('@sage/x3-system/GenericPrintReport')\n                .mutations.printReport({\n                reportName: false,\n                language: false,\n                destination: false,\n                parametersNames: false,\n                parametersValues: false,\n                errorCode: true,\n            }, {\n                parameters: _mutationArgs,\n            })\n                .execute())?.errorCode ?? -1;\n    }\n    catch (error) {\n        throw new xtrem_shared_1.SystemError(error.message, error);\n    }\n    return result;\n}\nexports.genericPrintReport = genericPrintReport;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/generic-print-report.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/build/lib/menu-items/other.js":
/*!****************************************************************!*\
  !*** ../../shared/x3-stock-data/build/lib/menu-items/other.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.other = void 0;\nexports.other = {\n    id: '@sage/x3-stock-data/other-root',\n    priority: 600,\n    title: 'Other',\n    icon: 'ellipsis_horizontal',\n};\n//# sourceMappingURL=other.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvb3RoZXIuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0QsYUFBYTtBQUNiLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly94dHJlbUFydGlmYWN0Ly4uLy4uL3NoYXJlZC94My1zdG9jay1kYXRhL2J1aWxkL2xpYi9tZW51LWl0ZW1zL290aGVyLmpzPzk5YzMiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5leHBvcnRzLm90aGVyID0gdm9pZCAwO1xuZXhwb3J0cy5vdGhlciA9IHtcbiAgICBpZDogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvb3RoZXItcm9vdCcsXG4gICAgcHJpb3JpdHk6IDYwMCxcbiAgICB0aXRsZTogJ090aGVyJyxcbiAgICBpY29uOiAnZWxsaXBzaXNfaG9yaXpvbnRhbCcsXG59O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9b3RoZXIuanMubWFwIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/build/lib/menu-items/other.js\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-date-time":
/*!****************************************!*\
  !*** external "@sage/xtrem-date-time" ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-date-time");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-manufacturing-label-printing.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;