"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkOrderSuggestion = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        productCode: {
            code: 'productCode',
        },
        originalSite: {
            code: 'originalSite',
        },
        customer: {
            code: 'customer',
        },
    },
    collectionJoins: {
        workOrderSuggestionLines: {
            code: 'code',
        },
        workOrderOperationSchedulingLines: {
            workOrder: 'code',
        },
    },
};
let WorkOrderSuggestion = class WorkOrderSuggestion extends xtrem_core_1.Node {
};
exports.WorkOrderSuggestion = WorkOrderSuggestion;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WIPTYP',
        dataType: () => sageX3ManufacturingData.enums.workOrderTypeDatatype,
    })
], WorkOrderSuggestion.prototype, "orderType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'WIPNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderSuggestion.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], WorkOrderSuggestion.prototype, "productCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WIPSTA',
        dataType: () => sageX3ManufacturingData.enums.statusInProgressDatatype,
    })
], WorkOrderSuggestion.prototype, "orderStatus", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkOrderSuggestion.prototype, "originalSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], WorkOrderSuggestion.prototype, "customer", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], WorkOrderSuggestion.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RMNEXTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkOrderSuggestion.prototype, "remainingQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPTFLG',
    })
], WorkOrderSuggestion.prototype, "optimized", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.WorkOrderSuggestionLine,
        isMutable: true,
        dependsOn: ['code'],
    })
], WorkOrderSuggestion.prototype, "workOrderSuggestionLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.WorkOrderOperationScheduling,
        isMutable: true,
        dependsOn: ['code'],
    })
], WorkOrderSuggestion.prototype, "workOrderOperationSchedulingLines", void 0);
exports.WorkOrderSuggestion = WorkOrderSuggestion = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ORDERS',
        keyPropertyNames: ['orderType', 'code', 'productCode'],
        indexes: [
            {
                orderBy: {
                    orderType: 1,
                    code: 1,
                    productCode: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['productCode'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], WorkOrderSuggestion);
//# sourceMappingURL=work-order-suggestion.js.map