import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3Manufacturing from '..';
export declare class WorkOrderProductionReportingLine extends Node {
    readonly trackingNumber: Promise<string>;
    readonly line: Promise<integer | null>;
    readonly orderNo: Promise<string>;
    readonly orderLineNumber: Promise<integer | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly bomAlternative: Reference<sageX3MasterData.nodes.BomCodes | null>;
    readonly lot: Promise<string>;
    readonly productionSite: Reference<sageX3System.nodes.Site>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly actualAcceptedQuantity: Promise<decimal | null>;
    readonly stkConversion: Promise<decimal | null>;
    readonly actualQuantity: Promise<decimal | null>;
    readonly releaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
    readonly serialNumber: Promise<string>;
    readonly stockJournal: Collection<sageX3StockData.nodes.StockJournal>;
    readonly workOrderProductionReporting: Reference<sageX3Manufacturing.nodes.WorkOrderProductionReporting>;
    readonly balance: Promise<decimal | null>;
    readonly destinationCode: Promise<string>;
    readonly labelDestination: Promise<string>;
    readonly postingDate: Promise<string>;
    readonly rejectedQty: Promise<decimal | null>;
    readonly transactionCode: Promise<string>;
}
//# sourceMappingURL=work-order-production-reporting-line.d.ts.map