import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, datetime, Collection } from '@sage/xtrem-core';
import * as sageX3Manufacturing from '..';
export declare class WorkOrderOperationLine extends Node {
    readonly workOrder: Reference<sageX3Manufacturing.nodes.WorkOrder | null>;
    readonly operationNumber: Promise<integer | null>;
    readonly operationSplit: Promise<integer | null>;
    readonly manufacturingSite: Reference<sageX3System.nodes.Site>;
    readonly expectedWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter>;
    readonly actualWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly laborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly actualLaborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly operationStatus: Promise<sageX3ManufacturingData.enums.OperationStatus | null>;
    readonly startDate: Promise<date | null>;
    readonly endDate: Promise<date | null>;
    readonly forcedStartDate: Promise<date | null>;
    readonly forcedStartTime: Promise<string>;
    readonly operationDescription: Promise<string>;
    readonly operationUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockOperationConversion: Promise<decimal | null>;
    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
    readonly routingOperationTimeCode: Promise<sageX3ManufacturingData.enums.RunTimeType | null>;
    readonly operationPlanNumber: Promise<string>;
    readonly technicalSheet: Promise<string>;
    readonly tool: Reference<sageX3MasterData.nodes.Product | null>;
    readonly fixture: Promise<string>;
    readonly program: Promise<string>;
    readonly numberOfResources: Promise<integer | null>;
    readonly preparationTime: Promise<decimal | null>;
    readonly setupTime: Promise<decimal | null>;
    readonly completedSetupTime: Promise<decimal | null>;
    readonly unitTime: Promise<decimal | null>;
    readonly completedUnitaryTime: Promise<decimal | null>;
    readonly runTime: Promise<decimal | null>;
    readonly completedOperationTime: Promise<decimal | null>;
    readonly waitingTime: Promise<decimal | null>;
    readonly postRunTime: Promise<decimal | null>;
    readonly expectedQuantity: Promise<decimal | null>;
    readonly completedQuantity: Promise<decimal | null>;
    readonly rejectQuantity: Promise<decimal | null>;
    readonly subcontract: Promise<sageX3ManufacturingData.enums.Subcontracting | null>;
    readonly subcontractWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly subcontractLeadTimeDays: Promise<decimal | null>;
    readonly groupingCriterion: Promise<string>;
    readonly distinctionCriteria: Promise<string>;
    readonly firstAvailability: Promise<datetime | null>;
    readonly workOrderScheduling: Collection<sageX3Manufacturing.nodes.WorkOrderScheduling>;
}
//# sourceMappingURL=work-order-operation-line.d.ts.map