"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkOrderMaterialTracking = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        productionSite: {
            code: 'productionSite',
        },
    },
    collectionJoins: {
        workOrderMaterialTrackingLines: {
            mfgTrackingNumber: 'trackingNumber',
        },
    },
};
let WorkOrderMaterialTracking = class WorkOrderMaterialTracking extends xtrem_core_1.Node {
};
exports.WorkOrderMaterialTracking = WorkOrderMaterialTracking;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGTRKNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkOrderMaterialTracking.prototype, "trackingNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MFGFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkOrderMaterialTracking.prototype, "productionSite", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.WorkOrderMaterialTrackingLine,
        isMutable: true,
        dependsOn: ['trackingNumber'],
    })
], WorkOrderMaterialTracking.prototype, "workOrderMaterialTrackingLines", void 0);
exports.WorkOrderMaterialTracking = WorkOrderMaterialTracking = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'MFGHEADTRK',
        keyPropertyNames: ['trackingNumber'],
        indexes: [
            {
                orderBy: {
                    trackingNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
        authorizationCode: 'GESMKM',
    })
], WorkOrderMaterialTracking);
//# sourceMappingURL=work-order-material-tracking.js.map