import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
import * as sageX3Manufacturing from '..';
export declare class WorkOrderMaterialLine extends Node {
    readonly number: Reference<sageX3Manufacturing.nodes.WorkOrder | null>;
    readonly lineNumber: Reference<sageX3Manufacturing.nodes.WorkOrderProductLine | null>;
    readonly bomSequence: Promise<integer | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product | null>;
    readonly productionSite: Reference<sageX3System.nodes.Site>;
    readonly requirementDate: Promise<date | null>;
    readonly bomOperationNumber: Promise<integer | null>;
    readonly cumulTotalQuantity: Promise<decimal | null>;
    readonly bomUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly bomUnitStockFactor: Promise<decimal | null>;
    readonly requiredQuantity: Promise<decimal | null>;
    readonly consumedQuantity: Promise<decimal | null>;
    readonly allocatedQuantity: Promise<decimal | null>;
    readonly shortageQuantity: Promise<decimal | null>;
    readonly location: Reference<sageX3StockData.nodes.Location | null>;
    readonly materialStatus: Promise<sageX3ManufacturingData.enums.ProductionStatus | null>;
    readonly componentType: Promise<sageX3MasterData.enums.ComponentType | null>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Promise<string>;
}
//# sourceMappingURL=work-order-material-line.d.ts.map