import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, integer, Reference } from '@sage/xtrem-core';
export declare class TransactionProductionReporting extends Node {
    readonly type: Promise<integer | null>;
    readonly transaction: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly description: Promise<string>;
    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
    readonly isActive: Promise<boolean>;
    readonly group: Reference<sageX3Structure.nodes.SiteGroupings | null>;
    readonly isWorkOrderTracking: Promise<boolean>;
    readonly isRoutingTracking: Promise<boolean>;
    readonly isWorkCenterTracking: Promise<boolean>;
    readonly isBomTracking: Promise<boolean>;
    readonly employeeEntry: Promise<sageX3ManufacturingData.enums.EnterMeasurement | null>;
    readonly isProductionReporting: Promise<boolean>;
    readonly isMaterialConsumption: Promise<boolean>;
    readonly stockWithdrawalMode: Promise<sageX3MasterData.enums.StockWithdrawalMode | null>;
    readonly sortCriteria1: Promise<sageX3ManufacturingData.enums.OperationSortCriteria | null>;
    readonly sortCriteria2: Promise<sageX3ManufacturingData.enums.OperationSortCriteria | null>;
    readonly materialConsumption: Promise<sageX3ManufacturingData.enums.MaterialConsumptionMode | null>;
    readonly isManualOnly: Promise<boolean>;
    readonly releaseQuantity: Promise<sageX3ManufacturingData.enums.DefaultQuantity | null>;
    readonly isUnitCanBeModified: Promise<boolean>;
    readonly defaultUnit: Promise<sageX3ManufacturingData.enums.EntryUnit | null>;
    readonly isPreloading: Promise<boolean>;
    readonly automaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
    readonly isUOMEntry: Promise<boolean>;
    readonly isEnterPac: Promise<boolean>;
    readonly labelPrinting: Promise<sageX3StockData.enums.LabelPrinting | null>;
    readonly formTableEntryModePrinting: Promise<sageX3System.enums.FormOrTableEntryMode | null>;
    readonly isNumberOfPrints: Promise<boolean>;
    readonly formTableEntryModeNumberOfPrints: Promise<sageX3System.enums.FormOrTableEntryMode | null>;
    readonly entryModeAvailableStock: Promise<sageX3System.enums.EntryMode | null>;
    readonly formTableEntryModeAvailableStock: Promise<sageX3System.enums.FormOrTableEntryMode | null>;
    readonly isExpiration: Promise<boolean>;
    readonly isPotency: Promise<boolean>;
    readonly isLotCustomText1: Promise<boolean>;
    readonly isLotCustomText2: Promise<boolean>;
    readonly isLotCustomNumber: Promise<boolean>;
    readonly isLotCustomDate: Promise<boolean>;
    readonly entryModeAnalyticalDimension: Promise<sageX3System.enums.EntryMode | null>;
    readonly isAutomaticIssue: Promise<boolean>;
    readonly isReceiptAtDock: Promise<boolean>;
    readonly materialFilterOperation: Promise<sageX3ManufacturingData.enums.FilterOperations | null>;
    readonly productFilterOperation: Promise<sageX3ManufacturingData.enums.FilterOperations | null>;
    readonly entryModeWarehouse: Promise<sageX3System.enums.EntryMode | null>;
    readonly isSingleWarehouse: Promise<boolean>;
    readonly unplannedMaterials: Promise<boolean>;
    readonly unplannedOperations: Promise<boolean>;
}
//# sourceMappingURL=transaction-production-reporting.d.ts.map