import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
import * as sageX3Manufacturing from '..';
export declare class RoutingOperation extends Node {
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly routing: Reference<sageX3MasterData.nodes.Product>;
    readonly routingCode: Reference<sageX3Manufacturing.nodes.RoutingHeader>;
    readonly operationNumber: Promise<integer | null>;
    readonly alternateIndex: Promise<integer | null>;
    readonly startDate: Promise<date | null>;
    readonly endDate: Promise<date | null>;
    readonly standardOperation: Reference<sageX3Manufacturing.nodes.StandardOperations | null>;
    readonly mainWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter>;
    readonly laborWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly laborTimeSetupFactor: Promise<decimal | null>;
    readonly laborRunTimeFactor: Promise<decimal | null>;
    readonly operationDescription: Promise<string>;
    readonly stockOperationConversion: Promise<decimal | null>;
    readonly stockOperationFormula: Promise<string>;
    readonly operationPlan: Promise<string>;
    readonly operationImage: Promise<string>;
    readonly technicalSheet: Promise<string>;
    readonly tools: Reference<sageX3MasterData.nodes.Product | null>;
    readonly fixture: Promise<string>;
    readonly program: Promise<string>;
    readonly numberOfRessources: Promise<integer | null>;
    readonly numberLaborRessources: Promise<integer | null>;
    readonly efficiencyPercentage: Promise<decimal | null>;
    readonly shrinkagePercentage: Promise<decimal | null>;
    readonly runTimeType: Promise<sageX3ManufacturingData.enums.RunTimeType | null>;
    readonly managementUnit: Promise<sageX3ManufacturingData.enums.OperationTimeCodes | null>;
    readonly baseQuantity: Promise<decimal | null>;
    readonly preparationTime: Promise<decimal | null>;
    readonly setupTime: Promise<decimal | null>;
    readonly runTime: Promise<decimal | null>;
    readonly rate: Promise<decimal | null>;
    readonly waitingTime: Promise<decimal | null>;
    readonly postRunTime: Promise<decimal | null>;
    readonly subcontractCode: Promise<sageX3ManufacturingData.enums.Subcontracting | null>;
    readonly subcontractedProducts: Reference<sageX3MasterData.nodes.Product | null>;
    readonly subcontractWorkCenter: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly businessPartnerAddress: Reference<sageX3MasterData.nodes.Address | null>;
    readonly referencePrice: Promise<decimal | null>;
    readonly splitting: Promise<sageX3ManufacturingData.enums.Splitting | null>;
    readonly maximumSplits: Promise<integer | null>;
    readonly operationSuffix: Promise<integer | null>;
    readonly isRoutingCodeOperation: Promise<boolean>;
    readonly machineRestriction: Promise<string>;
    readonly groupingCriterion: Promise<string>;
    readonly groupingFormula: Promise<string>;
    readonly distinctionCriteria: Promise<string>;
    readonly distinctionFormula: Promise<string>;
    readonly groupSetupTime: Promise<decimal | null>;
}
//# sourceMappingURL=routing-operation.d.ts.map