import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, decimal } from '@sage/xtrem-core';
export declare class RoutingHeader extends Node {
    readonly routing: Reference<sageX3MasterData.nodes.Product>;
    readonly routingCode: Reference<sageX3MasterData.nodes.BomRouting>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly description: Promise<string>;
    readonly useStatus: Promise<sageX3MasterData.enums.UseStatus | null>;
    readonly isValidated: Promise<boolean>;
    readonly validityStartDate: Promise<date | null>;
    readonly validityEndDate: Promise<date | null>;
    readonly timeUnit: Promise<sageX3ManufacturingData.enums.TimeUnitCode | null>;
    readonly workOrderManagementMode: Promise<sageX3ManufacturingData.enums.WorkOrderManagementMode | null>;
    readonly routingHeaderText: Promise<string>;
    readonly routingHeaderPlan: Promise<string>;
    readonly routingHeaderImage: Promise<string>;
    readonly minimumReleaseQuantity: Promise<decimal | null>;
    readonly maximumReleaseQuantity: Promise<decimal | null>;
    readonly lastReleaseQuantity: Promise<decimal | null>;
    readonly lastReleaseDate: Promise<date | null>;
    readonly journalNumberConfig: Promise<string>;
    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
}
//# sourceMappingURL=routing-header.d.ts.map